/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PhpMethodDescriptor
implements MethodDescriptor<PhpParameterInfo, String> {
    private final boolean myIsAnonymous;
    private final Function myMethod;

    public PhpMethodDescriptor(Function method) {
        this.myMethod = method;
        this.myIsAnonymous = StringUtil.isEmpty((String)this.myMethod.getName());
    }

    public String getMethodAccess() {
        return ((Method)this.myMethod).getAccess().toString();
    }

    public String getName() {
        return this.myMethod.getName();
    }

    public boolean isAnonymous() {
        return this.myIsAnonymous;
    }

    public List<PhpParameterInfo> getParameters() {
        ArrayList<PhpParameterInfo> parameterInfos = new ArrayList<PhpParameterInfo>();
        Parameter[] parameters = this.myMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            PsiElement value = parameter.getDefaultValue();
            boolean isOptional = value != null;
            String initializer = isOptional ? value.getText() : "";
            String type = PhpRefactoringUtil.getParameterTypeDeclarationString(parameter);
            parameterInfos.add(new PhpParameterInfo(i, parameter.getName(), type, "", initializer, parameter.isPassByRef(), parameter.isVariadic()));
        }
        return parameterInfos;
    }

    public int getParametersCount() {
        return this.myMethod.getParameters().length;
    }

    public String getVisibility() {
        if (this.myMethod instanceof Method) {
            PsiElement visibilityModifier;
            PhpPsiElement modifierList = this.myMethod.getFirstPsiChild();
            PsiElement psiElement = visibilityModifier = modifierList != null ? PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.tsVISIBILITY_MODIFIERS) : null;
            if (PhpPsiUtil.isOfType(visibilityModifier, PhpTokenTypes.kwPRIVATE)) {
                return PhpModifier.Access.PRIVATE.toString();
            }
            if (PhpPsiUtil.isOfType(visibilityModifier, PhpTokenTypes.kwPROTECTED)) {
                return PhpModifier.Access.PROTECTED.toString();
            }
            if (PhpPsiUtil.isOfType(visibilityModifier, PhpTokenTypes.kwPUBLIC)) {
                return PhpModifier.Access.PUBLIC.toString();
            }
        }
        return "";
    }

    public Function getMethod() {
        return this.myMethod;
    }

    public boolean canChangeVisibility() {
        if (!(this.myMethod instanceof Method)) {
            return false;
        }
        PhpClass clazz = ((Method)this.myMethod).getContainingClass();
        return clazz != null && !clazz.isInterface();
    }

    public boolean canChangeParameters() {
        return true;
    }

    public boolean canChangeName() {
        return !this.isConstructor() && !this.isAnonymous();
    }

    public boolean isConstructor() {
        if (!(this.myMethod instanceof Method)) {
            return false;
        }
        PhpClass clazz = ((Method)this.myMethod).getContainingClass();
        return clazz != null && !clazz.isInterface() && !clazz.isTrait() && ((Method)this.myMethod).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        if (!PhpProjectConfigurationFacade.getInstance(this.myMethod.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.RETURN_TYPES)) {
            return MethodDescriptor.ReadWriteOption.None;
        }
        return this.myMethod instanceof Method && PhpRefactoringUtil.isConstructor((Method)this.myMethod) ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    @Nullable
    public String getReturnTypeText() {
        return PhpMethodDescriptor.getReturnTypeText(this.myMethod);
    }

    public static String getReturnTypeText(Function method) {
        PhpReturnType typeElement = method.getReturnType();
        if (typeElement == null) {
            return null;
        }
        String typeElementText = typeElement.getText();
        if (PhpType.intersects((PhpType)method.getDeclaredType(), (PhpType)PhpType.NULL) && !typeElement.isNullable()) {
            typeElementText = "?" + typeElementText;
        }
        return typeElementText;
    }
}

