/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.SimpleDateFormat;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public class MpxjCreate {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: MpxCreate <output file name>");
            } else {
                MpxjCreate.create(stringArray[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static void create(String string) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        ProjectFile projectFile = new ProjectFile();
        ProjectCalendar projectCalendar = projectFile.addDefaultBaseCalendar();
        projectCalendar.addCalendarException(simpleDateFormat.parse("13/03/2006"), simpleDateFormat.parse("13/03/2006"));
        ProjectProperties projectProperties = projectFile.getProjectProperties();
        projectProperties.setStartDate(simpleDateFormat.parse("01/01/2003"));
        projectProperties.setProjectTitle("Created by MPXJ");
        projectProperties.setAuthor("Jon Iles");
        Resource resource = projectFile.addResource();
        resource.setName("Resource1");
        Resource resource2 = projectFile.addResource();
        resource2.setName("Resource2");
        resource2.setMaxUnits(50.0);
        Task task = projectFile.addTask();
        task.setName("Summary Task");
        Task task2 = task.addTask();
        task2.setName("First Sub Task");
        task2.setDuration(Duration.getInstance(10.5, TimeUnit.DAYS));
        task2.setStart(simpleDateFormat.parse("01/01/2003"));
        task2.setPercentageComplete(NumberHelper.getDouble(50.0));
        task2.setActualStart(simpleDateFormat.parse("01/01/2003"));
        Task task3 = task.addTask();
        task3.setName("Second Sub Task");
        task3.setStart(simpleDateFormat.parse("11/01/2003"));
        task3.setDuration(Duration.getInstance(10, TimeUnit.DAYS));
        task3.addPredecessor(task2, RelationType.FINISH_START, null);
        Task task4 = task.addTask();
        task4.setName("Milestone");
        task4.setStart(simpleDateFormat.parse("21/01/2003"));
        task4.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
        task4.addPredecessor(task3, RelationType.FINISH_START, null);
        Task task5 = projectFile.addTask();
        task5.setName("Next Task");
        task5.setDuration(Duration.getInstance(8, TimeUnit.DAYS));
        task5.setStart(simpleDateFormat.parse("01/01/2003"));
        task5.setPercentageComplete(NumberHelper.getDouble(70.0));
        task5.setActualStart(simpleDateFormat.parse("01/01/2003"));
        ResourceAssignment resourceAssignment = task2.addResourceAssignment(resource);
        ResourceAssignment resourceAssignment2 = task3.addResourceAssignment(resource2);
        resourceAssignment.setWork(Duration.getInstance(80, TimeUnit.HOURS));
        resourceAssignment.setActualWork(Duration.getInstance(40, TimeUnit.HOURS));
        resourceAssignment.setRemainingWork(Duration.getInstance(40, TimeUnit.HOURS));
        resourceAssignment2.setRemainingWork(Duration.getInstance(80, TimeUnit.HOURS));
        resourceAssignment.setStart(simpleDateFormat.parse("01/01/2003"));
        resourceAssignment2.setStart(simpleDateFormat.parse("11/01/2003"));
        Task task6 = projectFile.addTask();
        task6.setName("Last Task");
        task6.setDuration(Duration.getInstance(3, TimeUnit.DAYS));
        task6.setStart(simpleDateFormat.parse("01/01/2003"));
        task6.setPercentageComplete(NumberHelper.getDouble(100.0));
        task6.setActualStart(simpleDateFormat.parse("01/01/2003"));
        ProjectWriter projectWriter = ProjectWriterUtility.getProjectWriter(string);
        projectWriter.write(projectFile, string);
    }
}

