/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyCharmCommunityCustomizationBundle;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfigurationExtension;
import com.jetbrains.python.sdk.configuration.PySdkConfigurationCollector;
import com.jetbrains.python.sdk.pipenv.PipenvKt;
import com.jetbrains.python.sdk.pipenv.PyAddNewPipEnvFromFilePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0017\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyPipfileSdkConfiguration;", "Lcom/jetbrains/python/sdk/configuration/PyProjectSdkConfigurationExtension;", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "askForEnvData", "Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel$Data;", "module", "Lcom/intellij/openapi/module/Module;", "source", "Lcom/jetbrains/python/sdk/configuration/PySdkConfigurationCollector$Companion$Source;", "createAndAddSDk", "Lcom/intellij/openapi/projectRoots/Sdk;", "createAndAddSdkForConfigurator", "createAndAddSdkForInspection", "createPipEnv", "getIntention", "", "Lcom/intellij/codeInspection/util/IntentionName;", "Dialog", "intellij.pycharm.community.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPyPipfileSdkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPipfileSdkConfiguration.kt\ncom/jetbrains/python/sdk/configuration/PyPipfileSdkConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class PyPipfileSdkConfiguration
implements PyProjectSdkConfigurationExtension {
    @NotNull
    private final Logger LOGGER;

    public PyPipfileSdkConfiguration() {
        Logger logger = Logger.getInstance(PyPipfileSdkConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(PyPipfileSdkConfiguration::class.java)");
        this.LOGGER = logger;
    }

    @Nullable
    public Sdk createAndAddSdkForConfigurator(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSDk(module, PySdkConfigurationCollector.Companion.Source.CONFIGURATOR);
    }

    @Nullable
    public String getIntention(@NotNull Module module) {
        String string;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = PipenvKt.getPipFile((Module)module);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName()};
            string = PyCharmCommunityCustomizationBundle.message("sdk.create.pipenv.suggestion", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Sdk createAndAddSdkForInspection(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.createAndAddSDk(module, PySdkConfigurationCollector.Companion.Source.INSPECTION);
    }

    private final Sdk createAndAddSDk(Module module, PySdkConfigurationCollector.Companion.Source source) {
        PyAddNewPipEnvFromFilePanel.Data data = this.askForEnvData(module, source);
        if (data == null) {
            return null;
        }
        PyAddNewPipEnvFromFilePanel.Data pipEnvExecutable = data;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance()");
        PipenvKt.setPipEnvPath((PropertiesComponent)propertiesComponent, (String)pipEnvExecutable.getPipEnvPath());
        return this.createPipEnv(module);
    }

    private final PyAddNewPipEnvFromFilePanel.Data askForEnvData(Module module, PySdkConfigurationCollector.Companion.Source source) {
        String pipEnvExecutable;
        File file = PipenvKt.getPipEnvExecutable();
        String string = pipEnvExecutable = file != null ? file.getAbsolutePath() : null;
        if (source == PySdkConfigurationCollector.Companion.Source.INSPECTION && PipenvKt.validatePipEnvExecutable((String)pipEnvExecutable) == null) {
            String string2 = pipEnvExecutable;
            Intrinsics.checkNotNull((Object)string2);
            return new PyAddNewPipEnvFromFilePanel.Data(string2);
        }
        Ref.BooleanRef permitted = new Ref.BooleanRef();
        Ref.ObjectRef envData = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(() -> PyPipfileSdkConfiguration.askForEnvData$lambda$1(module, permitted, envData, this));
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        CharSequence charSequence = pipEnvExecutable;
        PySdkConfigurationCollector.Companion.logPipEnvDialog$intellij_pycharm_community_ide_impl(project, permitted.element, source, charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? PySdkConfigurationCollector.Companion.InputData.NOT_FILLED : PySdkConfigurationCollector.Companion.InputData.SPECIFIED);
        return permitted.element ? (PyAddNewPipEnvFromFilePanel.Data)envData.element : null;
    }

    private final Sdk createPipEnv(Module module) {
        VirtualFile virtualFile;
        String string;
        String string2;
        ProgressManager.progress((String)PyBundle.message((String)"python.sdk.setting.up.pipenv.sentence", (Object[])new Object[0]));
        this.LOGGER.debug("Creating pipenv environment");
        String string3 = BasePySdkExtKt.getBasePath((Module)module);
        if (string3 == null) {
            return null;
        }
        String basePath = string3;
        try {
            String string4 = FileUtil.toSystemDependentName((String)basePath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toSystemDependentName(basePath)");
            string2 = PipenvKt.setupPipEnv((String)string4, null, (boolean)true);
        }
        catch (ExecutionException e) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            PySdkConfigurationCollector.Companion.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.Companion.PipEnvResult.CREATION_FAILURE);
            this.LOGGER.warn("Exception during creating pipenv environment", (Throwable)e);
            String string5 = PyCharmCommunityCustomizationBundle.message("sdk.create.pipenv.exception.dialog.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"sdk.create.pipe\u2026.exception.dialog.title\")");
            PySdkExtKt.showSdkExecutionException(null, (ExecutionException)e, (String)string5);
            return null;
        }
        String pipEnv = string2;
        String it = string = PythonSdkUtil.getPythonExecutable((String)pipEnv);
        boolean bl = false;
        if (it == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            PySdkConfigurationCollector.Companion.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.Companion.PipEnvResult.NO_EXECUTABLE);
            this.LOGGER.warn("Python executable is not found: " + pipEnv);
        }
        String string6 = string;
        if (string6 == null) {
            return null;
        }
        String path = string6;
        VirtualFile it2 = virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        boolean bl2 = false;
        if (it2 == null) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            PySdkConfigurationCollector.Companion.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.Companion.PipEnvResult.NO_EXECUTABLE_FILE);
            this.LOGGER.warn("Python executable file is not found: " + path);
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        PySdkConfigurationCollector.Companion.logPipEnv$intellij_pycharm_community_ide_impl(project, PySdkConfigurationCollector.Companion.PipEnvResult.CREATED);
        this.LOGGER.debug("Setting up associated pipenv environment: " + path + ", " + basePath);
        Sdk sdk2 = SdkConfigurationUtil.setupSdk((Sdk[])ProjectJdkTable.getInstance().getAllJdks(), (VirtualFile)file, (SdkType)((SdkType)PythonSdkType.getInstance()), (boolean)false, null, (String)PipenvKt.suggestedSdkName((String)basePath));
        if (sdk2 == null) {
            return null;
        }
        Sdk sdk3 = sdk2;
        ApplicationManager.getApplication().invokeAndWait(() -> PyPipfileSdkConfiguration.createPipEnv$lambda$4(this, path, basePath, sdk3, module));
        return sdk3;
    }

    private static final void askForEnvData$lambda$1(Module $module, Ref.BooleanRef $permitted, Ref.ObjectRef $envData, PyPipfileSdkConfiguration this$0) {
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        Intrinsics.checkNotNullParameter((Object)$permitted, (String)"$permitted");
        Intrinsics.checkNotNullParameter((Object)$envData, (String)"$envData");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Dialog dialog = new Dialog($module);
        $permitted.element = dialog.showAndGet();
        $envData.element = dialog.getEnvData();
        this$0.LOGGER.debug("Dialog exit code: " + dialog.getExitCode() + ", " + $permitted.element);
    }

    private static final void createPipEnv$lambda$4(PyPipfileSdkConfiguration this$0, String $path, String $basePath, Sdk $sdk, Module $module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$basePath, (String)"$basePath");
        Intrinsics.checkNotNullParameter((Object)$sdk, (String)"$sdk");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        this$0.LOGGER.debug("Adding associated pipenv environment: " + $path + ", " + $basePath);
        SdkConfigurationUtil.addSdk((Sdk)$sdk);
        PipenvKt.setPipEnv((Sdk)$sdk, (boolean)true);
        PySdkExtKt.associateWithModule((Sdk)$sdk, (Module)$module, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/sdk/configuration/PyPipfileSdkConfiguration$Dialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "envData", "Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel$Data;", "getEnvData", "()Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel$Data;", "panel", "Lcom/jetbrains/python/sdk/pipenv/PyAddNewPipEnvFromFilePanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "postponeValidation", "", "intellij.pycharm.community.ide.impl"})
    private static final class Dialog
    extends DialogWrapper {
        @NotNull
        private final PyAddNewPipEnvFromFilePanel panel;

        public Dialog(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            super(module.getProject(), false, DialogWrapper.IdeModalityType.PROJECT);
            this.panel = new PyAddNewPipEnvFromFilePanel(module);
            this.setTitle(PyBundle.message((String)"python.sdk.setting.up.pipenv.title", (Object[])new Object[0]));
            this.init();
        }

        @NotNull
        public final PyAddNewPipEnvFromFilePanel.Data getEnvData() {
            return this.panel.getEnvData();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JPanel jPanel;
            JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            Border border = IdeBorderFactory.createEmptyBorder((Insets)new Insets(4, 0, 6, 0));
            String string = PyCharmCommunityCustomizationBundle.message("sdk.create.pipenv.permission", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"sdk.create.pipenv.permission\")");
            String message = string;
            $this$createCenterPanel_u24lambda_u240.add((Component)JBUI.Panels.simplePanel((Component)((Component)new JBLabel(message))).withBorder(border), "North");
            $this$createCenterPanel_u24lambda_u240.add((Component)this.panel, "Center");
            return jPanel;
        }

        protected boolean postponeValidation() {
            return false;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            return this.panel.validateAll();
        }
    }
}

