/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.internal.statistic.devkit.actions.OpenEventsSchemeFileAction;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogFilter;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J0\u0010\f\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogConsole;", "Lcom/intellij/diagnostic/logging/LogConsoleBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/diagnostic/logging/LogFilterModel;", "recorderId", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/diagnostic/logging/LogFilterModel;Ljava/lang/String;)V", "addLogLine", "", "line", "computeLineNumbers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "schemeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isActive", "", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogConsole
extends LogConsoleBase {
    @NotNull
    private final Project project;

    public StatisticsEventLogConsole(@NotNull Project project, @NotNull LogFilterModel model, @NotNull String recorderId) {
        block1: {
            HashMap groupIdToLine;
            Map map;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            super(project, null, "Statistics Event Log", false, model);
            this.project = project;
            VirtualFile schemeFile = LocalFileSystem.getInstance().findFileByNioFile(OpenEventsSchemeFileAction.Companion.getEventsSchemeFile(recorderId));
            if (schemeFile == null || (map = (Map)(groupIdToLine = (HashMap)ReadAction.compute(() -> StatisticsEventLogConsole._init_$lambda$0(this, schemeFile)))) == null || map.isEmpty()) break block1;
            ConsoleView consoleView = this.getConsole();
            if (consoleView != null) {
                Intrinsics.checkNotNullExpressionValue((Object)groupIdToLine, (String)"groupIdToLine");
                consoleView.addMessageFilter((Filter)new StatisticsEventLogFilter(schemeFile, groupIdToLine));
            }
        }
    }

    private final HashMap<String, Integer> computeLineNumbers(VirtualFile schemeFile) {
        HashMap<String, Integer> groupIdToLine = new HashMap<String, Integer>();
        Document document = FileDocumentManager.getInstance().getDocument(schemeFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(schemeFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)JsonLanguage.INSTANCE)) {
            psiFile2.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(groupIdToLine, document2){
                final /* synthetic */ HashMap<String, Integer> $groupIdToLine;
                final /* synthetic */ Document $document;
                {
                    this.$groupIdToLine = $groupIdToLine;
                    this.$document = $document;
                }

                public void visitProperty(@NotNull JsonProperty property) {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    if (!Intrinsics.areEqual((Object)property.getName(), (Object)"groups")) {
                        return;
                    }
                    JsonValue jsonValue = property.getValue();
                    JsonArray jsonArray = jsonValue instanceof JsonArray ? (JsonArray)jsonValue : null;
                    if (jsonArray == null) {
                        return;
                    }
                    JsonArray groups = jsonArray;
                    for (JsonValue groupElement : groups.getValueList()) {
                        JsonProperty idProperty;
                        JsonValue jsonValue2;
                        Object object;
                        Intrinsics.checkNotNull((Object)groupElement, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
                        JsonObject groupObject = (JsonObject)groupElement;
                        if (groupObject.findProperty("id") == null || (object = (jsonValue2 = idProperty.getValue()) instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue2 : null) == null || (object = object.getValue()) == null) continue;
                        Object id = object;
                        ((Map)this.$groupIdToLine).put(id, this.$document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)idProperty))));
                    }
                }
            });
        }
        return groupIdToLine;
    }

    public boolean isActive() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow("Statistics Event Log");
        return toolWindow != null ? toolWindow.isVisible() : false;
    }

    public final void addLogLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        super.addMessage(line);
    }

    private static final HashMap _init_$lambda$0(StatisticsEventLogConsole this$0, VirtualFile $schemeFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.computeLineNumbers($schemeFile);
    }
}

