/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.diff.util.Side;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunkUtil;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.messages.MessageBus;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReviewDTO;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewThread;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.GHPullRequestPendingReview;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataOperationsListener;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProviderImplKt;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewService;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016JH\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00022\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0.H\u0016J\u001e\u0010/\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00022\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0.H\u0016J\b\u00100\u001a\u000201H\u0016JD\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u00103\u001a\u0004\u0018\u0001042\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010$\u001a\u0004\u0018\u00010!2\u000e\u00105\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010\u0012H\u0016JF\u00107\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'2\u0006\u00108\u001a\u00020)2\u0006\u0010%\u001a\u00020!H\u0016J \u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020!H\u0016J\"\u0010<\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010:0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020!H\u0016J\b\u0010=\u001a\u00020+H\u0016J\u0015\u0010>\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001c\u00a2\u0006\u0002\b\u0016H\u0016J\u0019\u0010?\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u001c\u00a2\u0006\u0002\b\u0016H\u0016J\b\u0010@\u001a\u00020+H\u0016J\b\u0010A\u001a\u00020+H\u0016J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020!H\u0016J4\u0010D\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010:0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020!2\u0006\u00103\u001a\u0002042\b\u0010\"\u001a\u0004\u0018\u00010!H\u0016J\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020!H\u0016J&\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020!2\u0006\u0010G\u001a\u00020!H\u0016J&\u0010H\u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020!2\u0006\u0010G\u001a\u00020!H\u0016J\u001e\u0010I\u001a\b\u0012\u0004\u0012\u0002HJ0\u001c\"\u0004\b\u0000\u0010J*\b\u0012\u0004\u0012\u0002HJ0\u001cH\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u0002HJ0\u001c\"\u0004\b\u0000\u0010J*\b\u0012\u0004\u0012\u0002HJ0\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006L"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "Lcom/intellij/openapi/Disposable;", "reviewService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;", "changesProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProvider;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;Lcom/intellij/util/messages/MessageBus;)V", "getMessageBus", "()Lcom/intellij/util/messages/MessageBus;", "pendingReviewRequestValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPullRequestPendingReview;", "reviewThreadsRequestValue", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "submitReviewCommentDocument", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getSubmitReviewCommentDocument", "()Lcom/intellij/openapi/editor/Document;", "submitReviewCommentDocument$delegate", "Lkotlin/Lazy;", "addComment", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewComment;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "replyToCommentId", "", "body", "reviewId", "commitSha", "fileName", "side", "Lcom/intellij/diff/util/Side;", "line", "", "addPendingReviewListener", "", "disposable", "listener", "Lkotlin/Function0;", "addReviewThreadsListener", "canComment", "", "createReview", "event", "Lorg/jetbrains/plugins/github/api/data/GHPullRequestReviewEvent;", "threads", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewThread;", "createThread", "startLine", "deleteComment", "", "commentId", "deleteReview", "dispose", "loadPendingReview", "loadReviewThreads", "resetPendingReview", "resetReviewThreads", "resolveThread", "id", "submitReview", "unresolveThread", "updateComment", "newText", "updateReviewBody", "dropReviews", "T", "notifyReviews", "intellij.vcs.github"})
public final class GHPRReviewDataProviderImpl
implements GHPRReviewDataProvider,
Disposable {
    @NotNull
    private final GHPRReviewService reviewService;
    @NotNull
    private final GHPRChangesDataProvider changesProvider;
    @NotNull
    private final GHPRIdentifier pullRequestId;
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private final Lazy submitReviewCommentDocument$delegate;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<GHPullRequestPendingReview> pendingReviewRequestValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<List<GHPullRequestReviewThread>> reviewThreadsRequestValue;

    public GHPRReviewDataProviderImpl(@NotNull GHPRReviewService reviewService, @NotNull GHPRChangesDataProvider changesProvider, @NotNull GHPRIdentifier pullRequestId, @NotNull MessageBus messageBus2) {
        Intrinsics.checkNotNullParameter((Object)reviewService, (String)"reviewService");
        Intrinsics.checkNotNullParameter((Object)changesProvider, (String)"changesProvider");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)messageBus2, (String)"messageBus");
        this.reviewService = reviewService;
        this.changesProvider = changesProvider;
        this.pullRequestId = pullRequestId;
        this.messageBus = messageBus2;
        this.submitReviewCommentDocument$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)submitReviewCommentDocument.2.INSTANCE);
        this.pendingReviewRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GHPullRequestPendingReview>>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<GHPullRequestPendingReview> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletionStage completionStage = GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).loadPendingReview(it, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0)).thenApply(arg_0 -> pendingReviewRequestValue.1.invoke$lambda$0(pendingReviewRequestValue.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"reviewService.loadPendin\u2026enApply { it?.toModel() }");
                return completionStage;
            }

            private static final GHPullRequestPendingReview invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (GHPullRequestPendingReview)$tmp0.invoke(p0);
            }
        });
        this.reviewThreadsRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<List<? extends GHPullRequestReviewThread>>>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<List<GHPullRequestReviewThread>> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).loadReviewThreads(it, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    @Override
    @NotNull
    public Document getSubmitReviewCommentDocument() {
        Lazy lazy = this.submitReviewCommentDocument$delegate;
        return (Document)lazy.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReview> loadPendingReview() {
        Object object = this.pendingReviewRequestValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pendingReviewRequestValue.value");
        return (CompletableFuture)object;
    }

    @Override
    public void resetPendingReview() {
        this.pendingReviewRequestValue.drop();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHPullRequestReviewThread>> loadReviewThreads() {
        Object object = this.reviewThreadsRequestValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reviewThreadsRequestValue.value");
        return (CompletableFuture)object;
    }

    @Override
    public void resetReviewThreads() {
        this.reviewThreadsRequestValue.drop();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReview> createReview(@NotNull ProgressIndicator progressIndicator, @Nullable GHPullRequestReviewEvent event, @Nullable String body2, @Nullable String commitSha, @Nullable List<GHPullRequestDraftReviewThread> threads) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        CompletionStage completionStage = this.reviewService.createReview(progressIndicator, this.pullRequestId, event, body2, commitSha, threads).thenApply(arg_0 -> GHPRReviewDataProviderImpl.createReview$lambda$0(createReview.future.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"reviewService.createRevi\u2026henApply { it.toModel() }");
        CompletableFuture<GHPullRequestPendingReview> future2 = this.notifyReviews((CompletableFuture)completionStage);
        if (event == null) {
            this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function1)createReview.1.INSTANCE, (int)1, null));
        }
        return (collection = (Collection)threads) == null || collection.isEmpty() ? future2 : this.dropReviews(future2);
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> submitReview(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull GHPullRequestReviewEvent event, @Nullable String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        CompletableFuture<? extends Object> future2 = this.reviewService.submitReview(progressIndicator, this.pullRequestId, reviewId, event, body2);
        this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function1)submitReview.1.INSTANCE, (int)1, null));
        return this.notifyReviews(this.dropReviews(future2));
    }

    @Override
    @NotNull
    public CompletableFuture<String> updateReviewBody(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, this.reviewService.updateReviewBody(progressIndicator, reviewId, newText), null, (Function1)((Function1)new Function1<GHPullRequestReview, String>(this, reviewId, newText){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $newText;
            {
                this.this$0 = $receiver;
                this.$reviewId = $reviewId;
                this.$newText = $newText;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull GHPullRequestReview it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((GHPRDataOperationsListener)this.this$0.getMessageBus().syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onReviewUpdated(this.$reviewId, this.$newText);
                return it.getBody();
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> deleteReview(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        CompletableFuture<? extends Object> future2 = this.reviewService.deleteReview(progressIndicator, this.pullRequestId, reviewId);
        this.pendingReviewRequestValue.combineResult(future2, (Function2)new Function2<GHPullRequestPendingReview, ?, GHPullRequestPendingReview>(reviewId){
            final /* synthetic */ String $reviewId;
            {
                this.$reviewId = $reviewId;
                super(2);
            }

            @Nullable
            public final GHPullRequestPendingReview invoke(@Nullable GHPullRequestPendingReview pendingReview, @Nullable Object object) {
                if (pendingReview != null && Intrinsics.areEqual((Object)pendingReview.getId(), (Object)this.$reviewId)) {
                    throw new ProcessCanceledException();
                }
                return pendingReview;
            }
        });
        return this.notifyReviews(this.dropReviews(future2));
    }

    @Override
    public boolean canComment() {
        return this.reviewService.canComment();
    }

    @Override
    @NotNull
    public CompletableFuture<? extends GHPullRequestReviewComment> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String body2, @NotNull String commitSha, @NotNull String fileName, @NotNull Side side, int line) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        CompletionStage completionStage = this.changesProvider.loadPatchFromMergeBase(progressIndicator, commitSha, fileName).thenComposeAsync(arg_0 -> GHPRReviewDataProviderImpl.addComment$lambda$1((Function1)new Function1<FilePatch, CompletionStage<GHPullRequestReviewComment>>(side, line, this, progressIndicator, reviewId, body2, commitSha, fileName){
            final /* synthetic */ Side $side;
            final /* synthetic */ int $line;
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $body;
            final /* synthetic */ String $commitSha;
            final /* synthetic */ String $fileName;
            {
                this.$side = $side;
                this.$line = $line;
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$reviewId = $reviewId;
                this.$body = $body;
                this.$commitSha = $commitSha;
                this.$fileName = $fileName;
                super(1);
            }

            public final CompletionStage<GHPullRequestReviewComment> invoke(@Nullable FilePatch patch) {
                boolean bl = patch != null && patch instanceof TextFilePatch;
                String string = this.$commitSha;
                if (!bl) {
                    boolean bl2 = false;
                    String string2 = "Cannot find diff between " + string + " and merge base";
                    throw new IllegalStateException(string2.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)patch, (String)"patch");
                Integer n = PatchHunkUtil.INSTANCE.findDiffFileLineIndex((TextFilePatch)patch, TuplesKt.to((Object)this.$side, (Object)this.$line));
                if (n == null) {
                    throw new IllegalStateException("Can't map file line to diff".toString());
                }
                int position = n;
                return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).addComment(this.$progressIndicator, this.$reviewId, this.$body, this.$commitSha, this.$fileName, position);
            }
        }, arg_0), (Executor)ProcessIOExecutorService.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun addComment(\u2026ews().notifyReviews()\n  }");
        return this.notifyReviews(this.dropReviews(CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)completionStage, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LazyCancellableBackgroundProcessValue lazyCancellableBackgroundProcessValue = GHPRReviewDataProviderImpl.access$getPendingReviewRequestValue$p(this.this$0);
                CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
                lazyCancellableBackgroundProcessValue.combineResult(completableFuture, addComment.1.INSTANCE);
            }
        }), (int)1, null)));
    }

    @Override
    @NotNull
    public CompletableFuture<? extends GHPullRequestReviewComment> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull String replyToCommentId, @NotNull String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)replyToCommentId, (String)"replyToCommentId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        CompletionStage completionStage = ((CompletableFuture)this.pendingReviewRequestValue.getValue()).thenCompose(arg_0 -> GHPRReviewDataProviderImpl.addComment$lambda$2((Function1)new Function1<GHPullRequestPendingReview, CompletionStage<GHPullRequestReviewComment>>(this, progressIndicator, replyToCommentId, body2){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $replyToCommentId;
            final /* synthetic */ String $body;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$replyToCommentId = $replyToCommentId;
                this.$body = $body;
                super(1);
            }

            public final CompletionStage<GHPullRequestReviewComment> invoke(@Nullable GHPullRequestPendingReview it) {
                GHPullRequestPendingReview gHPullRequestPendingReview = it;
                String reviewId = gHPullRequestPendingReview != null ? gHPullRequestPendingReview.getId() : null;
                CompletableFuture<GHPullRequestReviewComment> completableFuture = reviewId == null ? GHPRReviewService.createReview$default(GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0), this.$progressIndicator, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0), null, null, null, null, 60, null).thenCompose(arg_0 -> addComment.3.invoke$lambda$0((Function1)new Function1<GHPullRequestPendingReviewDTO, CompletionStage<GHPullRequestReviewComment>>(this.this$0, this.$progressIndicator, this.$replyToCommentId, this.$body){
                    final /* synthetic */ GHPRReviewDataProviderImpl this$0;
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    final /* synthetic */ String $replyToCommentId;
                    final /* synthetic */ String $body;
                    {
                        this.this$0 = $receiver;
                        this.$progressIndicator = $progressIndicator;
                        this.$replyToCommentId = $replyToCommentId;
                        this.$body = $body;
                        super(1);
                    }

                    public final CompletionStage<GHPullRequestReviewComment> invoke(GHPullRequestPendingReviewDTO review) {
                        return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).addComment(this.$progressIndicator, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0), review.getId(), this.$replyToCommentId, this.$body).thenCompose(arg_0 -> addComment.1.invoke$lambda$0((Function1)new Function1<GHPullRequestReviewComment, CompletionStage<GHPullRequestReviewComment>>(this.this$0, this.$progressIndicator, review){
                            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
                            final /* synthetic */ ProgressIndicator $progressIndicator;
                            final /* synthetic */ GHPullRequestPendingReviewDTO $review;
                            {
                                this.this$0 = $receiver;
                                this.$progressIndicator = $progressIndicator;
                                this.$review = $review;
                                super(1);
                            }

                            public final CompletionStage<GHPullRequestReviewComment> invoke(GHPullRequestReviewComment comment) {
                                return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).submitReview(this.$progressIndicator, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0), this.$review.getId(), GHPullRequestReviewEvent.COMMENT, null).thenApply(arg_0 -> addComment.1.invoke$lambda$0(comment, arg_0));
                            }

                            private static final GHPullRequestReviewComment invoke$lambda$0(GHPullRequestReviewComment $comment, Object it) {
                                return $comment;
                            }
                        }, arg_0));
                    }

                    private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (CompletionStage)$tmp0.invoke(p0);
                    }
                }, arg_0)) : GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).addComment(this.$progressIndicator, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0), reviewId, this.$replyToCommentId, this.$body);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"override fun addComment(\u2026notifyReviews()\n    }\n  }");
                return GHPRReviewDataProviderImpl.access$notifyReviews(this.this$0, GHPRReviewDataProviderImpl.access$dropReviews(this.this$0, CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, completableFuture, null, (Function0)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ GHPRReviewDataProviderImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        LazyCancellableBackgroundProcessValue lazyCancellableBackgroundProcessValue = GHPRReviewDataProviderImpl.access$getPendingReviewRequestValue$p(this.this$0);
                        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
                        lazyCancellableBackgroundProcessValue.combineResult(completableFuture, addComment.1.INSTANCE);
                    }
                }), (int)1, null)));
            }

            private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletionStage)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun addComment(\u2026notifyReviews()\n    }\n  }");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> deleteComment(@NotNull ProgressIndicator progressIndicator, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        CompletableFuture<GHPullRequestPendingReviewDTO> future2 = this.reviewService.deleteComment(progressIndicator, this.pullRequestId, commentId);
        this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.handleOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function2)((Function2)new Function2<GHPullRequestPendingReviewDTO, Throwable, GHPullRequestPendingReview>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final GHPullRequestPendingReview invoke(@Nullable GHPullRequestPendingReviewDTO result, @Nullable Throwable error) {
                block3: {
                    block2: {
                        if (error != null) break block2;
                        GHPullRequestPendingReviewDTO gHPullRequestPendingReviewDTO = result;
                        if ((gHPullRequestPendingReviewDTO != null ? gHPullRequestPendingReviewDTO.getState() : null) != GHPullRequestReviewState.PENDING) break block2;
                        Integer n = result.getComments().getTotalCount();
                        if (n != null && n == 0) break block3;
                    }
                    ((GHPRDataOperationsListener)this.this$0.getMessageBus().syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onReviewsChanged();
                    throw new ProcessCanceledException();
                }
                return null;
            }
        }), (int)1, null));
        this.reviewThreadsRequestValue.combineResult(future2, (Function2)new Function2<List<? extends GHPullRequestReviewThread>, GHPullRequestPendingReviewDTO, List<? extends GHPullRequestReviewThread>>(commentId){
            final /* synthetic */ String $commentId;
            {
                this.$commentId = $commentId;
                super(2);
            }

            @NotNull
            public final List<GHPullRequestReviewThread> invoke(@NotNull List<GHPullRequestReviewThread> list, @NotNull GHPullRequestPendingReviewDTO gHPullRequestPendingReviewDTO) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)gHPullRequestPendingReviewDTO, (String)"<anonymous parameter 1>");
                return GHPRReviewDataProviderImplKt.access$removeComment(list, this.$commentId);
            }
        });
        return future2;
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewComment> updateComment(@NotNull ProgressIndicator progressIndicator, @NotNull String commentId, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        CompletableFuture<GHPullRequestReviewComment> future2 = this.reviewService.updateComment(progressIndicator, this.pullRequestId, commentId, newText);
        this.reviewThreadsRequestValue.combineResult(future2, (Function2)new Function2<List<? extends GHPullRequestReviewThread>, GHPullRequestReviewComment, List<? extends GHPullRequestReviewThread>>(commentId){
            final /* synthetic */ String $commentId;
            {
                this.$commentId = $commentId;
                super(2);
            }

            @NotNull
            public final List<GHPullRequestReviewThread> invoke(@NotNull List<GHPullRequestReviewThread> list, @NotNull GHPullRequestReviewComment newComment) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)newComment, (String)"newComment");
                return GHPRReviewDataProviderImplKt.access$updateCommentBody(list, this.$commentId, newComment.getBody());
            }
        });
        return future2;
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> createThread(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String body2, int line, @NotNull Side side, int startLine, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        CompletableFuture<GHPullRequestReviewThread> future2 = this.reviewService.addThread(progressIndicator, reviewId, body2, line, side, startLine, fileName);
        this.reviewThreadsRequestValue.combineResult(future2, createThread.1.INSTANCE);
        return this.notifyReviews(CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.resetPendingReview();
            }
        }), (int)1, null));
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> resolveThread(@NotNull ProgressIndicator progressIndicator, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CompletableFuture<GHPullRequestReviewThread> future2 = this.reviewService.resolveThread(progressIndicator, this.pullRequestId, id);
        this.reviewThreadsRequestValue.combineResult(future2, resolveThread.1.INSTANCE);
        return future2;
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> unresolveThread(@NotNull ProgressIndicator progressIndicator, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CompletableFuture<GHPullRequestReviewThread> future2 = this.reviewService.unresolveThread(progressIndicator, this.pullRequestId, id);
        this.reviewThreadsRequestValue.combineResult(future2, unresolveThread.1.INSTANCE);
        return future2;
    }

    private final <T> CompletableFuture<T> notifyReviews(CompletableFuture<T> $this$notifyReviews) {
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, $this$notifyReviews, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ((GHPRDataOperationsListener)this.this$0.getMessageBus().syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onReviewsChanged();
            }
        }), (int)1, null);
    }

    private final <T> CompletableFuture<T> dropReviews(CompletableFuture<T> $this$dropReviews) {
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, $this$dropReviews, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GHPRReviewDataProviderImpl.access$getReviewThreadsRequestValue$p(this.this$0).drop();
            }
        }), (int)1, null);
    }

    @Override
    public void addReviewThreadsListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.reviewThreadsRequestValue.addDropEventListener(disposable, listener2);
    }

    @Override
    public void addPendingReviewListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.pendingReviewRequestValue.addDropEventListener(disposable, listener2);
    }

    public void dispose() {
        this.pendingReviewRequestValue.drop();
        this.reviewThreadsRequestValue.drop();
    }

    private static final GHPullRequestPendingReview createReview$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GHPullRequestPendingReview)$tmp0.invoke(p0);
    }

    private static final CompletionStage addComment$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletionStage addComment$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ GHPRReviewService access$getReviewService$p(GHPRReviewDataProviderImpl $this) {
        return $this.reviewService;
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getPendingReviewRequestValue$p(GHPRReviewDataProviderImpl $this) {
        return $this.pendingReviewRequestValue;
    }

    public static final /* synthetic */ CompletableFuture access$notifyReviews(GHPRReviewDataProviderImpl $this, CompletableFuture $receiver) {
        return $this.notifyReviews($receiver);
    }

    public static final /* synthetic */ CompletableFuture access$dropReviews(GHPRReviewDataProviderImpl $this, CompletableFuture $receiver) {
        return $this.dropReviews($receiver);
    }

    public static final /* synthetic */ GHPRIdentifier access$getPullRequestId$p(GHPRReviewDataProviderImpl $this) {
        return $this.pullRequestId;
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getReviewThreadsRequestValue$p(GHPRReviewDataProviderImpl $this) {
        return $this.reviewThreadsRequestValue;
    }
}

