/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryException;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.propertyBased.ActionOnFile;
import com.intellij.testFramework.propertyBased.CheckPsiReadAccessors;
import com.intellij.testFramework.propertyBased.CheckPsiTextConsistency;
import com.intellij.testFramework.propertyBased.CommitDocumentAction;
import com.intellij.testFramework.propertyBased.DeleteRange;
import com.intellij.testFramework.propertyBased.InsertString;
import com.intellij.testFramework.propertyBased.MadTestingAction;
import com.intellij.testFramework.propertyBased.ResolveAllReferences;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.GenerationEnvironment;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.ImperativeCommand;
import org.jetbrains.jetCheck.PropertyChecker;

public final class MadTestingUtil {
    private static final Logger LOG = Logger.getInstance(MadTestingUtil.class);
    private static final boolean USE_ROULETTE_WHEEL = true;

    public static void restrictChangesToDocument(Document document, Runnable r) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r::run, event -> {
            VirtualFile file2;
            Document changed = event.getDocument();
            if (changed != document && (file2 = FileDocumentManager.getInstance().getFile(changed)) != null && file2.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed));
            }
        });
    }

    private static void letSaveAllDocumentsPassIfAny() {
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void prohibitDocumentChanges(Runnable r) {
        MadTestingUtil.letSaveAllDocumentsPassIfAny();
        MadTestingUtil.watchDocumentChanges(r::run, event -> {
            Document changed = event.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(changed);
            if (file2 != null && file2.isInLocalFileSystem()) {
                throw new AssertionError((Object)("Unexpected document change: " + changed));
            }
        });
    }

    private static <E extends Throwable> void watchDocumentChanges(ThrowableRunnable<E> r, final Consumer<? super DocumentEvent> eventHandler) throws E {
        Disposable disposable = Disposer.newDisposable();
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                eventHandler.accept(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/testFramework/propertyBased/MadTestingUtil$1", "documentChanged"));
            }
        }, disposable);
        try {
            r.run();
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static void changeAndRevert(Project project2, Runnable r) {
        Label label = LocalHistory.getInstance().putUserLabel(project2, "changeAndRevert");
        boolean failed = false;
        try {
            r.run();
        }
        catch (Throwable e) {
            failed = true;
            throw e;
        }
        finally {
            MadTestingUtil.restoreEverything(label, failed, project2);
        }
    }

    private static void restoreEverything(Label label, boolean failed, Project project2) {
        try {
            WriteAction.run(() -> {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                new RunAll(() -> PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting(), () -> FileEditorManagerEx.getInstanceEx((Project)project2).closeAllFiles(), () -> EditorHistoryManager.getInstance((Project)project2).removeAllFiles(), () -> FileDocumentManager.getInstance().saveAllDocuments(), () -> MadTestingUtil.revertVfs(label, project2), () -> documentManager.commitAllDocuments(), () -> UsefulTestCase.assertEmpty(documentManager.getUncommittedDocuments()), () -> UsefulTestCase.assertEmpty(FileDocumentManager.getInstance().getUnsavedDocuments())).run();
            });
        }
        catch (Throwable e) {
            if (failed) {
                LOG.info("Exceptions while restoring state", e);
            }
            throw e;
        }
    }

    private static void revertVfs(Label label, Project project2) throws LocalHistoryException {
        MadTestingUtil.watchDocumentChanges(() -> label.revert(project2, PlatformTestUtil.getOrCreateProjectBaseDir(project2)), __ -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            if (documentManager.getUncommittedDocuments().length > 3) {
                documentManager.commitAllDocuments();
            }
        });
    }

    public static void enableAllInspections(@NotNull Project project2, @NotNull Language fileLanguage, String ... except) {
        if (project2 == null) {
            MadTestingUtil.$$$reportNull$$$0(0);
        }
        if (fileLanguage == null) {
            MadTestingUtil.$$$reportNull$$$0(1);
        }
        if (except == null) {
            MadTestingUtil.$$$reportNull$$$0(2);
        }
        InspectionProfileImpl.INIT_INSPECTIONS = true;
        InspectionProfileImpl profile = new InspectionProfileImpl("allEnabled");
        profile.enableAllTools(project2);
        MadTestingUtil.disableInspection(project2, profile, "HighlightVisitorInternal");
        for (String shortId : except) {
            MadTestingUtil.disableInspection(project2, profile, shortId);
        }
        MadTestingUtil.replaceProfile(project2, profile, fileLanguage);
    }

    public static void enableDefaultInspections(@NotNull Project project2, @NotNull Language fileLanguage) {
        if (project2 == null) {
            MadTestingUtil.$$$reportNull$$$0(3);
        }
        if (fileLanguage == null) {
            MadTestingUtil.$$$reportNull$$$0(4);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl("defaultInspections");
        InspectionsKt.runInInitMode(() -> {
            MadTestingUtil.replaceProfile(project2, profile, fileLanguage);
            return null;
        });
    }

    private static void replaceProfile(@NotNull Project project2, @NotNull InspectionProfileImpl profile, @NotNull Language fileLanguage) {
        if (project2 == null) {
            MadTestingUtil.$$$reportNull$$$0(5);
        }
        if (profile == null) {
            MadTestingUtil.$$$reportNull$$$0(6);
        }
        if (fileLanguage == null) {
            MadTestingUtil.$$$reportNull$$$0(7);
        }
        profile.getAllEnabledInspectionTools(project2).forEach(state -> {
            InspectionToolWrapper wrapper = state.getTool();
            String inspectionLanguage = wrapper.getLanguage();
            if (inspectionLanguage == null || fileLanguage.isKindOf(inspectionLanguage)) {
                wrapper.getTool();
            }
        });
        ProjectInspectionProfileManager manager = (ProjectInspectionProfileManager)InspectionProjectProfileManager.getInstance((Project)project2);
        manager.addProfile(profile);
        InspectionProfileImpl prev = manager.getCurrentProfile();
        manager.setCurrentProfile(profile);
        Disposer.register((Disposable)((ProjectEx)project2).getEarlyDisposable(), () -> {
            InspectionProfileImpl.INIT_INSPECTIONS = false;
            manager.setCurrentProfile(prev);
            manager.deleteProfile(profile);
        });
    }

    private static void disableInspection(Project project2, InspectionProfileImpl profile, String shortId) {
        ToolsImpl tools = profile.getToolsOrNull(shortId, project2);
        if (tools != null) {
            tools.setEnabled(false);
        }
    }

    public static Generator<File> randomFiles(String rootPath, FileFilter fileFilter) {
        return MadTestingUtil.randomFiles(rootPath, fileFilter, true);
    }

    private static Generator<File> randomFiles(final String rootPath, FileFilter fileFilter, boolean useRouletteWheel) {
        FileFilter interestingIdeaFiles = child -> {
            String name = child.getName();
            if (name.startsWith(".")) {
                return false;
            }
            if (child.isDirectory()) {
                return MadTestingUtil.shouldGoInsiderDir(name);
            }
            return !FileTypeManager.getInstance().getFileTypeByFileName(name).isBinary() && fileFilter.accept(child) && child.length() < 500000L;
        };
        File root = new File(rootPath);
        Function<GenerationEnvironment, File> generator = useRouletteWheel ? new RouletteWheelFileGenerator(root, interestingIdeaFiles) : new FileGenerator(root, interestingIdeaFiles);
        return Generator.from((Function)generator).suchThat((Predicate)new Predicate<File>(){

            @Override
            public boolean test(File file2) {
                return file2 != null;
            }

            public String toString() {
                return "can find a file under " + rootPath + " satisfying given filters";
            }
        }).noShrink();
    }

    @NotNull
    public static Supplier<MadTestingAction> actionsOnFileContents(CodeInsightTestFixture fixture, String rootPath, FileFilter fileFilter, Function<? super PsiFile, ? extends Generator<? extends MadTestingAction>> actions) {
        return MadTestingUtil.performOnFileContents(fixture, rootPath, fileFilter, (env, vFile) -> env.executeCommands(Generator.from(data -> (MadTestingAction)data.generate((Generator)actions.apply(fixture.getPsiManager().findFile(vFile))))));
    }

    @NotNull
    public static Supplier<MadTestingAction> performOnFileContents(CodeInsightTestFixture fixture, String rootPath, FileFilter fileFilter, BiConsumer<? super ImperativeCommand.Environment, ? super VirtualFile> action) {
        Generator<File> randomFiles = MadTestingUtil.randomFiles(rootPath, fileFilter);
        Supplier<MadTestingAction> supplier = () -> env -> new RunAll(() -> {
            File ioFile = (File)env.generateValue(randomFiles, "Working with %s");
            VirtualFile vFile = MadTestingUtil.copyFileToProject(ioFile, fixture, rootPath);
            PsiFile psiFile = fixture.getPsiManager().findFile(vFile);
            if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiPlainTextFile) {
                System.err.println("Can't check " + vFile + " due to incorrect file type: " + psiFile + " of " + psiFile.getClass());
                return;
            }
            action.accept(env, vFile);
        }, () -> WriteAction.run(() -> {
            for (VirtualFile file2 : Objects.requireNonNull(fixture.getTempDirFixture().getFile("")).getChildren()) {
                file2.delete((Object)fixture);
            }
        }), () -> PsiDocumentManager.getInstance((Project)fixture.getProject()).commitAllDocuments(), () -> UIUtil.dispatchAllInvocationEvents()).run();
        if (supplier == null) {
            MadTestingUtil.$$$reportNull$$$0(8);
        }
        return supplier;
    }

    private static boolean shouldGoInsiderDir(@NotNull String name) {
        if (name == null) {
            MadTestingUtil.$$$reportNull$$$0(9);
        }
        return !name.equals("gen") && !name.equals("reports") && !name.equals("android") && MadTestingUtil.canContainSources(name) && !name.endsWith("system") && !name.endsWith("config") && !name.equals("build");
    }

    private static boolean canContainSources(@NotNull String name) {
        if (name == null) {
            MadTestingUtil.$$$reportNull$$$0(10);
        }
        return !name.equals("jdk") && !name.equals("jre") && !name.equals("lib") && !name.equals("bin") && !name.equals("out") && !name.startsWith(".");
    }

    @NotNull
    private static VirtualFile copyFileToProject(File ioFile, CodeInsightTestFixture fixture, String rootPath) {
        VirtualFile virtualFile;
        try {
            VirtualFile existing;
            String path = FileUtil.getRelativePath((String)FileUtil.toCanonicalPath((String)rootPath), (String)FileUtil.toSystemIndependentName((String)ioFile.getPath()), (char)'/');
            assert (path != null);
            Matcher rootPackageMatcher = Pattern.compile("/com/|/org/|/onair/").matcher(path);
            if (rootPackageMatcher.find()) {
                path = path.substring(rootPackageMatcher.start() + 1);
            }
            if ((existing = fixture.getTempDirFixture().getFile(path)) != null) {
                WriteAction.run(() -> existing.delete((Object)fixture));
            }
            virtualFile = fixture.addFileToProject(path, FileUtil.loadFile((File)ioFile)).getVirtualFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            MadTestingUtil.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    public static Generator<MadTestingAction> randomEditsWithReparseChecks(@NotNull PsiFile file2) {
        if (file2 == null) {
            MadTestingUtil.$$$reportNull$$$0(12);
        }
        Generator generator = Generator.sampledFrom((Object[])new MadTestingAction[]{new InsertString(file2), new DeleteRange(file2), new CommitDocumentAction(file2), new CheckPsiTextConsistency(file2)});
        if (generator == null) {
            MadTestingUtil.$$$reportNull$$$0(13);
        }
        return generator;
    }

    @NotNull
    public static Function<PsiFile, Generator<? extends MadTestingAction>> randomEditsWithPsiAccessorChecks(@NotNull Condition<? super Method> skipCondition) {
        if (skipCondition == null) {
            MadTestingUtil.$$$reportNull$$$0(14);
        }
        Function<PsiFile, Generator<? extends MadTestingAction>> function = file2 -> Generator.sampledFrom((Object[])new ActionOnFile[]{new InsertString((PsiFile)file2), new DeleteRange((PsiFile)file2), new CommitDocumentAction((PsiFile)file2), new CheckPsiReadAccessors((PsiFile)file2, skipCondition), new ResolveAllReferences((PsiFile)file2)});
        if (function == null) {
            MadTestingUtil.$$$reportNull$$$0(15);
        }
        return function;
    }

    public static boolean isAfterError(PsiFile file2, int offset) {
        return SyntaxTraverser.psiTraverser((PsiElement)file2).filter(PsiErrorElement.class).find(e -> e.getTextRange().getStartOffset() <= offset) != null;
    }

    public static boolean containsErrorElements(FileViewProvider viewProvider) {
        return ContainerUtil.exists((Iterable)viewProvider.getAllFiles(), file2 -> SyntaxTraverser.psiTraverser((PsiElement)file2).filter(PsiErrorElement.class).isNotEmpty());
    }

    @NotNull
    public static String getPositionDescription(int offset, Document document) {
        int line = document.getLineNumber(offset);
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        int column = offset - start;
        Object prefix = document.getText(new TextRange(start, offset)).trim();
        if (((String)prefix).length() > 30) {
            prefix = "..." + ((String)prefix).substring(((String)prefix).length() - 30);
        }
        String suffix = StringUtil.shortenTextWithEllipsis((String)document.getText(new TextRange(offset, end)), (int)30, (int)0);
        String text = (String)prefix + "|" + suffix;
        String string = offset + "(" + (line + 1) + ":" + (column + 1) + ") [" + text + "]";
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    static String getIntentionDescription(IntentionAction action) {
        return MadTestingUtil.getIntentionDescription(action.getText(), action);
    }

    @NotNull
    static String getIntentionDescription(String intentionName, IntentionAction action) {
        IntentionAction actual = IntentionActionDelegate.unwrap((IntentionAction)action);
        String family = actual.getFamilyName();
        Class<?> aClass = actual.getClass();
        LocalQuickFix fix = QuickFixWrapper.unwrap((CommonIntentionAction)actual);
        if (fix != null) {
            family = fix.getFamilyName();
            aClass = fix.getClass();
        }
        String string = "'" + intentionName + "' (family: '" + family + "'; class: '" + aClass.getName() + "')";
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void testFileGenerator(File root, FileFilter filter, int iterationCount, PrintStream out) {
        for (boolean roulette : new boolean[]{true, false}) {
            out.println("Testing " + (roulette ? "roulette" : "plain") + " generator");
            ObjectIntHashMap fileMap = new ObjectIntHashMap();
            Generator<File> generator = MadTestingUtil.randomFiles(root.getPath(), filter, roulette);
            MadTestingAction action = arg_0 -> MadTestingUtil.lambda$testFileGenerator$30(iterationCount, generator, filter, (ObjectIntMap)fileMap, out, arg_0);
            PropertyChecker.customized().withIterationCount(1).checkScenarios(() -> action);
        }
    }

    @NotNull
    private static String getHistogramReport(ObjectIntMap<String> fileMap, int iteration) {
        long[] stops = new long[]{1L, 2L, 3L, 5L, 10L, 20L, 30L, 50L, 100L, 200L, Long.MAX_VALUE};
        int[] histogram = new int[stops.length];
        for (ObjectIntMap.Entry entry : fileMap.entries()) {
            int count = entry.getValue();
            int pos = Arrays.binarySearch(stops, (long)count);
            if (pos < 0) {
                pos = -pos - 1;
            }
            int n = pos;
            histogram[n] = histogram[n] + 1;
        }
        StringBuilder report = new StringBuilder();
        for (int i = 0; i < stops.length; ++i) {
            String range = i == 0 || stops[i - 1] == stops[i] - 1L ? String.valueOf(stops[i]) : stops[i - 1] + 1L + (String)(stops[i] == Long.MAX_VALUE ? "+" : ".." + stops[i]);
            report.append(String.format(Locale.ENGLISH, "%s: %-5d| ", range, histogram[i]));
        }
        String string = String.format(Locale.ENGLISH, "#%-5d: sum = %5d [%s]", iteration, Arrays.stream(histogram).sum(), report.toString().replaceFirst("[\\s|]+$", ""));
        if (string == null) {
            MadTestingUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void lambda$testFileGenerator$30(int iterationCount, Generator generator, FileFilter filter, ObjectIntMap fileMap, PrintStream out, ImperativeCommand.Environment env) {
        long lastTime;
        long startTime = lastTime = System.nanoTime();
        for (int iteration = 1; iteration <= iterationCount; ++iteration) {
            File file2 = (File)env.generateValue(generator, null);
            assert (filter.accept(file2));
            fileMap.put((Object)file2.getPath(), fileMap.getOrDefault((Object)file2.getPath(), 0) + 1);
            long curTime = System.nanoTime();
            if (iteration <= 10) {
                out.print("#" + iteration + " = " + (curTime - lastTime) / 1000000L + "ms");
                if (iteration == 10) {
                    out.println();
                } else {
                    out.print("; ");
                }
                lastTime = curTime;
            }
            if (iteration != iterationCount && curTime - lastTime <= TimeUnit.SECONDS.toNanos(5L)) continue;
            lastTime = curTime;
            out.println(MadTestingUtil.getHistogramReport((ObjectIntMap<String>)fileMap, iteration));
        }
        out.println("Total time: " + (System.nanoTime() - startTime) / 1000000L + "ms");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 13, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileLanguage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "except";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "performOnFileContents";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFileToProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithReparseChecks";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "randomEditsWithPsiAccessorChecks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionDescription";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionDescription";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistogramReport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "enableAllInspections";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enableDefaultInspections";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceProfile";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldGoInsiderDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canContainSources";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "randomEditsWithReparseChecks";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "randomEditsWithPsiAccessorChecks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 13, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static final class RouletteWheelFileGenerator
    implements Function<GenerationEnvironment, File> {
        private final File myRoot;
        private final FileFilter myFilter;
        private static final File[] EMPTY_DIRECTORY = new File[0];
        private final SoftFactoryMap<File, File[]> myChildrenCache;

        private RouletteWheelFileGenerator(@NotNull File root, @NotNull FileFilter filter) {
            if (root == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(0);
            }
            if (filter == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(1);
            }
            this.myChildrenCache = new SoftFactoryMap<File, File[]>(){

                protected File[] create(@NotNull File f) {
                    File[] files;
                    if (f == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((files = f.listFiles(child -> myFilter.accept(child) && (child.isFile() || FileGenerator.containsAtLeastOneFileDeep(child)))) == null) {
                        return null;
                    }
                    if (files.length == 0) {
                        return EMPTY_DIRECTORY;
                    }
                    return files;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/testFramework/propertyBased/MadTestingUtil$RouletteWheelFileGenerator$1", "create"));
                }
            };
            this.myRoot = root;
            this.myFilter = filter;
        }

        @Override
        public File apply(GenerationEnvironment data) {
            return this.generateRandomFile(data, this.myRoot, new HashSet<File>());
        }

        @Nullable
        private File generateRandomFile(GenerationEnvironment data, File file2, Set<File> exhausted) {
            File[] children = (File[])this.myChildrenCache.get((Object)file2);
            if (children == null) {
                return file2;
            }
            if (children == EMPTY_DIRECTORY) {
                return null;
            }
            Arrays.sort(children, Comparator.comparing(File::getName));
            while (true) {
                int index;
                int[] weights = Arrays.stream(children).mapToInt(child -> this.estimateWeight((File)child, exhausted)).toArray();
                try {
                    index = RouletteWheelFileGenerator.spin(data, weights);
                }
                catch (RuntimeException e) {
                    if ("org.jetbrains.jetCheck.CannotRestoreValue".equals(e.getClass().getName())) {
                        throw new RuntimeException("Directory structure changed in " + file2 + " or its direct children?", e);
                    }
                    throw e;
                }
                if (index == -1) {
                    return null;
                }
                File chosen = children[index];
                File generated = this.generateRandomFile(data, chosen, exhausted);
                if (generated != null) {
                    return generated;
                }
                exhausted.add(chosen);
            }
        }

        private static int spin(@NotNull GenerationEnvironment data, int @NotNull [] weights) {
            int totalWeight;
            if (data == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(2);
            }
            if (weights == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(3);
            }
            if ((totalWeight = Arrays.stream(weights).sum()) == 0) {
                return -1;
            }
            int value = (Integer)data.generate(Generator.integers((int)0, (int)totalWeight));
            for (int i = 0; i < weights.length; ++i) {
                if ((value -= weights[i]) >= 0) continue;
                return i;
            }
            return -1;
        }

        private int estimateWeight(File file2, @NotNull Set<File> exhausted) {
            if (exhausted == null) {
                RouletteWheelFileGenerator.$$$reportNull$$$0(4);
            }
            if (exhausted.contains(file2)) {
                return 0;
            }
            File[] children = (File[])this.myChildrenCache.get((Object)file2);
            if (children == null) {
                return 1;
            }
            return Stream.of(children).mapToInt(f -> exhausted.contains(f) ? 0 : (f.isDirectory() ? 5 : 1)).sum();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "weights";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exhausted";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/testFramework/propertyBased/MadTestingUtil$RouletteWheelFileGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "spin";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "estimateWeight";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FileGenerator
    implements Function<GenerationEnvironment, File> {
        private static final com.intellij.util.Function<File, JBIterable<File>> FS_TRAVERSAL = TreeTraversal.PRE_ORDER_DFS.traversal(f -> f.isDirectory() ? Arrays.asList(Objects.requireNonNull(f.listFiles())) : Collections.emptyList());
        private final File myRoot;
        private final FileFilter myFilter;

        private FileGenerator(File root, FileFilter filter) {
            this.myRoot = root;
            this.myFilter = filter;
        }

        @Override
        public File apply(GenerationEnvironment data) {
            return this.generateRandomFile(data, this.myRoot, new HashSet());
        }

        @Nullable
        private File generateRandomFile(GenerationEnvironment data, File file2, Set<? super File> exhausted) {
            List<File> toChoose;
            File chosen;
            File generated;
            do {
                File[] children;
                if ((children = file2.listFiles(f -> !exhausted.contains(f) && FileGenerator.containsAtLeastOneFileDeep(f) && this.myFilter.accept(f))) == null) {
                    return file2;
                }
                if (children.length == 0) {
                    exhausted.add(file2);
                    return null;
                }
                toChoose = FileGenerator.preferDirs(data, children);
                toChoose.sort(Comparator.comparing(File::getName));
            } while ((generated = this.generateRandomFile(data, chosen = (File)data.generate(Generator.sampledFrom(toChoose)), exhausted)) == null);
            return generated;
        }

        private static boolean containsAtLeastOneFileDeep(File root) {
            return ((JBIterable)FS_TRAVERSAL.fun((Object)root)).find(f -> f.isFile()) != null;
        }

        private static List<File> preferDirs(GenerationEnvironment data, File[] children) {
            ArrayList files = new ArrayList();
            ArrayList<File> dirs = new ArrayList<File>();
            for (File child : children) {
                (child.isDirectory() ? dirs : files).add(child);
            }
            if (files.isEmpty() || dirs.isEmpty()) {
                return Arrays.asList(children);
            }
            int ratio = Math.max(100, dirs.size() / files.size());
            return (Integer)data.generate(Generator.integers((int)0, (int)(ratio - 1))) != 0 ? dirs : files;
        }
    }
}

