/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class ShellVariablesRegistryImpl
implements ShellVariablesRegistry {
    @NotNull
    private final Map<String, Collection<TextMateShellVariable>> myVariables = new ConcurrentHashMap<String, Collection<TextMateShellVariable>>();

    @Deprecated(forRemoval=true)
    public void fillVariablesFromPlist(@NotNull CharSequence scopeName, @NotNull Plist plist2) {
        PListValue shellVariables;
        if (scopeName == null) {
            ShellVariablesRegistryImpl.$$$reportNull$$$0(0);
        }
        if (plist2 == null) {
            ShellVariablesRegistryImpl.$$$reportNull$$$0(1);
        }
        if ((shellVariables = plist2.getPlistValue("shellVariables")) != null) {
            for (PListValue variable : shellVariables.getArray()) {
                Plist variablePlist = variable.getPlist();
                String name = variablePlist.getPlistValue("name", "").getString();
                String value = variablePlist.getPlistValue("value", "").getString();
                this.addVariable(new TextMateShellVariable(scopeName, name, value));
            }
        }
    }

    public void addVariable(@NotNull TextMateShellVariable variable) {
        if (variable == null) {
            ShellVariablesRegistryImpl.$$$reportNull$$$0(2);
        }
        if (!variable.name.isEmpty()) {
            this.myVariables.computeIfAbsent(variable.name, key -> Collections.synchronizedList(new CopyOnWriteArrayList())).add(variable);
        }
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariableValue(@NotNull String name, @Nullable TextMateScope scope) {
        if (name == null) {
            ShellVariablesRegistryImpl.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            return null;
        }
        Collection<TextMateShellVariable> variables = this.myVariables.get(name);
        if (variables == null) {
            return null;
        }
        return new TextMateScopeComparator<TextMateShellVariable>(scope, TextMateShellVariable::getScopeSelector).max(variables);
    }

    public void clear() {
        this.myVariables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistryImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillVariablesFromPlist";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

