/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.Semaphore;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalModelListenerEx;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\u0018\u0000 \u0097\u00012\u00020\u0001:\b\u0097\u0001\u0098\u0001\u0099\u0001\u009a\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010RJ\u001a\u0010S\u001a\u00020N2\u0006\u0010O\u001a\u00020\r2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010RJ\u001a\u0010T\u001a\u00020N2\u0006\u0010O\u001a\u00020D2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010RJ\u0016\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u0016J\u0006\u0010Y\u001a\u00020NJ\u0010\u0010Z\u001a\u00020N2\b\b\u0002\u0010[\u001a\u00020\u0016J\u0006\u0010\\\u001a\u00020NJ\u0016\u0010]\u001a\u00020N2\u0006\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020\u0016J\u001e\u0010`\u001a\u00020N2\u0006\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u00162\u0006\u0010a\u001a\u00020\u0016J\u001e\u0010b\u001a\u00020N2\u0006\u0010X\u001a\u00020\u00162\u0006\u0010a\u001a\u00020\u00162\u0006\u0010c\u001a\u00020\u0016J\u001e\u0010d\u001a\u00020N2\u0006\u0010e\u001a\u00020\u00162\u0006\u0010f\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u0016J\u0016\u0010g\u001a\u00020N2\u0006\u0010h\u001a\u00020\u00162\u0006\u0010i\u001a\u00020\u0016J\u001a\u0010j\u001a\u0002092\b\b\u0002\u0010k\u001a\u00020\u00162\b\b\u0002\u0010l\u001a\u00020\u0016J\u000e\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020\u0016J(\u0010p\u001a\u0002092\u0006\u0010q\u001a\u00020\u00162\u0006\u0010r\u001a\u00020\u00162\u0006\u0010k\u001a\u00020\u00162\u0006\u0010l\u001a\u00020\u0016H\u0002J\u0006\u0010s\u001a\u000209J\u001e\u0010t\u001a\u00020N2\u0006\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u00162\u0006\u0010a\u001a\u00020\u0016J\u001e\u0010u\u001a\u00020N2\u0006\u0010X\u001a\u00020\u00162\u0006\u0010a\u001a\u00020\u00162\u0006\u0010c\u001a\u00020\u0016J\u0006\u0010v\u001a\u00020NJ\u0006\u0010w\u001a\u00020NJ\u001e\u0010x\u001a\u00020N2\u0006\u0010y\u001a\u00020\u00162\u0006\u0010z\u001a\u00020\u00162\u0006\u0010{\u001a\u00020|J\u001e\u0010}\u001a\u00020N2\u0006\u0010~\u001a\u00020\u00162\u0006\u0010a\u001a\u00020\u00162\u0006\u0010{\u001a\u00020|J@\u0010\u007f\u001a\u00020N2\b\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001J!\u0010\u0088\u0001\u001a\u00020N2\u0007\u0010\u0089\u0001\u001a\u00020\u00162\u0006\u0010c\u001a\u00020\u00162\u0007\u0010\u008a\u0001\u001a\u00020\u0016J\u0017\u0010\u008b\u0001\u001a\u00020N2\u0006\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u0016J\u0018\u0010\u008c\u0001\u001a\u00020N2\u0006\u0010h\u001a\u00020\u00162\u0007\u0010\u008d\u0001\u001a\u00020 J\u0007\u0010\u008e\u0001\u001a\u00020NJ,\u0010\u008f\u0001\u001a\u0003H\u0090\u0001\"\u0005\b\u0000\u0010\u0090\u00012\u000f\u0010\u0091\u0001\u001a\n\u0012\u0005\u0012\u0003H\u0090\u00010\u0092\u0001H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0093\u0001J!\u0010\u0094\u0001\u001a\u00020N2\u0006\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u00162\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R$\u0010!\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\"\"\u0004\b&\u0010$R$\u0010'\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\"\"\u0004\b(\u0010$R$\u0010)\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R$\u0010+\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\"\"\u0004\b,\u0010$R$\u0010.\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020-@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00104\u001a\u0002032\u0006\u0010\u000e\u001a\u000203@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R$\u0010:\u001a\u0002092\u0006\u0010\u000e\u001a\u000209@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010E\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010\"\"\u0004\bG\u0010$R\u0011\u0010H\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u0019R$\u0010J\u001a\u0002092\u0006\u0010\u000e\u001a\u000209@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010<\"\u0004\bL\u0010>\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u009b\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "styleState", "Lcom/jediterm/terminal/model/StyleState;", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/jediterm/terminal/model/StyleState;)V", "commandExecutionSemaphore", "Lcom/intellij/util/concurrency/Semaphore;", "getCommandExecutionSemaphore", "()Lcom/intellij/util/concurrency/Semaphore;", "cursorListeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$CursorListener;", "value", "Lcom/jediterm/terminal/CursorShape;", "cursorShape", "getCursorShape", "()Lcom/jediterm/terminal/CursorShape;", "setCursorShape", "(Lcom/jediterm/terminal/CursorShape;)V", "<set-?>", "", "cursorX", "getCursorX", "()I", "cursorY", "getCursorY", "height", "getHeight", "historyLinesCount", "getHistoryLinesCount", "", "isBracketedPasteMode", "()Z", "setBracketedPasteMode", "(Z)V", "isCommandRunning", "setCommandRunning", "isCursorBlinking", "setCursorBlinking", "isCursorVisible", "setCursorVisible", "isScrollingEnabled", "setScrollingEnabled", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "mouseFormat", "getMouseFormat", "()Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "setMouseFormat", "(Lcom/jediterm/terminal/emulator/mouse/MouseFormat;)V", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "mouseMode", "getMouseMode", "()Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "setMouseMode", "(Lcom/jediterm/terminal/emulator/mouse/MouseMode;)V", "", "promptText", "getPromptText", "()Ljava/lang/String;", "setPromptText", "(Ljava/lang/String;)V", "screenLinesCount", "getScreenLinesCount", "getStyleState", "()Lcom/jediterm/terminal/model/StyleState;", "terminalListeners", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$TerminalListener;", "useAlternateBuffer", "getUseAlternateBuffer", "setUseAlternateBuffer", "width", "getWidth", "windowTitle", "getWindowTitle", "setWindowTitle", "addContentListener", "", "listener", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$ContentListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "addCursorListener", "addTerminalListener", "charAt", "", "x", "y", "clearAll", "clearAllExceptPrompt", "promptLines", "clearHistory", "clearLines", "beginY", "endY", "deleteCharacters", "count", "deleteLines", "scrollRegionBottom", "eraseCharacters", "leftX", "rightX", "eraseLine", "line", "limit", "getAllText", "updatedCursorX", "updatedCursorY", "getLine", "Lcom/jediterm/terminal/model/TerminalLine;", "index", "getLinesText", "fromLine", "toLine", "getScreenText", "insertBlankCharacters", "insertLines", "lockContent", "moveScreenLinesToHistory", "processHistoryAndScreenLines", "scrollOrigin", "maxLinesToProcess", "consumer", "Lcom/jediterm/terminal/StyledTextConsumer;", "processScreenLines", "yStart", "resize", "newSize", "Ljava/awt/Dimension;", "origin", "Lcom/jediterm/terminal/RequestOrigin;", "selection", "Lcom/jediterm/terminal/model/TerminalSelection;", "resizeHandler", "Lcom/jediterm/terminal/model/JediTerminal$ResizeHandler;", "scrollArea", "scrollRegionTop", "dy", "setCursor", "setLineWrapped", "wrapped", "unlockContent", "withContentLock", "T", "callable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "writeString", "buffer", "", "Companion", "ContentListener", "CursorListener", "TerminalListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1855#2,2:340\n1855#2,2:342\n1855#2,2:344\n1855#2,2:346\n1855#2,2:348\n1855#2,2:350\n1855#2,2:352\n1855#2,2:354\n1855#2,2:356\n1855#2,2:358\n1855#2,2:360\n1855#2,2:362\n*S KotlinDebug\n*F\n+ 1 TerminalModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalModel\n*L\n38#1:340,2\n46#1:342,2\n54#1:344,2\n62#1:346,2\n70#1:348,2\n78#1:350,2\n86#1:352,2\n94#1:354,2\n103#1:356,2\n112#1:358,2\n126#1:360,2\n224#1:362,2\n*E\n"})
public final class TerminalModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final StyleState styleState;
    @NotNull
    private final Semaphore commandExecutionSemaphore;
    private int cursorX;
    private int cursorY;
    private boolean isCommandRunning;
    @NotNull
    private CursorShape cursorShape;
    private boolean isCursorVisible;
    private boolean isCursorBlinking;
    private boolean isBracketedPasteMode;
    private boolean isScrollingEnabled;
    @NotNull
    private MouseMode mouseMode;
    @NotNull
    private MouseFormat mouseFormat;
    @NotNull
    private String windowTitle;
    @NotNull
    private volatile String promptText;
    @NotNull
    private final List<TerminalListener> terminalListeners;
    @NotNull
    private final List<CursorListener> cursorListeners;
    public static final int MIN_WIDTH = 5;
    public static final int MIN_HEIGHT = 2;

    public TerminalModel(@NotNull TerminalTextBuffer textBuffer, @NotNull StyleState styleState) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)styleState, (String)"styleState");
        this.textBuffer = textBuffer;
        this.styleState = styleState;
        this.commandExecutionSemaphore = new Semaphore();
        this.cursorShape = CursorShape.BLINK_BLOCK;
        this.isCursorVisible = true;
        this.isCursorBlinking = true;
        this.isScrollingEnabled = true;
        this.mouseMode = MouseMode.MOUSE_REPORTING_NONE;
        this.mouseFormat = MouseFormat.MOUSE_FORMAT_XTERM;
        this.windowTitle = "Terminal";
        this.promptText = "";
        this.terminalListeners = new CopyOnWriteArrayList();
        this.cursorListeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final StyleState getStyleState() {
        return this.styleState;
    }

    @NotNull
    public final Semaphore getCommandExecutionSemaphore() {
        return this.commandExecutionSemaphore;
    }

    public final int getWidth() {
        return this.textBuffer.getWidth();
    }

    public final int getHeight() {
        return this.textBuffer.getHeight();
    }

    public final int getCursorX() {
        return this.cursorX;
    }

    public final int getCursorY() {
        return this.cursorY;
    }

    public final boolean isCommandRunning() {
        return this.isCommandRunning;
    }

    public final void setCommandRunning(boolean bl) {
        this.isCommandRunning = bl;
    }

    @NotNull
    public final CursorShape getCursorShape() {
        return this.cursorShape;
    }

    public final void setCursorShape(@NotNull CursorShape value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.cursorShape) {
            this.cursorShape = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onShapeChanged(value);
            }
        }
    }

    public final boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    public final void setCursorVisible(boolean value) {
        if (value != this.isCursorVisible) {
            this.isCursorVisible = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onVisibilityChanged(value);
            }
        }
    }

    public final boolean isCursorBlinking() {
        return this.isCursorBlinking;
    }

    public final void setCursorBlinking(boolean value) {
        if (value != this.isCursorBlinking) {
            this.isCursorBlinking = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onBlinkingChanged(value);
            }
        }
    }

    public final boolean isBracketedPasteMode() {
        return this.isBracketedPasteMode;
    }

    public final void setBracketedPasteMode(boolean value) {
        if (value != this.isBracketedPasteMode) {
            this.isBracketedPasteMode = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onBracketedPasteModeChanged(value);
            }
        }
    }

    public final boolean isScrollingEnabled() {
        return this.isScrollingEnabled;
    }

    public final void setScrollingEnabled(boolean value) {
        if (value != this.isScrollingEnabled) {
            this.isScrollingEnabled = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onScrollingChanged(value);
            }
        }
    }

    @NotNull
    public final MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public final void setMouseMode(@NotNull MouseMode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.mouseMode) {
            this.mouseMode = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onMouseModeChanged(value);
            }
        }
    }

    @NotNull
    public final MouseFormat getMouseFormat() {
        return this.mouseFormat;
    }

    public final void setMouseFormat(@NotNull MouseFormat value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value != this.mouseFormat) {
            this.mouseFormat = value;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onMouseFormatChanged(value);
            }
        }
    }

    @NotNull
    public final String getWindowTitle() {
        return this.windowTitle;
    }

    public final void setWindowTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)value, (Object)this.windowTitle)) {
            this.windowTitle = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onWindowTitleChanged(value);
            }
        }
    }

    public final boolean getUseAlternateBuffer() {
        return this.textBuffer.isUsingAlternateBuffer();
    }

    public final void setUseAlternateBuffer(boolean value) {
        if (this.textBuffer.isUsingAlternateBuffer() != value) {
            this.textBuffer.useAlternateBuffer(value);
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onAlternateBufferChanged(value);
            }
        }
    }

    @NotNull
    public final String getPromptText() {
        return this.promptText;
    }

    public final void setPromptText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)value, (Object)this.promptText)) {
            this.promptText = value;
            Iterable $this$forEach$iv = this.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onPromptTextChanged(value);
            }
        }
    }

    public final int getHistoryLinesCount() {
        return this.textBuffer.getHistoryLinesCount();
    }

    public final int getScreenLinesCount() {
        return this.textBuffer.getScreenLinesCount();
    }

    public final void setCursor(int x, int y) {
        if (x != this.cursorX || y != this.cursorY) {
            this.cursorX = x;
            this.cursorY = y;
            Iterable $this$forEach$iv = this.cursorListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CursorListener it = (CursorListener)element$iv;
                boolean bl = false;
                it.onPositionChanged(x, y);
            }
        }
    }

    public final char charAt(int x, int y) {
        return this.textBuffer.getCharAt(x, y);
    }

    @NotNull
    public final TerminalLine getLine(int index) {
        TerminalLine terminalLine = this.textBuffer.getLine(index);
        Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"textBuffer.getLine(index)");
        return terminalLine;
    }

    public final void processHistoryAndScreenLines(int scrollOrigin, int maxLinesToProcess, @NotNull StyledTextConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.textBuffer.processHistoryAndScreenLines(scrollOrigin, maxLinesToProcess, consumer2);
    }

    public final void processScreenLines(int yStart, int count, @NotNull StyledTextConsumer consumer2) {
        Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
        this.textBuffer.processScreenLines(yStart, count, consumer2);
    }

    @NotNull
    public final String getAllText(int updatedCursorX, int updatedCursorY) {
        return this.getLinesText(-this.getHistoryLinesCount(), this.getScreenLinesCount(), updatedCursorX, updatedCursorY);
    }

    public static /* synthetic */ String getAllText$default(TerminalModel terminalModel, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = terminalModel.cursorX;
        }
        if ((n3 & 2) != 0) {
            n2 = terminalModel.cursorY;
        }
        return terminalModel.getAllText(n, n2);
    }

    @NotNull
    public final String getScreenText() {
        return this.getLinesText(0, this.getScreenLinesCount(), this.cursorX, this.cursorY);
    }

    private final String getLinesText(int fromLine, int toLine, int updatedCursorX, int updatedCursorY) {
        String string;
        StringBuilder builder = new StringBuilder();
        for (int ind = fromLine; ind < toLine; ++ind) {
            String text;
            Intrinsics.checkNotNullExpressionValue((Object)this.getLine(ind).getText(), (String)"getLine(ind).text");
            if (ind == updatedCursorY - 1) {
                String string2 = text.substring(0, Math.min(updatedCursorX, text.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                text = string2;
            }
            builder.append(text);
            if (!(((CharSequence)text).length() > 0)) continue;
            builder.append('\n');
        }
        if (((CharSequence)builder).length() > 0) {
            string = ((Object)StringsKt.dropLast((CharSequence)builder, (int)1)).toString();
        } else {
            String string3 = builder.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"builder.toString()");
        }
        return string;
    }

    public final void scrollArea(int scrollRegionTop, int scrollRegionBottom, int dy) {
        this.textBuffer.scrollArea(scrollRegionTop, dy, scrollRegionBottom);
    }

    public final void writeString(int x, int y, @NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.textBuffer.writeString(x, y, new CharBuffer(buffer, 0, buffer.length));
    }

    public final void insertLines(int y, int count, int scrollRegionBottom) {
        this.textBuffer.insertLines(y, count, scrollRegionBottom);
    }

    public final void insertBlankCharacters(int x, int y, int count) {
        this.textBuffer.insertBlankCharacters(x, y, count);
    }

    public final void clearAll() {
        this.textBuffer.clearAll();
    }

    public final void clearLines(int beginY, int endY) {
        this.textBuffer.clearLines(beginY, endY);
    }

    public final void clearHistory() {
        this.textBuffer.clearHistory();
    }

    public final void eraseLine(int line, int limit) {
        this.textBuffer.getLine(line).deleteCharacters(limit);
    }

    public final void eraseCharacters(int leftX, int rightX, int y) {
        this.textBuffer.eraseCharacters(leftX, rightX, y);
    }

    public final void deleteCharacters(int x, int y, int count) {
        this.textBuffer.deleteCharacters(x, y, count);
    }

    public final void deleteLines(int y, int count, int scrollRegionBottom) {
        this.textBuffer.deleteLines(y, count, scrollRegionBottom);
    }

    public final void setLineWrapped(int line, boolean wrapped) {
        this.textBuffer.getLine(line).setWrapped(wrapped);
    }

    public final void resize(@NotNull Dimension newSize, @NotNull RequestOrigin origin, int cursorX, int cursorY, @Nullable TerminalSelection selection, @NotNull JediTerminal.ResizeHandler resizeHandler) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)resizeHandler, (String)"resizeHandler");
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        JediTerminal.ResizeHandler handler = (arg_0, arg_1, arg_2, arg_3) -> TerminalModel.resize$lambda$12(oldWidth, oldHeight, this, resizeHandler, arg_0, arg_1, arg_2, arg_3);
        TermSize termSize = new TermSize(newSize.width, newSize.height);
        this.textBuffer.resize(termSize, origin, cursorX, cursorY, handler, selection);
    }

    public final void moveScreenLinesToHistory() {
        Method method = TerminalTextBuffer.class.getDeclaredMethod("moveScreenLinesToHistory", new Class[0]);
        if (method == null) {
            throw new IllegalStateException("Not found method: moveScreenLinesToHistory".toString());
        }
        Method method2 = method;
        method2.setAccessible(true);
        method2.invoke((Object)this.textBuffer, new Object[0]);
    }

    public final void clearAllExceptPrompt(int promptLines) {
        this.textBuffer.scrollArea(1, promptLines - this.cursorY, this.getHeight());
        this.textBuffer.clearHistory();
        this.cursorY = promptLines;
    }

    public static /* synthetic */ void clearAllExceptPrompt$default(TerminalModel terminalModel, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        terminalModel.clearAllExceptPrompt(n);
    }

    public final void lockContent() {
        this.textBuffer.lock();
    }

    public final void unlockContent() {
        this.textBuffer.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withContentLock(@NotNull Function0<? extends T> callable) {
        Object object;
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        boolean $i$f$withContentLock = false;
        this.lockContent();
        try {
            object = callable.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unlockContent();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public final void addContentListener(@NotNull ContentListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        TerminalModelListenerEx terminalListener2 = new TerminalModelListenerEx(listener){
            final /* synthetic */ ContentListener $listener;
            {
                this.$listener = $listener;
            }

            public void modelChanged() {
                this.$listener.onContentChanged();
            }

            public void textWritten(int x, int y, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                this.$listener.onTextWritten(x, y, text);
            }
        };
        this.textBuffer.addModelListener((TerminalModelListener)terminalListener2);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addContentListener$lambda$13(this, terminalListener2));
        }
    }

    public static /* synthetic */ void addContentListener$default(TerminalModel terminalModel, ContentListener contentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addContentListener(contentListener, disposable);
    }

    public final void addTerminalListener(@NotNull TerminalListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.terminalListeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addTerminalListener$lambda$14(this, listener));
        }
    }

    public static /* synthetic */ void addTerminalListener$default(TerminalModel terminalModel, TerminalListener terminalListener2, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addTerminalListener(terminalListener2, disposable);
    }

    public final void addCursorListener(@NotNull CursorListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.cursorListeners.add(listener);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> TerminalModel.addCursorListener$lambda$15(this, listener));
        }
    }

    public static /* synthetic */ void addCursorListener$default(TerminalModel terminalModel, CursorListener cursorListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalModel.addCursorListener(cursorListener, disposable);
    }

    private static final void resize$lambda$12(int $oldWidth, int $oldHeight, TerminalModel this$0, JediTerminal.ResizeHandler $resizeHandler, int newWidth, int newHeight, int newCursorX, int newCursorY) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resizeHandler, (String)"$resizeHandler");
        if (newWidth != $oldWidth || newHeight != $oldHeight) {
            Iterable $this$forEach$iv = this$0.terminalListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TerminalListener it = (TerminalListener)element$iv;
                boolean bl = false;
                it.onSizeChanged(newWidth, newHeight);
            }
        }
        $resizeHandler.sizeUpdated(newWidth, newHeight, newCursorX, newCursorY);
    }

    private static final void addContentListener$lambda$13(TerminalModel this$0, addContentListener.terminalListener.1 $terminalListener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$terminalListener, (String)"$terminalListener");
        this$0.textBuffer.removeModelListener((TerminalModelListener)$terminalListener);
    }

    private static final void addTerminalListener$lambda$14(TerminalModel this$0, TerminalListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.terminalListeners.remove($listener);
    }

    private static final void addCursorListener$lambda$15(TerminalModel this$0, CursorListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.cursorListeners.remove($listener);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalModel$Companion;", "", "()V", "MIN_HEIGHT", "", "MIN_WIDTH", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalModel$ContentListener;", "", "onContentChanged", "", "onTextWritten", "x", "", "y", "text", "", "intellij.terminal"})
    public static interface ContentListener {
        default public void onContentChanged() {
        }

        default public void onTextWritten(int x, int y, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalModel$CursorListener;", "", "onBlinkingChanged", "", "blinking", "", "onMouseFormatChanged", "format", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "onMouseModeChanged", "mode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "onPositionChanged", "cursorX", "", "cursorY", "onShapeChanged", "shape", "Lcom/jediterm/terminal/CursorShape;", "onVisibilityChanged", "visible", "intellij.terminal"})
    public static interface CursorListener {
        default public void onPositionChanged(int cursorX, int cursorY) {
        }

        default public void onShapeChanged(@NotNull CursorShape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        }

        default public void onVisibilityChanged(boolean visible) {
        }

        default public void onBlinkingChanged(boolean blinking) {
        }

        default public void onMouseModeChanged(@NotNull MouseMode mode) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        }

        default public void onMouseFormatChanged(@NotNull MouseFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\nH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalModel$TerminalListener;", "", "onAlternateBufferChanged", "", "enabled", "", "onBracketedPasteModeChanged", "bracketed", "onPromptTextChanged", "newText", "", "onScrollingChanged", "onSizeChanged", "width", "", "height", "onWindowTitleChanged", "title", "intellij.terminal"})
    public static interface TerminalListener {
        default public void onSizeChanged(int width, int height) {
        }

        default public void onWindowTitleChanged(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        }

        default public void onScrollingChanged(boolean enabled) {
        }

        default public void onAlternateBufferChanged(boolean enabled) {
        }

        default public void onBracketedPasteModeChanged(boolean bracketed) {
        }

        default public void onPromptTextChanged(@NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        }
    }
}

