/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringOperation;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextProblem {
    private final Rule rule;
    private final TextContent text;
    private final List<TextRange> highlightRanges;

    protected TextProblem(@NotNull Rule rule, @NotNull TextContent text2, @NotNull TextRange highlightRange) {
        if (rule == null) {
            TextProblem.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            TextProblem.$$$reportNull$$$0(1);
        }
        if (highlightRange == null) {
            TextProblem.$$$reportNull$$$0(2);
        }
        this(rule, text2, List.of(highlightRange));
    }

    protected TextProblem(@NotNull Rule rule, @NotNull TextContent text2, @NotNull List<TextRange> highlightRanges) {
        if (rule == null) {
            TextProblem.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            TextProblem.$$$reportNull$$$0(4);
        }
        if (highlightRanges == null) {
            TextProblem.$$$reportNull$$$0(5);
        }
        this.rule = rule;
        this.text = text2;
        this.highlightRanges = Collections.unmodifiableList(highlightRanges);
        assert (!highlightRanges.isEmpty());
        for (int i = 0; i < highlightRanges.size(); ++i) {
            TextRange range = highlightRanges.get(i);
            assert (range.getStartOffset() >= 0 && range.getEndOffset() <= text2.length());
            if (i > 0) assert (range.getStartOffset() > highlightRanges.get(i - 1).getEndOffset());
        }
    }

    @NotNull
    public final Rule getRule() {
        Rule rule = this.rule;
        if (rule == null) {
            TextProblem.$$$reportNull$$$0(6);
        }
        return rule;
    }

    @NotNull
    public abstract String getShortMessage();

    @NotNull
    @InspectionMessage
    public abstract String getDescriptionTemplate(boolean var1);

    @NotNull
    @NlsContexts.Tooltip
    public String getTooltipTemplate() {
        String string2 = this.getDescriptionTemplate(true);
        if (string2 == null) {
            TextProblem.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public final TextContent getText() {
        TextContent textContent = this.text;
        if (textContent == null) {
            TextProblem.$$$reportNull$$$0(8);
        }
        return textContent;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final TextRange getHighlightRange() {
        return new TextRange(this.highlightRanges.get(0).getStartOffset(), ((TextRange)ContainerUtil.getLastItem(this.highlightRanges)).getEndOffset());
    }

    @NotNull
    public final List<TextRange> getHighlightRanges() {
        List<TextRange> list = this.highlightRanges;
        if (list == null) {
            TextProblem.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public TextRange getReplacementRange() {
        TextRange textRange = this.getHighlightRanges().get(0);
        if (textRange == null) {
            TextProblem.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    @Nullable
    public TextRange getPatternRange() {
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public List<String> getCorrections() {
        List<String> list = List.of();
        if (list == null) {
            TextProblem.$$$reportNull$$$0(11);
        }
        return list;
    }

    public boolean shouldSuppressInCodeLikeFragments() {
        return true;
    }

    @NotNull
    public List<Suggestion> getSuggestions() {
        List<String> corrections = this.getCorrections();
        if (corrections.isEmpty()) {
            List<Suggestion> list = List.of();
            if (list == null) {
                TextProblem.$$$reportNull$$$0(12);
            }
            return list;
        }
        TextRange range = this.getReplacementRange();
        List list = ContainerUtil.map(corrections, replacement -> Suggestion.replace(range, replacement));
        if (list == null) {
            TextProblem.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<LocalQuickFix> getCustomFixes() {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            TextProblem.$$$reportNull$$$0(14);
        }
        return list;
    }

    public boolean fitsGroup(@NotNull RuleGroup group) {
        if (group == null) {
            TextProblem.$$$reportNull$$$0(15);
        }
        return group.getRules().contains(this.rule.getGlobalId());
    }

    public String toString() {
        return this.getHighlightRange().subSequence((CharSequence)this.text) + " (" + this.getShortMessage() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRanges";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/TextProblem";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/TextProblem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightRanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrections";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fitsGroup";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string2);
        };
    }

    public static interface Suggestion {
        public List<StringOperation> getChanges();

        public String getPresentableText();

        @Nullable
        default public String getBatchId() {
            return null;
        }

        public static Suggestion replace(final TextRange range, final CharSequence replacement) {
            return new Suggestion(){

                @Override
                public List<StringOperation> getChanges() {
                    return List.of(StringOperation.replace((TextRange)range, (CharSequence)replacement));
                }

                @Override
                public String getPresentableText() {
                    return replacement.toString();
                }
            };
        }
    }
}

