/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.lines.LinesFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class ClosingBracesFilter
extends LinesFilter {
    private boolean myHasInstructions;
    private int myCurrentLine = -1;
    private boolean mySeenReturn;
    private int myLinesCount = 0;

    private void tryRemoveLine() {
        if (this.myCurrentLine != -1 && this.mySeenReturn && !this.myHasInstructions && this.myLinesCount > 1) {
            this.myContext.removeLine(this.myCurrentLine);
            --this.myLinesCount;
            this.myCurrentLine = -1;
        }
    }

    public void visitLineNumber(int line, Label start) {
        this.tryRemoveLine();
        if (this.myCurrentLine != line) {
            ++this.myLinesCount;
        }
        this.myCurrentLine = this.myContext.getLineData(line) == null ? line : -1;
        this.myHasInstructions = false;
        this.mySeenReturn = false;
        super.visitLineNumber(line, start);
    }

    public void visitEnd() {
        this.tryRemoveLine();
        super.visitEnd();
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (this.myCurrentLine == -1) {
            return;
        }
        if (172 <= opcode && opcode <= 177) {
            this.mySeenReturn = true;
            return;
        }
        if (opcode == 87) {
            return;
        }
        this.setHasInstructions();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.setHasInstructions();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.setHasInstructions();
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.setHasInstructions();
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        this.setHasInstructions();
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.setHasInstructions();
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.setHasInstructions();
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        this.setHasInstructions();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.setHasInstructions();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        if (opcode == 178 && owner.equals("kotlin/Unit") && name.equals("INSTANCE") && descriptor.equals("Lkotlin/Unit;")) {
            return;
        }
        this.setHasInstructions();
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.setHasInstructions();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        this.setHasInstructions();
    }

    private void setHasInstructions() {
        this.myHasInstructions |= !this.mySeenReturn && this.myCurrentLine != -1;
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return true;
    }
}

