/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript;

import com.intellij.configurationScript.ConfigurationFileManagerKt;
import com.intellij.configurationScript.ConfigurationScriptBundle;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactory;
import com.intellij.configurationScript.IntellijConfigurationJsonSchemaProviderFactoryKt;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/configurationScript/IntellijConfigurationJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "schemeContent", "", "getSchemeContent", "()Ljava/lang/CharSequence;", "schemeContent$delegate", "Lkotlin/Lazy;", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "MyJsonSchemaFileProvider", "intellij.configurationScript"})
public final class IntellijConfigurationJsonSchemaProviderFactory
implements JsonSchemaProviderFactory,
DumbAware {
    @NotNull
    private final Lazy schemeContent$delegate = LazyKt.lazy((Function0)schemeContent.2.INSTANCE);

    private final CharSequence getSchemeContent() {
        Lazy lazy = this.schemeContent$delegate;
        return (CharSequence)lazy.getValue();
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        List result;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SoftReference softReference = (SoftReference)IntellijConfigurationJsonSchemaProviderFactoryKt.access$getPROVIDER_KEY$p().get((UserDataHolder)project);
        List list = result = softReference != null ? (List)softReference.get() : null;
        if (result != null) {
            return result;
        }
        result = CollectionsKt.listOf((Object)new MyJsonSchemaFileProvider());
        project.putUserData(IntellijConfigurationJsonSchemaProviderFactoryKt.access$getPROVIDER_KEY$p(), new SoftReference<List>(result));
        return result;
    }

    public static final /* synthetic */ CharSequence access$getSchemeContent(IntellijConfigurationJsonSchemaProviderFactory $this) {
        return $this.getSchemeContent();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\u0006\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/configurationScript/IntellijConfigurationJsonSchemaProviderFactory$MyJsonSchemaFileProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "Lcom/intellij/openapi/project/DumbAware;", "(Lcom/intellij/configurationScript/IntellijConfigurationJsonSchemaProviderFactory;)V", "schemeFile", "Lkotlin/Lazy;", "com/intellij/configurationScript/IntellijConfigurationJsonSchemaProviderFactory$MyJsonSchemaFileProvider$schemeFile$1$1", "getName", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "getSchemaFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "getSchemaVersion", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaVersion;", "isAvailable", "", "file", "isUserVisible", "intellij.configurationScript"})
    public final class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider,
    DumbAware {
        @NotNull
        private final Lazy<schemeFile.1> schemeFile;

        public MyJsonSchemaFileProvider() {
            this.schemeFile = LazyKt.lazy((Function0)((Function0)new Function0<schemeFile.1>(IntellijConfigurationJsonSchemaProviderFactory.this){
                final /* synthetic */ IntellijConfigurationJsonSchemaProviderFactory this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final schemeFile.1 invoke() {
                    JsonFileType jsonFileType = JsonFileType.INSTANCE;
                    Charset charset = Charsets.UTF_8;
                    return new LightVirtualFile(this.this$0, jsonFileType, charset){
                        final /* synthetic */ IntellijConfigurationJsonSchemaProviderFactory this$0;
                        {
                            this.this$0 = $receiver;
                            super("ij-scheme.json", (FileType)$super_call_param$1, (CharSequence)"", $super_call_param$2, 0L);
                        }

                        @NotNull
                        public CharSequence getContent() {
                            return IntellijConfigurationJsonSchemaProviderFactory.access$getSchemeContent(this.this$0);
                        }

                        @NotNull
                        public ThreeState isTooLargeForIntelligence() {
                            return ThreeState.YES;
                        }
                    };
                }
            }));
        }

        @NotNull
        public String getName() {
            String string = ConfigurationScriptBundle.message("intellij.configuration.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"intellij.configuration.name\")");
            return string;
        }

        @NotNull
        public VirtualFile getSchemaFile() {
            if (!SystemProperties.getBooleanProperty((String)"configuration.schema.cache", (boolean)true) && this.schemeFile.isInitialized()) {
                CharSequence newData = IntellijConfigurationJsonSchemaProviderFactoryKt.access$generateConfigurationSchema();
                schemeFile.1 file = (Object)this.schemeFile.getValue();
                if (!StringUtil.equals((CharSequence)file.getContent(), (CharSequence)newData)) {
                    file.setContent(null, newData, true);
                }
            }
            return (VirtualFile)this.schemeFile.getValue();
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }

        @NotNull
        public JsonSchemaVersion getSchemaVersion() {
            return JsonSchemaVersion.SCHEMA_7;
        }

        public boolean isUserVisible() {
            return false;
        }

        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return ConfigurationFileManagerKt.isConfigurationFile(file);
        }
    }
}

