/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public interface ScopeInfo {
    public static final ScopeInfo PROJECT = new ScopeInfo(){

        @Override
        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            return VcsBundle.message("update.project.scope.name", new Object[0]);
        }

        @Override
        public boolean filterExistsInVcs() {
            return true;
        }

        @Override
        public FilePath[] getRoots(VcsContext context, ActionInfo actionInfo) {
            AbstractVcs[] vcses;
            ArrayList<FilePath> result2 = new ArrayList<FilePath>();
            Project project2 = context.getProject();
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
            for (AbstractVcs vcs : vcses = vcsManager2.getAllActiveVcss()) {
                VirtualFile[] files2;
                if (actionInfo.getEnvironment(vcs) == null) continue;
                for (VirtualFile file : files2 = vcsManager2.getRootsUnderVcs(vcs)) {
                    result2.add(VcsUtil.getFilePath(file));
                }
            }
            return result2.toArray(new FilePath[0]);
        }
    };
    public static final ScopeInfo FILES = new ScopeInfo(){

        @Override
        public String getScopeName(VcsContext dataContext, ActionInfo actionInfo) {
            FilePath[] roots = this.getRoots(dataContext, actionInfo);
            if (roots.length == 0) {
                return VcsBundle.message("update.files.scope.name", new Object[0]);
            }
            boolean directory = roots[0].isDirectory();
            if (roots.length == 1) {
                if (directory) {
                    return VcsBundle.message("update.directory.scope.name", new Object[0]);
                }
                return VcsBundle.message("update.file.scope.name", new Object[0]);
            }
            if (directory) {
                return VcsBundle.message("update.directories.scope.name", new Object[0]);
            }
            return VcsBundle.message("update.files.scope.name", new Object[0]);
        }

        @Override
        public boolean filterExistsInVcs() {
            return true;
        }

        @Override
        public FilePath @NotNull [] getRoots(VcsContext context, ActionInfo actionInfo) {
            FilePath[] filePathArray = context.getSelectedFilePaths();
            if (filePathArray == null) {
                2.$$$reportNull$$$0(0);
            }
            return filePathArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ScopeInfo$2", "getRoots"));
        }
    };

    public FilePath[] getRoots(VcsContext var1, ActionInfo var2);

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getScopeName(VcsContext var1, ActionInfo var2);

    public boolean filterExistsInVcs();
}

