/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 4*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u00014B+\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u001dH\u0015J6\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u001dH%J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020&0\"H$JF\u0010'\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0014\u0010\u001c\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\"0\u001d2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020)0\u001d2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J8\u0010,\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020&0-2\u0006\u0010*\u001a\u00020+2\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00170.H\u0007J\b\u0010/\u001a\u00020\u0017H\u0014J\u001d\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020&2\u0006\u00102\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00103R\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Lcom/intellij/vcs/log/data/AbstractDataGetter;", "T", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/vcs/log/data/DataGetter;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "parentDisposable", "(Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;Lcom/intellij/openapi/Disposable;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "getDisposableFlag", "()Lcom/intellij/openapi/util/CheckedDisposable;", "getLogProviders", "()Ljava/util/Map;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "cacheCommits", "", "commits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "doLoadCommitsData", "Lit/unimi/dsi/fastutil/ints/IntSet;", "consumer", "Lcom/intellij/util/Consumer;", "doLoadCommitsDataFromProvider", "logProvider", "root", "hashes", "", "", "getCommitDataIfAvailable", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "loadCommitsData", "errorConsumer", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadCommitsDataSynchronously", "", "Lkotlin/Function2;", "notifyLoaded", "saveInCache", "commit", "details", "(ILcom/intellij/vcs/log/VcsShortCommitDetails;)V", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nAbstractDataGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,175:1\n1#2:176\n1490#3:177\n1520#3,3:178\n1523#3,3:188\n361#4,7:181\n*S KotlinDebug\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter\n*L\n105#1:177\n105#1:178,3\n105#1:188,3\n105#1:181,7\n*E\n"})
public abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final CheckedDisposable disposableFlag;
    @NotNull
    private static final Logger LOG;

    public AbstractDataGetter(@NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.storage = storage;
        this.logProviders = logProviders;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable()");
        this.disposableFlag = checkedDisposable;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    @NotNull
    protected final VcsLogStorage getStorage() {
        return this.storage;
    }

    @NotNull
    protected final Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.logProviders;
    }

    @NotNull
    protected final CheckedDisposable getDisposableFlag() {
        return this.disposableFlag;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> commits2, @NotNull Consumer<? super List<? extends T>> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator) {
        IntOpenHashSet intOpenHashSet;
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(errorConsumer, (String)"errorConsumer");
        Int2ObjectMap<T> detailsFromCache = this.getCommitDataIfAvailable(commits2);
        if (detailsFromCache.size() == commits2.size()) {
            AbstractDataGetter.Companion.runInCurrentThread(indicator, (Function0<Unit>)((Function0)new Function0<Unit>(consumer, commits2, detailsFromCache){
                final /* synthetic */ Consumer<? super List<? extends T>> $consumer;
                final /* synthetic */ List<Integer> $commits;
                final /* synthetic */ Int2ObjectMap<T> $detailsFromCache;
                {
                    this.$consumer = $consumer;
                    this.$commits = $commits;
                    this.$detailsFromCache = $detailsFromCache;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Iterable iterable = this.$commits;
                    Int2ObjectMap<T> int2ObjectMap = this.$detailsFromCache;
                    Consumer<? super List<? extends T>> consumer = this.$consumer;
                    boolean $i$f$mapNotNull = false;
                    void var4_5 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        VcsShortCommitDetails it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        int it = ((Number)element$iv$iv).intValue();
                        boolean bl2 = false;
                        if ((VcsShortCommitDetails)int2ObjectMap.get(it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    consumer.consume((Object)((List)destination$iv$iv));
                }
            }));
            return;
        }
        IntOpenHashSet $this$loadCommitsData_u24lambda_u240 = intOpenHashSet = new IntOpenHashSet((Collection)commits2);
        boolean bl = false;
        $this$loadCommitsData_u24lambda_u240.removeAll((IntCollection)detailsFromCache.keySet());
        IntOpenHashSet toLoad = intOpenHashSet;
        this.cacheCommits(toLoad);
        String string2 = VcsLogBundle.message("vcs.log.loading.selected.details.process", new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        Task.Backgroundable task2 = new Task.Backgroundable(this, toLoad, commits2, detailsFromCache, consumer, errorConsumer, string2, performInBackgroundOption){
            final /* synthetic */ AbstractDataGetter<T> this$0;
            final /* synthetic */ IntOpenHashSet $toLoad;
            final /* synthetic */ List<Integer> $commits;
            final /* synthetic */ Int2ObjectMap<T> $detailsFromCache;
            final /* synthetic */ Consumer<? super List<? extends T>> $consumer;
            final /* synthetic */ Consumer<? super Throwable> $errorConsumer;
            {
                this.this$0 = $receiver;
                this.$toLoad = $toLoad;
                this.$commits = $commits;
                this.$detailsFromCache = $detailsFromCache;
                this.$consumer = $consumer;
                this.$errorConsumer = $errorConsumer;
                super(null, $super_call_param$1, true, $super_call_param$2);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.checkCanceled();
                try {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Int2ObjectOpenHashMap detailsFromProvider = new Int2ObjectOpenHashMap();
                    this.this$0.doLoadCommitsData((IntSet)this.$toLoad, arg_0 -> loadCommitsData.task.1.run$lambda$0((Function1)new Function1<T, Unit>(this.this$0, detailsFromProvider){
                        final /* synthetic */ AbstractDataGetter<T> this$0;
                        final /* synthetic */ Int2ObjectOpenHashMap<T> $detailsFromProvider;
                        {
                            this.this$0 = $receiver;
                            this.$detailsFromProvider = $detailsFromProvider;
                            super(1);
                        }

                        public final void invoke(T metadata) {
                            VcsLogStorage vcsLogStorage = this.this$0.getStorage();
                            Id Id2 = metadata.getId();
                            Intrinsics.checkNotNullExpressionValue(Id2, (String)"metadata.id");
                            Hash hash2 = (Hash)Id2;
                            VirtualFile virtualFile = metadata.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"metadata.root");
                            int commitIndex = vcsLogStorage.getCommitIndex(hash2, virtualFile);
                            Intrinsics.checkNotNullExpressionValue(metadata, (String)"metadata");
                            this.this$0.saveInCache(commitIndex, metadata);
                            Integer n = commitIndex;
                            ((Map)this.$detailsFromProvider).put(n, metadata);
                        }
                    }, arg_0));
                    Iterable iterable = this.$commits;
                    Int2ObjectMap<T> int2ObjectMap = this.$detailsFromCache;
                    boolean $i$f$mapNotNull = false;
                    void var7_8 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        int it = ((Number)element$iv$iv).intValue();
                        boolean bl2 = false;
                        VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)int2ObjectMap.get(it);
                        if (vcsShortCommitDetails == null) {
                            vcsShortCommitDetails = (VcsShortCommitDetails)detailsFromProvider.get(it);
                        }
                        if (vcsShortCommitDetails == null) continue;
                        VcsShortCommitDetails it$iv$iv = vcsShortCommitDetails;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List result2 = (List)destination$iv$iv;
                    BaseSingleTaskControllerKt.runInEdt(this.this$0.getDisposableFlag(), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, this.$consumer, result2){
                        final /* synthetic */ AbstractDataGetter<T> this$0;
                        final /* synthetic */ Consumer<? super List<? extends T>> $consumer;
                        final /* synthetic */ List<T> $result;
                        {
                            this.this$0 = $receiver;
                            this.$consumer = $consumer;
                            this.$result = $result;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.notifyLoaded();
                            this.$consumer.consume(this.$result);
                        }
                    }));
                }
                catch (ProcessCanceledException detailsFromProvider) {
                }
                catch (Throwable t) {
                    if (!(t instanceof VcsException)) {
                        AbstractDataGetter.access$getLOG$cp().error(t);
                    }
                    BaseSingleTaskControllerKt.runInEdt(this.this$0.getDisposableFlag(), (Function0<Unit>)((Function0)new Function0<Unit>(this.$errorConsumer, t){
                        final /* synthetic */ Consumer<? super Throwable> $errorConsumer;
                        final /* synthetic */ Throwable $t;
                        {
                            this.$errorConsumer = $errorConsumer;
                            this.$t = $t;
                            super(0);
                        }

                        public final void invoke() {
                            this.$errorConsumer.consume((Object)this.$t);
                        }
                    }));
                }
            }

            private static final void run$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
        AbstractDataGetter.Companion.runInBackgroundThread(indicator, task2);
    }

    @RequiresBackgroundThread
    public final void loadCommitsDataSynchronously(@NotNull Iterable<Integer> commits2, @NotNull ProgressIndicator indicator, @NotNull Function2<? super Integer, ? super T, Unit> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        IntOpenHashSet toLoad = new IntOpenHashSet();
        Iterator<Integer> iterator = commits2.iterator();
        while (iterator.hasNext()) {
            int id = ((Number)iterator.next()).intValue();
            VcsShortCommitDetails details = this.getCommitDataIfAvailable(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                continue;
            }
            consumer.invoke((Object)id, (Object)details);
        }
        if (!toLoad.isEmpty()) {
            indicator.checkCanceled();
            this.doLoadCommitsData((IntSet)toLoad, arg_0 -> AbstractDataGetter.loadCommitsDataSynchronously$lambda$1((Function1)new Function1<T, Unit>(this, consumer){
                final /* synthetic */ AbstractDataGetter<T> this$0;
                final /* synthetic */ Function2<Integer, T, Unit> $consumer;
                {
                    this.this$0 = $receiver;
                    this.$consumer = $consumer;
                    super(1);
                }

                public final void invoke(T details) {
                    VcsLogStorage vcsLogStorage = this.this$0.getStorage();
                    Id Id2 = details.getId();
                    Intrinsics.checkNotNullExpressionValue(Id2, (String)"details.id");
                    Hash hash2 = (Hash)Id2;
                    VirtualFile virtualFile = details.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"details.root");
                    int commitIndex = vcsLogStorage.getCommitIndex(hash2, virtualFile);
                    Intrinsics.checkNotNullExpressionValue(details, (String)"details");
                    this.this$0.saveInCache(commitIndex, details);
                    this.$consumer.invoke((Object)commitIndex, details);
                }
            }, arg_0));
            this.notifyLoaded();
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    protected void doLoadCommitsData(@NotNull IntSet commits2, @NotNull Consumer<? super T> consumer) throws VcsException {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable iterable = this.storage.getCommitIds((Collection)commits2).values();
        boolean bl = false;
        void var6_6 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            VirtualFile key$iv$iv;
            CommitId it2 = (CommitId)element$iv$iv;
            boolean $i$a$-groupBy-AbstractDataGetter$doLoadCommitsData$hashesGroupedByRoot$332 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getRoot(), (String)"it.root");
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            CommitId $i$a$-groupBy-AbstractDataGetter$doLoadCommitsData$hashesGroupedByRoot$332 = (CommitId)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            String string2 = it.getHash().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.hash.asString()");
            list.add(string2);
        }
        Map hashesGroupedByRoot = destination$iv$iv;
        for (Map.Entry entry2 : hashesGroupedByRoot.entrySet()) {
            VirtualFile root = (VirtualFile)entry2.getKey();
            List hashes2 = (List)entry2.getValue();
            VcsLogProvider logProvider = this.logProviders.get(root);
            if (logProvider == null) {
                LOG.error("No log provider for root " + root.getPath() + ". All known log providers " + this.logProviders);
                continue;
            }
            this.doLoadCommitsDataFromProvider(logProvider, root, hashes2, consumer);
        }
    }

    @NotNull
    protected abstract Int2ObjectMap<T> getCommitDataIfAvailable(@NotNull List<Integer> var1);

    protected abstract void saveInCache(int var1, @NotNull T var2);

    protected void cacheCommits(@NotNull IntOpenHashSet commits2) {
        Intrinsics.checkNotNullParameter((Object)commits2, (String)"commits");
    }

    @RequiresBackgroundThread
    protected abstract void doLoadCommitsDataFromProvider(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3, @NotNull Consumer<? super T> var4) throws VcsException;

    protected void notifyLoaded() {
    }

    private static final void loadCommitsDataSynchronously$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final <T extends VcsShortCommitDetails> List<T> getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull List<Integer> commits2) throws VcsException {
        return Companion.getCommitDetails($this$getCommitDetails, commits2);
    }

    @JvmStatic
    @RequiresBackgroundThread
    @NotNull
    public static final <T extends VcsShortCommitDetails> T getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull Hash hash2, @NotNull VirtualFile root) throws VcsException {
        return Companion.getCommitDetails($this$getCommitDetails, hash2, root);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(AbstractDataGetter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(AbstractDataGetter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002J1\u0010\u000f\u001a\u0002H\u0010\"\b\b\u0001\u0010\u0010*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J0\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018\"\b\b\u0001\u0010\u0010*\u00020\u0011*\b\u0012\u0004\u0012\u0002H\u00100\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0018H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/data/AbstractDataGetter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "runInBackgroundThread", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "task", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "runInCurrentThread", "runnable", "Lkotlin/Function0;", "getCommitDetails", "T", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "Lcom/intellij/vcs/log/data/AbstractDataGetter;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/vcs/log/data/AbstractDataGetter;Lcom/intellij/vcs/log/Hash;Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/vcs/log/VcsShortCommitDetails;", "", "commits", "", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nAbstractDataGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1603#2,9:176\n1855#2:185\n1856#2:187\n1612#2:188\n1#3:186\n*S KotlinDebug\n*F\n+ 1 AbstractDataGetter.kt\ncom/intellij/vcs/log/data/AbstractDataGetter$Companion\n*L\n162#1:176,9\n162#1:185\n162#1:187\n162#1:188\n162#1:186\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void runInCurrentThread(ProgressIndicator indicator, Function0<Unit> runnable) {
            if (indicator != null) {
                ProgressManager.getInstance().runProcess(() -> Companion.runInCurrentThread$lambda$0(runnable), indicator);
            } else {
                runnable.invoke();
            }
        }

        private final void runInBackgroundThread(ProgressIndicator indicator, Task.Backgroundable task2) {
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @RequiresBackgroundThread
        @NotNull
        public final <T extends VcsShortCommitDetails> List<T> getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull List<Integer> commits2) throws VcsException {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$getCommitDetails, (String)"<this>");
            Intrinsics.checkNotNullParameter(commits2, (String)"commits");
            Int2ObjectOpenHashMap commitToDetailsMap = new Int2ObjectOpenHashMap();
            Iterable iterable = commits2;
            ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
            if (progressIndicator == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            $this$getCommitDetails.loadCommitsDataSynchronously(iterable, progressIndicator, (Function2)new Function2<Integer, T, Unit>(commitToDetailsMap){
                final /* synthetic */ Int2ObjectOpenHashMap<T> $commitToDetailsMap;
                {
                    this.$commitToDetailsMap = $commitToDetailsMap;
                    super(2);
                }

                public final void invoke(int commitIndex, @NotNull T details) {
                    Intrinsics.checkNotNullParameter(details, (String)"details");
                    Integer n = commitIndex;
                    ((Map)this.$commitToDetailsMap).put(n, details);
                }
            });
            Iterable $this$mapNotNull$iv = commits2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VcsShortCommitDetails it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if ((VcsShortCommitDetails)commitToDetailsMap.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @RequiresBackgroundThread
        @NotNull
        public final <T extends VcsShortCommitDetails> T getCommitDetails(@NotNull AbstractDataGetter<T> $this$getCommitDetails, @NotNull Hash hash2, @NotNull VirtualFile root) throws VcsException {
            Intrinsics.checkNotNullParameter($this$getCommitDetails, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            List<T> commitDetailsList = this.getCommitDetails($this$getCommitDetails, CollectionsKt.listOf((Object)$this$getCommitDetails.getStorage().getCommitIndex(hash2, root)));
            VcsShortCommitDetails vcsShortCommitDetails = (VcsShortCommitDetails)CollectionsKt.singleOrNull(commitDetailsList);
            if (vcsShortCommitDetails == null) {
                Object[] objectArray = new Object[]{hash2.asString(), root.getName()};
                throw new VcsException(VcsLogBundle.message("vcs.log.failed.loading.details", objectArray));
            }
            return (T)vcsShortCommitDetails;
        }

        private static final void runInCurrentThread$lambda$0(Function0 $tmp0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

