/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.query;

import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.query.WebSymbolNameConversionRules;
import com.intellij.webSymbols.query.WebSymbolNameConverter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/webSymbols/query/WebSymbolNameConversionRulesBuilder;", "", "()V", "canonicalNames", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "Lcom/intellij/webSymbols/query/WebSymbolNameConverter;", "matchNames", "nameVariants", "addCanonicalNamesRule", "", "symbolKind", "converter", "addMatchNamesRule", "addNameVariantsRule", "build", "Lcom/intellij/webSymbols/query/WebSymbolNameConversionRules;", "isEmpty", "", "intellij.platform.webSymbols"})
public final class WebSymbolNameConversionRulesBuilder {
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolNameConverter> canonicalNames = new LinkedHashMap();
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolNameConverter> matchNames = new LinkedHashMap();
    @NotNull
    private final Map<WebSymbolQualifiedKind, WebSymbolNameConverter> nameVariants = new LinkedHashMap();

    public final void addCanonicalNamesRule(@NotNull WebSymbolQualifiedKind symbolKind, @NotNull WebSymbolNameConverter converter) {
        Intrinsics.checkNotNullParameter((Object)symbolKind, (String)"symbolKind");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.canonicalNames.putIfAbsent(symbolKind, converter);
    }

    public final void addMatchNamesRule(@NotNull WebSymbolQualifiedKind symbolKind, @NotNull WebSymbolNameConverter converter) {
        Intrinsics.checkNotNullParameter((Object)symbolKind, (String)"symbolKind");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.matchNames.putIfAbsent(symbolKind, converter);
    }

    public final void addNameVariantsRule(@NotNull WebSymbolQualifiedKind symbolKind, @NotNull WebSymbolNameConverter converter) {
        Intrinsics.checkNotNullParameter((Object)symbolKind, (String)"symbolKind");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.nameVariants.putIfAbsent(symbolKind, converter);
    }

    @NotNull
    public final WebSymbolNameConversionRules build() {
        return WebSymbolNameConversionRules.Companion.create(MapsKt.toMap(this.canonicalNames), MapsKt.toMap(this.matchNames), MapsKt.toMap(this.nameVariants));
    }

    public final boolean isEmpty() {
        return this.canonicalNames.isEmpty() && this.matchNames.isEmpty() && this.nameVariants.isEmpty();
    }
}

