/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.query.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.context.WebSymbolsContext;
import com.intellij.webSymbols.context.WebSymbolsContextKindRules;
import com.intellij.webSymbols.context.WebSymbolsContextRulesProvider;
import com.intellij.webSymbols.context.impl.WebSymbolsContextDiscoveryKt;
import com.intellij.webSymbols.query.WebSymbolNameConversionRulesProvider;
import com.intellij.webSymbols.query.WebSymbolNamesProvider;
import com.intellij.webSymbols.query.WebSymbolsQueryConfigurator;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutorFactory;
import com.intellij.webSymbols.query.WebSymbolsQueryResultsCustomizerFactory;
import com.intellij.webSymbols.query.impl.WebSymbolNamesProviderImpl;
import com.intellij.webSymbols.query.impl.WebSymbolsQueryExecutorImpl;
import com.intellij.webSymbols.utils.FileUtils;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\rH\u0016J9\u0010\u001c\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u001ej\u0002`\u001f\u0012\u0004\u0012\u00020 0\u0007\u0012\u0004\u0012\u00020!0\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002R\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/webSymbols/query/impl/WebSymbolsQueryExecutorFactoryImpl;", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutorFactory;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "customScope", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "modificationCount", "", "addScope", "", "scope", "contextDirectory", "disposable", "create", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "location", "Lcom/intellij/psi/PsiElement;", "allowResolve", "", "createNamesProvider", "Lcom/intellij/webSymbols/query/WebSymbolNamesProvider;", "context", "Lcom/intellij/webSymbols/context/WebSymbolsContext;", "dispose", "getContextRules", "Lkotlin/Pair;", "", "Lcom/intellij/webSymbols/ContextKind;", "Lcom/intellij/webSymbols/context/WebSymbolsContextKindRules;", "Lcom/intellij/openapi/util/ModificationTracker;", "dir", "getContextRules$intellij_platform_webSymbols", "getCustomScope", "", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsQueryExecutorFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsQueryExecutorFactoryImpl.kt\ncom/intellij/webSymbols/query/impl/WebSymbolsQueryExecutorFactoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n1855#2,2:141\n1855#2,2:144\n1360#2:146\n1446#2,2:147\n1448#2,3:151\n800#2,11:154\n1549#2:165\n1620#2,3:166\n1855#2,2:169\n1360#2:171\n1446#2,5:172\n1360#2:177\n1446#2,5:178\n1855#2,2:183\n1#3:143\n10#4:149\n10#4:150\n*S KotlinDebug\n*F\n+ 1 WebSymbolsQueryExecutorFactoryImpl.kt\ncom/intellij/webSymbols/query/impl/WebSymbolsQueryExecutorFactoryImpl\n*L\n35#1:141,2\n40#1:144,2\n43#1:146\n43#1:147,2\n43#1:151,3\n87#1:154,11\n88#1:165\n88#1:166,3\n89#1:169,2\n94#1:171\n94#1:172,5\n107#1:177\n107#1:178,5\n109#1:183,2\n50#1:149\n54#1:150\n*E\n"})
public final class WebSymbolsQueryExecutorFactoryImpl
implements WebSymbolsQueryExecutorFactory,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<VirtualFile, WebSymbolsScope> customScope;
    private long modificationCount;

    public WebSymbolsQueryExecutorFactoryImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.customScope = new MultiMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WebSymbolsQueryExecutor create(@Nullable PsiElement location, boolean allowResolve) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        WebSymbolsScope p0;
        Object object;
        block10: {
            block9: {
                void $this$forEach$iv;
                Application application = ApplicationManager.getApplication();
                application.assertReadAccessAllowed();
                Iterable iterable = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WebSymbolsQueryConfigurator it = (WebSymbolsQueryConfigurator)element$iv;
                    boolean bl = false;
                    it.beforeQueryExecutorCreation(this.project);
                }
                object = location;
                if (object == null) break block9;
                PsiElement it = object;
                boolean bl = false;
                WebSymbolsContext webSymbolsContext = WebSymbolsContextDiscoveryKt.buildWebSymbolsContext(it);
                object = webSymbolsContext;
                if (webSymbolsContext != null) break block10;
            }
            object = WebSymbolsContext.Companion.empty();
        }
        Object context = object;
        List scopeList = new ArrayList();
        Iterable $this$forEach$iv = this.getCustomScope(location);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (WebSymbolsScope)element$iv;
            boolean bl = false;
            scopeList.add(p0);
        }
        boolean internalMode = ApplicationManager.getApplication().isInternal();
        PsiElement psiElement = location;
        PsiElement originalLocation = psiElement != null ? psiElement.getOriginalElement() : null;
        Iterable bl = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
        List list = scopeList;
        boolean $i$f$flatMap = false;
        p0 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<WebSymbolsScope> list2;
            WebSymbolsQueryConfigurator queryConfigurator = (WebSymbolsQueryConfigurator)element$iv$iv;
            boolean bl2 = false;
            List<WebSymbolsScope> it = list2 = queryConfigurator.getScope(this.project, originalLocation, (WebSymbolsContext)context, allowResolve);
            boolean bl3 = false;
            if (internalMode && Math.random() < 0.2) {
                boolean $i$f$logger;
                List<WebSymbolsScope> newScope = queryConfigurator.getScope(this.project, originalLocation, (WebSymbolsContext)context, allowResolve);
                if (!Intrinsics.areEqual(newScope, it)) {
                    $i$f$logger = false;
                    Logger logger = Logger.getInstance(WebSymbolsQueryExecutorFactory.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                    logger.error("Query configurator " + queryConfigurator + " should provide scope, which is the same (by equals()), when called with the same arguments: " + it + " != " + newScope);
                }
                if (((Object)newScope).hashCode() != ((Object)it).hashCode()) {
                    $i$f$logger = false;
                    Logger logger = Logger.getInstance(WebSymbolsQueryExecutorFactory.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                    logger.error("Query configurator " + queryConfigurator + " should provide scope, which has the same hashCode(), when called with the same arguments: " + it + " != " + newScope);
                }
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        return new WebSymbolsQueryExecutorImpl(scopeList, this.createNamesProvider(this.project, originalLocation, (WebSymbolsContext)context), WebSymbolsQueryResultsCustomizerFactory.Companion.getQueryResultsCustomizer(location, (WebSymbolsContext)context), (WebSymbolsContext)context, allowResolve);
    }

    @Override
    public void addScope(@NotNull WebSymbolsScope scope2, @Nullable VirtualFile contextDirectory, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        this.customScope.putValue((Object)contextDirectory, (Object)scope2);
        Disposer.register((Disposable)disposable, () -> WebSymbolsQueryExecutorFactoryImpl.addScope$lambda$4(this, contextDirectory, scope2));
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<MultiMap<String, WebSymbolsContextKindRules>, ModificationTracker> getContextRules$intellij_platform_webSymbols(@NotNull Project project2, @NotNull VirtualFile dir) {
        void $this$flatMapTo$iv$iv;
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        MultiMap result2 = new MultiMap();
        Iterable iterable = this.getCustomScope(dir);
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WebSymbolsContextRulesProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            WebSymbolsContextRulesProvider webSymbolsContextRulesProvider = (WebSymbolsContextRulesProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContextRules());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MultiMap it = (MultiMap)element$iv;
            boolean bl = false;
            result2.putAllValues(it);
        }
        List providers = new ArrayList();
        Iterable $this$flatMap$iv = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable it = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WebSymbolsQueryConfigurator it2 = (WebSymbolsQueryConfigurator)element$iv$iv;
            boolean bl = false;
            it2.beforeQueryExecutorCreation(project2);
            Iterable list$iv$iv = it2.getContextRulesProviders(project2, dir);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        for (WebSymbolsContextRulesProvider provider : (List)destination$iv$iv2) {
            result2.putAllValues(provider.getContextRules());
            providers.add(provider.createPointer());
        }
        return new Pair((Object)result2, (Object)WebSymbolUtils.createModificationTracker(providers));
    }

    /*
     * WARNING - void declaration
     */
    private final WebSymbolNamesProvider createNamesProvider(Project project2, PsiElement location, WebSymbolsContext context) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        List nameConversionRules = new ArrayList();
        List providers = new ArrayList();
        Iterable $this$flatMap$iv = WebSymbolsQueryConfigurator.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WebSymbolsQueryConfigurator provider = (WebSymbolsQueryConfigurator)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = provider.getNameConversionRulesProviders(project2, location, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebSymbolNameConversionRulesProvider provider = (WebSymbolNameConversionRulesProvider)element$iv;
            boolean bl = false;
            nameConversionRules.add(provider.getNameConversionRules());
            providers.add(provider.createPointer());
        }
        return new WebSymbolNamesProviderImpl(context.getFramework(), nameConversionRules, WebSymbolUtils.createModificationTracker(providers));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<WebSymbolsScope> getCustomScope(PsiElement context) {
        List<WebSymbolsScope> list;
        if (context != null) {
            VirtualFile virtualFile;
            PsiFile psiFile2;
            PsiElement it = context;
            boolean bl = false;
            PsiFile psiFile3 = InjectedLanguageManager.getInstance((Project)it.getProject()).getTopLevelFile(it);
            if (psiFile3 != null && (psiFile2 = psiFile3.getOriginalFile()) != null && (virtualFile = psiFile2.getVirtualFile()) != null) {
                VirtualFile it2 = virtualFile;
                boolean bl2 = false;
                VirtualFile virtualFile2 = FileUtils.findOriginalFile(it2);
                if (virtualFile2 != null) {
                    VirtualFile it3 = virtualFile2;
                    boolean bl3 = false;
                    List<WebSymbolsScope> list2 = this.getCustomScope(it3);
                    if (list2 != null) {
                        list = list2;
                        return list;
                    }
                }
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    private final List<WebSymbolsScope> getCustomScope(VirtualFile context) {
        List result2 = new ArrayList();
        if (!this.customScope.isEmpty()) {
            Collection collection = this.customScope.get(null);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"customScope.get(null)");
            result2.addAll(collection);
            for (VirtualFile f = context; f != null; f = f.getParent()) {
                if (!this.customScope.containsKey((Object)f)) continue;
                Collection collection2 = this.customScope.get((Object)f);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"customScope.get(f)");
                result2.addAll(collection2);
            }
        }
        return result2;
    }

    private static final void addScope$lambda$4(WebSymbolsQueryExecutorFactoryImpl this$0, VirtualFile $contextDirectory, WebSymbolsScope $scope) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        this$0.customScope.remove((Object)$contextDirectory, (Object)$scope);
    }
}

