/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldHaveBinaryContent;
import org.assertj.core.error.ShouldHaveDigest;
import org.assertj.core.error.ShouldHaveSameContent;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.internal.BinaryDiff;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.internal.Diff;
import org.assertj.core.internal.DigestDiff;
import org.assertj.core.internal.Digests;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.diff.Delta;

public class InputStreams {
    private static final InputStreams INSTANCE = new InputStreams();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    BinaryDiff binaryDiff = new BinaryDiff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static InputStreams instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    InputStreams() {
    }

    public void assertSameContentAs(AssertionInfo info, InputStream actual, InputStream expected) {
        java.util.Objects.requireNonNull(expected, "The InputStream to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of InputStreams:%n  <%s>%nand:%n  <%s>", actual, expected);
            throw new InputStreamsException(msg, e);
        }
    }

    public void assertIsEmpty(AssertionInfo info, InputStream actual) {
        InputStreams.assertNotNull(info, actual);
        try {
            if (actual.read() == -1) {
                return;
            }
            throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
        }
        catch (IOException e) {
            throw new InputStreamsException("Unable to read contents of InputStreams actual", e);
        }
    }

    public void assertIsNotEmpty(AssertionInfo info, InputStream actual) {
        InputStreams.assertNotNull(info, actual);
        try {
            if (actual.read() == -1) {
                throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
            }
        }
        catch (IOException e) {
            throw new InputStreamsException("Unable to read contents of InputStreams actual", e);
        }
    }

    public void assertHasContent(AssertionInfo info, InputStream actual, String expected) {
        java.util.Objects.requireNonNull(expected, "The String to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            List<Delta<String>> diffs = this.diff.diff(actual, expected);
            if (diffs.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveSameContent.shouldHaveSameContent(actual, expected, diffs));
        }
        catch (IOException e) {
            String msg = String.format("Unable to compare contents of InputStream:%n  <%s>%nand String:%n  <%s>", actual, expected);
            throw new InputStreamsException(msg, e);
        }
    }

    public void assertHasBinaryContent(AssertionInfo info, InputStream actual, byte[] expected) {
        java.util.Objects.requireNonNull(expected, "The binary content to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            BinaryDiffResult result2 = this.binaryDiff.diff(actual, expected);
            if (result2.hasNoDiff()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveBinaryContent.shouldHaveBinaryContent(actual, result2));
        }
        catch (IOException e) {
            throw new InputStreamsException(String.format("Unable to verify binary contents of InputStream:%n  <%s>", actual), e);
        }
    }

    private static void assertNotNull(AssertionInfo info, InputStream stream) {
        Objects.instance().assertNotNull(info, stream);
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, MessageDigest digest, byte[] expected) {
        java.util.Objects.requireNonNull(digest, "The message digest algorithm should not be null");
        java.util.Objects.requireNonNull(expected, "The binary representation of digest to compare to should not be null");
        InputStreams.assertNotNull(info, actual);
        try {
            DigestDiff diff = Digests.digestDiff(actual, digest, expected);
            if (diff.digestsDiffer()) {
                throw this.failures.failure(info, ShouldHaveDigest.shouldHaveDigest(actual, diff));
            }
        }
        catch (IOException e) {
            String msg = String.format("Unable to calculate digest of InputStream:%n  <%s>", actual);
            throw new InputStreamsException(msg, e);
        }
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, MessageDigest digest, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, digest, Digests.fromHex(expected));
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, String algorithm, byte[] expected) {
        java.util.Objects.requireNonNull(algorithm, "The message digest algorithm should not be null");
        try {
            this.assertHasDigest(info, actual, MessageDigest.getInstance(algorithm), expected);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("Unable to find digest implementation for: <%s>", algorithm), e);
        }
    }

    public void assertHasDigest(AssertionInfo info, InputStream actual, String algorithm, String expected) {
        java.util.Objects.requireNonNull(expected, "The string representation of digest to compare to should not be null");
        this.assertHasDigest(info, actual, algorithm, Digests.fromHex(expected));
    }
}

