/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.python;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.ProblemFilterUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/grazie/ide/language/python/PythonProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "seemsDocString", "", "text", "Lcom/intellij/grazie/text/TextContent;", "shouldIgnore", "problem", "Lcom/intellij/grazie/text/TextProblem;", "intellij.python.grazie"})
public final class PythonProblemFilter
extends ProblemFilter {
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent.TextDomain domain = problem.getText().getDomain();
        if (domain == TextContent.TextDomain.LITERALS) {
            return problem.fitsGroup(RuleGroup.LITERALS);
        }
        if (domain == TextContent.TextDomain.DOCUMENTATION) {
            TextContent textContent = problem.getText();
            Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
            if (this.seemsDocString(textContent) && (ProblemFilterUtil.isUndecoratedSingleSentenceIssue((TextProblem)problem) || ProblemFilterUtil.isInitialCasingIssue((TextProblem)problem))) {
                return true;
            }
        }
        return false;
    }

    private final boolean seemsDocString(TextContent text) {
        return StringsKt.endsWith$default((CharSequence)StringsKt.trim((CharSequence)text.getContainingFile().getViewProvider().getContents().subSequence(0, text.textOffsetToFile(0))), (CharSequence)":", (boolean)false, (int)2, null);
    }
}

