/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/black/BlackFormattingResponse;", "", "()V", "Failure", "Ignored", "Success", "Lcom/jetbrains/python/black/BlackFormattingResponse$Failure;", "Lcom/jetbrains/python/black/BlackFormattingResponse$Ignored;", "Lcom/jetbrains/python/black/BlackFormattingResponse$Success;", "intellij.python.community.impl"})
public abstract class BlackFormattingResponse {
    private BlackFormattingResponse() {
    }

    public /* synthetic */ BlackFormattingResponse(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0003H\u0007J\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0003H\u0007J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/black/BlackFormattingResponse$Failure;", "Lcom/jetbrains/python/black/BlackFormattingResponse;", "title", "", "description", "exitCode", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "getDescription", "()Ljava/lang/String;", "getExitCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTitle", "getInlineNotificationMessage", "getLoggingMessage", "getPopupMessage", "trimBlackErrorMessage", "maxLength", "intellij.python.community.impl"})
    public static final class Failure
    extends BlackFormattingResponse {
        @NotNull
        private final String title;
        @NotNull
        private final String description;
        @Nullable
        private final Integer exitCode;

        public Failure(@Nls @NotNull String title, @NlsSafe @NotNull String description, @Nullable Integer exitCode) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            super(null);
            this.title = title;
            this.description = description;
            this.exitCode = exitCode;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final Integer getExitCode() {
            return this.exitCode;
        }

        @NotNull
        public final String getLoggingMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.title + "\n");
            if (((CharSequence)this.description).length() > 0) {
                stringBuilder.append("stderr: " + this.description + "\n");
            }
            if (this.exitCode != null) {
                stringBuilder.append("exit code: " + this.exitCode + "\n");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
            return string;
        }

        @NlsSafe
        @NotNull
        public final String getInlineNotificationMessage() {
            return this.trimBlackErrorMessage(64);
        }

        @NlsSafe
        @NotNull
        public final String getPopupMessage() {
            return this.trimBlackErrorMessage(256);
        }

        private final String trimBlackErrorMessage(int maxLength) {
            Object object;
            String string;
            String errorInfo;
            String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)this.description));
            String string3 = errorInfo = string2 != null && (string = StringsKt.replaceBefore$default((String)string2, (String)"Cannot parse", (String)"", null, (int)4, null)) != null ? string : this.description;
            if (errorInfo.length() > maxLength) {
                String string4 = errorInfo.substring(0, maxLength);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = string4 + "...";
            } else {
                object = errorInfo;
            }
            return object;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/black/BlackFormattingResponse$Ignored;", "Lcom/jetbrains/python/black/BlackFormattingResponse;", "title", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getTitle", "intellij.python.community.impl"})
    public static final class Ignored
    extends BlackFormattingResponse {
        @NotNull
        private final String title;
        @NotNull
        private final String description;

        public Ignored(@Nls @NotNull String title, @NlsSafe @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            super(null);
            this.title = title;
            this.description = description;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/black/BlackFormattingResponse$Success;", "Lcom/jetbrains/python/black/BlackFormattingResponse;", "formattedText", "", "(Ljava/lang/String;)V", "getFormattedText", "()Ljava/lang/String;", "intellij.python.community.impl"})
    public static final class Success
    extends BlackFormattingResponse {
        @NotNull
        private final String formattedText;

        public Success(@NotNull String formattedText) {
            Intrinsics.checkNotNullParameter((Object)formattedText, (String)"formattedText");
            super(null);
            this.formattedText = formattedText;
        }

        @NotNull
        public final String getFormattedText() {
            return this.formattedText;
        }
    }
}

