/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.ui.LightweightHint;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.black.BlackFormatterAdvertiserService;
import com.jetbrains.python.black.BlackFormatterExecutor;
import com.jetbrains.python.black.BlackFormatterUtil;
import com.jetbrains.python.black.BlackFormattingRequest;
import com.jetbrains.python.black.BlackFormattingResponse;
import com.jetbrains.python.black.BlackFormattingService;
import com.jetbrains.python.black.configuration.BlackFormatterConfiguration;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0014J\b\u0010\u0016\u001a\u00020\u0004H\u0014J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J'\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000b\u0010\u001e\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u001f\u001a\u00020\u000bH\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/black/BlackFormattingService;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "()V", "buildNotificationMessage", "", "Lorg/jetbrains/annotations/Nls;", "document", "Lcom/intellij/openapi/editor/Document;", "textBefore", "", "canFormat", "", "source", "Lcom/intellij/psi/PsiFile;", "createFormattingTask", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "formattingRequest", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "getFeatures", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "getName", "getNotificationGroupId", "isFormatFragmentAction", "range", "Lcom/intellij/openapi/util/TextRange;", "showFormattedLinesInfo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "isError", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nBlackFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormattingService.kt\ncom/jetbrains/python/black/BlackFormattingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class BlackFormattingService
extends AsyncDocumentFormattingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String NAME;
    @NotNull
    private static final Charset DEFAULT_CHARSET;
    @NotNull
    public static final String NOTIFICATION_GROUP_ID = "Black Formatter Integration";
    @NotNull
    private static final Set<FormattingService.Feature> FEATURES;

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        return FEATURES;
    }

    public boolean canFormat(@NotNull PsiFile source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!Registry.is((String)"black.formatter.support.enabled")) {
            return false;
        }
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"source.project");
        Project project2 = project;
        BlackFormatterConfiguration blackConfiguration = BlackFormatterConfiguration.Companion.getBlackConfiguration(project2);
        VirtualFile virtualFile = source.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        boolean isApplicable = BlackFormatterUtil.Companion.isFileApplicable(vFile);
        if (isApplicable) {
            Project project3 = source.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"source.project");
            BlackFormatterAdvertiserService.Companion.getInstance(project3).suggestBlack(source, blackConfiguration);
        }
        if (!blackConfiguration.getEnabledOnReformat()) {
            return false;
        }
        return isApplicable;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest formattingRequest) {
        Object $this$createFormattingTask_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)formattingRequest, (String)"formattingRequest");
        FormattingContext formattingContext = formattingRequest.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)formattingContext, (String)"formattingRequest.context");
        FormattingContext formattingContext2 = formattingContext;
        PsiFile psiFile = formattingContext2.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"formattingContext.containingFile");
        PsiFile file = psiFile;
        VirtualFile virtualFile = formattingContext2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        TextRange formattingRange = (TextRange)formattingRequest.getFormattingRanges().get(0);
        Project project = formattingContext2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"formattingContext.project");
        Project project2 = project;
        BlackFormatterConfiguration blackConfig = BlackFormatterConfiguration.Companion.getBlackConfiguration(project2);
        Sdk sdk2 = blackConfig.getSdk(project2);
        if (sdk2 == null) {
            Object[] objectArray = new Object[]{project2.getName()};
            String string = PyBundle.message("black.sdk.not.configured.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"black.sdk.not.c\u2026red.error\", project.name)");
            String message = string;
            LOG.warn(message);
            formattingRequest.onError(PyBundle.message("black.sdk.not.configured.error.title", new Object[0]), message);
            return null;
        }
        Document document = (Document)ReadAction.compute(() -> BlackFormattingService.createFormattingTask$lambda$0(project2, file));
        if (document == null) {
            LOG.warn("Document for file " + file.getName() + " is null");
            return null;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
        String text = string;
        Object object = this;
        try {
            $this$createFormattingTask_u24lambda_u241 = object;
            boolean bl = false;
            $this$createFormattingTask_u24lambda_u241 = Result.constructor-impl((Object)document.getText(formattingRange));
        }
        catch (Throwable throwable) {
            $this$createFormattingTask_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object = $this$createFormattingTask_u24lambda_u241;
        String fragment2 = (String)((Object)(Result.isFailure-impl((Object)object) ? null : object));
        object = fragment2;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return null;
        }
        Editor editor2 = PsiEditorUtil.findEditor((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)formattingRange, (String)"formattingRange");
        BlackFormattingRequest blackFormattingRequest = this.isFormatFragmentAction(document, formattingRange) ? (BlackFormattingRequest)new BlackFormattingRequest.Fragment(fragment2, vFile) : (BlackFormattingRequest)new BlackFormattingRequest.File(fragment2, vFile);
        return new AsyncDocumentFormattingService.FormattingTask(project2, sdk2, blackConfig, blackFormattingRequest, this, text, formattingRange, formattingRequest, document, editor2, vFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $sdk;
            final /* synthetic */ BlackFormatterConfiguration $blackConfig;
            final /* synthetic */ BlackFormattingRequest $blackFormattingRequest;
            final /* synthetic */ BlackFormattingService this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ TextRange $formattingRange;
            final /* synthetic */ AsyncFormattingRequest $formattingRequest;
            final /* synthetic */ Document $document;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VirtualFile $vFile;
            {
                this.$project = $project;
                this.$sdk = $sdk;
                this.$blackConfig = $blackConfig;
                this.$blackFormattingRequest = $blackFormattingRequest;
                this.this$0 = $receiver;
                this.$text = $text;
                this.$formattingRange = $formattingRange;
                this.$formattingRequest = $formattingRequest;
                this.$document = $document;
                this.$editor = $editor;
                this.$vFile = $vFile;
            }

            public void run() {
                block15: {
                    Object object;
                    Object object2 = this;
                    Project project = this.$project;
                    Object object3 = this.$sdk;
                    BlackFormatterConfiguration blackFormatterConfiguration = this.$blackConfig;
                    BlackFormattingRequest blackFormattingRequest = this.$blackFormattingRequest;
                    BlackFormattingService blackFormattingService = this.this$0;
                    String string = this.$text;
                    TextRange textRange = this.$formattingRange;
                    AsyncFormattingRequest asyncFormattingRequest = this.$formattingRequest;
                    Document document = this.$document;
                    Editor editor2 = this.$editor;
                    VirtualFile virtualFile = this.$vFile;
                    try {
                        createFormattingTask.1 $this$run_u24lambda_u240 = object2;
                        boolean bl = false;
                        BlackFormatterExecutor executor = new BlackFormatterExecutor(project, (Sdk)object3, blackFormatterConfiguration);
                        java.time.Duration duration = BlackFormattingService.access$getTimeout(blackFormattingService);
                        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"timeout");
                        Object object4 = duration;
                        BlackFormattingResponse response = executor.getBlackFormattingResponse-HG0u8IE(blackFormattingRequest, Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)object4).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)object4).getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
                        if (response instanceof BlackFormattingResponse.Success) {
                            String string2;
                            String formattedFragment = ((BlackFormattingResponse.Success)response).getFormattedText();
                            BlackFormattingRequest blackFormattingRequest2 = blackFormattingRequest;
                            if (blackFormattingRequest2 instanceof BlackFormattingRequest.Fragment) {
                                String postProcessedFragment = ((BlackFormattingRequest.Fragment)blackFormattingRequest).postProcessResponse(formattedFragment);
                                String string3 = string;
                                IntRange intRange = new IntRange(textRange.getStartOffset(), textRange.getEndOffset() - 1);
                                string2 = ((Object)StringsKt.replaceRange((CharSequence)string3, (IntRange)intRange, (CharSequence)postProcessedFragment)).toString();
                            } else if (blackFormattingRequest2 instanceof BlackFormattingRequest.File) {
                                string2 = formattedFragment;
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            String formattedDocumentText = string2;
                            asyncFormattingRequest.onTextReady(formattedDocumentText);
                            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
                            String message = BlackFormattingService.access$buildNotificationMessage(blackFormattingService, document, formattedDocumentText);
                            BlackFormattingService.access$showFormattedLinesInfo(blackFormattingService, editor2, message, false);
                        } else if (response instanceof BlackFormattingResponse.Failure) {
                            BlackFormattingService.access$getLOG$cp().debug(((BlackFormattingResponse.Failure)response).getLoggingMessage());
                            object4 = blackFormattingRequest;
                            if (object4 instanceof BlackFormattingRequest.File) {
                                asyncFormattingRequest.onError(((BlackFormattingResponse.Failure)response).getTitle(), ((BlackFormattingResponse.Failure)response).getPopupMessage());
                            } else if (object4 instanceof BlackFormattingRequest.Fragment) {
                                Object[] objectArray = new Object[]{((BlackFormattingResponse.Failure)response).getInlineNotificationMessage()};
                                String string4 = PyBundle.message("black.format.fragment.inline.error", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"black.format.fr\u2026ineNotificationMessage())");
                                BlackFormattingService.access$showFormattedLinesInfo(blackFormattingService, editor2, string4, true);
                                asyncFormattingRequest.onTextReady(string);
                            }
                        } else if (response instanceof BlackFormattingResponse.Ignored) {
                            Object[] objectArray = new Object[]{virtualFile.getName()};
                            String string5 = PyBundle.message("black.file.ignored.notification.message", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"black.file.igno\u2026ion.message\", vFile.name)");
                            BlackFormattingService.access$showFormattedLinesInfo(blackFormattingService, editor2, string5, false);
                            asyncFormattingRequest.onTextReady(string);
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = object;
                    project = this.$formattingRequest;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) break block15;
                    Object exception = object3 = throwable;
                    boolean bl = false;
                    if (!(exception instanceof ProcessCanceledException)) {
                        BlackFormattingService.access$getLOG$cp().warn((Throwable)exception);
                        project.onError(PyBundle.message("black.exception.error.message", new Object[0]), ((Throwable)exception).getLocalizedMessage());
                    }
                }
            }

            public boolean cancel() {
                return true;
            }

            public boolean isRunUnderProgress() {
                return true;
            }
        };
    }

    private final String buildNotificationMessage(Document document, CharSequence textBefore) {
        String string;
        int diff = VcsFacade.getInstance().calculateChangedLinesNumber(document, textBefore);
        if (diff == 0) {
            String string2 = PyBundle.message("black.no.lines.changed", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"black.no.lines.changed\")");
        } else {
            Object[] objectArray = new Object[]{diff, diff == 1 ? 1 : 0};
            String string3 = PyBundle.message("black.formatted.n.lines", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"black.formatted\u2026 if (diff == 1) 1 else 0)");
        }
        return string;
    }

    private final void showFormattedLinesInfo(Editor editor2, String text, boolean isError) {
        if (editor2 != null) {
            ApplicationManager.getApplication().invokeLater(() -> BlackFormattingService.showFormattedLinesInfo$lambda$2(isError, text, editor2), ModalityState.defaultModalityState(), arg_0 -> BlackFormattingService.showFormattedLinesInfo$lambda$3(editor2, arg_0));
        }
    }

    private final boolean isFormatFragmentAction(Document document, TextRange range) {
        return range.getLength() != document.getTextLength();
    }

    @NotNull
    protected String getNotificationGroupId() {
        return NOTIFICATION_GROUP_ID;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    private static final Document createFormattingTask$lambda$0(Project $project, PsiFile $file) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return PsiDocumentManager.getInstance((Project)$project).getDocument($file);
    }

    private static final void showFormattedLinesInfo$lambda$2(boolean $isError, String $text, Editor $editor) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        JComponent component2 = $isError ? HintUtil.createErrorLabel((String)$text) : HintUtil.createInformationLabel((String)$text);
        LightweightHint hint = new LightweightHint(component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, $editor, (short)1, 34, 0, false);
    }

    private static final boolean showFormattedLinesInfo$lambda$3(Editor $editor, Object it) {
        return $editor.isDisposed() || !$editor.getComponent().isShowing();
    }

    public static final /* synthetic */ java.time.Duration access$getTimeout(BlackFormattingService $this) {
        return $this.getTimeout();
    }

    public static final /* synthetic */ String access$buildNotificationMessage(BlackFormattingService $this, Document document, CharSequence textBefore) {
        return $this.buildNotificationMessage(document, textBefore);
    }

    public static final /* synthetic */ void access$showFormattedLinesInfo(BlackFormattingService $this, Editor editor2, String text, boolean isError) {
        $this.showFormattedLinesInfo(editor2, text, isError);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(BlackFormattingService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(BlackFormattingService::class.java)");
        LOG = logger;
        String string = PyBundle.message("black.formatting.service.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"black.formatting.service.name\")");
        NAME = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        DEFAULT_CHARSET = charset;
        FEATURES = SetsKt.setOf((Object)FormattingService.Feature.FORMAT_FRAGMENTS);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/black/BlackFormattingService$Companion;", "", "()V", "DEFAULT_CHARSET", "Ljava/nio/charset/Charset;", "getDEFAULT_CHARSET", "()Ljava/nio/charset/Charset;", "FEATURES", "", "Lcom/intellij/formatting/service/FormattingService$Feature;", "getFEATURES", "()Ljava/util/Set;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NAME", "", "getNAME", "()Ljava/lang/String;", "NOTIFICATION_GROUP_ID", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        @NotNull
        public final Charset getDEFAULT_CHARSET() {
            return DEFAULT_CHARSET;
        }

        @NotNull
        public final Set<FormattingService.Feature> getFEATURES() {
            return FEATURES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

