/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.documentation.docstrings.DocStringLineParser;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocStringUpdater<T extends DocStringLineParser> {
    protected final T myOriginalDocString;
    private final StringBuilder myBuilder;
    private final List<Modification> myUpdates;
    protected final String myMinContentIndent;

    public DocStringUpdater(@NotNull T docString, @NotNull String minContentIndent) {
        if (docString == null) {
            DocStringUpdater.$$$reportNull$$$0(0);
        }
        if (minContentIndent == null) {
            DocStringUpdater.$$$reportNull$$$0(1);
        }
        this.myUpdates = new ArrayList<Modification>();
        this.myBuilder = new StringBuilder(((DocStringLineParser)docString).getDocStringContent().getSuperString());
        this.myOriginalDocString = docString;
        this.myMinContentIndent = minContentIndent;
    }

    protected final void replace(@NotNull TextRange range, @NotNull String text) {
        if (range == null) {
            DocStringUpdater.$$$reportNull$$$0(2);
        }
        if (text == null) {
            DocStringUpdater.$$$reportNull$$$0(3);
        }
        this.myUpdates.add(new Modification(range, text));
    }

    protected final void replace(int startOffset, int endOffset, @NotNull String text) {
        if (text == null) {
            DocStringUpdater.$$$reportNull$$$0(4);
        }
        this.replace(new TextRange(startOffset, endOffset), text);
    }

    protected final void insert(int offset, @NotNull String text) {
        if (text == null) {
            DocStringUpdater.$$$reportNull$$$0(5);
        }
        this.replace(offset, offset, text);
    }

    protected final void insertAfterLine(int lineNumber, @NotNull String text) {
        if (text == null) {
            DocStringUpdater.$$$reportNull$$$0(6);
        }
        Substring line2 = ((DocStringLineParser)this.myOriginalDocString).getLines().get(lineNumber);
        this.insert(line2.getEndOffset(), "\n" + text);
    }

    protected final void remove(int startOffset, int endOffset) {
        this.replace(startOffset, endOffset, "");
    }

    protected final void removeLines(int startLine, int endLine) {
        List<Substring> lines = ((DocStringLineParser)this.myOriginalDocString).getLines();
        int startOffset = lines.get(startLine).getStartOffset();
        int endOffset = endLine < lines.size() ? lines.get(endLine).getStartOffset() : lines.get(endLine - 1).getEndOffset();
        this.remove(startOffset, endOffset);
    }

    protected final void removeLinesAndSpacesAfter(int startLine, int endLine) {
        this.removeLines(startLine, this.skipEmptyLines(endLine));
    }

    private int skipEmptyLines(int startLine) {
        return Math.min(((DocStringLineParser)this.myOriginalDocString).consumeEmptyLines(startLine), ((DocStringLineParser)this.myOriginalDocString).getLineCount() - 1);
    }

    protected final void removeLine(int line2) {
        this.removeLines(line2, line2 + 1);
    }

    protected final void insertBeforeLine(int lineNumber, @NotNull String text) {
        if (text == null) {
            DocStringUpdater.$$$reportNull$$$0(7);
        }
        Substring line2 = ((DocStringLineParser)this.myOriginalDocString).getLines().get(lineNumber);
        this.insert(line2.getStartOffset(), text + "\n");
    }

    @NotNull
    public final String getDocStringText() {
        this.beforeApplyingModifications();
        if (((DocStringLineParser)this.myOriginalDocString).getLineCount() == 1 && !this.myUpdates.isEmpty()) {
            this.insertAfterLine(0, this.myMinContentIndent);
        }
        Collections.reverse(this.myUpdates);
        this.myUpdates.sort(Collections.reverseOrder());
        for (Modification update : this.myUpdates) {
            TextRange updateRange = update.range;
            if (updateRange.getStartOffset() == updateRange.getEndOffset()) {
                this.myBuilder.insert(updateRange.getStartOffset(), update.text);
                continue;
            }
            this.myBuilder.replace(updateRange.getStartOffset(), updateRange.getEndOffset(), update.text);
        }
        String string = this.myBuilder.toString();
        if (string == null) {
            DocStringUpdater.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected void beforeApplyingModifications() {
    }

    @NotNull
    public T getOriginalDocString() {
        T t = this.myOriginalDocString;
        if (t == null) {
            DocStringUpdater.$$$reportNull$$$0(9);
        }
        return t;
    }

    @NotNull
    protected String getLineIndent(int lineNum) {
        String lastLineIndent = ((DocStringLineParser)this.myOriginalDocString).getLineIndent(lineNum);
        if (PyIndentUtil.getLineIndentSize(lastLineIndent) < PyIndentUtil.getLineIndentSize(this.myMinContentIndent)) {
            String string = this.myMinContentIndent;
            if (string == null) {
                DocStringUpdater.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = lastLineIndent;
        if (string == null) {
            DocStringUpdater.$$$reportNull$$$0(11);
        }
        return string;
    }

    protected int getLineIndentSize(int lineNum) {
        return PyIndentUtil.getLineIndentSize(this.getLineIndent(lineNum));
    }

    protected int findLastNonEmptyLine() {
        for (int i = ((DocStringLineParser)this.myOriginalDocString).getLineCount() - 1; i >= 0; --i) {
            if (StringUtil.isEmptyOrSpaces((CharSequence)((DocStringLineParser)this.myOriginalDocString).getLine(i))) continue;
            return i;
        }
        return 0;
    }

    public abstract void addParameter(@NotNull String var1, @Nullable String var2);

    public abstract void addReturnValue(@Nullable String var1);

    public abstract void removeParameter(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minContentIndent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringUpdater";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalDocString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertAfterLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertBeforeLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static class Modification
    implements Comparable<Modification> {
        @NotNull
        final TextRange range;
        @NotNull
        final String text;

        Modification(@NotNull TextRange range, @NotNull String newText) {
            if (range == null) {
                Modification.$$$reportNull$$$0(0);
            }
            if (newText == null) {
                Modification.$$$reportNull$$$0(1);
            }
            this.range = range;
            this.text = newText;
        }

        @Override
        public int compareTo(Modification o) {
            return this.range.getStartOffset() - o.range.getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/documentation/docstrings/DocStringUpdater$Modification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

