/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public class RemovePrefixQuickFix
implements LocalQuickFix {
    private final String myPrefix;

    public RemovePrefixQuickFix(String prefix) {
        this.myPrefix = prefix;
    }

    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.remove.string.prefix", this.myPrefix);
        if (string == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.remove.string.prefix", new Object[0]);
        if (string == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PyStringLiteralExpression pyString;
        if (project == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            RemovePrefixQuickFix.$$$reportNull$$$0(3);
        }
        if ((pyString = PyUtil.as(descriptor2.getPsiElement(), PyStringLiteralExpression.class)) != null) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            for (ASTNode node : pyString.getStringNodes()) {
                int prefixLength;
                String nodeText = node.getText();
                if (!nodeText.substring(0, prefixLength = PyStringLiteralUtil.getPrefixLength(nodeText)).equalsIgnoreCase(this.myPrefix)) continue;
                PyStringLiteralExpression replacement = elementGenerator.createStringLiteralAlreadyEscaped(nodeText.substring(prefixLength));
                node.getPsi().replace(replacement.getFirstChild());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RemovePrefixQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

