/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParamHelper {
    private ParamHelper() {
    }

    public static void walkDownParamArray(PyParameter[] params, ParamWalker walker) {
        ParamHelper.walkDownParameters(ContainerUtil.map((Object[])params, PyCallableParameterImpl::psi), walker);
    }

    public static void walkDownParameters(@NotNull List<? extends PyCallableParameter> parameters, @NotNull ParamWalker walker) {
        if (parameters == null) {
            ParamHelper.$$$reportNull$$$0(0);
        }
        if (walker == null) {
            ParamHelper.$$$reportNull$$$0(1);
        }
        int i = 0;
        for (PyCallableParameter pyCallableParameter : parameters) {
            boolean last;
            PyParameter psi = pyCallableParameter.getParameter();
            boolean first = i == 0;
            boolean bl = last = i == parameters.size() - 1;
            if (psi instanceof PyTupleParameter) {
                PyTupleParameter tupleParameter = (PyTupleParameter)psi;
                walker.enterTupleParameter(tupleParameter, first, last);
                ParamHelper.walkDownParamArray(tupleParameter.getContents(), walker);
                walker.leaveTupleParameter(tupleParameter, first, last);
            } else if (psi instanceof PyNamedParameter) {
                walker.visitNamedParameter((PyNamedParameter)psi, first, last);
            } else if (psi instanceof PySlashParameter) {
                walker.visitSlashParameter((PySlashParameter)psi, first, last);
            } else if (psi instanceof PySingleStarParameter) {
                walker.visitSingleStarParameter((PySingleStarParameter)psi, first, last);
            } else {
                walker.visitNonPsiParameter(pyCallableParameter, first, last);
            }
            ++i;
        }
    }

    @NotNull
    public static String getPresentableText(PyParameter @NotNull [] parameters, boolean includeDefaultValue, @Nullable TypeEvalContext context) {
        if (parameters == null) {
            ParamHelper.$$$reportNull$$$0(2);
        }
        return ParamHelper.getPresentableText(ContainerUtil.map((Object[])parameters, PyCallableParameterImpl::psi), includeDefaultValue, context);
    }

    @NotNull
    public static String getPresentableText(@NotNull List<? extends PyCallableParameter> parameters, final boolean includeDefaultValue, final @Nullable TypeEvalContext context) {
        if (parameters == null) {
            ParamHelper.$$$reportNull$$$0(3);
        }
        final StringBuilder result2 = new StringBuilder();
        result2.append("(");
        ParamHelper.walkDownParameters(parameters, new ParamWalker(){

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                result2.append("(");
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                result2.append(")");
                if (!last) {
                    result2.append(", ");
                }
            }

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                this.visitNonPsiParameter(PyCallableParameterImpl.psi(param), first, last);
            }

            @Override
            public void visitSlashParameter(@NotNull PySlashParameter param, boolean first, boolean last) {
                if (param == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.append("/");
                if (!last) {
                    result2.append(", ");
                }
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                result2.append("*");
                if (!last) {
                    result2.append(", ");
                }
            }

            @Override
            public void visitNonPsiParameter(@NotNull PyCallableParameter parameter, boolean first, boolean last) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(1);
                }
                result2.append(parameter.getPresentableText(includeDefaultValue, context));
                if (!last) {
                    result2.append(", ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "param";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/psi/impl/ParamHelper$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSlashParameter";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNonPsiParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        result2.append(")");
        String string = result2.toString();
        if (string == null) {
            ParamHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getNameInSignature(@NotNull PyCallableParameter parameter) {
        if (parameter == null) {
            ParamHelper.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        if (parameter.isPositionalContainer()) {
            sb.append("*");
        } else if (parameter.isKeywordContainer()) {
            sb.append("**");
        }
        String name2 = parameter.getName();
        sb.append(name2 != null ? name2 : "...");
        String string = sb.toString();
        if (string == null) {
            ParamHelper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String getNameInSignature(@NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            ParamHelper.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        if (parameter.isPositionalContainer()) {
            sb.append("*");
        } else if (parameter.isKeywordContainer()) {
            sb.append("**");
        }
        String name2 = parameter.getName();
        sb.append(name2 != null ? name2 : "...");
        String string = sb.toString();
        if (string == null) {
            ParamHelper.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    @Contract(value="null, _->null")
    public static String getDefaultValuePartInSignature(@Nullable String defaultValue, boolean parameterRenderedAsTyped) {
        if (defaultValue == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(parameterRenderedAsTyped ? " = " : "=");
        Pair<String, String> quotes = PyStringLiteralCoreUtil.getQuotes(defaultValue);
        if (quotes != null) {
            String value = defaultValue.substring(((String)quotes.getFirst()).length(), defaultValue.length() - ((String)quotes.getSecond()).length());
            sb.append((String)quotes.getFirst());
            StringUtil.escapeStringCharacters((int)value.length(), (String)value, (StringBuilder)sb);
            sb.append((String)quotes.getSecond());
        } else {
            sb.append(defaultValue);
        }
        return sb.toString();
    }

    @Nullable
    public static String getDefaultValueText(@Nullable PyExpression defaultValue) {
        Pair<String, String> quotes;
        if (defaultValue instanceof PyStringLiteralExpression && (quotes = PyStringLiteralCoreUtil.getQuotes(defaultValue.getText())) != null) {
            return (String)quotes.getFirst() + ((PyStringLiteralExpression)defaultValue).getStringValue() + (String)quotes.getSecond();
        }
        return defaultValue == null ? null : defaultValue.getText();
    }

    public static boolean couldHaveDefaultValue(@NotNull String parameterName) {
        if (parameterName == null) {
            ParamHelper.$$$reportNull$$$0(9);
        }
        return !parameterName.startsWith("*") && !parameterName.equals("/");
    }

    public static boolean isSelfArgsKwargsCallable(@Nullable PsiElement element, @NotNull TypeEvalContext context) {
        if (context == null) {
            ParamHelper.$$$reportNull$$$0(10);
        }
        if (element instanceof PyCallable) {
            List<PyCallableParameter> parameters = ((PyCallable)element).getParameters(context);
            return parameters.size() == 3 && parameters.get(0).isSelf() && parameters.get(1).isPositionalContainer() && parameters.get(2).isKeywordContainer();
        }
        return false;
    }

    public static List<PyNamedParameter> collectNamedParameters(PyParameterList plist) {
        final ArrayList<PyNamedParameter> result2 = new ArrayList<PyNamedParameter>(10);
        ParamHelper.walkDownParamArray(plist.getParameters(), new ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                result2.add(param);
            }
        });
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/ParamHelper";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/ParamHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameInSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "walkDownParameters";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNameInSignature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "couldHaveDefaultValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSelfArgsKwargsCallable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static interface ParamWalker {
        public void enterTupleParameter(PyTupleParameter var1, boolean var2, boolean var3);

        public void leaveTupleParameter(PyTupleParameter var1, boolean var2, boolean var3);

        public void visitNamedParameter(PyNamedParameter var1, boolean var2, boolean var3);

        public void visitSlashParameter(@NotNull PySlashParameter var1, boolean var2, boolean var3);

        public void visitSingleStarParameter(PySingleStarParameter var1, boolean var2, boolean var3);

        public void visitNonPsiParameter(@NotNull PyCallableParameter var1, boolean var2, boolean var3);
    }

    public static abstract class ParamVisitor
    implements ParamWalker {
        @Override
        public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
        }

        @Override
        public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitSlashParameter(@NotNull PySlashParameter param, boolean first, boolean last) {
            if (param == null) {
                ParamVisitor.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
        }

        @Override
        public void visitNonPsiParameter(@NotNull PyCallableParameter parameter, boolean first, boolean last) {
            if (parameter == null) {
                ParamVisitor.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/ParamHelper$ParamVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSlashParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNonPsiParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

