/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureProcessor;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import com.jetbrains.python.refactoring.changeSignature.PyParameterTableModel;
import com.jetbrains.python.refactoring.changeSignature.PyParameterTableModelItem;
import com.jetbrains.python.refactoring.introduce.IntroduceValidator;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureDialog
extends ChangeSignatureDialogBase<PyParameterInfo, PyFunction, String, PyMethodDescriptor, PyParameterTableModelItem, PyParameterTableModel> {
    public PyChangeSignatureDialog(Project project, PyMethodDescriptor method) {
        super(project, (MethodDescriptor)method, false, method.getMethod().getContext());
    }

    protected LanguageFileType getFileType() {
        return PythonFileType.INSTANCE;
    }

    @NotNull
    protected PyParameterTableModel createParametersInfoModel(@NotNull PyMethodDescriptor method) {
        if (method == null) {
            PyChangeSignatureDialog.$$$reportNull$$$0(0);
        }
        PyParameterList parameterList = (PyParameterList)PsiTreeUtil.getChildOfType((PsiElement)method.getMethod(), PyParameterList.class);
        return new PyParameterTableModel(parameterList, this.myDefaultValueContext, this.myProject);
    }

    public BaseRefactoringProcessor createRefactoringProcessor() {
        List parameters = this.getParameters();
        return new PyChangeSignatureProcessor(this.myProject, ((PyMethodDescriptor)this.myMethod).getMethod(), this.getMethodName(), parameters.toArray(new PyParameterInfo[0]));
    }

    @Nullable
    protected PsiCodeFragment createReturnTypeCodeFragment() {
        return null;
    }

    @Nullable
    protected CallerChooserBase<PyFunction> createCallerChooser(String title, Tree treeToReuse, Consumer<? super Set<PyFunction>> callback) {
        return null;
    }

    public boolean isNameValid(String name2, Project project) {
        NamesValidator validator = LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
        return name2 != null && validator.isIdentifier(name2, project) && !validator.isKeyword(name2, project);
    }

    @Nullable
    protected String validateAndCommitData() {
        String functionName = this.myNameField.getText().trim();
        if (!functionName.equals(((PyMethodDescriptor)this.myMethod).getName())) {
            boolean defined = IntroduceValidator.isDefinedInScope(functionName, ((PyMethodDescriptor)this.myMethod).getMethod());
            if (defined) {
                return PyBundle.message("refactoring.change.signature.dialog.validation.name.defined", new Object[0]);
            }
            if (!this.isNameValid(functionName, this.myProject)) {
                return PyBundle.message("refactoring.change.signature.dialog.validation.function.name", new Object[0]);
            }
        }
        List parameters = ((PyParameterTableModel)this.myParametersTableModel).getItems();
        HashSet<String> parameterNames = new HashSet<String>();
        boolean hadPositionalContainer = false;
        boolean hadKeywordContainer = false;
        boolean hadDefaultValue = false;
        boolean hadSlash = false;
        boolean hadSingleStar = false;
        boolean hadParamsAfterSingleStar = false;
        LanguageLevel languageLevel = LanguageLevel.forElement(((PyMethodDescriptor)this.myMethod).getMethod());
        int parametersLength = parameters.size();
        for (int index = 0; index < parametersLength; ++index) {
            boolean isMarkerParameter;
            PyParameterTableModelItem info = (PyParameterTableModelItem)((Object)parameters.get(index));
            PyParameterInfo parameter = (PyParameterInfo)info.parameter;
            String name2 = parameter.getName();
            boolean bl = isMarkerParameter = name2.equals("/") || name2.equals("*");
            if (!isMarkerParameter) {
                String nameWithoutStars = StringUtil.trimLeading((String)name2, (char)'*').trim();
                if (parameterNames.contains(nameWithoutStars)) {
                    return PyPsiBundle.message("ANN.duplicate.param.name", new Object[0]);
                }
                parameterNames.add(nameWithoutStars);
            }
            if (name2.equals("*")) {
                if (hadSingleStar) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.multiple.star", new Object[0]);
                }
                hadSingleStar = true;
                if (index == parametersLength - 1) {
                    return PyPsiBundle.message("ANN.named.parameters.after.star", new Object[0]);
                }
            } else if (name2.equals("/")) {
                if (hadSlash) {
                    return PyPsiBundle.message("ANN.multiple.slash", new Object[0]);
                }
                hadSlash = true;
                if (hadPositionalContainer || hadSingleStar) {
                    return PyPsiBundle.message("ANN.slash.param.after.vararg", new Object[0]);
                }
                if (hadKeywordContainer) {
                    return PyPsiBundle.message("ANN.slash.param.after.keyword", new Object[0]);
                }
                if (index == 0) {
                    return PyPsiBundle.message("ANN.named.parameters.before.slash", new Object[0]);
                }
            } else if (name2.startsWith("*") && !name2.startsWith("**")) {
                if (hadKeywordContainer) {
                    return PyPsiBundle.message("ANN.starred.param.after.kwparam", new Object[0]);
                }
                if (hadSingleStar || hadPositionalContainer) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.multiple.star", new Object[0]);
                }
                if (!this.isNameValid(name2.substring(1), this.myProject)) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.name", new Object[0]);
                }
                hadPositionalContainer = true;
            } else if (name2.startsWith("**")) {
                if (hadSingleStar && !hadParamsAfterSingleStar) {
                    return PyPsiBundle.message("ANN.named.parameters.after.star", new Object[0]);
                }
                if (hadKeywordContainer) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.multiple.double.star", new Object[0]);
                }
                if (!this.isNameValid(name2.substring(2), this.myProject)) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.name", new Object[0]);
                }
                hadKeywordContainer = true;
            } else {
                if (!this.isNameValid(name2, this.myProject)) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.name", new Object[0]);
                }
                if (hadSingleStar) {
                    hadParamsAfterSingleStar = true;
                }
                if (hadPositionalContainer && languageLevel.isPython2()) {
                    return PyPsiBundle.message("ANN.regular.param.after.vararg", new Object[0]);
                }
                if (hadKeywordContainer) {
                    return PyPsiBundle.message("ANN.regular.param.after.keyword", new Object[0]);
                }
                String defaultValue = info.getDefaultValue();
                if (defaultValue != null && !StringUtil.isEmptyOrSpaces((String)defaultValue) && parameter.getDefaultInSignature()) {
                    hadDefaultValue = true;
                } else if (hadDefaultValue && !hadSingleStar && (languageLevel.isPython2() || !hadPositionalContainer)) {
                    return PyPsiBundle.message("ANN.non.default.param.after.default", new Object[0]);
                }
            }
            if (parameter.getOldIndex() < 0) {
                if (!ParamHelper.couldHaveDefaultValue(name2)) continue;
                if (StringUtil.isEmpty((String)info.defaultValueCodeFragment.getText())) {
                    return PyBundle.message("refactoring.change.signature.dialog.validation.default.missing", new Object[0]);
                }
                if (!StringUtil.isEmptyOrSpaces((String)name2)) continue;
                return PyBundle.message("refactoring.change.signature.dialog.validation.parameter.missing", new Object[0]);
            }
            if (!((PyMethodDescriptor)this.myMethod).getParameters().get(parameter.getOldIndex()).getDefaultInSignature() || !StringUtil.isEmptyOrSpaces((String)parameter.getDefaultValue())) continue;
            return PyBundle.message("refactoring.change.signature.dialog.validation.default.missing", new Object[0]);
        }
        return null;
    }

    protected ValidationInfo doValidate() {
        String message = this.validateAndCommitData();
        this.getRefactorAction().setEnabled(message == null);
        this.getPreviewAction().setEnabled(message == null);
        if (message != null) {
            return new ValidationInfo(message);
        }
        return super.doValidate();
    }

    protected String calculateSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethodName());
        builder.append("(");
        List parameters = ((PyParameterTableModel)this.myParametersTableModel).getItems();
        for (int i = 0; i < parameters.size(); ++i) {
            PyParameterTableModelItem parameterInfo = (PyParameterTableModelItem)((Object)parameters.get(i));
            builder.append(((PyParameterInfo)parameterInfo.parameter).getName());
            String defaultValue = parameterInfo.defaultValueCodeFragment.getText();
            if (!defaultValue.isEmpty() && parameterInfo.isDefaultInSignature()) {
                builder.append(" = ").append(defaultValue);
            }
            if (i == parameters.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }

    protected VisibilityPanelBase<String> createVisibilityControl() {
        return new ComboBoxVisibilityPanel((Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(){

            protected JBTableRowRenderer getRowRenderer(int row) {
                return new EditorTextFieldJBTableRowRenderer(PyChangeSignatureDialog.this.getProject(), PythonLanguage.getInstance(), PyChangeSignatureDialog.this.getDisposable()){

                    protected String getText(JTable table, int row) {
                        String defaultValue;
                        PyParameterTableModelItem pyItem = (PyParameterTableModelItem)this.getRowItem(row);
                        StringBuilder text = new StringBuilder(((PyParameterInfo)pyItem.parameter).getName());
                        String defaultCallValue = pyItem.defaultValueCodeFragment.getText();
                        String string = defaultValue = pyItem.isDefaultInSignature() ? pyItem.defaultValueCodeFragment.getText() : "";
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            text.append(" = ").append(defaultValue);
                        }
                        if (StringUtil.isNotEmpty((String)defaultCallValue)) {
                            text.append(" // default value = ").append(defaultCallValue);
                        }
                        return text.toString();
                    }
                };
            }

            @NotNull
            protected JBTableRowEditor getRowEditor(final ParameterTableModelItemBase<PyParameterInfo> item) {
                return new JBTableRowEditor(){
                    private EditorTextField myNameEditor;
                    private EditorTextField myDefaultValueEditor;
                    private JCheckBox myDefaultInSignature;

                    public void prepareEditor(JTable table, int row) {
                        this.setLayout(new GridLayout(1, 3));
                        JPanel parameterPanel = this.createParameterPanel();
                        this.add(parameterPanel);
                        JPanel defaultValuePanel = this.createDefaultValuePanel();
                        this.add(defaultValuePanel);
                        JPanel defaultValueCheckBox = this.createDefaultValueCheckBox();
                        this.add(defaultValueCheckBox);
                        String nameText = this.myNameEditor.getText();
                        boolean couldHaveDefaultValue = ParamHelper.couldHaveDefaultValue(nameText) && !"self".equals(nameText);
                        this.myDefaultValueEditor.setEnabled(couldHaveDefaultValue);
                        this.myDefaultInSignature.setEnabled(couldHaveDefaultValue);
                    }

                    private JPanel createDefaultValueCheckBox() {
                        JPanel defaultValuePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                        JBLabel inSignatureLabel = new JBLabel(PyBundle.message("refactoring.change.signature.dialog.default.value.checkbox", new Object[0]), UIUtil.ComponentStyle.SMALL);
                        defaultValuePanel.add((Component)inSignatureLabel, "West");
                        this.myDefaultInSignature = new JCheckBox();
                        this.myDefaultInSignature.setSelected(((PyParameterTableModelItem)item).isDefaultInSignature());
                        this.myDefaultInSignature.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent event) {
                                ((PyParameterTableModelItem)item).setDefaultInSignature(myDefaultInSignature.isSelected());
                            }
                        });
                        this.myDefaultInSignature.addChangeListener((ChangeListener)PyChangeSignatureDialog.this.mySignatureUpdater);
                        this.myDefaultInSignature.setEnabled(((PyParameterInfo)item.parameter).isNew());
                        defaultValuePanel.add((Component)this.myDefaultInSignature, "East");
                        return defaultValuePanel;
                    }

                    private JPanel createDefaultValuePanel() {
                        JPanel defaultValuePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                        Document doc = PsiDocumentManager.getInstance((Project)PyChangeSignatureDialog.this.getProject()).getDocument((PsiFile)item.defaultValueCodeFragment);
                        this.myDefaultValueEditor = new EditorTextField(doc, PyChangeSignatureDialog.this.getProject(), (FileType)PyChangeSignatureDialog.this.getFileType());
                        JBLabel defaultValueLabel = new JBLabel(RefactoringBundle.message((String)"changeSignature.default.value.label"), UIUtil.ComponentStyle.SMALL);
                        defaultValuePanel.add((Component)defaultValueLabel);
                        defaultValuePanel.add((Component)this.myDefaultValueEditor);
                        this.myDefaultValueEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                        this.myDefaultValueEditor.addDocumentListener(new DocumentListener(){

                            public void documentChanged(@NotNull DocumentEvent event) {
                                if (event == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                ((PyParameterInfo)item.parameter).setDefaultValue(myDefaultValueEditor.getText().trim());
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureDialog$1$2$2", "documentChanged"));
                            }
                        });
                        this.myDefaultValueEditor.addDocumentListener((DocumentListener)PyChangeSignatureDialog.this.mySignatureUpdater);
                        return defaultValuePanel;
                    }

                    private JPanel createParameterPanel() {
                        JPanel namePanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                        this.myNameEditor = new EditorTextField(((PyParameterInfo)item.parameter).getName(), PyChangeSignatureDialog.this.getProject(), (FileType)PyChangeSignatureDialog.this.getFileType());
                        JBLabel nameLabel = new JBLabel(PyBundle.message("refactoring.change.signature.dialog.name.label", new Object[0]), UIUtil.ComponentStyle.SMALL);
                        namePanel.add((Component)nameLabel);
                        namePanel.add((Component)this.myNameEditor);
                        this.myNameEditor.setPreferredWidth(this.getTable().getWidth() / 2);
                        this.myNameEditor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                        this.myNameEditor.addDocumentListener(new DocumentListener(){

                            public void documentChanged(@NotNull DocumentEvent event) {
                                if (event == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                boolean couldHaveDefaultValue = ParamHelper.couldHaveDefaultValue(myNameEditor.getText());
                                myDefaultValueEditor.setEnabled(couldHaveDefaultValue);
                                myDefaultInSignature.setEnabled(couldHaveDefaultValue);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureDialog$1$2$3", "documentChanged"));
                            }
                        });
                        this.myNameEditor.addDocumentListener((DocumentListener)PyChangeSignatureDialog.this.mySignatureUpdater);
                        return namePanel;
                    }

                    public JBTableRow getValue() {
                        return new JBTableRow(){

                            public Object getValueAt(int column) {
                                return switch (column) {
                                    case 0 -> myNameEditor.getText().trim();
                                    case 1 -> new Pair((Object)item.defaultValueCodeFragment, (Object)((PyParameterTableModelItem)item).isDefaultInSignature());
                                    default -> null;
                                };
                            }
                        };
                    }

                    public JComponent getPreferredFocusedComponent() {
                        return this.myNameEditor.getFocusTarget();
                    }

                    public JComponent[] getFocusableComponents() {
                        ArrayList<JComponent> focusable = new ArrayList<JComponent>();
                        focusable.add(this.myNameEditor.getFocusTarget());
                        if (this.myDefaultValueEditor != null) {
                            focusable.add(this.myDefaultValueEditor.getFocusTarget());
                        }
                        if (this.myDefaultInSignature != null) {
                            focusable.add(this.myDefaultInSignature);
                        }
                        return focusable.toArray(new JComponent[0]);
                    }
                };
            }

            protected boolean isRowEmpty(int row) {
                return false;
            }
        };
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    protected boolean mayPropagateParameters() {
        return false;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected JPanel createParametersPanel(boolean hasTabsInDialog) {
        JPanel panel2 = super.createParametersPanel(hasTabsInDialog);
        this.myPropagateParamChangesButton.setVisible(false);
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureDialog", "createParametersInfoModel"));
    }
}

