/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PatternUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JythonSdkFlavor
extends PythonSdkFlavor<PyFlavorData.Empty> {
    private static final Pattern VERSION_RE = Pattern.compile("(Jython \\S+)( on .*)?");
    private static final String JYTHONPATH = "JYTHONPATH";
    private static final String PYTHON_PATH_PREFIX = "-Dpython.path=";

    private JythonSdkFlavor() {
    }

    public static JythonSdkFlavor getInstance() {
        return (JythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(JythonSdkFlavor.class);
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            JythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return StringUtil.toLowerCase((String)FileUtilRt.getNameWithoutExtension((String)file.getName())).startsWith("jython");
    }

    @Override
    @Nullable
    public String getVersionStringFromOutput(@NotNull String output2) {
        if (output2 == null) {
            JythonSdkFlavor.$$$reportNull$$$0(1);
        }
        return PatternUtil.getFirstMatch(Arrays.asList(StringUtil.splitByLines((String)output2)), (Pattern)VERSION_RE);
    }

    @Override
    @NotNull
    public String getVersionOption() {
        return "--version";
    }

    @Override
    public void initPythonPath(@NotNull GeneralCommandLine cmd, boolean passParentEnvs, @NotNull Collection<String> path2) {
        if (cmd == null) {
            JythonSdkFlavor.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            JythonSdkFlavor.$$$reportNull$$$0(3);
        }
        this.initPythonPath(path2, passParentEnvs, cmd.getEnvironment());
        ParamsGroup paramGroup = cmd.getParametersList().getParamsGroup("Exe Options");
        assert (paramGroup != null);
        for (String param : paramGroup.getParameters()) {
            if (!param.startsWith(PYTHON_PATH_PREFIX)) continue;
            return;
        }
        paramGroup.addParameter(JythonSdkFlavor.getPythonPathCmdLineArgument(path2));
    }

    @Override
    public void initPythonPath(@NotNull Collection<String> path2, boolean passParentEnvs, @NotNull Map<String, String> env) {
        if (path2 == null) {
            JythonSdkFlavor.$$$reportNull$$$0(4);
        }
        if (env == null) {
            JythonSdkFlavor.$$$reportNull$$$0(5);
        }
        if (passParentEnvs) {
            path2 = PythonEnvUtil.appendSystemEnvPaths(path2, JYTHONPATH);
        }
        String jythonPath = StringUtil.join(path2, (String)File.pathSeparator);
        PythonEnvUtil.addToEnv(JYTHONPATH, jythonPath, env);
    }

    @Override
    @NotNull
    public String getName() {
        return "Jython";
    }

    public static String getPythonPathCmdLineArgument(Collection<String> path2) {
        return PYTHON_PATH_PREFIX + StringUtil.join(PythonEnvUtil.appendSystemEnvPaths(path2, JYTHONPATH), (String)File.pathSeparator);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Jython;
        if (icon == null) {
            JythonSdkFlavor.$$$reportNull$$$0(6);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/JythonSdkFlavor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/JythonSdkFlavor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVersionStringFromOutput";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

