/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors.conda;

import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.flavors.conda.CondaPathFixKt;
import com.jetbrains.python.sdk.flavors.conda.PyCondaEnv;
import com.jetbrains.python.sdk.flavors.conda.PyCondaEnvIdentity;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\"\u0010\f\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, d2={"usePythonForLocalConda", "", "getUsePythonForLocalConda", "()Z", "addCondaPythonToTargetCommandLine", "", "targetedCommandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "condaEnv", "Lcom/jetbrains/python/sdk/flavors/conda/PyCondaEnv;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "configureLegacy", "intellij.python.community.impl"})
public final class CondaPythonExecKt {
    public static final boolean getUsePythonForLocalConda() {
        return Registry.is((String)"use.python.for.local.conda");
    }

    public static final void addCondaPythonToTargetCommandLine(@NotNull TargetedCommandLineBuilder targetedCommandLineBuilder, @NotNull PyCondaEnv condaEnv, @Nullable Sdk sdk2) {
        boolean legacyUsed;
        Intrinsics.checkNotNullParameter((Object)targetedCommandLineBuilder, (String)"targetedCommandLineBuilder");
        Intrinsics.checkNotNullParameter((Object)condaEnv, (String)"condaEnv");
        boolean bl = legacyUsed = CondaPythonExecKt.getUsePythonForLocalConda() && targetedCommandLineBuilder.getRequest().getConfiguration() == null && CondaPythonExecKt.configureLegacy(sdk2, condaEnv, targetedCommandLineBuilder);
        if (!legacyUsed) {
            condaEnv.addCondaToTargetBuilder(targetedCommandLineBuilder);
            targetedCommandLineBuilder.addParameter("python");
        }
        if (sdk2 != null) {
            CondaPathFixKt.fixCondaPathEnvIfNeeded(targetedCommandLineBuilder, sdk2);
        } else {
            CondaPathFixKt.fixCondaPathEnvIfNeeded(targetedCommandLineBuilder, condaEnv.getFullCondaPathOnTarget());
        }
    }

    private static final boolean configureLegacy(Sdk sdk2, PyCondaEnv condaEnv, TargetedCommandLineBuilder targetedCommandLineBuilder) {
        String pythonPath;
        block5: {
            Logger logger;
            block4: {
                CharSequence charSequence;
                Logger logger2 = Logger.getInstance((String)"CondaPythonLegacy");
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"CondaPythonLegacy\")");
                logger = logger2;
                Sdk sdk3 = sdk2;
                pythonPath = sdk3 != null ? sdk3.getHomePath() : null;
                PyCondaEnvIdentity envIdentity = condaEnv.getEnvIdentity();
                if (pythonPath == null && envIdentity instanceof PyCondaEnvIdentity.UnnamedEnv && ((PyCondaEnvIdentity.UnnamedEnv)envIdentity).isBase()) {
                    pythonPath = PyCondaPackageService.getCondaBasePython(condaEnv.getFullCondaPathOnTarget());
                }
                if ((charSequence = (CharSequence)pythonPath) == null || StringsKt.isBlank((CharSequence)charSequence)) break block4;
                Path path2 = Path.of(pythonPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(pythonPath)");
                if (Files.isExecutable(path2)) break block5;
            }
            logger.warn("Can't find python path to use, will use conda run instead");
            return false;
        }
        targetedCommandLineBuilder.setExePath(pythonPath);
        return true;
    }
}

