/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import git4idea.GitBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.branch.GitBrancher;
import git4idea.config.GitSharedSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lgit4idea/actions/branch/GitMergeBranchAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "()V", "disabledForCurrent", "", "getDisabledForCurrent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "branch", "Lgit4idea/GitBranch;", "deleteOnMerge", "Lgit4idea/branch/GitBrancher$DeleteOnMergeOption;", "updateIfEnabledAndVisible", "intellij.vcs.git"})
public final class GitMergeBranchAction
extends GitSingleBranchAction {
    private final boolean disabledForCurrent;

    public GitMergeBranchAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.merge.into.current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(\"branches.merge.into.current\")");
        super(supplier);
        this.disabledForCurrent = true;
    }

    @Override
    public boolean getDisabledForCurrent() {
        return this.disabledForCurrent;
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Presentation $this$updateIfEnabledAndVisible_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        Object[] objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, branch.getName()), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setText(GitBundle.message("branches.merge.into", objectArray));
        objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(branch.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        $this$updateIfEnabledAndVisible_u24lambda_u240.setDescription(GitBundle.message("branches.merge.into", objectArray));
        objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(branch.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories2)};
        GitBranchPopupActions.addTooltipText($this$updateIfEnabledAndVisible_u24lambda_u240, GitBundle.message("branches.merge.into", objectArray));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories2, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        GitBrancher.getInstance(project).merge(branch.getName(), this.deleteOnMerge(branch, project), repositories2);
    }

    private final GitBrancher.DeleteOnMergeOption deleteOnMerge(GitBranch branch, Project project) {
        return !branch.isRemote() && !GitSharedSettings.getInstance(project).isBranchProtected(branch.getName()) ? GitBrancher.DeleteOnMergeOption.PROPOSE : GitBrancher.DeleteOnMergeOption.NOTHING;
    }
}

