/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeHandler {
    private static final Logger LOG = Logger.getInstance(GitMergeHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergeDialogCustomizer myDialogCustomizer;

    public GitMergeHandler(@NotNull Project project, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        if (project == null) {
            GitMergeHandler.$$$reportNull$$$0(0);
        }
        if (mergeDialogCustomizer == null) {
            GitMergeHandler.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDialogCustomizer = mergeDialogCustomizer;
    }

    @Nls
    @NotNull
    public String loadMergeDescription() {
        String string = this.myDialogCustomizer.getMultipleFileMergeDescription(Collections.emptyList());
        if (string == null) {
            GitMergeHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean canResolveConflict(@NotNull GitConflict conflict2) {
        VirtualFile file2;
        if (conflict2 == null) {
            GitMergeHandler.$$$reportNull$$$0(3);
        }
        if ((file2 = conflict2.getFilePath().getVirtualFile()) == null) {
            return false;
        }
        if (file2.isDirectory()) {
            return false;
        }
        return conflict2.getStatus(GitConflict.ConflictSide.OURS) != GitConflict.Status.DELETED || conflict2.getStatus(GitConflict.ConflictSide.THEIRS) != GitConflict.Status.DELETED;
    }

    @NotNull
    public Resolver resolveConflict(@NotNull GitConflict conflict2, @NotNull VirtualFile file2, boolean isReversed) throws VcsException {
        if (conflict2 == null) {
            GitMergeHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            GitMergeHandler.$$$reportNull$$$0(5);
        }
        VirtualFile root = conflict2.getRoot();
        FilePath path = conflict2.getFilePath();
        MergeData mergeData = GitMergeUtil.loadMergeData(this.myProject, root, path, isReversed);
        String windowTitle = this.myDialogCustomizer.getMergeWindowTitle(file2);
        String leftTitle = this.myDialogCustomizer.getLeftPanelTitle(file2);
        String centerTitle = this.myDialogCustomizer.getCenterPanelTitle(file2);
        String rightTitle = this.myDialogCustomizer.getRightPanelTitle(file2, mergeData.LAST_REVISION_NUMBER);
        MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizerList = this.myDialogCustomizer.getTitleCustomizerList(path);
        return new Resolver(this.myProject, conflict2, isReversed, file2, mergeData, windowTitle, Arrays.asList(leftTitle, centerTitle, rightTitle), titleCustomizerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptOneVersion(@NotNull Collection<? extends GitConflict> conflicts, @NotNull Collection<? extends VirtualFile> reversedRoots, boolean takeTheirs) throws VcsException {
        if (conflicts == null) {
            GitMergeHandler.$$$reportNull$$$0(6);
        }
        if (reversedRoots == null) {
            GitMergeHandler.$$$reportNull$$$0(7);
        }
        try {
            MultiMap<VirtualFile, GitConflict> byRoot = GitMergeHandler.groupConflictsByRoot(conflicts);
            for (VirtualFile root : byRoot.keySet()) {
                Collection rootConflicts = byRoot.get((Object)root);
                boolean isReversed = reversedRoots.contains(root);
                GitConflict.ConflictSide side = isReversed == takeTheirs ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                GitMergeUtil.acceptOneVersion(this.myProject, root, rootConflicts, side);
                GitMergeUtil.markConflictResolved(this.myProject, root, rootConflicts, side);
            }
        }
        finally {
            List filePaths = ContainerUtil.map(conflicts, GitConflict::getFilePath);
            VcsDirtyScopeManager.getInstance((Project)this.myProject).filePathsDirty((Collection)filePaths, null);
            List virtualFiles = ContainerUtil.mapNotNull((Collection)filePaths, GitMergeHandler::getExistingFileOrParent);
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)virtualFiles));
        }
    }

    @Nullable
    private static VirtualFile getExistingFileOrParent(@NotNull FilePath filePath) {
        VirtualFile file2;
        if (filePath == null) {
            GitMergeHandler.$$$reportNull$$$0(8);
        }
        if ((file2 = filePath.getVirtualFile()) != null) {
            return file2;
        }
        return filePath.getVirtualFileParent();
    }

    @NotNull
    public static MultiMap<VirtualFile, GitConflict> groupConflictsByRoot(@NotNull Collection<? extends GitConflict> conflicts) {
        if (conflicts == null) {
            GitMergeHandler.$$$reportNull$$$0(9);
        }
        MultiMap byRoot = MultiMap.create();
        for (GitConflict gitConflict : conflicts) {
            byRoot.putValue((Object)gitConflict.getRoot(), (Object)gitConflict);
        }
        MultiMap multiMap = byRoot;
        if (multiMap == null) {
            GitMergeHandler.$$$reportNull$$$0(10);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeDialogCustomizer";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/conflicts/GitMergeHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reversedRoots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/conflicts/GitMergeHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMergeDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "groupConflictsByRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResolveConflict";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptOneVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExistingFileOrParent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "groupConflictsByRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10 -> new IllegalStateException(string);
        };
    }

    public static final class Resolver {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitConflict myConflict;
        private final boolean myIsReversed;
        @NotNull
        private final MergeData myMergeData;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final String myWindowTitle;
        @NotNull
        private final List<String> myContentTitles;
        @NotNull
        private final MergeDialogCustomizer.DiffEditorTitleCustomizerList myTitleCustomizerList;
        private volatile boolean myIsValid;

        private Resolver(@NotNull Project project, @NotNull GitConflict conflict2, boolean isReversed, @NotNull VirtualFile file2, @NotNull MergeData mergeData, @NotNull String windowTitle, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizerList) {
            if (project == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            if (conflict2 == null) {
                Resolver.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                Resolver.$$$reportNull$$$0(2);
            }
            if (mergeData == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            if (windowTitle == null) {
                Resolver.$$$reportNull$$$0(4);
            }
            if (contentTitles == null) {
                Resolver.$$$reportNull$$$0(5);
            }
            if (titleCustomizerList == null) {
                Resolver.$$$reportNull$$$0(6);
            }
            this.myIsValid = true;
            this.myProject = project;
            this.myConflict = conflict2;
            this.myIsReversed = isReversed;
            this.myMergeData = mergeData;
            this.myFile = file2;
            this.myWindowTitle = windowTitle;
            this.myContentTitles = contentTitles;
            this.myTitleCustomizerList = titleCustomizerList;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Resolver.$$$reportNull$$$0(7);
            }
            return project;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                Resolver.$$$reportNull$$$0(8);
            }
            return virtualFile;
        }

        @NotNull
        public MergeData getMergeData() {
            MergeData mergeData = this.myMergeData;
            if (mergeData == null) {
                Resolver.$$$reportNull$$$0(9);
            }
            return mergeData;
        }

        public void onConflictResolved(@NotNull MergeResult result2) {
            if (result2 == null) {
                Resolver.$$$reportNull$$$0(10);
            }
            if (result2 != MergeResult.CANCEL) {
                try {
                    GitMergeUtil.markConflictResolved(this.myProject, this.myConflict.getRoot(), Collections.singletonList(this.myConflict), this.getResolutionSide(result2));
                }
                catch (VcsException e) {
                    LOG.error(String.format("Unexpected exception during the git operation: file - %s)", this.myConflict.getFilePath()), (Throwable)e);
                }
            }
            VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(Collections.singletonList(this.myFile), Collections.emptyList());
        }

        @Nullable
        private GitConflict.ConflictSide getResolutionSide(@NotNull MergeResult result2) {
            if (result2 == null) {
                Resolver.$$$reportNull$$$0(11);
            }
            return switch (result2) {
                case MergeResult.LEFT -> {
                    if (!this.myIsReversed) {
                        yield GitConflict.ConflictSide.OURS;
                    }
                    yield GitConflict.ConflictSide.THEIRS;
                }
                case MergeResult.RIGHT -> {
                    if (this.myIsReversed) {
                        yield GitConflict.ConflictSide.OURS;
                    }
                    yield GitConflict.ConflictSide.THEIRS;
                }
                default -> null;
            };
        }

        @NotNull
        public String getWindowTitle() {
            String string = this.myWindowTitle;
            if (string == null) {
                Resolver.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        public List<String> getContentTitles() {
            List<String> list2 = this.myContentTitles;
            if (list2 == null) {
                Resolver.$$$reportNull$$$0(13);
            }
            return list2;
        }

        @NotNull
        public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList() {
            MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList = this.myTitleCustomizerList;
            if (diffEditorTitleCustomizerList == null) {
                Resolver.$$$reportNull$$$0(14);
            }
            return diffEditorTitleCustomizerList;
        }

        public boolean checkIsValid() {
            if (this.myIsValid) {
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRootQuick(this.myConflict.getRoot());
                if (repository == null) {
                    return true;
                }
                this.myIsValid = repository.getStagingAreaHolder().findConflict(this.myConflict.getFilePath()) != null;
            }
            return this.myIsValid;
        }

        public void addListener(@NotNull MergeCallback.Listener listener2, @NotNull Disposable disposable) {
            if (listener2 == null) {
                Resolver.$$$reportNull$$$0(15);
            }
            if (disposable == null) {
                Resolver.$$$reportNull$$$0(16);
            }
            this.myProject.getMessageBus().connect(disposable).subscribe(GitStagingAreaHolder.TOPIC, repo -> {
                if (this.myIsValid && this.myConflict.getRoot().equals(repo.getRoot()) && !this.checkIsValid()) {
                    listener2.fireConflictInvalid();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 12, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowTitle";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentTitles";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleCustomizerList";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/conflicts/GitMergeHandler$Resolver";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/conflicts/GitMergeHandler$Resolver";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergeData";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowTitle";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentTitles";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleCustomizerList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "onConflictResolved";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getResolutionSide";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 12, 13, 14 -> new IllegalStateException(string);
            };
        }
    }
}

