/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.codeWithMe.ClientId;
import com.intellij.externalProcessAuthHelper.ExternalProcessHandlerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import externalApp.ExternalAppHandler;
import git4idea.config.GitExecutable;
import git4idea.editor.GitRebaseEditorApp;
import git4idea.editor.GitRebaseEditorAppHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import java.io.File;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0005H\u0014J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0012"}, d2={"Lgit4idea/rebase/GitRebaseEditorService;", "Lcom/intellij/externalProcessAuthHelper/ExternalProcessHandlerService;", "Lgit4idea/editor/GitRebaseEditorAppHandler;", "()V", "handleRequest", "", "handler", "requestBody", "registerHandler", "Ljava/util/UUID;", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "executable", "Lgit4idea/config/GitExecutable;", "disposable", "Lcom/intellij/openapi/Disposable;", "Companion", "RebaseEditorAppHandler", "intellij.vcs.git"})
public final class GitRebaseEditorService
extends ExternalProcessHandlerService<GitRebaseEditorAppHandler> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public GitRebaseEditorService() {
        super("intellij-git-editor", GitRebaseEditorApp.class);
    }

    @Nullable
    protected String handleRequest(@NotNull GitRebaseEditorAppHandler handler, @NotNull String requestBody) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        String[] stringArray = new String[]{"\n"};
        List args = StringsKt.split$default((CharSequence)requestBody, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (args.size() != 2) {
            return null;
        }
        int exitCode = handler.editCommits((String)args.get(0), (String)args.get(1));
        return String.valueOf(exitCode);
    }

    @NotNull
    public final UUID registerHandler(@NotNull GitRebaseEditorHandler editorHandler, @NotNull GitExecutable executable, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editorHandler, (String)"editorHandler");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        return this.registerHandler((ExternalAppHandler)new RebaseEditorAppHandler(editorHandler, executable), disposable);
    }

    @JvmStatic
    @NotNull
    public static final GitRebaseEditorService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lgit4idea/rebase/GitRebaseEditorService$Companion;", "", "()V", "getInstance", "Lgit4idea/rebase/GitRebaseEditorService;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRebaseEditorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseEditorService.kt\ngit4idea/rebase/GitRebaseEditorService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,51:1\n43#2,3:52\n*S KotlinDebug\n*F\n+ 1 GitRebaseEditorService.kt\ngit4idea/rebase/GitRebaseEditorService$Companion\n*L\n22#1:52,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitRebaseEditorService getInstance() {
            boolean $i$f$service = false;
            Class<GitRebaseEditorService> serviceClass$iv = GitRebaseEditorService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GitRebaseEditorService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/rebase/GitRebaseEditorService$RebaseEditorAppHandler;", "Lgit4idea/editor/GitRebaseEditorAppHandler;", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "executable", "Lgit4idea/config/GitExecutable;", "(Lgit4idea/rebase/GitRebaseEditorHandler;Lgit4idea/config/GitExecutable;)V", "editCommits", "", "path", "", "workingDir", "intellij.vcs.git"})
    private static final class RebaseEditorAppHandler
    implements GitRebaseEditorAppHandler {
        @NotNull
        private final GitRebaseEditorHandler editorHandler;
        @NotNull
        private final GitExecutable executable;

        public RebaseEditorAppHandler(@NotNull GitRebaseEditorHandler editorHandler, @NotNull GitExecutable executable) {
            Intrinsics.checkNotNullParameter((Object)editorHandler, (String)"editorHandler");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            this.editorHandler = editorHandler;
            this.executable = executable;
        }

        public int editCommits(@NotNull String path, @NotNull String workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            File file2 = this.executable.convertFilePathBack(path, new File(workingDir));
            return this.editorHandler.editCommits(file2);
        }
    }
}

