/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.CustomIconProvider;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import git4idea.GitLocalBranch;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.GitOngoingOperationAction;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchOperationType;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitCheckoutAndRebaseRemoteBranchWorkflow;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.ui.branch.GitRefDialog;
import git4idea.update.GitUpdateExecutionProcess;
import icons.DvcsImplIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchPopupActions {
    @NonNls
    public static final String EXPERIMENTAL_BRANCH_POPUP_ACTION_GROUP = "Git.Experimental.Branch.Popup.Actions";
    private static final int MAX_BRANCH_NAME_LENGTH = 40;
    public static final int BRANCH_NAME_LENGTH_DELTA = 4;
    public static final int BRANCH_NAME_SUFFIX_LENGTH = 5;
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, null, false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @Nullable GitRepository specificRepository, boolean firstLevelGroup) {
        LightActionGroup topActions = new LightActionGroup(false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        GitRebaseSpec rebaseSpec = GitRepositoryManager.getInstance(this.myProject).getOngoingRebaseSpec();
        if (rebaseSpec != null && GitBranchPopupActions.isSpecForRepo(rebaseSpec, this.myRepository)) {
            topActions.addAll(GitBranchPopupActions.getRebaseActions());
        } else {
            topActions.addAll(GitBranchPopupActions.createPerRepoRebaseActions(this.myRepository));
        }
        if (ExperimentalUI.isNewUI()) {
            ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction(EXPERIMENTAL_BRANCH_POPUP_ACTION_GROUP);
            topActions.addAll(actionGroup);
            topActions.addSeparator();
        }
        topActions.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        if (!ExperimentalUI.isNewUI()) {
            topActions.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        }
        LightActionGroup popupGroup = new LightActionGroup(true);
        for (AnAction action : topActions.getChildren(null)) {
            boolean isSeparatorOrGroup = action instanceof Separator || action instanceof ActionGroup;
            popupGroup.addAction((AnAction)(isSeparatorOrGroup ? action : new MyDelegateWithShortcutText(action)));
        }
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.local.branches", new Object[0]) : GitBundle.message("branches.local.branches.in.repo", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        GitBranchesCollection branchesCollection = this.myRepository.getBranches();
        List localBranchActions = ((StreamEx)((StreamEx)StreamEx.of(branchesCollection.getLocalBranches()).filter(branch -> !branch.equals(currentBranch))).map(branch -> new LocalBranchActions(this.myProject, repositoryList, branch.getName(), this.myRepository)).sorted((b1, b2) -> {
            int delta = BranchActionUtil.FAVORITE_BRANCH_COMPARATOR.compare(b1, b2);
            if (delta != 0) {
                return delta;
            }
            return StringUtil.naturalCompare((String)b1.myBranchName, (String)b2.myBranchName);
        })).toList();
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches((List)localBranchActions);
        if (currentBranch != null) {
            localBranchActions = ContainerUtil.prepend((List)localBranchActions, (Object[])new LocalBranchActions[]{new CurrentBranchActions(this.myProject, repositoryList, currentBranch.getName(), this.myRepository)});
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)localBranchActions, (int)topShownBranches, (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.remote.branches", new Object[0]) : GitBundle.message("branches.remote.branches.in.repo", specificRepository));
        List remoteBranchActions = ((StreamEx)StreamEx.of(branchesCollection.getRemoteBranches()).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(remoteName -> new RemoteBranchActions(this.myProject, (List<? extends GitRepository>)repositoryList, (String)remoteName, this.myRepository)).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static boolean isSpecForRepo(@NotNull GitRebaseSpec spec, @NotNull GitRepository repository) {
        Collection<GitRepository> repositoriesFromSpec;
        if (spec == null) {
            GitBranchPopupActions.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(1);
        }
        return (repositoriesFromSpec = spec.getAllRepositories()).size() == 1 && repository.equals(ContainerUtil.getFirstItem(repositoriesFromSpec));
    }

    @NotNull
    private static List<AnAction> createPerRepoRebaseActions(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.mapNotNull(GitBranchPopupActions.getRebaseActions(), action -> GitBranchPopupActions.createRepositoryRebaseAction(action, repository));
        if (list2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    static List<AnAction> getRebaseActions() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Git.Ongoing.Rebase.Actions");
        List<AnAction> list2 = Arrays.asList(group.getChildren(null));
        if (list2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Nullable
    private static AnAction createRepositoryRebaseAction(@NotNull AnAction rebaseAction, @NotNull GitRepository repository) {
        if (rebaseAction == null) {
            GitBranchPopupActions.$$$reportNull$$$0(5);
        }
        if (repository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(6);
        }
        if (!(rebaseAction instanceof GitOngoingOperationAction)) {
            return null;
        }
        GitOngoingOperationAction ongoingAction = (GitOngoingOperationAction)rebaseAction;
        MyOngoindOperationAnAction repositoryAction = new MyOngoindOperationAnAction(ongoingAction, repository);
        repositoryAction.getTemplatePresentation().copyFrom(rebaseAction.getTemplatePresentation());
        return repositoryAction;
    }

    @NlsSafe
    @NotNull
    public static String getCurrentBranchFullPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2) {
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(7);
        }
        if (repositories2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(8);
        }
        return GitBranchPopupActions.getCurrentBranchPresentation(project, repositories2, false);
    }

    @NlsSafe
    @NotNull
    public static String getCurrentBranchTruncatedPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2) {
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(9);
        }
        if (repositories2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(10);
        }
        return GitBranchPopupActions.getCurrentBranchPresentation(project, repositories2, true);
    }

    @Nls
    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories2, boolean truncateBranchName) {
        Set currentBranches;
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(11);
        }
        if (repositories2 == null) {
            GitBranchPopupActions.$$$reportNull$$$0(12);
        }
        if ((currentBranches = ContainerUtil.map2SetNotNull(repositories2, repo -> repo.isFresh() ? repo.getCurrentBranchName() : (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)Objects.requireNonNull(repo.getCurrentRevision()))))).size() == 1) {
            String fullBranchName = (String)currentBranches.iterator().next();
            return truncateBranchName ? GitBranchPopupActions.getCurrentBranchTruncatedName(fullBranchName, project) : GitBranchPopupActions.wrapWithQuotes(fullBranchName);
        }
        String string = GitBundle.message("branches.current.branch", new Object[0]);
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getSelectedBranchFullPresentation(@NlsSafe @NotNull String branchName) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(14);
        }
        return GitBranchPopupActions.wrapWithQuotes(branchName);
    }

    @NlsSafe
    @NotNull
    private static String getCurrentBranchTruncatedName(@NlsSafe @NotNull String branchName, @NotNull Project project) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(15);
        }
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(16);
        }
        return GitBranchPopupActions.wrapWithQuotes(StringUtil.escapeMnemonics((String)GitBranchPopupActions.truncateBranchName(branchName, project)));
    }

    @NlsSafe
    @NotNull
    public static String getSelectedBranchTruncatedPresentation(@NotNull Project project, @NlsSafe @NotNull String branchName) {
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(17);
        }
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(18);
        }
        return GitBranchPopupActions.wrapWithQuotes(StringUtil.escapeMnemonics((String)GitBranchPopupActions.truncateBranchName(branchName, project)));
    }

    @NlsSafe
    @NotNull
    public static String truncateBranchName(@NotNull @NlsSafe String branchName, @NotNull Project project) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(19);
        }
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(20);
        }
        return GitBranchPopupActions.truncateBranchName(project, branchName, 40, 5, 4);
    }

    @NlsSafe
    @NotNull
    public static String truncateBranchName(@NotNull Project project, @NotNull @NlsSafe String branchName, int maxBranchNameLength, int suffixLength, int delta) {
        int branchNameLength;
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(21);
        }
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(22);
        }
        if ((branchNameLength = branchName.length()) <= maxBranchNameLength + delta) {
            String string = branchName;
            if (string == null) {
                GitBranchPopupActions.$$$reportNull$$$0(23);
            }
            return string;
        }
        IssueNavigationConfiguration issueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
        List issueMatches = issueNavigationConfiguration.findIssueLinks((CharSequence)branchName);
        int affectedMaxBranchNameLength = maxBranchNameLength - "\u2026".length();
        if (!issueMatches.isEmpty()) {
            IssueNavigationConfiguration.LinkMatch firstMatch = (IssueNavigationConfiguration.LinkMatch)issueMatches.get(0);
            TextRange firstMatchRange = firstMatch.getRange();
            return GitBranchPopupActions.truncateAndSaveIssueId(firstMatchRange, branchName, affectedMaxBranchNameLength, suffixLength, delta);
        }
        if (affectedMaxBranchNameLength - suffixLength - "\u2026".length() < 0) {
            String string = branchName;
            if (string == null) {
                GitBranchPopupActions.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)branchName, (int)affectedMaxBranchNameLength, (int)suffixLength, (boolean)true);
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    static String truncateAndSaveIssueId(@NotNull TextRange issueIdRange, @NotNull String branchName, int maxBranchNameLength, int suffixLength, int delta) {
        Object prefixAndIssue;
        int startOffset;
        int endOffset;
        int branchNameLength;
        String issueId;
        block12: {
            String string;
            String truncatedByDefault;
            if (issueIdRange == null) {
                GitBranchPopupActions.$$$reportNull$$$0(26);
            }
            if (branchName == null) {
                GitBranchPopupActions.$$$reportNull$$$0(27);
            }
            if ((truncatedByDefault = StringUtil.shortenTextWithEllipsis((String)branchName, (int)maxBranchNameLength, (int)suffixLength, (boolean)true)).contains(issueId = issueIdRange.substring(branchName))) {
                String string2 = truncatedByDefault;
                if (string2 == null) {
                    GitBranchPopupActions.$$$reportNull$$$0(28);
                }
                return string2;
            }
            try {
                branchNameLength = branchName.length();
                endOffset = issueIdRange.getEndOffset();
                startOffset = issueIdRange.getStartOffset();
                if (endOffset < branchNameLength - suffixLength - delta) break block12;
                string = StringUtil.shortenTextWithEllipsis((String)branchName, (int)maxBranchNameLength, (int)(branchNameLength - startOffset), (boolean)true);
            }
            catch (Throwable e) {
                String string3 = truncatedByDefault;
                if (string3 == null) {
                    GitBranchPopupActions.$$$reportNull$$$0(31);
                }
                return string3;
            }
            if (string == null) {
                GitBranchPopupActions.$$$reportNull$$$0(29);
            }
            return string;
        }
        String suffix = branchName.substring(branchNameLength - suffixLength);
        int prefixLength = maxBranchNameLength - suffixLength - issueId.length();
        if (Math.abs(startOffset - prefixLength) <= delta) {
            prefixAndIssue = branchName.substring(0, endOffset);
        } else {
            String prefix = branchName.substring(0, prefixLength);
            prefixAndIssue = prefix + "\u2026" + issueId;
        }
        String string = (String)prefixAndIssue + "\u2026" + suffix;
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String wrapWithQuotes(@NlsSafe @NotNull String branchName) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(32);
        }
        String string = "'" + branchName + "'";
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(33);
        }
        return string;
    }

    public static void addTooltipText(Presentation presentation, @NlsContexts.Tooltip String tooltipText) {
        presentation.putClientProperty("ToolTipText", (Object)tooltipText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 13, 23, 24, 25, 28, 29, 30, 31, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseAction";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueIdRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPerRepoRebaseActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRebaseActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchPresentation";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateBranchName";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateAndSaveIssueId";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSpecForRepo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPerRepoRebaseActions";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRepositoryRebaseAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchFullPresentation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchTruncatedPresentation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedBranchFullPresentation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchTruncatedName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedBranchTruncatedPresentation";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "truncateBranchName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "truncateAndSaveIssueId";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 13, 23, 24, 25, 28, 29, 30, 31, 33 -> new IllegalStateException(string);
        };
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories2) {
            if (project == null) {
                GitNewBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                GitNewBranchAction.$$$reportNull$$$0(1);
            }
            super(project, repositories2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GitNewBranchAction.$$$reportNull$$$0(2);
            }
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, "HEAD", GitBundle.message("branches.create.new.branch.dialog.title", new Object[0]), MultiRootBranches.getCommonCurrentBranch((Collection)this.myRepositories));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$GitNewBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories2) {
            super(GitBundle.messagePointer("branches.checkout.tag.or.revision", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitRefDialog dialog2;
            if (e == null) {
                CheckoutRevisionActions.$$$reportNull$$$0(0);
            }
            if ((dialog2 = new GitRefDialog(this.myProject, this.myRepositories, GitBundle.message("branches.checkout", new Object[0]), GitBundle.message("branches.enter.reference.branch.tag.name.or.commit.hash", new Object[0]))).showAndGet()) {
                String reference = dialog2.getReference();
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CheckoutRevisionActions.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutRevisionActions.$$$reportNull$$$0(2);
            }
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.checkout", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutRevisionActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutRevisionActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyDelegateWithShortcutText
    extends AnActionWrapper
    implements PopupElementWithAdditionalInfo {
        private MyDelegateWithShortcutText(@NotNull AnAction action) {
            if (action == null) {
                MyDelegateWithShortcutText.$$$reportNull$$$0(0);
            }
            super(action);
        }

        @Nls
        @Nullable
        public String getInfoText() {
            return KeymapUtil.getPreferredShortcutText((Shortcut[])this.getDelegate().getShortcutSet().getShortcuts());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "git4idea/ui/branch/GitBranchPopupActions$MyDelegateWithShortcutText", "<init>"));
        }
    }

    public static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        @NlsSafe
        protected final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull @NlsSafe String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                LocalBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                LocalBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                LocalBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                LocalBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = Collections.unmodifiableList(repositories2);
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)project.getService(GitBranchManager.class));
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.myBranchName, false);
            GitBranchPopupActions.addTooltipText(this.getTemplatePresentation(), LocalBranchActions.constructIncomingOutgoingTooltip(this.hasIncomingCommits(), this.hasOutgoingCommits()));
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories2.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        List<GitRepository> getRepositories() {
            List<GitRepository> list2 = this.myRepositories;
            if (list2 == null) {
                LocalBranchActions.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @NotNull
        public String getBranchName() {
            String string = this.myBranchName;
            if (string == null) {
                LocalBranchActions.$$$reportNull$$$0(5);
            }
            return string;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName, false), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                LocalBranchActions.$$$reportNull$$$0(6);
            }
            return anActionArray;
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public static String constructIncomingOutgoingTooltip(boolean incoming, boolean outgoing) {
            if (!incoming && !outgoing) {
                return null;
            }
            if (incoming && outgoing) {
                return GitBundle.message("branches.there.are.incoming.and.outgoing.commits", new Object[0]);
            }
            if (incoming) {
                return GitBundle.message("branches.there.are.incoming.commits", new Object[0]);
            }
            return GitBundle.message("branches.there.are.outgoing.commits", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRepositories";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }

        public static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            public CheckoutAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    CheckoutAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    CheckoutAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    CheckoutAction.$$$reportNull$$$0(2);
                }
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CheckoutAction.$$$reportNull$$$0(3);
                }
                CheckoutAction.checkoutBranch(this.myProject, this.myRepositories, this.myBranchName);
            }

            public static void checkoutBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    CheckoutAction.$$$reportNull$$$0(4);
                }
                if (repositories2 == null) {
                    CheckoutAction.$$$reportNull$$$0(5);
                }
                if (branchName == null) {
                    CheckoutAction.$$$reportNull$$$0(6);
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkout(branchName, false, repositories2, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkoutBranch";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class CheckoutWithRebaseAction
        extends CheckoutWithRebaseActionBase {
            CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(2);
                }
                super(project, repositories2, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(3);
                }
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$CheckoutWithRebaseAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PushBranchAction
        extends DumbAwareAction
        implements CustomIconProvider {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;
            private final boolean myHasCommitsToPush;

            PushBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories2, @NotNull String branchName, boolean hasCommitsToPush) {
                if (project == null) {
                    PushBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    PushBranchAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    PushBranchAction.$$$reportNull$$$0(2);
                }
                super(ActionsBundle.messagePointer((String)"action.Vcs.Push.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myBranchName = branchName;
                this.myHasCommitsToPush = hasCommitsToPush;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    PushBranchAction.$$$reportNull$$$0(3);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    PushBranchAction.$$$reportNull$$$0(4);
                }
                DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.push", new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    PushBranchAction.$$$reportNull$$$0(5);
                }
                GitLocalBranch localBranch = this.myRepositories.get(0).getBranches().findLocalBranch(this.myBranchName);
                assert (localBranch != null);
                new VcsPushDialog(this.myProject, this.myRepositories, this.myRepositories, null, (PushSource)GitPushSource.create(localBranch)).show();
            }

            @Nullable
            public Icon getRightIcon() {
                return this.myHasCommitsToPush ? DvcsImplIcons.Outgoing : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$PushBranchAction";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$PushBranchAction";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }

        public static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<? extends GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            RenameBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String currentBranchName) {
                if (project == null) {
                    RenameBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    RenameBranchAction.$$$reportNull$$$0(1);
                }
                if (currentBranchName == null) {
                    RenameBranchAction.$$$reportNull$$$0(2);
                }
                super(ActionsBundle.messagePointer((String)"action.RenameAction.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    RenameBranchAction.$$$reportNull$$$0(3);
                }
                RenameBranchAction.rename(this.myProject, this.myRepositories, this.myCurrentBranchName);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    RenameBranchAction.$$$reportNull$$$0(4);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    RenameBranchAction.$$$reportNull$$$0(5);
                }
                DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.rename.branch", new Object[0]));
            }

            public static void rename(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String currentBranchName) {
                GitNewBranchOptions options;
                if (project == null) {
                    RenameBranchAction.$$$reportNull$$$0(6);
                }
                if (repositories2 == null) {
                    RenameBranchAction.$$$reportNull$$$0(7);
                }
                if (currentBranchName == null) {
                    RenameBranchAction.$$$reportNull$$$0(8);
                }
                if ((options = new GitNewBranchDialog(project, repositories2, GitBundle.message("branches.rename.branch", currentBranchName), currentBranchName, false, false, false, false, GitBranchOperationType.RENAME).showAndGetOptions()) != null) {
                    GitBrancher brancher = GitBrancher.getInstance(project);
                    brancher.renameBranch(currentBranchName, options.getName(), repositories2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentBranchName";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$RenameBranchAction";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "rename";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<? extends GitRepository> repositories2, String branchName) {
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteAction.$$$reportNull$$$0(0);
                }
                GitBrancher.getInstance(this.myProject).deleteBranch(this.myBranchName, ContainerUtil.filter(this.myRepositories, repository -> !this.myBranchName.equals(repository.getCurrentBranchName())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions$DeleteAction", "actionPerformed"));
            }
        }
    }

    public static class CurrentBranchActions
    extends LocalBranchActions {
        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                CurrentBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                CurrentBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                CurrentBranchActions.$$$reportNull$$$0(3);
            }
            super(project, repositories2, branchName, selectedRepository);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new LocalBranchActions.PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new LocalBranchActions.RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                CurrentBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CurrentBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyOngoindOperationAnAction
    extends DumbAwareAction {
        @NotNull
        private final GitOngoingOperationAction myOngoingAction;
        @NotNull
        private final GitRepository myRepository;

        MyOngoindOperationAnAction(@NotNull GitOngoingOperationAction ongoingAction, @NotNull GitRepository repository) {
            if (ongoingAction == null) {
                MyOngoindOperationAnAction.$$$reportNull$$$0(0);
            }
            if (repository == null) {
                MyOngoindOperationAnAction.$$$reportNull$$$0(1);
            }
            this.myOngoingAction = ongoingAction;
            this.myRepository = repository;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyOngoindOperationAnAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyOngoindOperationAnAction.$$$reportNull$$$0(3);
            }
            e.getPresentation().setEnabledAndVisible(this.myOngoingAction.isEnabled(this.myRepository));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyOngoindOperationAnAction.$$$reportNull$$$0(4);
            }
            this.myOngoingAction.performInBackground(this.myRepository);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ongoingAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$MyOngoindOperationAnAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$MyOngoindOperationAnAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        @NlsSafe
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull @NlsSafe String branchName, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                RemoteBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                RemoteBranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                RemoteBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                RemoteBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)project.getService(GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories2.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName, true), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new PullWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new PullWithMergeAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                RemoteBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        public static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;

            CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String remoteBranchName) {
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(1);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(2);
                }
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(3);
                }
                CheckoutRemoteBranchAction.checkoutRemoteBranch(this.myProject, this.myRepositories, this.myRemoteBranchName);
            }

            @RequiresEdt
            public static void checkoutRemoteBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String remoteBranchName) {
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(4);
                }
                if (repositories2 == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(5);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(6);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                GitRepository repository = repositories2.get(0);
                GitRemoteBranch remoteBranch = Objects.requireNonNull(repository.getBranches().findRemoteBranch(remoteBranchName));
                String suggestedLocalName = remoteBranch.getNameForRemoteOperations();
                if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)suggestedLocalName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories2, remoteBranchName, suggestedLocalName);
                    return;
                }
                Map conflictingLocalBranches2 = ContainerUtil.map2MapNotNull(repositories2, r -> {
                    GitLocalBranch local = r.getBranches().findLocalBranch(suggestedLocalName);
                    return local != null ? Pair.create((Object)r, (Object)local) : null;
                });
                if (GitBranchActionsUtilKt.hasTrackingConflicts(conflictingLocalBranches2, remoteBranchName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories2, remoteBranchName, suggestedLocalName);
                    return;
                }
                new GitBranchCheckoutOperation(project, repositories2).perform(remoteBranchName, new GitNewBranchOptions(suggestedLocalName, true, true));
            }

            @RequiresEdt
            private static void askNewBranchNameAndCheckout(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String remoteBranchName, @NotNull String suggestedLocalName) {
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(7);
                }
                if (repositories2 == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(8);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(9);
                }
                if (suggestedLocalName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(10);
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                GitNewBranchOptions options = new GitNewBranchDialog(project, repositories2, GitBundle.message("branches.checkout.s", remoteBranchName), suggestedLocalName, false, true).showAndGetOptions();
                if (options == null) {
                    return;
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkoutNewBranchStartingFrom(options.getName(), remoteBranchName, options.shouldReset(), repositories2, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remoteBranchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suggestedLocalName";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkoutRemoteBranch";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "askNewBranchNameAndCheckout";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class CheckoutWithRebaseAction
        extends CheckoutWithRebaseActionBase {
            CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(2);
                }
                super(project, repositories2, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(3);
                }
                GitRepository repository = (GitRepository)this.myRepositories.get(0);
                GitRemoteBranch remoteBranch = Objects.requireNonNull(repository.getBranches().findRemoteBranch(this.myBranchName));
                String suggestedLocalName = remoteBranch.getNameForRemoteOperations();
                GitNewBranchOptions newBranchOptions = new GitNewBranchOptions(suggestedLocalName, false, true);
                if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)this.myBranchName, (Object)suggestedLocalName) && (newBranchOptions = this.askBranchName(suggestedLocalName)) == null) {
                    return;
                }
                String localName = newBranchOptions.getName();
                Map conflictingLocalBranches2 = ContainerUtil.map2MapNotNull((Collection)this.myRepositories, r -> {
                    GitLocalBranch local = r.getBranches().findLocalBranch(localName);
                    return local != null ? Pair.create((Object)r, (Object)local) : null;
                });
                if (GitBranchActionsUtilKt.hasTrackingConflicts(conflictingLocalBranches2, this.myBranchName) && (newBranchOptions = this.askBranchName(localName)) == null) {
                    return;
                }
                GitCheckoutAndRebaseRemoteBranchWorkflow workflow = new GitCheckoutAndRebaseRemoteBranchWorkflow(this.myProject, this.myRepositories);
                workflow.execute(remoteBranch.getNameForLocalOperations(), newBranchOptions);
            }

            @Nullable
            private GitNewBranchOptions askBranchName(@NotNull String suggestedLocalName) {
                if (suggestedLocalName == null) {
                    CheckoutWithRebaseAction.$$$reportNull$$$0(4);
                }
                return new GitNewBranchDialog(this.myProject, this.myRepositories, GitBundle.message("branches.checkout.s", this.myBranchName), suggestedLocalName, false, true).showAndGetOptions();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suggestedLocalName";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutWithRebaseAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "askBranchName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PullWithRebaseAction
        extends PullBranchBaseAction {
            PullWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    PullWithRebaseAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    PullWithRebaseAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    PullWithRebaseAction.$$$reportNull$$$0(2);
                }
                super(project, repositories2, branchName, UpdateMethod.REBASE);
                Presentation presentation = this.getTemplatePresentation();
                Supplier<@Nls String> text = GitBundle.messagePointer("branches.action.pull.into.branch.using.rebase", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, repositories2));
                presentation.setText(text);
                Supplier<@Nls String> description2 = GitBundle.messagePointer("branches.action.pull.into.branch.using.rebase.description", GitBranchPopupActions.getCurrentBranchFullPresentation(project, repositories2));
                presentation.setDescription(description2);
                GitBranchPopupActions.addTooltipText(presentation, description2.get());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$PullWithRebaseAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class PullWithMergeAction
        extends PullBranchBaseAction {
            PullWithMergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    PullWithMergeAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    PullWithMergeAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    PullWithMergeAction.$$$reportNull$$$0(2);
                }
                super(project, repositories2, branchName, UpdateMethod.MERGE);
                Presentation presentation = this.getTemplatePresentation();
                Supplier<@Nls String> text = GitBundle.messagePointer("branches.action.pull.into.branch.using.merge", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, repositories2));
                presentation.setText(text);
                Supplier<@Nls String> description2 = GitBundle.messagePointer("branches.action.pull.into.branch.using.merge.description", GitBranchPopupActions.getCurrentBranchFullPresentation(project, repositories2));
                presentation.setDescription(description2);
                GitBranchPopupActions.addTooltipText(presentation, description2.get());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "branchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$PullWithMergeAction";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
                if (project == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(2);
                }
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(3);
                }
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(4);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    RemoteDeleteAction.$$$reportNull$$$0(5);
                }
                e.getPresentation().setEnabled(!GitProtectedBranchesKt.isRemoteBranchProtected(this.myRepositories, this.myBranchName));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$RemoteDeleteAction";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        }

        private static class PullBranchBaseAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;
            private final UpdateMethod myUpdateMethod;

            PullBranchBaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String remoteBranchName, UpdateMethod updateMethod) {
                if (project == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(0);
                }
                if (repositories2 == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(1);
                }
                if (remoteBranchName == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(2);
                }
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myRemoteBranchName = remoteBranchName;
                this.myUpdateMethod = updateMethod;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    PullBranchBaseAction.$$$reportNull$$$0(3);
                }
                new GitUpdateExecutionProcess(this.myProject, this.myRepositories, PullBranchBaseAction.configureTarget(this.myRepositories, this.myRemoteBranchName), this.myUpdateMethod, false).execute();
            }

            private static Map<GitRepository, GitBranchPair> configureTarget(List<? extends GitRepository> repositories2, String branchName) {
                LinkedHashMap<GitRepository, GitBranchPair> map2 = new LinkedHashMap<GitRepository, GitBranchPair>();
                for (GitRepository gitRepository : repositories2) {
                    GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
                    GitRemoteBranch remoteBranch = gitRepository.getBranches().findRemoteBranch(branchName);
                    if (currentBranch == null || remoteBranch == null) continue;
                    map2.put(gitRepository, new GitBranchPair(currentBranch, remoteBranch));
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remoteBranchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$PullBranchBaseAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myTagName;

        TagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull @NlsSafe String tagName) {
            if (project == null) {
                TagActions.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                TagActions.$$$reportNull$$$0(1);
            }
            if (tagName == null) {
                TagActions.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myTagName = tagName;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new MergeAction(this.myProject, this.myRepositories, this.myTagName, false), new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
            if (anActionArray == null) {
                TagActions.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<? extends GitRepository> repositories2, String tagName) {
                super(IdeBundle.messagePointer((String)"button.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories2;
                this.myTagName = tagName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteTagAction.$$$reportNull$$$0(0);
                }
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/branch/GitBranchPopupActions$TagActions$DeleteTagAction", "actionPerformed"));
            }
        }
    }

    private static class UpdateSelectedBranchAction
    extends DumbAwareAction
    implements CustomIconProvider {
        protected final Project myProject;
        protected final List<? extends GitRepository> myRepositories;
        protected final String myBranchName;
        protected final List<String> myBranchNameList;
        protected final boolean myHasIncoming;

        UpdateSelectedBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName, boolean hasIncoming) {
            if (project == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.update", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
            this.myBranchNameList = Collections.singletonList(branchName);
            this.myHasIncoming = hasIncoming;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(4);
            }
            Presentation presentation = e.getPresentation();
            if (!GitBranchActionsUtilKt.hasRemotes(this.myProject)) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            String branchPresentation = GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName);
            String description2 = GitBundle.message("action.Git.Update.Selected.description", this.myBranchNameList.size(), GitVcsSettings.getInstance(this.myProject).getUpdateMethod().getMethodName().toLowerCase(Locale.ROOT));
            presentation.setDescription(description2);
            if (GitFetchSupport.fetchSupport(this.myProject).isFetchRunning()) {
                presentation.setEnabled(false);
                presentation.setDescription(GitBundle.message("branches.update.is.already.running", new Object[0]));
                return;
            }
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(this.myBranchNameList, this.myRepositories);
            presentation.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                presentation.setDescription(GitBundle.message("branches.tracking.branch.doesn.t.configured.for.s", branchPresentation));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateSelectedBranchAction.$$$reportNull$$$0(5);
            }
            GitBranchActionsUtilKt.updateBranches(this.myProject, this.myRepositories, this.myBranchNameList);
        }

        @Nullable
        public Icon getRightIcon() {
            return this.myHasIncoming ? DvcsImplIcons.Incoming : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$UpdateSelectedBranchAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$UpdateSelectedBranchAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        RebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
            if (project == null) {
                RebaseAction.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                RebaseAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                RebaseAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.rebase.current.onto.selected", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RebaseAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isOnBranch;
            if (e == null) {
                RebaseAction.$$$reportNull$$$0(4);
            }
            String description2 = (isOnBranch = ContainerUtil.and(this.myRepositories, GitRepository::isOnBranch)) ? GitBundle.message("branches.rebase.onto", GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories), GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName)) : GitBundle.message("branches.rebase.is.not.possible.in.the.detached.head.state", new Object[0]);
            Presentation presentation = e.getPresentation();
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            presentation.setEnabled(isOnBranch);
            String actionText = GitBundle.message("branches.rebase.onto", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories), GitBranchPopupActions.getSelectedBranchTruncatedPresentation(this.myProject, this.myBranchName));
            presentation.setText(actionText);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RebaseAction.$$$reportNull$$$0(5);
            }
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RebaseAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RebaseAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        MergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName, boolean localBranch) {
            if (project == null) {
                MergeAction.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                MergeAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                MergeAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.merge.into.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MergeAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(4);
            }
            Presentation presentation = e.getPresentation();
            String description2 = GitBundle.message("branches.merge.into", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories));
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            String name = GitBundle.message("branches.merge.into", GitBranchPopupActions.getSelectedBranchTruncatedPresentation(this.myProject, this.myBranchName), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(name);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(5);
            }
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(this.myProject), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge(Project project) {
            if (this.myLocalBranch && !GitSharedSettings.getInstance(project).isBranchProtected(this.myBranchName)) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$MergeAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$MergeAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ShowDiffWithBranchAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        ShowDiffWithBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
            if (project == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.show.diff.with.working.tree", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(3);
            }
            GitBrancher.getInstance(this.myProject).showDiffWithLocal(this.myBranchName, this.myRepositories);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithBranchAction.$$$reportNull$$$0(5);
            }
            e.getPresentation().setEnabledAndVisible(!new GitMultiRootBranchConfig(this.myRepositories).diverged());
            String description2 = GitBundle.message("branches.compare.the.current.working.tree.with", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName));
            e.getPresentation().setDescription(description2);
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.show.diff", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$ShowDiffWithBranchAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$ShowDiffWithBranchAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CompareAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
            if (project == null) {
                CompareAction.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                CompareAction.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CompareAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.compare.with.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompareAction.$$$reportNull$$$0(3);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CompareAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompareAction.$$$reportNull$$$0(5);
            }
            String description2 = GitBundle.message("branches.show.commits.in", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories));
            Presentation presentation = e.getPresentation();
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            String text = GitBundle.message("branches.compare.with.branch", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CompareAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CompareAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class CheckoutWithRebaseActionBase
    extends DumbAwareAction {
        protected final Project myProject;
        protected final List<? extends GitRepository> myRepositories;
        protected final String myBranchName;

        CheckoutWithRebaseActionBase(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
            if (project == null) {
                CheckoutWithRebaseActionBase.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                CheckoutWithRebaseActionBase.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CheckoutWithRebaseActionBase.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.checkout.and.rebase.onto.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CheckoutWithRebaseActionBase.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutWithRebaseActionBase.$$$reportNull$$$0(4);
            }
            String description2 = GitBundle.message("branches.checkout.and.rebase.onto.in.one.step", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories), this.myBranchName);
            Presentation presentation = e.getPresentation();
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            String text = GitBundle.message("branches.checkout.and.rebase.onto.branch", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseActionBase";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutWithRebaseActionBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class CheckoutAsNewBranch
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myIsRemote;

        CheckoutAsNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories2, @NotNull String branchName, boolean isRemote) {
            if (project == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(0);
            }
            if (repositories2 == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.new.branch.from.branch", GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, branchName)));
            Supplier<@Nls String> description2 = GitBundle.messagePointer("branches.new.branch.from.branch.description", GitBranchPopupActions.getSelectedBranchFullPresentation(branchName));
            this.getTemplatePresentation().setDescription(description2);
            GitBranchPopupActions.addTooltipText(this.getTemplatePresentation(), description2.get());
            this.myProject = project;
            this.myRepositories = repositories2;
            this.myBranchName = branchName;
            this.myIsRemote = isRemote;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(4);
            }
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)DvcsBundle.message((String)"action.not.possible.in.fresh.repo.new.branch", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CheckoutAsNewBranch.$$$reportNull$$$0(5);
            }
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, this.myBranchName + "^0", GitBundle.message("action.Git.New.Branch.dialog.title", this.myBranchName), GitBranchActionsUtil.calculateNewBranchInitialName(this.myBranchName, this.myIsRemote));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutAsNewBranch";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$CheckoutAsNewBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

