/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesDashboardActions;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeStateHolder;
import git4idea.ui.branch.dashboard.BranchesTreeStateProvider;
import git4idea.ui.branch.dashboard.FilteringBranchesTree;
import git4idea.ui.branch.dashboard.NodeDescriptorsModel;
import git4idea.ui.branch.dashboard.NodeType;
import git4idea.ui.branch.dashboard.RemoteInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B<\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u0003H\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0012\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\fH\u0014J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u0003062\u0006\u0010-\u001a\u00020\u0003H\u0014J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000208H\u0014J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030:H\u0002J\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\f0<J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030>J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00130<J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0>J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020C0<2\u0006\u0010D\u001a\u00020\u0013J\u0019\u0010E\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\bF2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0014J\b\u0010G\u001a\u000203H\u0002J\b\u0010H\u001a\u000201H\u0016J\b\u0010I\u001a\u00020\u0014H\u0002J\u000e\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u001cJ\u0012\u0010L\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\fH\u0014J\u0006\u0010M\u001a\u000203J\u0006\u0010N\u001a\u000203J\b\u0010O\u001a\u000203H\u0002J\u001e\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u00020\u00142\f\u0010R\u001a\b\u0012\u0004\u0012\u0002030SH\u0002J\b\u0010T\u001a\u000203H\u0002J\u0016\u0010U\u001a\u0002032\u0006\u0010K\u001a\u00020\u001c2\u0006\u0010V\u001a\u00020\u0014J\u000e\u0010W\u001a\u0002032\u0006\u0010X\u001a\u00020\u0014J\b\u0010Y\u001a\u000203H\u0002J\b\u0010Z\u001a\u00020\u0014H\u0014J\u0012\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00030>*\u00020\u0003H\u0002R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00140\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "Lcom/intellij/ui/FilteringTree;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "rootNode", "place", "", "Lorg/jetbrains/annotations/NonNls;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lgit4idea/ui/branch/dashboard/BranchesDashboardController;Lgit4idea/ui/branch/dashboard/BranchTreeNode;Ljava/lang/String;Lcom/intellij/openapi/Disposable;)V", "branchFilter", "Lkotlin/Function1;", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "", "getComponent", "()Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "expandedPaths", "Ljava/util/HashSet;", "Ljavax/swing/tree/TreePath;", "groupingConfig", "", "Lcom/intellij/dvcs/branch/GroupingKey;", "headBranchesNode", "localBranchesNode", "localNodeExist", "nodeDescriptorsModel", "Lgit4idea/ui/branch/dashboard/NodeDescriptorsModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "remoteBranchesNode", "remoteNodeExist", "treeStateHolder", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "getTreeStateHolder", "()Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "treeStateProvider", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateProvider;", "createNode", "nodeDescriptor", "createSpeedSearch", "Lcom/intellij/ui/speedSearch/SpeedSearchSupply;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "expandTreeOnSearchUpdateComplete", "", "pattern", "getChildren", "", "getNodeClass", "Ljava/lang/Class;", "getRootNodeDescriptors", "", "getSelectedBranchFilters", "", "getSelectedBranchNodes", "", "getSelectedBranches", "getSelectedRemotes", "Lgit4idea/ui/branch/dashboard/RemoteInfo;", "getSelectedRepositories", "Lgit4idea/repo/GitRepository;", "branchInfo", "getText", "Lcom/intellij/openapi/util/NlsSafe;", "initDefaultTreeExpandState", "installSearchField", "isEmptyModel", "isGroupingEnabled", "key", "onSpeedSearchUpdateComplete", "refreshNodeDescriptorsModel", "refreshTree", "restorePreviouslyExpandedPaths", "runPreservingTreeState", "loadSaved", "runnable", "Lkotlin/Function0;", "setupTreeListeners", "toggleGrouping", "state", "update", "initial", "updateSpeedSearchBackground", "useIdentityHashing", "getDirectChildren", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/FilteringBranchesTree\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,548:1\n29#2,3:549\n29#2,3:552\n*S KotlinDebug\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/FilteringBranchesTree\n*L\n264#1:549,3\n261#1:552,3\n*E\n"})
public final class FilteringBranchesTree
extends FilteringTree<BranchTreeNode, BranchNodeDescriptor> {
    @NotNull
    private final Project project;
    @NotNull
    private final BranchesTreeComponent component;
    @NotNull
    private final BranchesDashboardController uiController;
    @NotNull
    private final HashSet<TreePath> expandedPaths;
    @NotNull
    private final BranchTreeNode localBranchesNode;
    @NotNull
    private final BranchTreeNode remoteBranchesNode;
    @NotNull
    private final BranchTreeNode headBranchesNode;
    @NotNull
    private final Function1<BranchInfo, Boolean> branchFilter;
    @NotNull
    private final NodeDescriptorsModel nodeDescriptorsModel;
    private boolean localNodeExist;
    private boolean remoteNodeExist;
    @NotNull
    private final BranchesTreeStateProvider treeStateProvider;
    @NotNull
    private final Map<GroupingKey, Boolean> groupingConfig;

    /*
     * WARNING - void declaration
     */
    public FilteringBranchesTree(@NotNull Project project, @NotNull BranchesTreeComponent component2, @NotNull BranchesDashboardController uiController, @NotNull BranchTreeNode rootNode, final @NotNull String place, @NotNull Disposable disposable) {
        void $this$groupingConfig_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)component2), (String)"component");
        Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((Tree)component2, (DefaultMutableTreeNode)rootNode);
        this.project = project;
        this.component = component2;
        this.uiController = uiController;
        this.expandedPaths = new HashSet();
        this.localBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.LOCAL_ROOT, null, null, null, null, 30, null));
        this.remoteBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.REMOTE_ROOT, null, null, null, null, 30, null));
        this.headBranchesNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.HEAD_NODE, null, null, null, null, 30, null));
        this.branchFilter = (Function1)new Function1<BranchInfo, Boolean>(this){
            final /* synthetic */ FilteringBranchesTree this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BranchInfo branch) {
                Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                return !FilteringBranchesTree.access$getUiController$p(this.this$0).getShowOnlyMy() || branch.isMy() == ThreeState.YES;
            }
        };
        this.nodeDescriptorsModel = new NodeDescriptorsModel(this.localBranchesNode.getNodeDescriptor(), this.remoteBranchesNode.getNodeDescriptor());
        this.treeStateProvider = new BranchesTreeStateProvider(this, disposable);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service22 = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Pair[] pairArray = $this$service$iv.getService(serviceClass$iv);
        if (pairArray == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        GitBranchManager $i$f$service22 = (GitBranchManager)pairArray;
        FilteringBranchesTree filteringBranchesTree = this;
        boolean bl = false;
        pairArray = new Pair[]{TuplesKt.to((Object)GroupingKey.GROUPING_BY_DIRECTORY, (Object)$this$groupingConfig_u24lambda_u240.isGroupingEnabled(GroupingKey.GROUPING_BY_DIRECTORY)), TuplesKt.to((Object)GroupingKey.GROUPING_BY_REPOSITORY, (Object)$this$groupingConfig_u24lambda_u240.isGroupingEnabled(GroupingKey.GROUPING_BY_REPOSITORY))};
        filteringBranchesTree.groupingConfig = MapsKt.hashMapOf((Pair[])pairArray);
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this.getComponent())), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(), (String)place);
                this.setupTreeListeners();
            }
        }), (int)1, null);
    }

    public /* synthetic */ FilteringBranchesTree(Project project, BranchesTreeComponent branchesTreeComponent, BranchesDashboardController branchesDashboardController, BranchTreeNode branchTreeNode, String string, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            branchTreeNode = new BranchTreeNode(new BranchNodeDescriptor(NodeType.ROOT, null, null, null, null, 30, null));
        }
        this(project, branchesTreeComponent, branchesDashboardController, branchTreeNode, string, disposable);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final BranchesTreeComponent getComponent() {
        return this.component;
    }

    private final BranchesTreeStateHolder getTreeStateHolder() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<BranchesTreeStateHolder> serviceClass$iv = BranchesTreeStateHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return (BranchesTreeStateHolder)object;
    }

    public final void toggleGrouping(@NotNull GroupingKey key, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Boolean bl = state2;
        this.groupingConfig.put(key, bl);
        this.refreshTree();
    }

    public final boolean isGroupingEnabled(@NotNull GroupingKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Intrinsics.areEqual((Object)this.groupingConfig.get(key), (Object)true);
    }

    @NotNull
    protected SpeedSearchSupply createSpeedSearch(@NotNull SearchTextField searchTextField) {
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"searchTextField");
        return (SpeedSearchSupply)new FilteringTree.FilteringSpeedSearch(this, searchTextField){
            @NotNull
            private final HashSet<MinusculeMatcher> customWordMatchers;
            {
                this.customWordMatchers = new HashSet<E>();
            }

            @Nullable
            public Iterable<TextRange> matchingFragments(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Iterable allTextRanges = super.matchingFragments(text);
                if (this.customWordMatchers.isEmpty()) {
                    return allTextRanges;
                }
                ArrayList<E> wordRanges = new ArrayList<E>();
                for (MinusculeMatcher wordMatcher : this.customWordMatchers) {
                    FList fList = wordMatcher.matchingFragments(text);
                    if (fList == null) continue;
                    Collection p0 = (Collection)fList;
                    boolean bl = false;
                    wordRanges.addAll(p0);
                }
                Iterable iterable = allTextRanges;
                return iterable != null ? (Iterable<T>)CollectionsKt.plus((Iterable)iterable, (Iterable)wordRanges) : (!((Collection)wordRanges).isEmpty() ? (Iterable)wordRanges : null);
            }

            public void updatePattern(@Nullable String string) {
                super.updatePattern(string);
                this.onUpdatePattern(string);
            }

            protected void onUpdatePattern(@Nullable String text) {
                this.customWordMatchers.clear();
                this.customWordMatchers.addAll((Collection<MinusculeMatcher>)this.buildCustomWordMatchers(text));
            }

            private final Set<MinusculeMatcher> buildCustomWordMatchers(String text) {
                if (text == null) {
                    return SetsKt.emptySet();
                }
                HashSet<FixingLayoutMatcher> wordMatchers = new HashSet<FixingLayoutMatcher>();
                for (String word : StringUtil.split((String)text, (String)" ")) {
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"word");
                    String trimmedWord = ((Object)StringsKt.trim((CharSequence)word)).toString();
                    wordMatchers.add(new FixingLayoutMatcher("*" + trimmedWord, NameUtil.MatchingCaseSensitivity.NONE, ""));
                }
                return wordMatchers;
            }
        };
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField searchTextField = super.installSearchField();
        Intrinsics.checkNotNullExpressionValue((Object)searchTextField, (String)"super.installSearchField()");
        SearchTextField searchField = searchTextField;
        this.component.setSearchField(searchField);
        return searchField;
    }

    private final void setupTreeListeners() {
        this.component.addTreeExpansionListener(new TreeExpansionListener(this){
            final /* synthetic */ FilteringBranchesTree this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeExpanded(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).add(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }

            public void treeCollapsed(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).remove(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }
        });
        this.component.addTreeSelectionListener(arg_0 -> FilteringBranchesTree.setupTreeListeners$lambda$1(this, arg_0));
    }

    @NotNull
    public final List<GitRepository> getSelectedRepositories(@NotNull BranchInfo branchInfo) {
        Intrinsics.checkNotNullParameter((Object)branchInfo, (String)"branchInfo");
        Set<GitRepository> selectedRepositories = this.component.getSelectedRepositories(branchInfo);
        return !((Collection)selectedRepositories).isEmpty() ? CollectionsKt.toList((Iterable)selectedRepositories) : branchInfo.getRepositories();
    }

    @NotNull
    public final List<BranchInfo> getSelectedBranches() {
        return this.component.getSelectedBranches();
    }

    @NotNull
    public final List<String> getSelectedBranchFilters() {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull(this.component.getSelectedNodes(), (Function1)getSelectedBranchFilters.1.INSTANCE));
    }

    @NotNull
    public final Set<RemoteInfo> getSelectedRemotes() {
        return this.component.getSelectedRemotes();
    }

    @NotNull
    public final Set<BranchNodeDescriptor> getSelectedBranchNodes() {
        return SequencesKt.toSet((Sequence)SequencesKt.map(this.component.getSelectedNodes(), (Function1)getSelectedBranchNodes.1.INSTANCE));
    }

    private final void restorePreviouslyExpandedPaths() {
        TreeUtil.restoreExpandedPaths((JTree)((JTree)((Object)this.component)), (List)CollectionsKt.toList((Iterable)this.expandedPaths));
    }

    protected void expandTreeOnSearchUpdateComplete(@Nullable String pattern) {
        this.restorePreviouslyExpandedPaths();
    }

    protected void onSpeedSearchUpdateComplete(@Nullable String pattern) {
        this.updateSpeedSearchBackground();
    }

    protected boolean useIdentityHashing() {
        return false;
    }

    private final void updateSpeedSearchBackground() {
        SpeedSearchSupply speedSearchSupply = this.getSearchModel().getSpeedSearch();
        SpeedSearch speedSearch = speedSearchSupply instanceof SpeedSearch ? (SpeedSearch)speedSearchSupply : null;
        if (speedSearch == null) {
            return;
        }
        SpeedSearch speedSearch2 = speedSearch;
        SearchTextField searchTextField = this.component.getSearchField();
        Object object = searchTextField != null ? searchTextField.getTextEditor() : null;
        if (object == null) {
            return;
        }
        JBTextField textEditor = object;
        if (this.isEmptyModel()) {
            textEditor.setOpaque(true);
            speedSearch2.noHits();
        } else {
            textEditor.setOpaque(false);
            textEditor.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    private final boolean isEmptyModel() {
        return this.getSearchModel().isLeaf((Object)this.localBranchesNode) && this.getSearchModel().isLeaf((Object)this.remoteBranchesNode);
    }

    @NotNull
    protected Class<BranchTreeNode> getNodeClass() {
        return BranchTreeNode.class;
    }

    @NotNull
    protected BranchTreeNode createNode(@NotNull BranchNodeDescriptor nodeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)nodeDescriptor, (String)"nodeDescriptor");
        return switch (WhenMappings.$EnumSwitchMapping$0[nodeDescriptor.getType().ordinal()]) {
            case 1 -> this.localBranchesNode;
            case 2 -> this.remoteBranchesNode;
            case 3 -> this.headBranchesNode;
            default -> new BranchTreeNode(nodeDescriptor);
        };
    }

    @NotNull
    protected Collection<BranchNodeDescriptor> getChildren(@NotNull BranchNodeDescriptor nodeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)nodeDescriptor, (String)"nodeDescriptor");
        return switch (WhenMappings.$EnumSwitchMapping$0[nodeDescriptor.getType().ordinal()]) {
            case 4 -> this.getRootNodeDescriptors();
            case 1 -> this.getDirectChildren(this.localBranchesNode.getNodeDescriptor());
            case 2 -> this.getDirectChildren(this.remoteBranchesNode.getNodeDescriptor());
            case 5 -> this.getDirectChildren(nodeDescriptor);
            case 6 -> this.getDirectChildren(nodeDescriptor);
            default -> CollectionsKt.emptyList();
        };
    }

    private final Set<BranchNodeDescriptor> getDirectChildren(BranchNodeDescriptor $this$getDirectChildren) {
        return this.nodeDescriptorsModel.getChildrenForParent($this$getDirectChildren);
    }

    public final void update(boolean initial) {
        boolean branchesReloaded = this.uiController.reloadBranches();
        this.runPreservingTreeState(initial, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FilteringBranchesTree this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getSearchModel().updateStructure();
            }
        }));
        if (branchesReloaded) {
            this.getTree().revalidate();
            this.getTree().repaint();
        }
    }

    private final void runPreservingTreeState(boolean loadSaved, Function0<Unit> runnable) {
        if (Registry.is((String)"git.branches.panel.persist.tree.state")) {
            TreeState treeState = loadSaved ? this.getTreeStateHolder().getInitialTreeState() : TreeState.createOn((JTree)((JTree)this.getTree()), (DefaultMutableTreeNode)this.getRoot());
            runnable.invoke();
            if (treeState != null) {
                treeState.applyTo((JTree)this.getTree());
            } else {
                this.initDefaultTreeExpandState();
            }
        } else {
            runnable.invoke();
            if (loadSaved) {
                this.initDefaultTreeExpandState();
            }
        }
    }

    private final void initDefaultTreeExpandState() {
        if (TreeUtil.hasManyNodes((Tree)this.getTree(), (int)30000)) {
            TreeUtil.collapseAll((JTree)((JTree)this.getTree()), (int)1);
        } else {
            TreeUtil.expandAll((JTree)((JTree)this.getTree()));
        }
    }

    public final void refreshTree() {
        this.runPreservingTreeState(false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FilteringBranchesTree this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getTree().getSelectionModel().clearSelection();
                this.this$0.refreshNodeDescriptorsModel();
                this.this$0.getSearchModel().updateStructure();
            }
        }));
    }

    public final void refreshNodeDescriptorsModel() {
        BranchesDashboardController $this$refreshNodeDescriptorsModel_u24lambda_u242 = this.uiController;
        boolean bl = false;
        this.nodeDescriptorsModel.clear();
        this.localNodeExist = !((Collection)$this$refreshNodeDescriptorsModel_u24lambda_u242.getLocalBranches()).isEmpty();
        this.remoteNodeExist = !((Collection)$this$refreshNodeDescriptorsModel_u24lambda_u242.getRemoteBranches()).isEmpty();
        this.nodeDescriptorsModel.populateFrom((Sequence<BranchInfo>)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)$this$refreshNodeDescriptorsModel_u24lambda_u242.getLocalBranches()), (Sequence)CollectionsKt.asSequence((Iterable)$this$refreshNodeDescriptorsModel_u24lambda_u242.getRemoteBranches())), this.branchFilter), this.groupingConfig);
    }

    @Nullable
    protected String getText(@Nullable BranchNodeDescriptor nodeDescriptor) {
        Object object = nodeDescriptor;
        if (object == null || (object = ((BranchNodeDescriptor)object).getBranchInfo()) == null || (object = ((BranchInfo)object).getBranchName()) == null) {
            BranchNodeDescriptor branchNodeDescriptor = nodeDescriptor;
            object = branchNodeDescriptor != null ? branchNodeDescriptor.getDisplayName() : null;
        }
        return object;
    }

    private final List<BranchNodeDescriptor> getRootNodeDescriptors() {
        List list2;
        List $this$getRootNodeDescriptors_u24lambda_u243 = list2 = (List)new ArrayList();
        boolean bl = false;
        if (this.localNodeExist || this.remoteNodeExist) {
            $this$getRootNodeDescriptors_u24lambda_u243.add(this.headBranchesNode.getNodeDescriptor());
        }
        if (this.localNodeExist) {
            $this$getRootNodeDescriptors_u24lambda_u243.add(this.localBranchesNode.getNodeDescriptor());
        }
        if (this.remoteNodeExist) {
            $this$getRootNodeDescriptors_u24lambda_u243.add(this.remoteBranchesNode.getNodeDescriptor());
        }
        return list2;
    }

    private static final void setupTreeListeners$lambda$1(FilteringBranchesTree this$0, TreeSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getTreeStateHolder().setStateProvider(this$0.treeStateProvider);
    }

    public static final /* synthetic */ HashSet access$getExpandedPaths$p(FilteringBranchesTree $this) {
        return $this.expandedPaths;
    }

    public static final /* synthetic */ BranchesTreeStateHolder access$getTreeStateHolder(FilteringBranchesTree $this) {
        return $this.getTreeStateHolder();
    }

    public static final /* synthetic */ BranchesTreeStateProvider access$getTreeStateProvider$p(FilteringBranchesTree $this) {
        return $this.treeStateProvider;
    }

    public static final /* synthetic */ BranchesDashboardController access$getUiController$p(FilteringBranchesTree $this) {
        return $this.uiController;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NodeType.values().length];
            try {
                nArray[NodeType.LOCAL_ROOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.REMOTE_ROOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.HEAD_NODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.ROOT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.GROUP_NODE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.GROUP_REPOSITORY_NODE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

