/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentReloadingKt;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.settingsSync.SettingsProvider;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotKt;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncFilteringKt;
import com.intellij.settingsSync.SettingsSyncIdeMediator;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.plugins.SettingsSyncPluginManager;
import com.intellij.settingsSync.plugins.SettingsSyncPluginsState;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0001IB#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0006H\u0002J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u001fH\u0016J\"\u0010+\u001a\u0014 ,*\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00140\u0015\u00a2\u0006\u0002\b\u00142\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0018\u0010-\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0016J\u0088\u0001\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2!\u00100\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(3\u0012\u0004\u0012\u00020\t012K\u00104\u001aG\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(3\u0012\u0013\u0012\u001106\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(7\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b2\u0012\b\b3\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020\t05H\u0016J.\u00109\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0014\u0010:\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000106\u0012\u0004\u0012\u00020\u001c01H\u0016J)\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\u0006\u0010#\u001a\u00020\u00132\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0\bH\u0002\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020\u001cH\u0016J \u0010@\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010A\u001a\u00020B2\u0006\u0010$\u001a\u00020%H\u0016J\u0016\u0010C\u001a\u00020\u001c2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J)\u0010G\u001a\u0002H<\"\u0004\b\u0000\u0010<2\u0006\u0010#\u001a\u00020\u00132\f\u0010H\u001a\b\u0012\u0004\u0012\u0002H<0\bH\u0002\u00a2\u0006\u0002\u0010>R\u0014\u0010\u000b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0011\u001a\u001d\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u0014\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00140\u0012\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00178\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/settingsSync/SettingsSyncIdeMediatorImpl;", "Lcom/intellij/configurationStore/StreamProvider;", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "componentStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "rootConfig", "Ljava/nio/file/Path;", "enabledCondition", "Lkotlin/Function0;", "", "(Lcom/intellij/configurationStore/ComponentStoreImpl;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "appConfig", "getAppConfig", "()Ljava/nio/file/Path;", "enabled", "getEnabled", "()Z", "fileSpecsToLocks", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Ljava/util/concurrent/locks/ReadWriteLock;", "files2applyLast", "", "getFiles2applyLast$intellij_settingsSync", "()Ljava/util/List;", "isExclusive", "activateStreamProvider", "", "applyToIde", "snapshot", "Lcom/intellij/settingsSync/SettingsSnapshot;", "settings", "Lcom/intellij/settingsSync/SettingsSyncState;", "delete", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "deleteOrLogError", "file", "getInitialSnapshot", "appConfigPath", "lastSavedSnapshot", "getOrCreateLock", "kotlin.jvm.PlatformType", "isApplicable", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "input", "readOnly", "read", "consumer", "readUnderLock", "R", "readingProcedure", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "removeStreamProvider", "write", "content", "", "writeStatesToAppConfig", "fileStates", "", "Lcom/intellij/settingsSync/FileState;", "writeUnderLock", "writingProcedure", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncIdeMediatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncIdeMediatorImpl.kt\ncom/intellij/settingsSync/SettingsSyncIdeMediatorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,284:1\n1#2:285\n766#3:286\n857#3,2:287\n1549#3:296\n1620#3,3:297\n467#4,7:289\n10#5:300\n*S KotlinDebug\n*F\n+ 1 SettingsSyncIdeMediatorImpl.kt\ncom/intellij/settingsSync/SettingsSyncIdeMediatorImpl\n*L\n69#1:286\n69#1:287,2\n100#1:296\n100#1:297,3\n96#1:289,7\n266#1:300\n*E\n"})
public final class SettingsSyncIdeMediatorImpl
implements StreamProvider,
SettingsSyncIdeMediator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComponentStoreImpl componentStore;
    @NotNull
    private final Path rootConfig;
    @NotNull
    private final Function0<Boolean> enabledCondition;
    @NotNull
    private final ConcurrentMap<String, ReadWriteLock> fileSpecsToLocks;
    @VisibleForTesting
    @NotNull
    private final List<String> files2applyLast;
    @NotNull
    private static final Logger LOG;

    public SettingsSyncIdeMediatorImpl(@NotNull ComponentStoreImpl componentStore, @NotNull Path rootConfig, @NotNull Function0<Boolean> enabledCondition) {
        Intrinsics.checkNotNullParameter((Object)componentStore, (String)"componentStore");
        Intrinsics.checkNotNullParameter((Object)rootConfig, (String)"rootConfig");
        Intrinsics.checkNotNullParameter(enabledCondition, (String)"enabledCondition");
        this.componentStore = componentStore;
        this.rootConfig = rootConfig;
        this.enabledCondition = enabledCondition;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap<String, ReadWriteLock>()");
        this.fileSpecsToLocks = concurrentMap;
        Object[] objectArray = new String[]{"colors.scheme.xml"};
        this.files2applyLast = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private final Path getAppConfig() {
        Path path = this.rootConfig.resolve("options");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootConfig.resolve(OPTIONS_DIRECTORY)");
        return path;
    }

    @NotNull
    public final List<String> getFiles2applyLast$intellij_settingsSync() {
        return this.files2applyLast;
    }

    public boolean isExclusive() {
        return true;
    }

    public boolean getEnabled() {
        return (Boolean)this.enabledCondition.invoke();
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        return roamingType != RoamingType.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyToIde(@NotNull SettingsSnapshot snapshot, @Nullable SettingsSyncState settings) {
        void $this$filterTo$iv$iv;
        Object v0;
        Object object;
        block8: {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            Iterable iterable = snapshot.getFileStates();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                FileState it = (FileState)object;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)"options/settingsSync.xml")) continue;
                v0 = object;
                break block8;
            }
            v0 = null;
        }
        FileState settingsSyncFileState = v0;
        if (settings != null) {
            LOG.info("applying sync settings from SettingsSyncState");
            SettingsSyncSettings.Companion.getInstance().applyFromState(settings);
        } else if (settingsSyncFileState != null) {
            this.writeStatesToAppConfig(CollectionsKt.listOf((Object)settingsSyncFileState));
        }
        if (snapshot.getPlugins() != null) {
            SettingsSyncPluginManager.Companion.getInstance().pushChangesToIde(snapshot.getPlugins());
        }
        Iterable $this$filter$iv = snapshot.getFileStates();
        boolean bl = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileState it = (FileState)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)settingsSyncFileState))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List regularFileStates = (List)destination$iv$iv;
        this.writeStatesToAppConfig(regularFileStates);
        for (Map.Entry entry : snapshot.getSettingsFromProviders().entrySet()) {
            Object state;
            String id = (String)entry.getKey();
            SettingsProvider provider = Companion.findProviderById$intellij_settingsSync(id, state = entry.getValue());
            if (provider != null) {
                LOG.debug("Applying settings for provider '" + id + "'");
                provider.applyNewSettings(state);
                continue;
            }
            LOG.warn("Couldn't find provider for id '" + id + "' and state '" + state.getClass() + "'");
        }
    }

    @Override
    public void activateStreamProvider() {
        this.componentStore.getStorageManager().addStreamProvider((StreamProvider)this, true);
    }

    @Override
    public void removeStreamProvider() {
        this.componentStore.getStorageManager().removeStreamProvider(this.getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SettingsSnapshot getInitialSnapshot(@NotNull Path appConfigPath, @NotNull SettingsSnapshot lastSavedSnapshot) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry entry$iv2;
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
        Intrinsics.checkNotNullParameter((Object)lastSavedSnapshot, (String)"lastSavedSnapshot");
        Map map = ExportSettingsActionKt.getExportableComponentsMap$default((boolean)false, (StateStorageManager)this.componentStore.getStorageManager(), (boolean)false, (boolean)false, (int)4, null);
        boolean $i$f$filterKeys = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv2 : $this$filterKeys$iv.entrySet()) {
            FileSpec it = (FileSpec)entry$iv2.getKey();
            boolean bl = false;
            if (!SettingsSyncFilteringKt.isSyncEnabled(it.getRawFileSpec(), RoamingType.DEFAULT)) continue;
            ((HashMap)result$iv).put(entry$iv2.getKey(), entry$iv2.getValue());
        }
        Map exportableItems = (Map)result$iv;
        Set filesToExport = ExportSettingsActionKt.getExportableItemsFromLocalStorage((Map)exportableItems, (StateStorageManager)this.componentStore.getStorageManager()).keySet();
        Set<FileState> fileStates2 = FileStateKt.collectFileStatesFromFiles(filesToExport, appConfigPath);
        result$iv = fileStates2;
        Logger logger = LOG;
        boolean $i$f$map = false;
        entry$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileState fileState = (FileState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        logger.debug("Collected files for the following fileSpecs: " + (List)destination$iv$iv);
        SettingsSyncPluginsState pluginsState = SettingsSyncPluginManager.Companion.getInstance().updateStateFromIdeOnStart$intellij_settingsSync(lastSavedSnapshot.getPlugins());
        LOG.debug("Collected following plugin state: " + pluginsState);
        Map settingsFromProviders = new LinkedHashMap();
        SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().forEachExtensionSafe(arg_0 -> SettingsSyncIdeMediatorImpl.getInitialSnapshot$lambda$4(settingsFromProviders, arg_0));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), fileStates2, pluginsState, settingsFromProviders, SetsKt.emptySet());
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        String file = StoreUtilKt.getFileRelativeToRootConfig((String)fileSpec);
        this.writeUnderLock(file, (Function0)new Function0<Path>(this, file, content){
            final /* synthetic */ SettingsSyncIdeMediatorImpl this$0;
            final /* synthetic */ String $file;
            final /* synthetic */ byte[] $content;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$content = $content;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                Path path = SettingsSyncIdeMediatorImpl.access$getRootConfig$p(this.this$0).resolve(this.$file);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootConfig.resolve(file)");
                return PathKt.write$default((Path)path, (byte[])this.$content, (int)0, (int)0, (int)6, null);
            }
        });
        boolean syncEnabled = SettingsSyncFilteringKt.isSyncEnabled(fileSpec, roamingType);
        LOG.debug("Sync is " + (syncEnabled ? "enabled" : "disabled") + " for " + fileSpec + " (" + file + ")");
        if (!syncEnabled) {
            return;
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        SettingsSnapshot snapshot = new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), SetsKt.setOf((Object)new FileState.Modified(file, content)), null, MapsKt.emptyMap(), SetsKt.emptySet());
        SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.IdeChange(snapshot));
    }

    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        Path path = this.getAppConfig().resolve(fileSpec);
        String adjustedSpec = StoreUtilKt.getFileRelativeToRootConfig((String)fileSpec);
        return (Boolean)this.readUnderLock(adjustedSpec, (Function0)new Function0<Boolean>(consumer, path, fileSpec){
            final /* synthetic */ Function1<InputStream, Unit> $consumer;
            final /* synthetic */ Path $path;
            final /* synthetic */ String $fileSpec;
            {
                this.$consumer = $consumer;
                this.$path = $path;
                this.$fileSpec = $fileSpec;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                try {
                    Path path = this.$path;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                    this.$consumer.invoke((Object)PathKt.inputStreamIfExists((Path)path));
                    bl = true;
                }
                catch (Throwable e) {
                    Attachment[] attachmentArray;
                    try {
                        Path path = this.$path;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                        attachmentArray = new Attachment(this.$fileSpec, PathKt.readText((Path)path));
                    }
                    catch (Throwable errorReadingFile) {
                        attachmentArray = new Attachment("file-read-error", errorReadingFile);
                    }
                    Attachment[] attachment = attachmentArray;
                    attachmentArray = new Attachment[]{attachment};
                    SettingsSyncIdeMediatorImpl.Companion.getLOG().error("Couldn't read " + this.$fileSpec, e, attachmentArray);
                    bl = false;
                }
                return bl;
            }
        });
    }

    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Path folder = this.rootConfig.resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)folder, (String)"folder");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(folder, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return true;
        }
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filter, this, processor){
            final /* synthetic */ Function1<String, Boolean> $filter;
            final /* synthetic */ SettingsSyncIdeMediatorImpl this$0;
            final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
            {
                this.$filter = $filter;
                this.this$0 = $receiver;
                this.$processor = $processor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @Nullable BasicFileAttributes attrs) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!((Boolean)this.$filter.invoke((Object)PathsKt.getName((Path)file))).booleanValue()) {
                    return FileVisitResult.CONTINUE;
                }
                if (!PathKt.isFile((Path)file)) {
                    return FileVisitResult.CONTINUE;
                }
                Closeable closeable = PathKt.inputStream((Path)file);
                SettingsSyncIdeMediatorImpl settingsSyncIdeMediatorImpl = this.this$0;
                Function3<String, InputStream, Boolean, Boolean> function3 = this.$processor;
                Throwable throwable = null;
                try {
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl2 = false;
                    Path path = SettingsSyncIdeMediatorImpl.access$getRootConfig$p(settingsSyncIdeMediatorImpl).relativize(file);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootConfig.relativize(file)");
                    String fileSpec = PathKt.getSystemIndependentPath((Path)path);
                    bl = StreamProvider.read$default((StreamProvider)settingsSyncIdeMediatorImpl, (String)fileSpec, null, (Function1)((Function1)new Function1<InputStream, Unit>(function3, file, inputStream){
                        final /* synthetic */ Function3<String, InputStream, Boolean, Boolean> $processor;
                        final /* synthetic */ Path $file;
                        final /* synthetic */ InputStream $inputStream;
                        {
                            this.$processor = $processor;
                            this.$file = $file;
                            this.$inputStream = $inputStream;
                            super(1);
                        }

                        public final void invoke(@Nullable InputStream it) {
                            this.$processor.invoke((Object)((Object)this.$file.getFileName()).toString(), (Object)this.$inputStream, (Object)false);
                        }
                    }), (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                boolean shouldProceed2 = bl;
                return shouldProceed2 ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
            }
        });
        return true;
    }

    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        String adjustedSpec = StoreUtilKt.getFileRelativeToRootConfig((String)fileSpec);
        Path file = this.rootConfig.resolve(adjustedSpec);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LOG.debug("File " + file + " doesn't exist, no need to delete");
            return true;
        }
        boolean deleted2 = (Boolean)this.writeUnderLock(adjustedSpec, (Function0)new Function0<Boolean>(this, file){
            final /* synthetic */ SettingsSyncIdeMediatorImpl this$0;
            final /* synthetic */ Path $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Path path = this.$file;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                return SettingsSyncIdeMediatorImpl.access$deleteOrLogError(this.this$0, path);
            }
        });
        if (deleted2) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            SettingsSnapshot snapshot = new SettingsSnapshot(new SettingsSnapshot.MetaInfo(instant, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), SetsKt.setOf((Object)new FileState.Deleted(adjustedSpec)), null, MapsKt.emptyMap(), SetsKt.emptySet());
            SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.IdeChange(snapshot));
        }
        return deleted2;
    }

    private final boolean deleteOrLogError(Path file) {
        try {
            PathKt.delete$default((Path)file, (boolean)false, (int)1, null);
            return true;
        }
        catch (Exception e) {
            LOG.error("Couldn't delete " + ((Object)file).toString(), (Throwable)e);
            return false;
        }
    }

    private final void writeStatesToAppConfig(Collection<? extends FileState> fileStates2) {
        ArrayList<String> changedFileSpecs = new ArrayList<String>();
        ArrayList<String> deletedFileSpecs = new ArrayList<String>();
        for (FileState fileState : fileStates2) {
            String fileSpec = StringsKt.removePrefix((String)fileState.getFile(), (CharSequence)"options/");
            if (!SettingsSyncFilteringKt.isSyncEnabled(fileSpec, RoamingType.DEFAULT)) continue;
            Path file = this.rootConfig.resolve(fileState.getFile());
            FileState fileState2 = fileState;
            if (fileState2 instanceof FileState.Modified) {
                this.writeUnderLock(fileSpec, (Function0)new Function0<Path>(file, fileState){
                    final /* synthetic */ Path $file;
                    final /* synthetic */ FileState $fileState;
                    {
                        this.$file = $file;
                        this.$fileState = $fileState;
                        super(0);
                    }

                    @NotNull
                    public final Path invoke() {
                        Path path = this.$file;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                        return PathKt.write$default((Path)path, (byte[])((FileState.Modified)this.$fileState).getContent(), (int)0, (int)0, (int)6, null);
                    }
                });
                changedFileSpecs.add(fileSpec);
                continue;
            }
            if (!(fileState2 instanceof FileState.Deleted)) continue;
            this.writeUnderLock(fileSpec, (Function0)new Function0<Unit>(file){
                final /* synthetic */ Path $file;
                {
                    this.$file = $file;
                    super(0);
                }

                public final void invoke() {
                    Path path = this.$file;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                    PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
                }
            });
            deletedFileSpecs.add(fileSpec);
        }
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(changedFileSpecs, this, deletedFileSpecs){
            final /* synthetic */ ArrayList<String> $changedFileSpecs;
            final /* synthetic */ SettingsSyncIdeMediatorImpl this$0;
            final /* synthetic */ ArrayList<String> $deletedFileSpecs;
            {
                this.$changedFileSpecs = $changedFileSpecs;
                this.this$0 = $receiver;
                this.$deletedFileSpecs = $deletedFileSpecs;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$partition$iv;
                Iterable iterable = this.$changedFileSpecs;
                SettingsSyncIdeMediatorImpl settingsSyncIdeMediatorImpl = this.this$0;
                boolean $i$f$partition = false;
                ArrayList<T> first$iv = new ArrayList<T>();
                ArrayList<T> second$iv = new ArrayList<T>();
                for (T element$iv : $this$partition$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!settingsSyncIdeMediatorImpl.getFiles2applyLast$intellij_settingsSync().contains(it)) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair = new Pair(first$iv, second$iv);
                List normalChanged = (List)pair.component1();
                List lastChanged = (List)pair.component2();
                ComponentReloadingKt.reloadComponents((ComponentStoreImpl)SettingsSyncIdeMediatorImpl.access$getComponentStore$p(this.this$0), (Collection)normalChanged, (Collection)this.$deletedFileSpecs);
                if (!((Collection)lastChanged).isEmpty()) {
                    ComponentReloadingKt.reloadComponents((ComponentStoreImpl)SettingsSyncIdeMediatorImpl.access$getComponentStore$p(this.this$0), (Collection)lastChanged, (Collection)CollectionsKt.emptyList());
                }
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R writeUnderLock(String fileSpec, Function0<? extends R> writingProcedure) {
        Object object;
        Lock lock = this.getOrCreateLock(fileSpec).writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"getOrCreateLock(fileSpec).writeLock()");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            object = writingProcedure.invoke();
        }
        finally {
            lock2.unlock();
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R readUnderLock(String fileSpec, Function0<? extends R> readingProcedure) {
        Object object;
        Lock lock = this.getOrCreateLock(fileSpec).readLock();
        Intrinsics.checkNotNullExpressionValue((Object)lock, (String)"getOrCreateLock(fileSpec).readLock()");
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            object = readingProcedure.invoke();
        }
        finally {
            lock2.unlock();
        }
        return (R)object;
    }

    private final ReadWriteLock getOrCreateLock(String fileSpec) {
        return this.fileSpecsToLocks.computeIfAbsent(fileSpec, arg_0 -> SettingsSyncIdeMediatorImpl.getOrCreateLock$lambda$7(getOrCreateLock.1.INSTANCE, arg_0));
    }

    private static final void getInitialSnapshot$lambda$4(Map $settingsFromProviders, SettingsProvider it) {
        Intrinsics.checkNotNullParameter((Object)$settingsFromProviders, (String)"$settingsFromProviders");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object currentSettings = it.collectCurrentSettings();
        if (currentSettings != null) {
            $settingsFromProviders.put(it.getId(), currentSettings);
        }
    }

    private static final ReadWriteLock getOrCreateLock$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ReadWriteLock)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$getRootConfig$p(SettingsSyncIdeMediatorImpl $this) {
        return $this.rootConfig;
    }

    public static final /* synthetic */ boolean access$deleteOrLogError(SettingsSyncIdeMediatorImpl $this, Path file) {
        return $this.deleteOrLogError(file);
    }

    public static final /* synthetic */ ComponentStoreImpl access$getComponentStore$p(SettingsSyncIdeMediatorImpl $this) {
        return $this.componentStore;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncIdeMediatorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\b\"\b\b\u0000\u0010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u0002H\tH\u0000\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/SettingsSyncIdeMediatorImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "findProviderById", "Lcom/intellij/settingsSync/SettingsProvider;", "T", "id", "", "state", "findProviderById$intellij_settingsSync", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/intellij/settingsSync/SettingsProvider;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @Nullable
        public final <T> SettingsProvider<T> findProviderById$intellij_settingsSync(@NotNull String id, @NotNull T state) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(state, (String)"state");
            SettingsProvider provider = (SettingsProvider)SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().findFirstSafe(arg_0 -> Companion.findProviderById$lambda$0(id, arg_0));
            if (provider != null) {
                try {
                    return provider;
                }
                catch (Exception e) {
                    this.getLOG().error("Could not cast the provider '" + provider.getId() + "' to expected class " + state.getClass(), (Throwable)e);
                }
            } else {
                this.getLOG().warn("Couldn't find provider for state class '" + state.getClass() + "'");
            }
            return null;
        }

        private static final boolean findProviderById$lambda$0(String $id, SettingsProvider it) {
            Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getId(), (Object)$id);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

