/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.wiztools.commons.StringUtil;

public final class RCUIConstants {
    private static final Logger LOG = Logger.getLogger(RCUIConstants.class.getName());
    public static final String SYS_PROPERTY_FONT_SIZE = "rc:ui-font-size";
    public static final int DEFAULT_UI_FONT_SIZE = 12;

    private RCUIConstants() {
    }

    public static int getUIFontSize() {
        String t = System.getProperty(SYS_PROPERTY_FONT_SIZE);
        if (StringUtil.isNotEmpty(t)) {
            try {
                int fontSize = Integer.parseInt(t);
                if (fontSize < 12) {
                    throw new NumberFormatException("Font size value cannot be less than 12.");
                }
                return fontSize;
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.WARNING, "Illegal font size specified: {0}", t);
            }
        }
        return -1;
    }

    public static int getUIFontSizeDefault() {
        int size = RCUIConstants.getUIFontSize();
        return size == -1 ? 12 : size;
    }
}

