/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.RubyDockerUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyRemoteDebugRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfigurationParams;

public class RubyDockerDebugRunner
extends RubyRemoteDebugRunner {
    private static final Logger LOG = Logger.getInstance(RubyDockerDebugRunner.class);
    protected static final Key<ProcessHandler> DOCKER_PROCESS_HANDLER_KEY = Key.create((String)"DOCKER_PROCESS_HANDLER");
    public static final int DEBUGGER_START_TIME = 1000;
    public static final Pair<Integer, Integer> DEFAULT_DISPATCHER_PORT = Pair.create((Object)26166, (Object)26168);
    public static final int DEFAULT_DEBUG_PORT = 1234;

    @NotNull
    public String getRunnerId() {
        if ("RubyDockerDebugRunner" == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(0);
        }
        return "RubyDockerDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(2);
        }
        if (DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof AbstractRubyRunConfiguration) {
            Sdk sdk = ((AbstractRubyRunConfiguration)profile).getSdk();
            return RubyDockerUtil.isRubyDockerSDK(sdk) || RubyDockerComposeUtil.isRubyDockerComposeSDK(sdk);
        }
        return false;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(4);
        }
        try {
            return super.doExecute(state, env);
        }
        catch (Throwable e) {
            ProcessHandler processHandler = (ProcessHandler)env.getUserData(DOCKER_PROCESS_HANDLER_KEY);
            RubyDockerDebugRunner.destroyDockerProcess(processHandler);
            throw e;
        }
    }

    private static void destroyDockerProcess(ProcessHandler processHandler) {
        if (processHandler != null) {
            try {
                processHandler.destroyProcess();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected ProcessHandler runBeforeTask(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ExecutionResult executionResult;
        ProcessHandler processHandler;
        if (state == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(5);
        }
        if (env == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(6);
        }
        ProcessHandler processHandler2 = processHandler = (executionResult = state.execute(env.getExecutor(), (ProgramRunner)this)) != null ? executionResult.getProcessHandler() : null;
        if (processHandler == null) {
            throw new ExecutionException(RubyDockerBundle.message("ruby.docker.no.execution.result", new Object[0]));
        }
        env.putUserData(DOCKER_PROCESS_HANDLER_KEY, (Object)processHandler);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyDockerDebugRunner.destroyDockerProcess(processHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/docker/remote/ruby/RubyDockerDebugRunner$1", "processTerminated"));
            }
        });
        return processHandler;
    }

    @NotNull
    protected RubyRemoteDebugConfigurationParams getRemoteDebugConfigurationParams(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(7);
        }
        AbstractRubyRunConfiguration runConfiguration = (AbstractRubyRunConfiguration)env.getRunProfile();
        RubyRemoteDebugConfiguration result = new RubyRemoteDebugConfiguration(env.getProject(), runConfiguration.getFactory());
        result.setRemoteHost("localhost");
        result.setPort(1234);
        result.setDispatcherPort(((Integer)RubyDockerDebugRunner.DEFAULT_DISPATCHER_PORT.second).intValue());
        DockerContainerSettings containerSettings = DockerContainerSettings.defaultSettings((Project)env.getProject());
        DockerVolumeBindingImpl binding = (DockerVolumeBindingImpl)containerSettings.getVolumeBindings().get(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("docker: using mapping '%s' -> '%s'", binding.getHostPath(), binding.getContainerPath()));
        }
        result.setLocalRoot(binding.getHostPath());
        result.setRemoteRoot(binding.getContainerPath());
        RubyRemoteDebugConfiguration rubyRemoteDebugConfiguration = result;
        if (rubyRemoteDebugConfiguration == null) {
            RubyDockerDebugRunner.$$$reportNull$$$0(8);
        }
        return rubyRemoteDebugConfiguration;
    }

    protected void beforeDebuggerConnects() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/RubyDockerDebugRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerDebugRunner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteDebugConfigurationParams";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runBeforeTask";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteDebugConfigurationParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

