/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;

public class FirstInBranch {
    private static final Logger LOG = Logger.getInstance(FirstInBranch.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Url myAbsoluteBranchUrl;
    @NotNull
    private final Url myAbsoluteTrunkUrl;
    @NotNull
    private final Url myRepositoryRoot;

    public FirstInBranch(@NotNull SvnVcs vcs, @NotNull Url repositoryRoot, @NotNull Url branchUrl, @NotNull Url trunkUrl) {
        if (vcs == null) {
            FirstInBranch.$$$reportNull$$$0(0);
        }
        if (repositoryRoot == null) {
            FirstInBranch.$$$reportNull$$$0(1);
        }
        if (branchUrl == null) {
            FirstInBranch.$$$reportNull$$$0(2);
        }
        if (trunkUrl == null) {
            FirstInBranch.$$$reportNull$$$0(3);
        }
        this.myVcs = vcs;
        this.myRepositoryRoot = repositoryRoot;
        this.myAbsoluteBranchUrl = branchUrl;
        this.myAbsoluteTrunkUrl = trunkUrl;
    }

    @Nullable
    public CopyData run() throws VcsException {
        Target trunk = Target.on(this.myAbsoluteTrunkUrl, Revision.HEAD);
        Target branch = Target.on(this.myAbsoluteBranchUrl, Revision.HEAD);
        CopyData result = this.find(new BranchPoint(trunk), new BranchPoint(branch), true);
        this.debug(result);
        return result;
    }

    @Nullable
    private CopyData find(@NotNull BranchPoint trunk, @NotNull BranchPoint branch, boolean isBranchFromTrunk) throws VcsException {
        if (trunk == null) {
            FirstInBranch.$$$reportNull$$$0(4);
        }
        if (branch == null) {
            FirstInBranch.$$$reportNull$$$0(5);
        }
        CopyData result = null;
        this.debug(trunk, branch, isBranchFromTrunk);
        if (trunk.hasCopyPath()) {
            result = StringUtil.equals((CharSequence)trunk.copyPath(), (CharSequence)branch.relativePath()) ? trunk.toCopyData(!isBranchFromTrunk) : (branch.hasCopyPath() ? (branch.copyRevision() == trunk.copyRevision() ? (branch.revision() > trunk.revision() ? branch.toCopyData(isBranchFromTrunk) : trunk.toCopyData(!isBranchFromTrunk)) : (branch.copyRevision() > trunk.copyRevision() ? this.find(trunk, new BranchPoint(branch.copyTarget()), isBranchFromTrunk) : this.find(new BranchPoint(trunk.copyTarget()), branch, isBranchFromTrunk))) : this.find(branch, trunk, !isBranchFromTrunk));
        } else if (branch.hasCopyPath()) {
            result = StringUtil.equals((CharSequence)branch.copyPath(), (CharSequence)trunk.relativePath()) ? branch.toCopyData(isBranchFromTrunk) : this.find(trunk, new BranchPoint(branch.copyTarget()), isBranchFromTrunk);
        }
        return result;
    }

    private void debug(@Nullable CopyData copyData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found branch point " + StringUtil.join((Iterable)ContainerUtil.immutableList((Object[])new Object[]{this.myAbsoluteTrunkUrl.toDecodedString(), this.myAbsoluteBranchUrl.toDecodedString(), copyData}), (String)", "));
        }
    }

    private void debug(@NotNull BranchPoint trunk, @NotNull BranchPoint branch, boolean isBranchFromTrunk) {
        if (trunk == null) {
            FirstInBranch.$$$reportNull$$$0(6);
        }
        if (branch == null) {
            FirstInBranch.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching branch point for " + StringUtil.join((Iterable)ContainerUtil.immutableList((Object[])new Object[]{trunk, branch, isBranchFromTrunk}), (String)", "));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trunkUrl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trunk";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/history/FirstInBranch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "debug";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class BranchPoint {
        @NotNull
        private final Target myTarget;
        @Nullable
        private LogEntry myEntry;
        @Nullable
        private LogEntryPath myPath;

        private BranchPoint(Target target) {
            if (target == null) {
                BranchPoint.$$$reportNull$$$0(0);
            }
            this.myTarget = target;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.myTarget).add("revision", this.myEntry != null ? this.myEntry.getRevision() : -1L).add("path", this.myPath != null && this.myPath.getCopyPath() != null ? CommandUtil.format(this.myPath.getCopyPath(), Revision.of(this.myPath.getCopyRevision())) : null).toString();
        }

        private void init() throws VcsException {
            if (this.myEntry == null) {
                Pair<LogEntry, LogEntryPath> copyPoint = this.getCopyPoint();
                this.myEntry = (LogEntry)copyPoint.first;
                this.myPath = (LogEntryPath)copyPoint.second;
            }
        }

        @NotNull
        private Pair<LogEntry, LogEntryPath> getCopyPoint() throws VcsException {
            HistoryClient client = FirstInBranch.this.myVcs.getFactory(this.myTarget).createHistoryClient();
            Ref entry = Ref.create();
            client.doLog(this.myTarget, Revision.of(1L), this.myTarget.getPegRevision(), true, true, false, 1L, null, arg_0 -> ((Ref)entry).set(arg_0));
            if (entry.isNull()) {
                throw new VcsException("No branch point found for " + this.myTarget);
            }
            LogEntryPath path = ((LogEntry)entry.get()).getChangedPaths().get(this.relativePath());
            if (path == null) {
                throw new VcsException(this.myTarget + " not found in " + ((LogEntry)entry.get()).getChangedPaths());
            }
            Pair pair = Pair.create((Object)entry.get(), (Object)path);
            if (pair == null) {
                BranchPoint.$$$reportNull$$$0(1);
            }
            return pair;
        }

        private boolean hasCopyPath() throws VcsException {
            this.init();
            return ((LogEntryPath)ObjectUtils.notNull((Object)this.myPath)).getCopyPath() != null;
        }

        @NotNull
        private String copyPath() throws VcsException {
            this.init();
            String string = ((LogEntryPath)ObjectUtils.notNull((Object)this.myPath)).getCopyPath();
            if (string == null) {
                BranchPoint.$$$reportNull$$$0(2);
            }
            return string;
        }

        private long copyRevision() throws VcsException {
            this.init();
            return ((LogEntryPath)ObjectUtils.notNull((Object)this.myPath)).getCopyRevision();
        }

        @NotNull
        private Target copyTarget() throws VcsException {
            Target target = Target.on(SvnUtil.append(FirstInBranch.this.myRepositoryRoot, this.copyPath()), Revision.of(this.copyRevision()));
            if (target == null) {
                BranchPoint.$$$reportNull$$$0(3);
            }
            return target;
        }

        @NotNull
        private String relativePath() {
            String string = SvnUtil.ensureStartSlash(SvnUtil.getRelativeUrl(FirstInBranch.this.myRepositoryRoot, this.myTarget.getUrl()));
            if (string == null) {
                BranchPoint.$$$reportNull$$$0(4);
            }
            return string;
        }

        private long revision() throws VcsException {
            this.init();
            return ((LogEntry)ObjectUtils.notNull((Object)this.myEntry)).getRevision();
        }

        @NotNull
        private CopyData toCopyData(boolean isBranchFromTrunk) throws VcsException {
            CopyData copyData = new CopyData(this.copyRevision(), this.revision(), isBranchFromTrunk);
            if (copyData == null) {
                BranchPoint.$$$reportNull$$$0(5);
            }
            return copyData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/history/FirstInBranch$BranchPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/history/FirstInBranch$BranchPoint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCopyPoint";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "relativePath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toCopyData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

