/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.ClickHouse;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CHouseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.CHouseIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;

public class CHouseIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final CHouseIntermediateProvider INSTANCE = new CHouseIntermediateProvider();
    static final Pattern CHOUSE_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:clickhouse:.+$");
    static final String CHOUSE_CONNECTION_STRING_EXAMPLE = "jdbc:clickhouse://localhost:8123";
    private static final String CHOUSE_DRIVER_CLASS_NAME = "ru.yandex.clickhouse.ClickHouseDriver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return CHOUSE_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver(String connectionString) {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(CHOUSE_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("ClickHouse SQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return ClickHouse.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return CHOUSE_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected CHouseIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new CHouseIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, CHouseExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return CHouseExceptionRecognizer.INSTANCE;
    }
}

