/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.sql.ScriptumResource;
import org.jetbrains.dekaf.sql.TextFileFragment;
import org.jetbrains.dekaf.util.Strings;

final class ScriptumResourceFromJava
extends ScriptumResource {
    private static final Pattern SECTION_HEADER_PATTERN = Pattern.compile("^\\s*-{4,}\\s*(([\\p{L}\\p{javaJavaIdentifierPart}$-]+)(\\s*\\+\\s*([\\p{L}\\p{javaJavaIdentifierPart}$-]+))?)\\s*-{4,}\\s*$", 66);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final ClassLoader myClassLoader;
    @NotNull
    private final String myResourcePath;
    @NotNull
    private final String myFileName;

    ScriptumResourceFromJava(@NotNull ClassLoader classLoader, @NotNull String resourcePath) {
        this.myClassLoader = classLoader;
        this.myResourcePath = resourcePath;
        this.myFileName = Strings.lastPart(resourcePath, '/');
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    protected TextFileFragment[] loadFragments() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected InputStream openStream() {
        return this.myClassLoader.getResourceAsStream(this.myResourcePath);
    }

    private TextFileFragment[] loadFragmentsFromReader(@NotNull BufferedReader reader) throws IOException {
        ArrayList<TextFileFragment> fragments = new ArrayList<TextFileFragment>();
        StringBuilder buf = new StringBuilder();
        String currentName = "0";
        int row = 0;
        int fragmentRow = 1;
        while (true) {
            String line = reader.readLine();
            ++row;
            if (line == null) break;
            Matcher m = SECTION_HEADER_PATTERN.matcher(line = Strings.rtrim(line));
            if (m.matches()) {
                this.putTheText(fragments, buf, fragmentRow, currentName);
                fragmentRow = row + 1;
                buf.delete(0, buf.length());
                currentName = this.normalizeName(m);
                continue;
            }
            if (line.length() == 0 && buf.length() == 0) {
                ++fragmentRow;
                continue;
            }
            buf.append(line).append('\n');
        }
        this.putTheText(fragments, buf, fragmentRow, currentName);
        int n = fragments.size();
        return fragments.toArray(new TextFileFragment[n]);
    }

    @NotNull
    private String normalizeName(Matcher m) {
        return Strings.minimizeSpaces(m.group(1)).replace(" + ", "+");
    }

    private void putTheText(ArrayList<TextFileFragment> fragments, StringBuilder buf, int row, String name) {
        String text = Strings.rtrim(buf.toString());
        TextFileFragment fragment = new TextFileFragment(text, this.myFileName, row, 1, name);
        fragments.add(fragment);
    }
}

