/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.PluginManagerConfigurableNew;
import com.intellij.ide.plugins.newui.CellPluginComponent;
import com.intellij.ide.plugins.newui.ComponentCache;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PluginsListLayout
extends AbstractLayoutManager {
    private final ComponentCache myCache = new ComponentCache();
    int myLineHeight;

    public Dimension preferredLayoutSize(@NotNull Container parent) {
        if (parent == null) {
            PluginsListLayout.$$$reportNull$$$0(0);
        }
        this.calculateLineHeight(parent);
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        int height = 0;
        for (UIPluginGroup group : groups) {
            height += group.panel.getPreferredSize().height;
            height += group.plugins.size() * this.myLineHeight;
        }
        return new Dimension(0, height);
    }

    public void layoutContainer(@NotNull Container parent) {
        if (parent == null) {
            PluginsListLayout.$$$reportNull$$$0(1);
        }
        this.calculateLineHeight(parent);
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        int width = parent.getWidth();
        int y = 0;
        for (UIPluginGroup group : groups) {
            Component component = group.panel;
            int height = component.getPreferredSize().height;
            component.setBounds(0, y, width, height);
            y += height;
            for (CellPluginComponent plugin : group.plugins) {
                plugin.setBounds(0, y, width, this.myLineHeight);
                y += this.myLineHeight;
            }
        }
    }

    private void calculateLineHeight(@NotNull Container parent) {
        if (parent == null) {
            PluginsListLayout.$$$reportNull$$$0(2);
        }
        if (this.myCache.isCached(parent)) {
            return;
        }
        List<UIPluginGroup> groups = ((PluginsGroupComponent)((Object)parent)).getGroups();
        int width = PluginManagerConfigurableNew.getParentWidth(parent) - parent.getInsets().right;
        this.myLineHeight = 0;
        for (UIPluginGroup group : groups) {
            for (CellPluginComponent plugin : group.plugins) {
                JEditorPane description = plugin.myDescription;
                if (description != null) {
                    plugin.doLayout();
                    int parentWidth = width - SwingUtilities.convertPoint((Component)description.getParent(), (Point)description.getLocation(), (Component)plugin).x;
                    if (parentWidth > 0) {
                        description.putClientProperty("parent.width", new Integer(parentWidth));
                    }
                }
                plugin.doLayout();
                this.myLineHeight = Math.max(this.myLineHeight, plugin.getPreferredSize().height);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "parent";
        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsListLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preferredLayoutSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layoutContainer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLineHeight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

