/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagPattern<Self extends XmlTagPattern<Self>>
extends XmlNamedElementPattern<XmlTag, Self> {
    protected XmlTagPattern() {
        super(new InitialPatternCondition<XmlTag>(XmlTag.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof XmlTag;
            }
        });
    }

    protected XmlTagPattern(@NotNull InitialPatternCondition<XmlTag> condition) {
        if (condition == null) {
            XmlTagPattern.$$$reportNull$$$0(0);
        }
        super(condition);
    }

    @Override
    protected String getLocalName(XmlTag tag) {
        return tag.getLocalName();
    }

    @Override
    protected String getNamespace(XmlTag tag) {
        return tag.getNamespace();
    }

    public Self withAttributeValue(final @NotNull @NonNls String attributeName, final @NotNull String attributeValue) {
        if (attributeName == null) {
            XmlTagPattern.$$$reportNull$$$0(1);
        }
        if (attributeValue == null) {
            XmlTagPattern.$$$reportNull$$$0(2);
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withAttributeValue"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    2.$$$reportNull$$$0(0);
                }
                return Comparing.equal((String)xmlTag.getAttributeValue(attributeName), (String)attributeValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/patterns/XmlTagPattern$2", "accepts"));
            }
        }));
    }

    public Self withAnyAttribute(final String ... attributeNames) {
        if (attributeNames == null) {
            XmlTagPattern.$$$reportNull$$$0(3);
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withAnyAttribute"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (String attributeName : attributeNames) {
                    if (xmlTag.getAttribute(attributeName) == null) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/patterns/XmlTagPattern$3", "accepts"));
            }
        }));
    }

    public Self withDescriptor(final @NotNull ElementPattern<? extends PsiMetaData> metaDataPattern) {
        if (metaDataPattern == null) {
            XmlTagPattern.$$$reportNull$$$0(4);
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withDescriptor"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    4.$$$reportNull$$$0(0);
                }
                return metaDataPattern.accepts(xmlTag.getDescriptor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/patterns/XmlTagPattern$4", "accepts"));
            }
        }));
    }

    public Self isFirstSubtag(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            XmlTagPattern.$$$reportNull$$$0(5);
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("isFirstSubtag"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                XmlTag parent;
                if (xmlTag == null) {
                    5.$$$reportNull$$$0(0);
                }
                return (parent = xmlTag.getParentTag()) != null && pattern.accepts(parent, context) && parent.getSubTags()[0] == xmlTag;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/patterns/XmlTagPattern$5", "accepts"));
            }
        }));
    }

    public Self withFirstSubTag(@NotNull ElementPattern<? extends XmlTag> pattern) {
        if (pattern == null) {
            XmlTagPattern.$$$reportNull$$$0(6);
        }
        return this.withSubTags(StandardPatterns.collection().first(pattern));
    }

    public Self withSubTags(final @NotNull ElementPattern<? extends Collection<XmlTag>> pattern) {
        if (pattern == null) {
            XmlTagPattern.$$$reportNull$$$0(7);
        }
        return (Self)((XmlTagPattern)this.with(new PatternCondition<XmlTag>("withSubTags"){

            @Override
            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    6.$$$reportNull$$$0(0);
                }
                return pattern.accepts(Arrays.asList(xmlTag.getSubTags()), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/patterns/XmlTagPattern$6", "accepts"));
            }
        }));
    }

    public Self withoutAttributeValue(@NotNull @NonNls String attributeName, @NotNull String attributeValue) {
        if (attributeName == null) {
            XmlTagPattern.$$$reportNull$$$0(8);
        }
        if (attributeValue == null) {
            XmlTagPattern.$$$reportNull$$$0(9);
        }
        return (Self)((XmlTagPattern)this.and(StandardPatterns.not(this.withAttributeValue(attributeName, attributeValue))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaDataPattern";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        objectArray2[1] = "com/intellij/patterns/XmlTagPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withAttributeValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withAnyAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstSubtag";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withFirstSubTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "withSubTags";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "withoutAttributeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Capture
    extends XmlTagPattern<Capture> {
        static final Capture XML_TAG_PATTERN = new Capture();
    }
}

