/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileIndentOptionsProvider {
    public static final ExtensionPointName<FileIndentOptionsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.fileIndentOptionsProvider");

    @Nullable
    public abstract CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings var1, @NotNull PsiFile var2);

    public boolean useOnFullReformat() {
        return true;
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(0);
        }
        if (indentOptions == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nullable
    public AnAction[] getActions(@NotNull PsiFile file, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (file == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(2);
        }
        if (indentOptions == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public String getTooltip(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(4);
        }
        String string = FileIndentOptionsProvider.getTooltip(indentOptions, this.getHint(indentOptions));
        if (string == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getHint(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (indentOptions == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(6);
        }
        return null;
    }

    @NotNull
    public static String getTooltip(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable String hint) {
        if (indentOptions == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        if (indentOptions.USE_TAB_CHARACTER) {
            sb.append("Tab");
        } else {
            int indent = indentOptions.INDENT_SIZE;
            sb.append(indentOptions.INDENT_SIZE).append(indent > 1 ? " spaces" : " space");
        }
        if (hint != null) {
            sb.append(" (").append(hint).append(')');
        }
        String string = sb.toString();
        if (string == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getAdvertisementText(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (psiFile == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(9);
        }
        if (indentOptions == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(10);
        }
        return null;
    }

    protected static void notifyIndentOptionsChanged(@NotNull Project project, @Nullable PsiFile file) {
        if (project == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(11);
        }
        CodeStyleSettingsManager.getInstance(project).fireCodeStyleSettingsChanged(file);
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return true;
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        if (project == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    public AnAction createDefaultAction(@NotNull Project project) {
        if (project == null) {
            FileIndentOptionsProvider.$$$reportNull$$$0(13);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/FileIndentOptionsProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/FileIndentOptionsProvider";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areActionsAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTooltip";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdvertisementText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notifyIndentOptionsChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDisableAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

