/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigStreamProvider;
import com.intellij.cloudConfig.CloudConfigStreamProviderKt;
import com.intellij.cloudConfig.ConfigList;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusBarInfoManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageBaseKt;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.idea.cloudConfig.ETagCloudConfigFileClient;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cloudconfig.exception.AccessDeniedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConfigManager
implements ApplicationLoadListener {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.cloudConfig.CloudConfigManager");
    private static final String LOCAL_DISABLED_PLUGINS_FILENAME = "local_disabled_plugins.txt";
    private static final String API = "1";
    private static final String SELF_PLUGIN_ID = "com.intellij.CloudConfig";
    private static CloudConfigManager ourInstance;
    private File myIdeConfigPath;
    private File myConfigDir;
    private File myCachesDir;
    private File myFilesArchive;
    private File myUpdatesArchive;
    private File myApiFile;
    private File myStatusFile;
    private File myAutoUpdatePluginsFile;
    private StatusInfo myStatusInfo;
    private ETagCloudConfigFileClient myClient;
    private String myErrorMessage;
    private boolean myIOError;
    private boolean myIOOperation;
    private boolean myOfflineWithJBA;
    private LocalChanges myLocalChanges;
    private StatusBarInfoManager myStatusBarManager;
    private FrameStateListener myFrameListener;
    private Runnable myDisablePluginsListener;
    private PluginStateListener myStatePluginListener;
    private List<PluginState> myEnabledDisabledPlugins = Collections.emptyList();
    private List<PluginState> myInstalledUninstalledPlugins = Collections.emptyList();
    private boolean myUpdatePlugins;
    private boolean myUpdateApi;
    private boolean myUpdateApiNotification = true;
    private boolean myBeforeApplicationLoadedStart;
    private boolean mySavePluginsWithEditConfigs = true;
    private boolean mySaveSkipRulesFile;
    private boolean myAutoUpdatePlugins;
    private ExecuteManager myExecuteManager;
    private static final Function2<Class, String, String> NAME_CONVERTER;
    private static List<IdeaPluginDescriptor> myRepositoryPlugins;
    private static final int ENABLE_DISABLE = 0;
    private static final int INSTALL_UNINSTALL = 1;
    private static final int SHUTDOWN = 2;
    private static final String[] OS_NAMES;

    @NotNull
    public static CloudConfigManager getInstance() {
        if (ourInstance == null) {
            ourInstance = (CloudConfigManager)ApplicationLoadListener.EP_NAME.findExtension(CloudConfigManager.class);
            LOG.assertTrue(ourInstance != null);
        }
        CloudConfigManager cloudConfigManager = ourInstance;
        if (cloudConfigManager == null) {
            CloudConfigManager.$$$reportNull$$$0(0);
        }
        return cloudConfigManager;
    }

    @NotNull
    public StatusInfo getStatusInfo() {
        if (this.myIOOperation) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_OPERATION;
            if (statusInfo == null) {
                CloudConfigManager.$$$reportNull$$$0(1);
            }
            return statusInfo;
        }
        if (this.myIOError) {
            StatusInfo statusInfo = StatusInfo.JBA_IO_ERROR;
            if (statusInfo == null) {
                CloudConfigManager.$$$reportNull$$$0(2);
            }
            return statusInfo;
        }
        if (this.myStatusInfo != StatusInfo.OFFLINE && this.myStatusInfo != StatusInfo.JBA_CONNECTED && CloudConfigManager.isExclusiveStreamProviderEnabled()) {
            this.myStatusInfo = StatusInfo.OFFLINE;
            this.updateStatusBar(false);
        }
        StatusInfo statusInfo = this.myStatusInfo;
        if (statusInfo == null) {
            CloudConfigManager.$$$reportNull$$$0(3);
        }
        return statusInfo;
    }

    public boolean isConnectedState() {
        return this.myStatusInfo == StatusInfo.JBA_CONNECTED;
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    public boolean isAutoUpdatePlugins() {
        return this.myAutoUpdatePlugins;
    }

    public void setAutoUpdatePlugins(boolean value) {
        boolean update = this.myAutoUpdatePlugins != value;
        this.myAutoUpdatePlugins = value;
        if (update) {
            this.storeAutoUpdatePlugins();
            if (value) {
                this.executePlugins();
            }
        }
    }

    public boolean isLocalConnected() {
        return this.myFilesArchive.exists();
    }

    public boolean isOfflineWithJBA() {
        return this.myOfflineWithJBA || this.myClient != null;
    }

    @NotNull
    public List<PluginState> getEnabledDisabledPlugins() {
        List<PluginState> list = this.myEnabledDisabledPlugins;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<PluginState> getInstalledUninstalledPlugins() {
        List<PluginState> list = this.myInstalledUninstalledPlugins;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean hasPluginsUpdate() {
        return this.myUpdatePlugins;
    }

    public boolean hasPluginsAnyUpdate() {
        return !this.myEnabledDisabledPlugins.isEmpty() || !this.myInstalledUninstalledPlugins.isEmpty();
    }

    public boolean hasUpdateApi() {
        return this.myUpdateApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeApplicationLoaded(@NotNull Application application, @NotNull String configPath) {
        block27: {
            if (application == null) {
                CloudConfigManager.$$$reportNull$$$0(6);
            }
            if (configPath == null) {
                CloudConfigManager.$$$reportNull$$$0(7);
            }
            CloudConfigProvider.setProvider(null);
            if (!configPath.isEmpty()) {
                if (application.isUnitTestMode()) {
                    this.myStatusBarManager = StatusBarInfoManager.EMPTY;
                    this.myExecuteManager = new TestExecuteManager();
                } else {
                    this.myStatusBarManager = new StatusBarInfoManager();
                    this.myExecuteManager = new ExecuteManager();
                    if (CloudConfigManager.isExclusiveStreamProviderEnabled()) {
                        this.myStatusInfo = StatusInfo.OFFLINE;
                        boolean bl = this.myOfflineWithJBA = CloudConfigClientUtil.createClient() != null;
                        if (this.myOfflineWithJBA) {
                            this.updateStatusBarLater(true);
                        }
                        LOG.info("=== Offline: " + CloudConfigManager.isExclusiveStreamProviderEnabled() + " ===");
                        return;
                    }
                }
                this.myIdeConfigPath = new File(configPath);
                this.myConfigDir = new File(configPath, "jba_config");
                this.myCachesDir = new File(this.myConfigDir, "caches");
                this.myFilesArchive = new File(this.myCachesDir, "files.7z");
                this.myUpdatesArchive = new File(this.myCachesDir, "updates.7z");
                this.myApiFile = new File(this.myCachesDir, "api");
                this.myStatusFile = new File(this.myConfigDir, "status.info");
                this.myAutoUpdatePluginsFile = new File(this.myConfigDir, "auto_update_plugins");
                this.myLocalChanges = new LocalChanges();
            } else {
                LOG.info("=== Restart after update user info ===");
            }
            try {
                this.myStatusInfo = StatusInfo.valueOf(FileUtil.loadFile((File)this.myStatusFile));
                if (this.myStatusInfo == StatusInfo.DISABLED) {
                    LOG.info("=== Exit: " + (Object)((Object)this.myStatusInfo) + " ===");
                    return;
                }
            }
            catch (IOException | IllegalArgumentException ignored) {
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            }
            try {
                this.myAutoUpdatePlugins = API.equals(FileUtil.loadFile((File)this.myAutoUpdatePluginsFile));
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.myClient = CloudConfigClientUtil.createClient();
            if (this.myClient == null) {
                this.myStatusInfo = StatusInfo.JBA_NOT_FOUND;
                if (this.isLocalConnected()) {
                    this.updateStatusBarLater(true);
                }
                LOG.info("=== Exit: " + (Object)((Object)this.myStatusInfo) + " ===");
                return;
            }
            try {
                this.myBeforeApplicationLoadedStart = true;
                File autoConnect = new File(this.myConfigDir, ".auto_connect");
                if (autoConnect.exists()) {
                    boolean remote = false;
                    try {
                        remote = "remote".equals(FileUtil.loadFile((File)autoConnect));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    FileUtil.delete((File)autoConnect);
                    if (remote) {
                        this.connectThisInstance(true, true, null);
                    } else {
                        this.connectFirstInstance(true, null);
                    }
                    break block27;
                }
                if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.myLocalChanges.load();
                    this.updateConnection(true);
                } else if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.updateInitStatus();
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.updateInitStatus());
                }
            }
            finally {
                this.myBeforeApplicationLoadedStart = false;
            }
        }
        LOG.info("=== Start: " + (Object)((Object)this.myStatusInfo) + " ===");
    }

    public void updateUserInfo(@NotNull Runnable errorDialog) {
        if (errorDialog == null) {
            CloudConfigManager.$$$reportNull$$$0(8);
        }
        try {
            Preferences.userRoot().sync();
        }
        catch (BackingStoreException e) {
            LOG.info((Throwable)e);
        }
        if (CloudConfigClientUtil.createClient() == null) {
            errorDialog.run();
        } else {
            this.beforeApplicationLoaded(ApplicationManager.getApplication(), "");
        }
    }

    public void recalculateInitStatus(@Nullable Project project) {
        LOG.info("=== Start.recalculateInitStatus ===");
        if (this.myStatusInfo == StatusInfo.DISABLED && this.myClient == null) {
            this.myStatusInfo = null;
            FileUtil.delete((File)this.myStatusFile);
            this.myClient = CloudConfigClientUtil.createClient();
            LOG.assertTrue(this.myClient != null);
        }
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.runProcessWithProgressSynchronously(() -> {
            try {
                this.calculateInitStatus();
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
        }, CloudConfigBundle.message("io.operation.message", new Object[0]), false, project);
        this.myIOOperation = false;
        this.updateStatusBar(false);
        LOG.info("=== End.recalculateInitStatus ===");
    }

    private void calculateInitStatus() throws IOException {
        LOG.info("=== calculateInitStatus ===");
        try {
            this.myStatusInfo = this.listFiles("").contains("files.7z") ? StatusInfo.JBA_THIS_NOT_CONNECTED : StatusInfo.JBA_NOT_CONNECTED;
            File file403 = new File(this.myConfigDir, "403");
            if (file403.exists()) {
                FileUtil.delete((File)file403);
                ApplicationManager.getApplication().invokeLater(() -> StatusBarInfoManager.showStartNotification());
            }
        }
        catch (AccessDeniedException ignored) {
            this.myStatusInfo = StatusInfo.JBA_NOT_ACCEPTED;
            FileUtil.createIfDoesntExist((File)new File(this.myConfigDir, "403"));
            this.resetIO();
        }
        catch (FileNotFoundException ignored) {
            this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            this.resetIO();
        }
        finally {
            LOG.info("=== calculateInitStatus.value: " + (Object)((Object)this.myStatusInfo) + " ===");
        }
    }

    private void updateInitStatus() {
        LOG.info("=== Start.updateInitStatus ===");
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.executeOnPooledThread(() -> {
            try {
                this.calculateInitStatus();
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
            this.myExecuteManager.invokeLater(() -> {
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.updateInitStatus ===");
            });
        });
    }

    private void resetIO() {
        this.myIOError = false;
        this.myErrorMessage = null;
    }

    public void updateIO(@Nullable Runnable failedRun) {
        LOG.info("=== Start.updateIO ===");
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.executeOnPooledThread(() -> {
            try {
                LOG.info("=== updateIO ===");
                try {
                    this.listFiles("io");
                }
                catch (FileNotFoundException ignored) {
                    this.resetIO();
                }
                if (this.myStatusInfo == null) {
                    this.calculateInitStatus();
                } else if (this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                    this.myIOError = true;
                    this.doConnection();
                    return;
                }
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
            this.myExecuteManager.invokeLater(() -> {
                this.myIOOperation = false;
                this.updateStatusBar(false);
                if (this.myIOError && failedRun != null) {
                    failedRun.run();
                }
                LOG.info("=== End.updateIO ===");
            });
        });
    }

    public void disable() {
        this.myLocalChanges.clean();
        this.myStatusInfo = StatusInfo.DISABLED;
        this.myIOError = false;
        this.myIOOperation = false;
        if (this.myClient != null) {
            this.myClient.clearTags();
            this.myClient = null;
        }
        this.storeState();
        this.updateStatusBar(false);
    }

    public void testDisconnect(boolean removeData) {
        this.removeListeners();
        this.doDisconnect(removeData, false);
        this.updateStatusBar(false);
    }

    public void disconnect(boolean removeData) {
        LOG.info("=== Start.disconnect ===");
        this.removeListeners();
        if (!removeData) {
            this.doDisconnect(false, true);
            this.updateStatusBar(false);
            LOG.info("=== End.disconnect ===");
            return;
        }
        this.myIOOperation = true;
        this.updateStatusBar(false);
        this.myExecuteManager.executeOnPooledThread(() -> {
            boolean[] success = new boolean[]{false};
            try {
                LOG.info("=== disconnect.delete_files ===");
                File delFile = new File(this.myConfigDir, ".del");
                FileUtil.createIfDoesntExist((File)delFile);
                this.writeFile(delFile);
                this.deleteFile("files.7z");
                this.deleteFile("updates.7z");
                this.deleteFile("api");
                success[0] = true;
            }
            catch (Throwable e) {
                CloudConfigManager.logInfo(e);
            }
            this.myExecuteManager.invokeLater(() -> {
                if (success[0]) {
                    this.doDisconnect(true, true);
                }
                this.myIOOperation = false;
                this.updateStatusBar(false);
                LOG.info("=== End.disconnect ===");
            });
        });
    }

    private void doDisconnect(boolean removeData, boolean reload) {
        try {
            LOG.info("=== doDisconnect ===");
            this.myInstalledUninstalledPlugins = Collections.emptyList();
            this.myEnabledDisabledPlugins = this.myInstalledUninstalledPlugins;
            this.myUpdatePlugins = false;
            this.myUpdateApi = false;
            this.myUpdateApiNotification = true;
            this.myLocalChanges.clean();
            this.myStatusInfo = removeData ? StatusInfo.JBA_NOT_CONNECTED : StatusInfo.JBA_THIS_NOT_CONNECTED;
            this.myClient.clearTags();
            FileUtil.delete((File)this.myConfigDir);
            this.setStreamProvider(true, reload, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private ConnectionState getConnectionState() {
        block12: {
            block11: {
                Boolean newVersion;
                block10: {
                    ConnectionState connectionState;
                    try {
                        LOG.info("=== getConnectionState ===");
                        this.getFile("api");
                        newVersion = this.getFile("files.7z");
                        if (newVersion != null) break block10;
                        connectionState = ConnectionState.DELETE;
                    }
                    catch (Throwable e) {
                        CloudConfigManager.logInfo(e);
                        ConnectionState connectionState2 = ConnectionState.IO_ERROR;
                        if (connectionState2 == null) {
                            CloudConfigManager.$$$reportNull$$$0(13);
                        }
                        return connectionState2;
                    }
                    if (connectionState == null) {
                        CloudConfigManager.$$$reportNull$$$0(9);
                    }
                    return connectionState;
                }
                if (!newVersion.booleanValue()) break block11;
                ConnectionState connectionState = ConnectionState.NEW;
                if (connectionState == null) {
                    CloudConfigManager.$$$reportNull$$$0(10);
                }
                return connectionState;
            }
            if (this.getFile("updates.7z") != Boolean.TRUE) break block12;
            ConnectionState connectionState = ConnectionState.UPDATE;
            if (connectionState == null) {
                CloudConfigManager.$$$reportNull$$$0(11);
            }
            return connectionState;
        }
        ConnectionState connectionState = ConnectionState.OLD;
        if (connectionState == null) {
            CloudConfigManager.$$$reportNull$$$0(12);
        }
        return connectionState;
    }

    private void updateConnection(boolean init) {
        try {
            LOG.info("=== Start.updateConnection ===");
            if (init) {
                FileUtil.copyContent((File)this.getIdeaDisabledPluginsFile(), (File)this.getLocalDisabledPluginsFile());
                this.setStreamProvider(false, false, false);
            }
            this.myIOOperation = true;
            this.updateStatusBar(init);
            Runnable connection = () -> this.myExecuteManager.executeOnPooledThread(() -> this.doConnection());
            if (init && !ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(connection);
            } else {
                connection.run();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void doConnection() {
        LOG.info("=== doConnect ===");
        ConnectionState state = this.getConnectionState();
        if (state != ConnectionState.DELETE && state != ConnectionState.IO_ERROR) {
            this.checkApi();
        }
        if (state == ConnectionState.NEW) {
            this.connectThisInstanceOperation(true, true, null);
            return;
        }
        this.myExecuteManager.invokeLater(() -> {
            if (state == ConnectionState.OLD) {
                this.safeUpdatePlugins();
                if (this.handleUpdates()) {
                    return;
                }
            } else if (state == ConnectionState.UPDATE) {
                try {
                    this.updateFiles();
                    if (this.handleUpdates()) {
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            } else if (state == ConnectionState.DELETE) {
                this.removeListeners();
                this.doDisconnect(false, true);
                this.myStatusInfo = StatusInfo.JBA_NOT_CONNECTED;
            }
            this.myIOOperation = false;
            this.updateStatusBar(false);
            LOG.info("=== End.connect ===");
        });
    }

    private void checkApi() {
        int api;
        try {
            api = Integer.parseInt(FileUtil.loadFile((File)this.myApiFile));
        }
        catch (IOException ignore) {
            api = 0;
        }
        boolean bl = this.myUpdateApi = api < Integer.parseInt(API);
        if (this.myUpdateApi && this.myUpdateApiNotification) {
            this.myUpdateApiNotification = false;
            ApplicationManager.getApplication().invokeLater(() -> StatusBarInfoManager.showUpdateApiNotification());
        }
    }

    public void doUpdateApi() {
        if (this.myStatusInfo != StatusInfo.JBA_CONNECTED || !this.myUpdateApi) {
            return;
        }
        LOG.info("=== Start.doUpdateApi ===");
        File temp = new File(this.myCachesDir, "temp");
        try {
            FileUtil.delete((File)temp);
            FileUtil.createDirectory((File)temp);
            int prefix = temp.getAbsolutePath().length();
            for (File file : this.copyConfigs(temp, ConfigList.CLASSES)) {
                File indexFile = new File(this.myConfigDir, file.getAbsolutePath().substring(prefix));
                if (indexFile.exists()) continue;
                FileUtil.copyContent((File)file, (File)indexFile);
            }
            FileUtil.delete((File)temp);
            LinkedHashSet<File> index = new LinkedHashSet<File>();
            for (File file : Objects.requireNonNull(this.myConfigDir.listFiles())) {
                String name = file.getName();
                if (file.isDirectory()) {
                    if ("caches".equals(name)) continue;
                    ContainerUtil.addAll(index, (Object[])Objects.requireNonNull(file.listFiles((File child) -> child.isFile())));
                    continue;
                }
                if (ArrayUtil.contains((String)name, (String[])new String[]{"status.info", "auto_update_plugins", LOCAL_DISABLED_PLUGINS_FILENAME, "local.changes", ".auto_connect"})) continue;
                index.add(file);
            }
            this.myIOOperation = true;
            this.updateStatusBar(false);
            this.myExecuteManager.executeOnPooledThread(() -> {
                boolean[] success = new boolean[]{false};
                try {
                    LOG.info("=== doUpdateApi.write ===");
                    this.pushToServer(index, true);
                    FileUtil.delete((File)this.myUpdatesArchive);
                    success[0] = true;
                }
                catch (Throwable e) {
                    CloudConfigManager.logInfo(e);
                }
                this.myExecuteManager.invokeLater(() -> {
                    if (success[0]) {
                        CloudConfigManager.reloadComponents(this.myConfigDir, true, null, ConfigList.CLASSES_WITH_RELOAD_ORDER);
                        this.myUpdateApi = false;
                        this.myUpdateApiNotification = true;
                    }
                    this.myIOOperation = false;
                    this.updateStatusBar(false);
                    LOG.info("=== End.doUpdateApi ===");
                });
            });
        }
        catch (Throwable e) {
            FileUtil.delete((File)temp);
            LOG.error(e);
        }
    }

    public void connectFirstInstance(boolean cleanup, @Nullable Runnable successRun) {
        try {
            LOG.info("=== Start.connectFirstInstance ===");
            FileUtil.delete((File)this.myConfigDir);
            FileUtil.createDirectory((File)this.myConfigDir);
            CloudConfigManager.saveSettings();
            this.myLocalChanges.clean();
            this.myClient.clearTags();
            Set<File> index = this.copyConfigs(this.myConfigDir, ConfigList.CLASSES);
            this.addPlugins(index);
            this.addToFile(index, "os", CloudConfigClientUtil.getOS());
            this.addToFile(index, "version", "0");
            this.myIOOperation = true;
            this.updateStatusBar(true);
            this.myExecuteManager.executeOnPooledThread(() -> {
                boolean[] success = new boolean[]{false};
                try {
                    LOG.info("=== connectFirstInstance.pushToServer ===");
                    this.pushToServer(index, cleanup);
                    success[0] = true;
                }
                catch (Throwable e) {
                    CloudConfigManager.logInfo(e);
                }
                this.myExecuteManager.invokeLater(() -> {
                    if (success[0]) {
                        try {
                            this.setConnected();
                            this.setStreamProvider(false, false, true);
                        }
                        catch (IOException e) {
                            success[0] = false;
                            LOG.error((Throwable)e);
                        }
                    }
                    this.myIOOperation = false;
                    this.updateStatusBar(false);
                    this.finishConnectOperation(success[0], successRun);
                    LOG.info("=== End.connectFirstInstance ===");
                });
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void addToFile(@NotNull Set<File> index, @NotNull String name, @NotNull String content) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(14);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(15);
        }
        if (content == null) {
            CloudConfigManager.$$$reportNull$$$0(16);
        }
        File file = new File(this.myConfigDir, name);
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
    }

    private void initListeners() {
        if (this.myFrameListener == null) {
            this.myFrameListener = new FrameStateListener(){
                long time;

                public void onFrameDeactivated() {
                    this.time = System.currentTimeMillis();
                }

                public void onFrameActivated() {
                    if (CloudConfigManager.this.myIOOperation || !CloudConfigManager.this.myStatusInfo.in(StatusInfo.JBA_NOT_CONNECTED, StatusInfo.JBA_CONNECTED)) {
                        return;
                    }
                    if (!Boolean.getBoolean("no_delay.jba.cloud.config") && System.currentTimeMillis() - this.time < 3600000L) {
                        return;
                    }
                    if (CloudConfigManager.this.myStatusInfo == StatusInfo.JBA_CONNECTED) {
                        CloudConfigManager.this.updateConnection(false);
                    } else {
                        CloudConfigManager.this.updateInitStatus();
                    }
                }
            };
            FrameStateManager.getInstance().addListener(this.myFrameListener);
        }
        if (this.myDisablePluginsListener == null) {
            this.myDisablePluginsListener = () -> this.handleDisablePlugins();
            PluginManagerCore.addDisablePluginListener((Runnable)this.myDisablePluginsListener);
        }
        if (this.myStatePluginListener == null) {
            this.myStatePluginListener = new PluginStateListener(){

                public void install(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CloudConfigManager.this.installPlugin(descriptor);
                }

                public void uninstall(@NotNull IdeaPluginDescriptor descriptor) {
                    if (descriptor == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    CloudConfigManager.this.uninstallPlugin(descriptor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "descriptor";
                    objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "install";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "uninstall";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PluginInstaller.addStateListener((PluginStateListener)this.myStatePluginListener);
        }
    }

    private void handleDisablePlugins() {
        try {
            boolean result;
            LOG.info("=== Start.DisablePluginHandler ===");
            File localFile = this.getLocalDisabledPluginsFile();
            LinkedHashSet oldPlugins = new LinkedHashSet(FileUtil.loadLines((File)localFile));
            File sourceFile = this.getIdeaDisabledPluginsFile();
            LinkedHashSet newPlugins = new LinkedHashSet(FileUtil.loadLines((File)sourceFile));
            Iterator I = newPlugins.iterator();
            while (I.hasNext()) {
                if (!oldPlugins.remove(I.next())) continue;
                I.remove();
            }
            newPlugins.remove(SELF_PLUGIN_ID);
            if (oldPlugins.isEmpty() && newPlugins.isEmpty()) {
                return;
            }
            FileUtil.copyContent((File)sourceFile, (File)localFile);
            List<String> plugins = this.loadPlugins("disabled_plugins.txt");
            boolean update = false;
            for (String deletedPluginId : oldPlugins) {
                result = this.removePlugin(plugins, deletedPluginId);
                update |= result;
                LOG.info("=== DisablePluginHandler.Remove: " + deletedPluginId + " (" + result + ") ===");
            }
            for (String newPluginId : newPlugins) {
                result = this.addPlugin(plugins, newPluginId);
                update |= result;
                LOG.info("=== DisablePluginHandler.Add: " + newPluginId + " (" + result + ") ===");
            }
            if (update) {
                this.savePlugins(plugins, "disabled_plugins.txt");
            }
            LOG.info("=== End.DisablePluginHandler ===");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void installPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(17);
        }
        LOG.info("=== InstallPlugin: " + descriptor + " ===");
        if (descriptor.isBundled()) {
            return;
        }
        String pluginId = descriptor.getPluginId().getIdString();
        if (ContainerUtil.find(CloudConfigManager.getRepositoryPlugins(), remote -> remote.getPluginId().getIdString().equals(pluginId)) == null) {
            return;
        }
        this.addPlugin(descriptor, "installed_plugins.txt");
    }

    private void addPlugin(@NotNull IdeaPluginDescriptor descriptor, @NotNull String name) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(18);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(19);
        }
        try {
            List<String> plugins = this.loadPlugins(name);
            if (this.addPlugin(plugins, descriptor.getPluginId().getIdString())) {
                LOG.info("=== " + name + ".Add: " + descriptor + " ===");
                this.savePlugins(plugins, name);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void uninstallPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(20);
        }
        if (!SELF_PLUGIN_ID.equals(descriptor.getPluginId().getIdString())) {
            this.removePlugin(descriptor, "installed_plugins.txt");
        }
    }

    private void removePlugin(@NotNull IdeaPluginDescriptor descriptor, @NotNull String name) {
        if (descriptor == null) {
            CloudConfigManager.$$$reportNull$$$0(21);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(22);
        }
        try {
            LOG.info("=== " + name + ": " + descriptor + " ===");
            List<String> plugins = this.loadPlugins(name);
            if (this.removePlugin(plugins, descriptor.getPluginId().getIdString())) {
                LOG.info("=== " + name + ".Remove: " + descriptor + " ===");
                this.savePlugins(plugins, name);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private List<String> loadPlugins(String name) throws IOException {
        List list;
        try {
            list = FileUtil.loadLines((File)new File(this.myConfigDir, name));
        }
        catch (FileNotFoundException e) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (arrayList == null) {
                CloudConfigManager.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    private void savePlugins(@NotNull List<String> plugins, @NotNull String name) throws IOException {
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(25);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(26);
        }
        this.savePluginsToFile(plugins, name);
        if (this.mySavePluginsWithEditConfigs) {
            if (this.mySaveSkipRulesFile) {
                this.mySaveSkipRulesFile = false;
                this.editConfigFiles(name, "plugin_rules.txt");
            } else {
                this.editConfigFiles(name);
            }
        }
    }

    private void savePluginsToFile(@NotNull List<String> plugins, @NotNull String name) throws IOException {
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(27);
        }
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(28);
        }
        FileUtil.writeToFile((File)new File(this.myConfigDir, name), (String)StringUtil.join(plugins, (String)"\n"));
    }

    private boolean addPlugin(@NotNull List<String> plugins, @NotNull String pluginId) throws IOException {
        int index;
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(29);
        }
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(30);
        }
        if ((index = plugins.indexOf(pluginId)) == -1) {
            plugins.add(pluginId);
            this.removeRules(pluginId);
            return true;
        }
        return false;
    }

    private boolean removePlugin(@NotNull List<String> plugins, @NotNull String pluginId) throws IOException {
        int index;
        if (plugins == null) {
            CloudConfigManager.$$$reportNull$$$0(31);
        }
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(32);
        }
        if ((index = plugins.indexOf(pluginId)) != -1) {
            plugins.remove(index);
            this.removeRules(pluginId);
            return true;
        }
        return false;
    }

    private void removeListeners() {
        if (this.myFrameListener != null) {
            FrameStateManager.getInstance().removeListener(this.myFrameListener);
            this.myFrameListener = null;
        }
        if (this.myDisablePluginsListener != null) {
            PluginManagerCore.removeDisablePluginListener((Runnable)this.myDisablePluginsListener);
            this.myDisablePluginsListener = null;
        }
        if (this.myStatePluginListener != null) {
            PluginInstaller.removeStateListener((PluginStateListener)this.myStatePluginListener);
            this.myStatePluginListener = null;
        }
    }

    public void connectThisInstance(boolean reload, boolean saveCaches, @Nullable Runnable successRun) {
        this.myIOOperation = true;
        this.updateStatusBar(true);
        this.myExecuteManager.executeOnPooledThread(() -> {
            try {
                this.getFile("api");
                this.checkApi();
            }
            catch (IOException | RuntimeException e) {
                this.resetIO();
            }
            this.connectThisInstanceOperation(reload, saveCaches, successRun);
        });
    }

    private void connectThisInstanceOperation(boolean reload, boolean saveCaches, @Nullable Runnable successRun) {
        LOG.info("=== connectThisInstanceOperation ===");
        boolean[] success = new boolean[]{false};
        try {
            this.myExecuteManager.invokeAndWait(() -> {
                if (saveCaches) {
                    File[] files = this.myConfigDir.listFiles();
                    LOG.assertTrue(files != null);
                    for (File file : files) {
                        if ("caches".equals(file.getName())) continue;
                        FileUtil.delete((File)file);
                    }
                } else {
                    this.myClient.clearTags();
                    FileUtil.delete((File)this.myConfigDir);
                    FileUtil.createDirectory((File)this.myConfigDir);
                }
                this.myLocalChanges.clean();
            });
            LOG.assertTrue(this.getFile("files.7z") != null);
            CloudConfigManager.extractArchive(this.myFilesArchive, this.myConfigDir, false);
            if (this.getFile("updates.7z") != null) {
                CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, true);
            }
            boolean[] write = new boolean[]{false};
            this.myExecuteManager.invokeAndWait(() -> {
                try {
                    File osFile = new File(this.myConfigDir, "os");
                    LOG.assertTrue(osFile.exists());
                    List osNames = FileUtil.loadLines((File)osFile);
                    String os = CloudConfigClientUtil.getOS();
                    CloudConfigManager.saveSettings();
                    LinkedHashSet<File> index = new LinkedHashSet<File>();
                    if (!osNames.contains(os)) {
                        index.addAll(this.copyConfigs(this.myConfigDir, ConfigList.OS_CLASSES));
                        osNames.add(os);
                        this.addToFile(index, "os", StringUtil.join((Collection)osNames, (String)"\n"));
                    }
                    FileUtil.copyContent((File)this.getIdeaDisabledPluginsFile(), (File)this.getLocalDisabledPluginsFile());
                    if (!index.isEmpty()) {
                        this.createUpdates(index);
                        write[0] = true;
                    }
                    success[0] = true;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            });
            if (write[0]) {
                this.writeUpdates();
            }
        }
        catch (Throwable e) {
            success[0] = false;
            if (this.myIOError) {
                CloudConfigManager.logInfo(e);
            }
            LOG.error(e);
        }
        this.myExecuteManager.invokeLater(() -> {
            if (success[0]) {
                try {
                    this.setConnected();
                    this.setStreamProvider(false, reload, true);
                }
                catch (IOException e) {
                    success[0] = false;
                    LOG.error((Throwable)e);
                }
            }
            if (!success[0] || !this.handleUpdates()) {
                this.myIOOperation = false;
                this.updateStatusBar(false);
            }
            this.finishConnectOperation(success[0], successRun);
            LOG.info("=== End.connectThisInstanceOperation ===");
        });
    }

    private static void saveSettings() {
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            application.saveSettings();
        }
    }

    private void finishConnectOperation(boolean success, @Nullable Runnable successRun) {
        if (successRun == null) {
            return;
        }
        if (success) {
            successRun.run();
        } else if (this.myIOError) {
            StatusBarInfoManager.showErrorMessage(this.myErrorMessage);
        }
    }

    private boolean handleUpdates() {
        try {
            File newUpdates = new File(this.myConfigDir, "new.updates");
            Set<File> index = this.myLocalChanges.getFiles();
            if (!index.isEmpty()) {
                LOG.info("=== End.Update: " + index + " ===");
                this.createUpdates(index);
                this.myLocalChanges.clean();
                FileUtil.createIfDoesntExist((File)newUpdates);
            }
            if (newUpdates.exists()) {
                this.myExecuteManager.executeOnPooledThread(() -> {
                    boolean[] write = new boolean[]{false};
                    try {
                        this.writeUpdates();
                        write[0] = true;
                    }
                    catch (Throwable e) {
                        CloudConfigManager.logInfo(e);
                    }
                    this.myExecuteManager.invokeLater(() -> {
                        if (write[0]) {
                            FileUtil.delete((File)newUpdates);
                        }
                        this.myIOOperation = false;
                        this.updateStatusBar(false);
                    });
                });
                return true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private void createUpdates(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(33);
        }
        this.addToFile(index, "version", CloudConfigManager.plusOne(FileUtil.loadFile((File)new File(this.myConfigDir, "version"))));
        String configPrefix = this.myConfigDir.getAbsolutePath();
        if (this.myUpdatesArchive.exists()) {
            File temp = new File(this.myCachesDir, "temp");
            FileUtil.delete((File)temp);
            CloudConfigManager.extractArchive(this.myUpdatesArchive, temp, false);
            int configPrefixLength = configPrefix.length();
            Set newUpdate = ContainerUtil.map2Set(index, file -> {
                String path = file.getAbsolutePath();
                assert (path.startsWith(configPrefix));
                return path.substring(configPrefixLength);
            });
            LinkedHashSet<File> oldUpdate = new LinkedHashSet<File>();
            String oldUpdatePrefix = temp.getAbsolutePath();
            CloudConfigManager.collectFiles(temp, oldUpdatePrefix, oldUpdate, newUpdate);
            try (SevenZOutputFile archive = new SevenZOutputFile(this.myUpdatesArchive);){
                CloudConfigManager.addToArchive(archive, oldUpdate, oldUpdatePrefix);
                CloudConfigManager.addToArchive(archive, index, configPrefix);
            }
            FileUtil.delete((File)temp);
        } else {
            CloudConfigManager.createArchive(index, this.myUpdatesArchive, configPrefix);
        }
    }

    private void writeUpdates() throws IOException {
        this.writeFile(this.myUpdatesArchive);
    }

    private static void collectFiles(@NotNull File dir, @NotNull String prefix, @NotNull Set<File> result, @NotNull Set<String> excludes) {
        File[] files;
        if (dir == null) {
            CloudConfigManager.$$$reportNull$$$0(34);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(35);
        }
        if (result == null) {
            CloudConfigManager.$$$reportNull$$$0(36);
        }
        if (excludes == null) {
            CloudConfigManager.$$$reportNull$$$0(37);
        }
        if ((files = dir.listFiles()) == null) {
            return;
        }
        int prefixLength = prefix.length();
        for (File file : files) {
            if (file.isDirectory()) {
                CloudConfigManager.collectFiles(file, prefix, result, excludes);
                continue;
            }
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(prefixLength);
            if (excludes.contains(name)) continue;
            result.add(file);
        }
    }

    @NotNull
    private Set<File> copyConfigs(@NotNull File configDir, Class ... storageClasses) throws IOException {
        if (configDir == null) {
            CloudConfigManager.$$$reportNull$$$0(38);
        }
        if (storageClasses == null) {
            CloudConfigManager.$$$reportNull$$$0(39);
        }
        LinkedHashSet<File> index = new LinkedHashSet<File>();
        File optionsDir = new File(this.myIdeConfigPath, "options");
        for (Class storageClass : storageClasses) {
            File dir;
            String schemeDir;
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            String inputName = CloudConfigStreamProviderKt.getFileConfig(spec);
            File inputFile = new File(optionsDir, inputName);
            if (inputFile.exists() && inputFile.isFile()) {
                String outName = (String)NAME_CONVERTER.invoke((Object)storageClass, (Object)inputName);
                File outFile = new File(configDir, outName);
                FileUtil.copyContent((File)inputFile, (File)outFile);
                index.add(outFile);
            }
            if ((schemeDir = spec.additionalExportFile()).isEmpty() || !(dir = new File(this.myIdeConfigPath, schemeDir)).exists() || !dir.isDirectory()) continue;
            if (!ConfigList.loadService(storageClass)) {
                LOG.info("=== CopyConfig: service '" + storageClass + "' not loaded ===");
            }
            SchemeManagerImpl scheme = CloudConfigManager.findScheme(schemeDir);
            String schemeOutDir = (String)NAME_CONVERTER.invoke((Object)storageClass, (Object)schemeDir);
            FileUtil.copyDir((File)dir, (File)new File(configDir, schemeOutDir), childFile -> {
                boolean canRead;
                if (configDir == null) {
                    CloudConfigManager.$$$reportNull$$$0(98);
                }
                String childName = childFile.getName();
                boolean bl = canRead = scheme == null || scheme.canRead((CharSequence)childName);
                if (canRead) {
                    index.add(new File(configDir, schemeOutDir + File.separator + childName));
                }
                return canRead;
            });
        }
        LinkedHashSet<File> linkedHashSet = index;
        if (linkedHashSet == null) {
            CloudConfigManager.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    private void addPlugins(@NotNull Set<File> index) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(41);
        }
        String content = FileUtil.loadFile((File)this.getIdeaDisabledPluginsFile());
        FileUtil.writeToFile((File)this.getLocalDisabledPluginsFile(), (String)content);
        File file = new File(this.myConfigDir, "disabled_plugins.txt");
        FileUtil.writeToFile((File)file, (String)content);
        index.add(file);
        this.addToFile(index, "installed_plugins.txt", StringUtil.join(CloudConfigManager.getInstalledPlugins(null), descriptor -> descriptor.getPluginId().getIdString(), (String)"\n"));
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getInstalledPlugins(@Nullable Set<String> bundled) {
        List<IdeaPluginDescriptor> plugins = new ArrayList();
        ContainerUtil.addAll(plugins, (Object[])PluginManagerCore.getPlugins());
        plugins.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
        plugins = ContainerUtil.filter(plugins, descriptor -> {
            if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted()) {
                return false;
            }
            if (descriptor.isBundled()) {
                if (bundled != null) {
                    bundled.add(descriptor.getPluginId().getIdString());
                }
                return false;
            }
            return true;
        });
        if (!plugins.isEmpty()) {
            List<IdeaPluginDescriptor> repositoryPlugins = CloudConfigManager.getRepositoryPlugins();
            plugins = ContainerUtil.filter(plugins, local -> {
                PluginId id = local.getPluginId();
                return ContainerUtil.find((Iterable)repositoryPlugins, remote -> remote.getPluginId().compareTo(id) == 0) != null;
            });
        }
        List<IdeaPluginDescriptor> list = plugins;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    private static List<IdeaPluginDescriptor> getRepositoryPlugins() {
        if (myRepositoryPlugins == null) {
            try {
                Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        return RepositoryHelper.loadPlugins(null);
                    }
                    catch (IOException e) {
                        CloudConfigManager.logInfo(e);
                        return null;
                    }
                });
                CloudConfigManager.waitDone(future);
                myRepositoryPlugins = (List)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                CloudConfigManager.logInfo(e);
            }
        }
        List<Object> list = myRepositoryPlugins == null ? Collections.emptyList() : myRepositoryPlugins;
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(43);
        }
        return list;
    }

    private static void waitDone(Future<?> future) throws InterruptedException {
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (!future.isDone()) {
            while (eventQueue.peekEvent() != null) {
                eventQueue.dispatchEvent(eventQueue.getNextEvent());
            }
            Thread.sleep(0L);
        }
    }

    private void safeUpdatePlugins() {
        try {
            this.updatePlugins(null, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void updatePlugins(@Nullable Set<String> changedFiles, boolean autoUpdatePlugins) throws IOException {
        LinkedHashSet<String> oldPlugins;
        boolean checkDisabled = true;
        boolean checkInstalled = true;
        if (changedFiles != null) {
            if (changedFiles.isEmpty()) {
                return;
            }
            boolean rules = changedFiles.contains("plugin_rules.txt");
            checkDisabled = rules || changedFiles.contains("disabled_plugins.txt");
            boolean bl = checkInstalled = rules || changedFiles.contains("installed_plugins.txt");
            if (!checkDisabled && !checkInstalled) {
                return;
            }
        }
        this.myUpdatePlugins = false;
        Function function = descriptor -> Pair.create((Object)descriptor.getPluginId().getIdString(), (Object)descriptor);
        HashMap<String, PluginState> enabledDisabledStates = new HashMap<String, PluginState>();
        HashMap<String, PluginState> installedUninstalledStates = new HashMap<String, PluginState>();
        Map plugins = ContainerUtil.map2Map((Object[])PluginManagerCore.getPlugins(), (Function)function);
        if (checkDisabled) {
            this.myEnabledDisabledPlugins = new ArrayList<PluginState>();
            oldPlugins = new LinkedHashSet(FileUtil.loadLines((File)this.getIdeaDisabledPluginsFile()));
            this.mergePlugins(this.myEnabledDisabledPlugins, enabledDisabledStates, plugins, null, oldPlugins, null, PluginState.Type.Enable, "disabled_plugins.txt", PluginState.Type.Disable);
        }
        if (checkInstalled) {
            this.myInstalledUninstalledPlugins = new ArrayList<PluginState>();
            oldPlugins = new LinkedHashSet<String>();
            LinkedHashSet<String> bundled = new LinkedHashSet<String>();
            for (IdeaPluginDescriptor descriptor2 : CloudConfigManager.getInstalledPlugins(bundled)) {
                oldPlugins.add(descriptor2.getPluginId().getIdString());
            }
            Map rPlugins = ContainerUtil.map2Map(CloudConfigManager.getRepositoryPlugins(), (Function)function);
            this.mergePlugins(this.myInstalledUninstalledPlugins, installedUninstalledStates, plugins, rPlugins, oldPlugins, bundled, PluginState.Type.Uninstall, "installed_plugins.txt", PluginState.Type.Install);
        }
        if (!this.myEnabledDisabledPlugins.isEmpty() || !this.myInstalledUninstalledPlugins.isEmpty()) {
            this.applyRules(enabledDisabledStates, installedUninstalledStates, false);
            this.applyRules(enabledDisabledStates, installedUninstalledStates, true);
            if (this.myEnabledDisabledPlugins.stream().anyMatch(state -> !state.skip) || this.myInstalledUninstalledPlugins.stream().anyMatch(state -> !state.skip)) {
                this.myUpdatePlugins = true;
            }
        }
        this.updateStatusBar(false);
        if (autoUpdatePlugins && this.myAutoUpdatePlugins) {
            this.executePlugins();
        }
    }

    private void applyRules(@NotNull Map<String, PluginState> enabledDisabledStates, @NotNull Map<String, PluginState> installedUninstalledStates, boolean local) throws IOException {
        if (enabledDisabledStates == null) {
            CloudConfigManager.$$$reportNull$$$0(44);
        }
        if (installedUninstalledStates == null) {
            CloudConfigManager.$$$reportNull$$$0(45);
        }
        for (String ruleLine : this.loadPlugins(local ? "local_plugin_rules.txt" : "plugin_rules.txt")) {
            String pluginId = StringUtil.substringBefore((String)ruleLine, (String)":");
            assert (pluginId != null);
            String ruleValue = StringUtil.substringAfter((String)ruleLine, (String)":");
            assert (ruleValue != null);
            for (String rule : StringUtil.split((String)ruleValue, (String)",")) {
                if (CloudConfigManager.applyRule(enabledDisabledStates, pluginId, rule, "skip_disable", PluginState.Type.Disable, local) || CloudConfigManager.applyRule(enabledDisabledStates, pluginId, rule, "skip_enable", PluginState.Type.Enable, local) || CloudConfigManager.applyRule(installedUninstalledStates, pluginId, rule, "skip_install", PluginState.Type.Install, local)) continue;
                CloudConfigManager.applyRule(installedUninstalledStates, pluginId, rule, "skip_uninstall", PluginState.Type.Uninstall, local);
            }
        }
    }

    private static boolean applyRule(@NotNull Map<String, PluginState> states, @NotNull String pluginId, @NotNull String rule, @NotNull String ruleExpected, @NotNull PluginState.Type type, boolean local) {
        PluginState state;
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(46);
        }
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(47);
        }
        if (rule == null) {
            CloudConfigManager.$$$reportNull$$$0(48);
        }
        if (ruleExpected == null) {
            CloudConfigManager.$$$reportNull$$$0(49);
        }
        if (type == null) {
            CloudConfigManager.$$$reportNull$$$0(50);
        }
        if (ruleExpected.equals(rule) && (state = states.get(pluginId)) != null) {
            assert (state.type == type) : pluginId + " : " + rule + " : " + (Object)((Object)state.type);
            state.skip = true;
            state.local = local;
            return true;
        }
        return false;
    }

    private void addRule(@NotNull PluginState state) {
        if (state == null) {
            CloudConfigManager.$$$reportNull$$$0(51);
        }
        try {
            String pluginId = state.plugin.getPluginId().getIdString();
            String name = state.local ? "local_plugin_rules.txt" : "plugin_rules.txt";
            List<String> rules = this.loadPlugins(name);
            boolean found = false;
            String newRule = "skip_" + StringUtil.decapitalize((String)state.type.name());
            ListIterator<String> I = rules.listIterator();
            while (I.hasNext()) {
                String ruleLine = I.next();
                String nextId = StringUtil.substringBefore((String)ruleLine, (String)":");
                assert (nextId != null);
                if (!pluginId.equals(nextId)) continue;
                String ruleValue = StringUtil.substringAfter((String)ruleLine, (String)":");
                assert (ruleValue != null);
                List allRules = StringUtil.split((String)ruleValue, (String)",");
                if (allRules.contains(newRule)) {
                    return;
                }
                allRules.add(newRule);
                I.set(pluginId + ":" + StringUtil.join((Collection)allRules, (String)","));
                found = true;
            }
            if (!found) {
                rules.add(pluginId + ":" + newRule);
            }
            this.savePluginsToFile(rules, name);
            if (!state.local) {
                this.mySaveSkipRulesFile = true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void removeRules(@NotNull String pluginId) throws IOException {
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(52);
        }
        this.mySaveSkipRulesFile = this.removeRules(pluginId, "plugin_rules.txt");
        this.removeRules(pluginId, "local_plugin_rules.txt");
    }

    private boolean removeRules(@NotNull String pluginId, @NotNull String file) throws IOException {
        if (pluginId == null) {
            CloudConfigManager.$$$reportNull$$$0(53);
        }
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(54);
        }
        List<String> rules = this.loadPlugins(file);
        Iterator<String> I = rules.iterator();
        while (I.hasNext()) {
            String ruleLine = I.next();
            String nextPluginId = StringUtil.substringBefore((String)ruleLine, (String)":");
            assert (nextPluginId != null);
            if (!pluginId.equals(nextPluginId)) continue;
            I.remove();
            this.savePluginsToFile(rules, file);
            return true;
        }
        return false;
    }

    private void mergePlugins(@NotNull List<PluginState> result, @NotNull Map<String, PluginState> states, @NotNull Map<String, IdeaPluginDescriptor> plugins1, @Nullable Map<String, IdeaPluginDescriptor> plugins2, @NotNull Set<String> oldPlugins1, @Nullable Set<String> oldPlugins2, @NotNull PluginState.Type oldState, @NotNull String newPluginsName, @NotNull PluginState.Type newState) throws IOException {
        if (result == null) {
            CloudConfigManager.$$$reportNull$$$0(55);
        }
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(56);
        }
        if (plugins1 == null) {
            CloudConfigManager.$$$reportNull$$$0(57);
        }
        if (oldPlugins1 == null) {
            CloudConfigManager.$$$reportNull$$$0(58);
        }
        if (oldState == null) {
            CloudConfigManager.$$$reportNull$$$0(59);
        }
        if (newPluginsName == null) {
            CloudConfigManager.$$$reportNull$$$0(60);
        }
        if (newState == null) {
            CloudConfigManager.$$$reportNull$$$0(61);
        }
        LinkedHashSet<String> newPlugins = new LinkedHashSet<String>(this.loadPlugins(newPluginsName));
        Iterator I = newPlugins.iterator();
        while (I.hasNext()) {
            String newPlugin = (String)I.next();
            if (!oldPlugins1.remove(newPlugin) && (oldPlugins2 == null || !oldPlugins2.remove(newPlugin))) continue;
            I.remove();
        }
        CloudConfigManager.mergePlugins(result, states, plugins1, plugins2, oldPlugins1, oldState);
        CloudConfigManager.mergePlugins(result, states, plugins1, plugins2, newPlugins, newState);
    }

    private static void mergePlugins(@NotNull List<PluginState> result, @NotNull Map<String, PluginState> states, @NotNull Map<String, IdeaPluginDescriptor> plugins1, @Nullable Map<String, IdeaPluginDescriptor> plugins2, @NotNull Set<String> pluginIds, @NotNull PluginState.Type type) {
        if (result == null) {
            CloudConfigManager.$$$reportNull$$$0(62);
        }
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(63);
        }
        if (plugins1 == null) {
            CloudConfigManager.$$$reportNull$$$0(64);
        }
        if (pluginIds == null) {
            CloudConfigManager.$$$reportNull$$$0(65);
        }
        if (type == null) {
            CloudConfigManager.$$$reportNull$$$0(66);
        }
        for (String pluginId : pluginIds) {
            IdeaPluginDescriptor descriptor = plugins1.get(pluginId);
            if (descriptor == null && plugins2 != null) {
                descriptor = plugins2.get(pluginId);
            }
            if (descriptor == null || !PluginManagerCore.isCompatible((IdeaPluginDescriptor)descriptor)) continue;
            PluginState state = new PluginState(type, descriptor);
            result.add(state);
            states.put(pluginId, state);
        }
    }

    public void executePlugins() {
        ArrayList<PluginState> states = new ArrayList<PluginState>(this.myEnabledDisabledPlugins);
        states.addAll(this.myInstalledUninstalledPlugins);
        List<Pair<PluginState, PluginState.Operation>> executeList = states.stream().filter(state -> !state.skip).map(state -> Pair.create((Object)state, (Object)((Object)PluginState.Operation.Auto))).collect(Collectors.toList());
        this.executePlugins(executeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePlugins(@NotNull List<Pair<PluginState, PluginState.Operation>> executeList) {
        if (executeList == null) {
            CloudConfigManager.$$$reportNull$$$0(67);
        }
        if (executeList.isEmpty()) {
            return;
        }
        final ArrayList<IdeaPluginDescriptor> installList = new ArrayList<IdeaPluginDescriptor>();
        final boolean[] states = new boolean[]{false, false, false};
        try {
            this.mySavePluginsWithEditConfigs = false;
            for (Pair<PluginState, PluginState.Operation> info : executeList) {
                PluginState state = (PluginState)info.first;
                IdeaPluginDescriptor descriptor = state.plugin;
                PluginState.Operation operation = (PluginState.Operation)((Object)info.second);
                PluginState.Type type = state.type;
                if (operation == PluginState.Operation.Auto) {
                    if (type == PluginState.Type.Install) {
                        installList.add(descriptor);
                        continue;
                    }
                    if (type == PluginState.Type.Uninstall) {
                        try {
                            assert (descriptor instanceof IdeaPluginDescriptorImpl) : descriptor.getClass() + " : " + descriptor;
                            ((IdeaPluginDescriptorImpl)descriptor).setDeleted(true);
                            PluginInstaller.prepareToUninstall((PluginId)descriptor.getPluginId());
                            states[1] = true;
                            states[2] = true;
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.error((Throwable)e);
                        }
                        continue;
                    }
                    if (type == PluginState.Type.Disable) {
                        PluginManagerCore.disablePlugin((String)descriptor.getPluginId().getIdString());
                        states[0] = true;
                        states[2] = true;
                        continue;
                    }
                    PluginManagerCore.enablePlugin((String)descriptor.getPluginId().getIdString());
                    states[0] = true;
                    states[2] = true;
                    continue;
                }
                if (operation == PluginState.Operation.Revert) {
                    if (type == PluginState.Type.Install) {
                        this.removePlugin(descriptor, "installed_plugins.txt");
                        states[1] = true;
                        continue;
                    }
                    if (type == PluginState.Type.Uninstall) {
                        this.addPlugin(descriptor, "installed_plugins.txt");
                        states[1] = true;
                        continue;
                    }
                    if (type == PluginState.Type.Disable) {
                        this.removePlugin(descriptor, "disabled_plugins.txt");
                    } else {
                        this.addPlugin(descriptor, "disabled_plugins.txt");
                    }
                    states[0] = true;
                    continue;
                }
                state.skip = true;
                state.local = operation == PluginState.Operation.SkipLocally;
                this.addRule(state);
            }
        }
        finally {
            this.mySavePluginsWithEditConfigs = true;
        }
        if (installList.isEmpty()) {
            this.doneExecutePlugins(states);
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Download JBA Cloud Shared Plugins"){
                final List<PluginDownloader> myDownloaders;
                boolean mySuccess;
                {
                    super(arg0, arg1);
                    this.myDownloaders = new ArrayList<PluginDownloader>();
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    for (IdeaPluginDescriptor descriptor : installList) {
                        try {
                            PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor);
                            if (!downloader.prepareToInstall(indicator)) continue;
                            this.myDownloaders.add(downloader);
                        }
                        catch (IOException e) {
                            PluginManagerMain.LOG.error((Throwable)e);
                        }
                    }
                }

                public void onSuccess() {
                    this.mySuccess = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFinished() {
                    if (this.mySuccess) {
                        try {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = false;
                            for (PluginDownloader downloader : this.myDownloaders) {
                                try {
                                    downloader.install();
                                    states[1] = true;
                                    states[2] = true;
                                }
                                catch (IOException e) {
                                    PluginManagerMain.LOG.error((Throwable)e);
                                }
                            }
                        }
                        finally {
                            CloudConfigManager.this.mySavePluginsWithEditConfigs = true;
                        }
                    }
                    CloudConfigManager.this.doneExecutePlugins(states);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cloudConfig/CloudConfigManager$3", "run"));
                }
            });
        }
    }

    private void doneExecutePlugins(@NotNull boolean[] states) {
        if (states == null) {
            CloudConfigManager.$$$reportNull$$$0(68);
        }
        ArrayList<String> files = new ArrayList<String>();
        if (states[0]) {
            files.add("disabled_plugins.txt");
        }
        if (states[1]) {
            files.add("installed_plugins.txt");
        }
        if (this.mySaveSkipRulesFile) {
            this.mySaveSkipRulesFile = false;
            if (files.isEmpty()) {
                this.editConfigFiles("plugin_rules.txt");
                this.safeUpdatePlugins();
                return;
            }
            files.add("plugin_rules.txt");
        }
        if (files.isEmpty()) {
            this.safeUpdatePlugins();
        } else {
            this.editConfigFiles(ArrayUtil.toStringArray(files));
            this.safeUpdatePlugins();
            if (states[2]) {
                PluginManagerConfigurable.shutdownOrRestartApp();
            }
        }
    }

    @Nullable
    private static SchemeManagerImpl findScheme(@NotNull String fileSpec) {
        if (fileSpec == null) {
            CloudConfigManager.$$$reportNull$$$0(69);
        }
        Ref result = new Ref();
        ((SchemeManagerFactoryBase)SchemeManagerFactory.getInstance()).process(manager -> {
            if (fileSpec == null) {
                CloudConfigManager.$$$reportNull$$$0(97);
            }
            if (result.isNull() && fileSpec.equals(manager.getFileSpec())) {
                result.set(manager);
            }
            return null;
        });
        return (SchemeManagerImpl)result.get();
    }

    private void pushToServer(@NotNull Set<File> index, boolean cleanup) throws IOException {
        if (index == null) {
            CloudConfigManager.$$$reportNull$$$0(70);
        }
        if (cleanup) {
            this.deleteFile("updates.7z");
            this.deleteFile(".del");
        }
        CloudConfigManager.createArchive(index, this.myFilesArchive, this.myConfigDir.getAbsolutePath());
        this.writeFile(this.myFilesArchive);
        this.writeApi();
    }

    private void writeApi() throws IOException {
        FileUtil.writeToFile((File)this.myApiFile, (String)API);
        this.writeFile(this.myApiFile);
    }

    private void setConnected() throws IOException {
        this.myStatusInfo = StatusInfo.JBA_CONNECTED;
        this.storeStateIO();
        this.storeAutoUpdatePlugins();
    }

    private void updateStatusBar(boolean create) {
        if (this.myBeforeApplicationLoadedStart) {
            this.updateStatusBarLater(create);
        } else {
            this.myStatusBarManager.update(create);
        }
    }

    private void updateStatusBarLater(boolean create) {
        ApplicationManager.getApplication().invokeLater(() -> this.myStatusBarManager.update(create));
    }

    public void editConfigFiles(String ... fileNames) {
        if (fileNames == null) {
            CloudConfigManager.$$$reportNull$$$0(71);
        }
        try {
            LOG.info("=== Start.Edit: " + Arrays.toString(fileNames) + " |" + this.myIOOperation + "| ===");
            this.myLocalChanges.addFiles(fileNames);
            if (this.myIOOperation) {
                return;
            }
            this.myIOOperation = true;
            this.updateStatusBar(false);
            this.myExecuteManager.schedule(() -> this.doConnection(), 1L, TimeUnit.SECONDS);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private static String plusOne(@NotNull String value) {
        if (value == null) {
            CloudConfigManager.$$$reportNull$$$0(72);
        }
        String string = Integer.toString(Integer.parseInt(value) + 1);
        if (string == null) {
            CloudConfigManager.$$$reportNull$$$0(73);
        }
        return string;
    }

    private void storeState() {
        try {
            this.storeStateIO();
        }
        catch (IOException e) {
            CloudConfigManager.logInfo(e);
        }
    }

    private void storeStateIO() throws IOException {
        FileUtil.writeToFile((File)this.myStatusFile, (String)this.myStatusInfo.name());
    }

    private void storeAutoUpdatePlugins() {
        try {
            FileUtil.writeToFile((File)this.myAutoUpdatePluginsFile, (String)(this.myAutoUpdatePlugins ? API : "0"));
        }
        catch (IOException e) {
            CloudConfigManager.logInfo(e);
        }
    }

    private void setStreamProvider(boolean noProvider, boolean reload, boolean plugins) throws IOException {
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        storageManager.removeStreamProvider(CloudConfigStreamProvider.class);
        if (!noProvider) {
            storageManager.addStreamProvider((StreamProvider)new CloudConfigStreamProvider(this.myConfigDir, this), true);
        }
        if (!noProvider) {
            this.initListeners();
        }
        if (reload) {
            File optionsDir = noProvider ? new File(this.myIdeConfigPath, "options") : this.myConfigDir;
            CloudConfigManager.reloadComponents(optionsDir, !noProvider, null, ConfigList.CLASSES_WITH_RELOAD_ORDER);
        }
        if (noProvider) {
            this.myInstalledUninstalledPlugins = Collections.emptyList();
            this.myEnabledDisabledPlugins = this.myInstalledUninstalledPlugins;
            this.myUpdatePlugins = false;
        } else if (plugins) {
            this.updatePlugins(null, true);
        }
    }

    private void updateFiles() throws IOException {
        LOG.info("=== Update Files ===");
        HashSet<String> changedFiles = new HashSet<String>();
        CloudConfigManager.extractArchive(this.myUpdatesArchive, this.myConfigDir, changedFiles);
        this.myLocalChanges.removeFiles(changedFiles);
        if (!changedFiles.isEmpty()) {
            CloudConfigManager.reloadComponents(this.myConfigDir, true, changedFiles, ConfigList.CLASSES_WITH_RELOAD_ORDER);
        }
        this.updatePlugins(changedFiles, true);
    }

    private static void reloadComponents(@NotNull File optionsDir, boolean streamProvider, @Nullable Set<String> changedFiles, @NotNull Class[] storageClasses) {
        if (optionsDir == null) {
            CloudConfigManager.$$$reportNull$$$0(74);
        }
        if (storageClasses == null) {
            CloudConfigManager.$$$reportNull$$$0(75);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final LinkedHashSet<String> componentNames = new LinkedHashSet<String>();
        final HashSet<StateStorage> changedStorages = new HashSet<StateStorage>();
        ArrayList<SchemeManagerImpl> schemes = new ArrayList<SchemeManagerImpl>();
        StateStorageManagerImpl storageManager = CloudConfigManager.getStateStorageManager();
        for (Class storageClass : storageClasses) {
            State spec = StoreUtil.getStateSpec((Class)storageClass);
            LOG.assertTrue(spec != null);
            boolean addComponent = false;
            String schemeDir = spec.additionalExportFile();
            if (schemeDir.length() > 0 && (changedFiles == null || changedFiles.contains(schemeDir))) {
                SchemeManagerImpl scheme = CloudConfigManager.findScheme(schemeDir);
                if (scheme != null) {
                    schemes.add(scheme);
                    addComponent = true;
                } else {
                    LOG.info("=== Reload: lazy component scheme '" + schemeDir + "' ===");
                }
            }
            String name = CloudConfigStreamProviderKt.getFileConfig(spec);
            boolean exists = new File(optionsDir, name).exists();
            StateStorage storage = storageManager.findCachedFileStorage(name);
            if (storage == null) {
                LOG.info("=== Reload: lazy component '" + name + "' ===");
                continue;
            }
            LOG.assertTrue(storage instanceof XmlElementStorage, (Object)(name + " : " + storage));
            changedStorages.add(storage);
            ((XmlElementStorage)storage).updatedFrom(componentNames, !exists, streamProvider);
            if (!addComponent && changedFiles != null && !changedFiles.contains(name)) continue;
            componentNames.add(spec.name());
        }
        CustomActionsSchema.getInstance().clearFirstLoadState();
        for (SchemeManagerImpl scheme : schemes) {
            scheme.reload();
        }
        Application application = ApplicationManager.getApplication();
        final ComponentStoreImpl store = (ComponentStoreImpl)ServiceKt.getStateStore((ComponentManager)application);
        final Collection notReloadableComponents = store.getNotReloadableComponents(componentNames);
        LOG.assertTrue(notReloadableComponents.isEmpty());
        StateStorageBaseKt.runBatchUpdate((MessageBus)application.getMessageBus(), (Function0)new Function0<Object>(){

            public Object invoke() {
                store.reinitComponents(componentNames, changedStorages, notReloadableComponents);
                return null;
            }
        });
        CloudConfigManager.updateUI();
        LOG.info("=== Reload components: " + componentNames + " ===");
    }

    private static void updateUI() {
        boolean darcula = UIUtil.isUnderDarcula();
        JBColor.setDark((boolean)darcula);
        IconLoader.setUseDarkIcons((boolean)darcula);
        ActionToolbarImpl.updateAllToolbarsImmediately();
        LafManager.getInstance().updateUI();
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        UISettings.getInstance().fireUISettingsChanged();
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        EditorOptionsPanel.reinitAllEditors();
        EditorOptionsPanel.restartDaemons();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    private static boolean isExclusiveStreamProviderEnabled() {
        return CloudConfigManager.getStateStorageManager().getCompoundStreamProvider().isExclusivelyEnabled();
    }

    @NotNull
    public static StateStorageManagerImpl getStateStorageManager() {
        StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStorageManager();
        if (stateStorageManagerImpl == null) {
            CloudConfigManager.$$$reportNull$$$0(76);
        }
        return stateStorageManagerImpl;
    }

    private static boolean filterOsName(@NotNull String fileName) {
        if (fileName == null) {
            CloudConfigManager.$$$reportNull$$$0(77);
        }
        if (!fileName.startsWith(CloudConfigClientUtil.getOS() + ".")) {
            for (String name : OS_NAMES) {
                if (!fileName.startsWith(name + ".")) continue;
                return false;
            }
        }
        return true;
    }

    public static void createArchive(@NotNull Set<File> files, @NotNull File outFile, @NotNull String prefix) throws IOException {
        if (files == null) {
            CloudConfigManager.$$$reportNull$$$0(78);
        }
        if (outFile == null) {
            CloudConfigManager.$$$reportNull$$$0(79);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(80);
        }
        FileUtil.createParentDirs((File)outFile);
        try (SevenZOutputFile archive = new SevenZOutputFile(outFile);){
            CloudConfigManager.addToArchive(archive, files, prefix);
        }
    }

    private static void addToArchive(SevenZOutputFile archive, @NotNull Set<File> files, @NotNull String prefix) throws IOException {
        if (files == null) {
            CloudConfigManager.$$$reportNull$$$0(81);
        }
        if (prefix == null) {
            CloudConfigManager.$$$reportNull$$$0(82);
        }
        prefix = prefix + File.separator;
        int length = prefix.length();
        for (File file : files) {
            String path = file.getAbsolutePath();
            assert (path.startsWith(prefix));
            String name = path.substring(length);
            if (File.separatorChar != '/') {
                name = name.replace(File.separatorChar, '/');
            }
            archive.putArchiveEntry((ArchiveEntry)archive.createArchiveEntry(file, name));
            if (file.exists() && file.isFile()) {
                archive.write(FileUtil.loadFileBytes((File)file));
            }
            archive.closeArchiveEntry();
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, boolean delete) throws IOException {
        if (archiveFile == null) {
            CloudConfigManager.$$$reportNull$$$0(83);
        }
        if (outDir == null) {
            CloudConfigManager.$$$reportNull$$$0(84);
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory() || !CloudConfigManager.filterOsName(entry.getName())) continue;
                File file = new File(outDir, entry.getName());
                int size = (int)entry.getSize();
                if (delete && size == 0) {
                    FileUtil.delete((File)file);
                    continue;
                }
                FileUtil.writeToFile((File)file, (byte[])CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)size));
            }
        }
    }

    private static void extractArchive(@NotNull File archiveFile, @NotNull File outDir, @NotNull Set<String> changedFiles) throws IOException {
        if (archiveFile == null) {
            CloudConfigManager.$$$reportNull$$$0(85);
        }
        if (outDir == null) {
            CloudConfigManager.$$$reportNull$$$0(86);
        }
        if (changedFiles == null) {
            CloudConfigManager.$$$reportNull$$$0(87);
        }
        try (SevenZFile archive = new SevenZFile(archiveFile);){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                File file = new File(outDir, fileName);
                int size = (int)entry.getSize();
                boolean change = false;
                if (size == 0) {
                    if (file.exists()) {
                        FileUtil.delete((File)file);
                        change = true;
                        LOG.info("=== Update File(Delete): " + fileName + " ===");
                    }
                } else if (CloudConfigManager.filterOsName(fileName)) {
                    byte[] oldBytes = file.isFile() && file.exists() ? FileUtil.loadFileBytes((File)file) : null;
                    byte[] newBytes = CloudConfigClientUtil.loadBytes((SevenZFile)archive, (int)((int)entry.getSize()));
                    if (!Arrays.equals(newBytes, oldBytes)) {
                        FileUtil.writeToFile((File)file, (byte[])newBytes);
                        if (!"version".equals(fileName)) {
                            change = true;
                            LOG.info("=== Update File(Edit): " + fileName + " ===");
                        }
                    }
                }
                if (!change) continue;
                changedFiles.add(fileName);
                String dirName = StringUtil.substringBefore((String)fileName, (String)"/");
                if (dirName == null) continue;
                changedFiles.add(dirName);
            }
        }
    }

    @NotNull
    private List<String> listFiles(@NotNull String file) throws IOException {
        List list;
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(88);
        }
        try {
            List result = this.myClient.list(CloudConfigClientUtil.getName() + file);
            this.resetIO();
            list = result;
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
        if (list == null) {
            CloudConfigManager.$$$reportNull$$$0(89);
        }
        return list;
    }

    @Nullable
    private Boolean getFile(@NotNull String name) throws IOException {
        InputStream stream;
        if (name == null) {
            CloudConfigManager.$$$reportNull$$$0(90);
        }
        File file = new File(this.myCachesDir, name);
        try {
            stream = this.myClient.read(CloudConfigClientUtil.getName() + name);
            this.resetIO();
        }
        catch (FileNotFoundException ignored) {
            FileUtil.delete((File)file);
            this.resetIO();
            return null;
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
        if (stream != null) {
            FileUtil.createParentDirs((File)file);
            try (InputStream inputStream = stream;
                 FileOutputStream outputStream = new FileOutputStream(file);){
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                this.resetIO();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                this.myIOError = true;
                throw e;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void writeFile(@NotNull File file) throws IOException {
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(91);
        }
        try (FileInputStream stream = new FileInputStream(file);){
            this.myClient.write(CloudConfigClientUtil.getName() + file.getName(), (InputStream)stream);
            this.resetIO();
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
    }

    private void deleteFile(@NotNull String file) throws IOException {
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(92);
        }
        try {
            this.myClient.delete(CloudConfigClientUtil.getName() + file);
            this.resetIO();
        }
        catch (IOException | RuntimeException e) {
            this.myIOError = true;
            this.setErrorMessage(e);
            throw e;
        }
    }

    @NotNull
    private File getIdeaDisabledPluginsFile() {
        File file = new File(this.myIdeConfigPath, "disabled_plugins.txt");
        FileUtil.createIfDoesntExist((File)file);
        File file2 = file;
        if (file2 == null) {
            CloudConfigManager.$$$reportNull$$$0(93);
        }
        return file2;
    }

    @NotNull
    private File getLocalDisabledPluginsFile() {
        File file = new File(this.myConfigDir, LOCAL_DISABLED_PLUGINS_FILENAME);
        if (file == null) {
            CloudConfigManager.$$$reportNull$$$0(94);
        }
        return file;
    }

    private void setErrorMessage(@NotNull Exception e) {
        if (e == null) {
            CloudConfigManager.$$$reportNull$$$0(95);
        }
        if (e instanceof RuntimeException) {
            this.myErrorMessage = e.getMessage();
            if (this.myErrorMessage != null && this.myErrorMessage.startsWith("Unexpected response (code: 413,")) {
                this.myErrorMessage = "Request Entity Too Large";
            }
        } else {
            this.myErrorMessage = null;
        }
    }

    private static void logInfo(@NotNull Throwable e) {
        if (e == null) {
            CloudConfigManager.$$$reportNull$$$0(96);
        }
        LOG.info(e);
    }

    static {
        NAME_CONVERTER = (storageClass, name) -> ConfigList.isOSConfig(storageClass) ? CloudConfigClientUtil.getOS() + "." + name : name;
        OS_NAMES = new String[]{"mac", "win", "linux", "freebsd", "unix", "unknown"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cloudConfig/CloudConfigManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDialog";
                break;
            }
            case 14: 
            case 33: 
            case 41: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 15: 
            case 19: 
            case 22: 
            case 26: 
            case 28: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 30: 
            case 32: 
            case 47: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 35: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 36: 
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 38: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 39: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageClasses";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledDisabledStates";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedUninstalledStates";
                break;
            }
            case 46: 
            case 56: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleExpected";
                break;
            }
            case 50: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 54: 
            case 88: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 57: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPlugins1";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldState";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginsName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeList";
                break;
            }
            case 69: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSpec";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsDir";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFile";
                break;
            }
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFile";
                break;
            }
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFiles";
                break;
            }
            case 95: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledDisabledPlugins";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledUninstalledPlugins";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionState";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPlugins";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyConfigs";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPlugins";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryPlugins";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "plusOne";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateStorageManager";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "listFiles";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaDisabledPluginsFile";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDisabledPluginsFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeApplicationLoaded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateUserInfo";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addToFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "installPlugin";
                break;
            }
            case 18: 
            case 19: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addPlugin";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPlugin";
                break;
            }
            case 21: 
            case 22: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "savePlugins";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsToFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createUpdates";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copyConfigs";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addPlugins";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "applyRules";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "applyRule";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "removeRules";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "mergePlugins";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "executePlugins";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "doneExecutePlugins";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findScheme";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "pushToServer";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "editConfigFiles";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "plusOne";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "reloadComponents";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "filterOsName";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createArchive";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addToArchive";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "extractArchive";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "listFiles";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "setErrorMessage";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findScheme$39";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyConfigs$28";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LocalChanges {
        private final Set<String> myFiles = new LinkedHashSet<String>();
        private final File myFile = new File(CloudConfigManager.access$1100(CloudConfigManager.this), "local.changes");

        private LocalChanges() {
        }

        public void load() {
            try {
                if (this.myFile.exists()) {
                    this.myFiles.addAll(FileUtil.loadLines((File)this.myFile));
                    LOG.info("=== Local Changes: " + this.myFiles + " ===");
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }

        public void addFiles(String ... fileNames) throws IOException {
            if (fileNames == null) {
                LocalChanges.$$$reportNull$$$0(0);
            }
            if (Collections.addAll(this.myFiles, fileNames)) {
                this.save();
            }
        }

        @NotNull
        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (String file : this.myFiles) {
                files.add(new File(CloudConfigManager.this.myConfigDir, file));
            }
            LinkedHashSet<File> linkedHashSet = files;
            if (linkedHashSet == null) {
                LocalChanges.$$$reportNull$$$0(1);
            }
            return linkedHashSet;
        }

        public void removeFiles(@NotNull Set<String> files) throws IOException {
            if (files == null) {
                LocalChanges.$$$reportNull$$$0(2);
            }
            this.myFiles.removeAll(files);
            if (this.myFiles.isEmpty()) {
                FileUtil.delete((File)this.myFile);
            } else {
                this.save();
            }
        }

        private void save() throws IOException {
            FileUtil.writeToFile((File)this.myFile, (String)StringUtil.join(this.myFiles, (String)"\n"));
        }

        public void clean() {
            this.myFiles.clear();
            FileUtil.delete((File)this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/CloudConfigManager$LocalChanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager$LocalChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFiles";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFiles";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TestExecuteManager
    extends ExecuteManager {
        private TestExecuteManager() {
        }

        @Override
        public void executeOnPooledThread(@NotNull Runnable action) {
            if (action == null) {
                TestExecuteManager.$$$reportNull$$$0(0);
            }
            action.run();
        }

        @Override
        public void invokeAndWait(@NotNull Runnable runnable) {
            if (runnable == null) {
                TestExecuteManager.$$$reportNull$$$0(1);
            }
            runnable.run();
        }

        @Override
        public void invokeLater(@NotNull Runnable runnable) {
            if (runnable == null) {
                TestExecuteManager.$$$reportNull$$$0(2);
            }
            runnable.run();
        }

        @Override
        public void runProcessWithProgressSynchronously(@NotNull Runnable process, @Nls @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
            if (process == null) {
                TestExecuteManager.$$$reportNull$$$0(3);
            }
            if (progressTitle == null) {
                TestExecuteManager.$$$reportNull$$$0(4);
            }
            process.run();
        }

        @Override
        public void schedule(Runnable command, long delay, TimeUnit unit) {
            command.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressTitle";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager$TestExecuteManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeOnPooledThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runProcessWithProgressSynchronously";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExecuteManager {
        private ExecuteManager() {
        }

        public void executeOnPooledThread(@NotNull Runnable action) {
            if (action == null) {
                ExecuteManager.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().executeOnPooledThread(action);
        }

        public void invokeAndWait(@NotNull Runnable runnable) {
            if (runnable == null) {
                ExecuteManager.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeAndWait(runnable);
        }

        public void invokeLater(@NotNull Runnable runnable) {
            if (runnable == null) {
                ExecuteManager.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().invokeLater(runnable);
        }

        public void runProcessWithProgressSynchronously(@NotNull Runnable process, @Nls @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) {
            if (process == null) {
                ExecuteManager.$$$reportNull$$$0(3);
            }
            if (progressTitle == null) {
                ExecuteManager.$$$reportNull$$$0(4);
            }
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, progressTitle, canBeCanceled, project);
        }

        public void schedule(Runnable command, long delay, TimeUnit unit) {
            JobScheduler.getScheduler().schedule(command, delay, unit);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressTitle";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/CloudConfigManager$ExecuteManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeOnPooledThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runProcessWithProgressSynchronously";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum ConnectionState {
        OLD,
        NEW,
        UPDATE,
        DELETE,
        IO_ERROR;

    }
}

