/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import b.h.la;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.GemRunnerBasedParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;

public class RunConfigurationUIUtil {
    private static final long a = la.a(-886804214217553312L, 1887952970689060521L, MethodHandles.lookup().lookupClass()).a(143294582080935L);

    private RunConfigurationUIUtil() {
    }

    public static LabeledComponent<RawCommandLineEditor> createRawEditorComponent(Ref<? super RawCommandLineEditor> rawEditorWrapper, String dialogCaption, String labelTextWithMnemonic) {
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor();
        rawEditorWrapper.set((Object)rawCommandLineEditor);
        rawCommandLineEditor.setDialogCaption(dialogCaption);
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setComponent((JComponent)rawCommandLineEditor);
        labeledComponent.setText(labelTextWithMnemonic);
        return labeledComponent;
    }

    public static LabeledComponent createTextFieldLabeledComponent(Ref<? super JTextField> textFieldRef, String text) {
        return RunConfigurationUIUtil.createTextFieldLabeledComponent(textFieldRef, text, null);
    }

    public static LabeledComponent createTextFieldLabeledComponent(Ref<? super JTextField> textFieldRef, String text, @Nullable String toolTipText) {
        JTextField jTextField = new JTextField();
        textFieldRef.set((Object)jTextField);
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setComponent((JComponent)jTextField);
        labeledComponent.setText(text);
        if (toolTipText != null) {
            labeledComponent.setToolTipText(toolTipText);
        }
        return labeledComponent;
    }

    public static LabeledComponent<TextFieldWithBrowseButton> createScriptPathComponent(Ref<? super TextFieldWithBrowseButton> testScriptTextFieldWrapper, String text) {
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        testScriptTextFieldWrapper.set((Object)textFieldWithBrowseButton);
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setComponent((JComponent)textFieldWithBrowseButton);
        labeledComponent.setText(text);
        return labeledComponent;
    }

    public static LabeledComponent createTestFolderComponent(Ref<? super TextFieldWithBrowseButton> testsFolderTextFieldWrapper) {
        long l2 = a ^ 0x1BB3E65CE7DCL;
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        testsFolderTextFieldWrapper.set((Object)textFieldWithBrowseButton);
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setComponent((JComponent)textFieldWithBrowseButton);
        labeledComponent.setText(RBundle.message((String)"run.configuration.messages.folder.path"));
        return labeledComponent;
    }

    public static FileChooserDescriptor addFolderChooser(@NotNull String title, @NotNull TextFieldWithBrowseButton textField, Project project) {
        if (title == null) {
            RunConfigurationUIUtil.a(0);
        }
        if (textField == null) {
            RunConfigurationUIUtil.a(1);
        }
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fileChooserDescriptor.setTitle(title);
        textField.addBrowseFolderListener(title, null, project, fileChooserDescriptor);
        return fileChooserDescriptor;
    }

    public static FileChooserDescriptor addFileChooser(String title, TextFieldWithBrowseButton textField, Project project) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        fileChooserDescriptor.setTitle(title);
        textField.addBrowseFolderListener(title, null, project, fileChooserDescriptor);
        return fileChooserDescriptor;
    }

    public static LabeledComponent createRunnerOptionsComponent(Ref<? super RawCommandLineEditor> runnerOptionsEditorRef) {
        long l2 = a ^ 0xF772E3D88D9L;
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor();
        runnerOptionsEditorRef.set((Object)rawCommandLineEditor);
        rawCommandLineEditor.setDialogCaption(RBundle.message((String)"run.configuration.messages.edit.runner.options"));
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setComponent((JComponent)rawCommandLineEditor);
        labeledComponent.setText(RBundle.message((String)"run.configuration.messages.runner.options"));
        return labeledComponent;
    }

    public static LabeledComponent createRSpecExamplesComponent(@NotNull Ref<? super RawCommandLineEditor> runnerOptionsEditorRef) {
        long l2 = a ^ 0x17D0BC496AFDL;
        if (runnerOptionsEditorRef == null) {
            RunConfigurationUIUtil.a(2);
        }
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor();
        runnerOptionsEditorRef.set((Object)rawCommandLineEditor);
        rawCommandLineEditor.setDialogCaption(RBundle.message((String)"rspec.run.configuration.tests.dialog.messages.edit"));
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setComponent((JComponent)rawCommandLineEditor);
        labeledComponent.setText(RBundle.message((String)"rspec.run.configuration.tests.dialog.components.example.name"));
        return labeledComponent;
    }

    public static void setWorkingDirectoryIfNotDefinedByUser(VirtualFile file, AbstractRubyRunConfiguration templateConfiguration, Module module) {
        long l2 = a ^ 0x6C4C8C688155L;
        if (StringUtil.isEmptyOrSpaces((String)templateConfiguration.getWorkingDirectory())) {
            String string;
            if (RailsFacetUtil.hasRailsSupport(module)) {
                string = RailsFacetUtil.getRailsAppHomeDirPath(module);
            } else {
                String string2 = RunConfigurationUIUtil.a(file, "spec", module);
                if (string2 != null) {
                    string = string2;
                } else {
                    VirtualFile virtualFile = file.isDirectory() ? file : file.getParent();
                    String string3 = string = virtualFile != null ? virtualFile.getPath() : null;
                }
            }
            if (string != null) {
                templateConfiguration.setWorkingDirectory(string);
            }
        }
    }

    @Nullable
    private static String a(@NotNull VirtualFile virtualFile, @NotNull String string, @NotNull Module module) {
        VirtualFile virtualFile2;
        if (virtualFile == null) {
            RunConfigurationUIUtil.a(3);
        }
        if (string == null) {
            RunConfigurationUIUtil.a(4);
        }
        if (module == null) {
            RunConfigurationUIUtil.a(5);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        VirtualFile virtualFile3 = null;
        for (VirtualFile virtualFile4 = virtualFile; virtualFile4 != null && projectFileIndex.isInContent(virtualFile4); virtualFile4 = virtualFile4.getParent()) {
            if (!virtualFile4.isDirectory() || !string.equals(virtualFile4.getName())) continue;
            virtualFile3 = virtualFile4;
            break;
        }
        if (virtualFile3 != null && (virtualFile2 = virtualFile3.getParent()) != null && projectFileIndex.isInContent(virtualFile2)) {
            return virtualFile2.getPath();
        }
        return null;
    }

    public static boolean findAlternativeSdkInProject(Project project, AbstractRubyRunConfigurationParams templateConfiguration) {
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (moduleArray.length > 0) {
            templateConfiguration.setAlternativeSdk(RModuleUtil.getInstance().findRubySdkForModule(moduleArray[0]));
            return true;
        }
        return false;
    }

    public static GemRunnerBasedParamsEditor createGemRunnerBasedParamsEditor(@NotNull JPanel panel, @NotNull List<String> gemNameList, @Nullable Map<String, GemRunnerBasedParamsEditor.Filter> gems2FilterTable, @NotNull RubyCommonRunParamsEditor commonEditor) {
        long l2 = a ^ 0x648E31E794A8L;
        if (panel == null) {
            RunConfigurationUIUtil.a(6);
        }
        if (gemNameList == null) {
            RunConfigurationUIUtil.a(7);
        }
        if (commonEditor == null) {
            RunConfigurationUIUtil.a(8);
        }
        GemRunnerBasedParamsEditor gemRunnerBasedParamsEditor = new GemRunnerBasedParamsEditor(gemNameList, gems2FilterTable, commonEditor);
        panel.add((Component)gemRunnerBasedParamsEditor.getMainPanel(), "Center");
        return gemRunnerBasedParamsEditor;
    }

    public static RubyCommonRunParamsEditor createRubyCommonRunParamsEditor(@NotNull AbstractRubyRunConfiguration configuration, @NotNull String gemName, @NotNull JPanel commonOptionsPanel) {
        long l2 = a ^ 0x2A40D506583FL;
        if (configuration == null) {
            RunConfigurationUIUtil.a(9);
        }
        if (gemName == null) {
            RunConfigurationUIUtil.a(10);
        }
        if (commonOptionsPanel == null) {
            RunConfigurationUIUtil.a(11);
        }
        RubyCommonRunParamsEditor rubyCommonRunParamsEditor = new RubyCommonRunParamsEditor(configuration);
        rubyCommonRunParamsEditor.setGemName(gemName);
        commonOptionsPanel.add((Component)rubyCommonRunParamsEditor.getMainPanel(), "Center");
        return rubyCommonRunParamsEditor;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x311255369A63L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerOptionsEditorRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemNameList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonOptionsPanel";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUIUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFolderChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRSpecExamplesComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentOfAncestorOf";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createGemRunnerBasedParamsEditor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createRubyCommonRunParamsEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

