/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files.apple;

import com.swoval.concurrent.ThreadFactory;
import com.swoval.files.apple.FileEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileEventsApi
implements AutoCloseable {
    private long handle;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory("com.swoval.files.apple.FileEventsApi.run-loop-thread"));
    private AtomicBoolean closed = new AtomicBoolean(false);
    private static final String NATIVE_LIBRARY = "apple-file-events0";

    private FileEventsApi(final Consumer<FileEvent> consumer, final Consumer<String> consumer2) throws InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                FileEventsApi.this.handle = FileEventsApi.init(consumer, consumer2);
                countDownLatch.countDown();
                FileEventsApi.this.loop();
            }
        });
        countDownLatch.await();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.stopLoop();
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                FileEventsApi.close(this.handle);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void loop() {
        FileEventsApi.loop(this.handle);
    }

    public int createStream(String string, double d, int n) {
        if (this.closed.get()) {
            String string2 = "Tried to create watch stream for path " + string + " on closed watch service";
            throw new IllegalStateException(string2);
        }
        return FileEventsApi.createStream(string, d, n, this.handle);
    }

    public void stopLoop() {
        FileEventsApi.stopLoop(this.handle);
    }

    public void stopStream(int n) {
        if (!this.closed.get()) {
            FileEventsApi.stopStream(this.handle, n);
        }
    }

    private static final void exit(String string) {
        System.err.println(string);
        System.exit(1);
    }

    private static void loadPackaged() {
        try {
            String string = System.mapLibraryName(NATIVE_LIBRARY);
            File file = File.createTempFile("jni-", "");
            if (!file.delete()) {
                throw new IOException("Couldn't remove temp file");
            }
            if (!file.mkdir()) {
                throw new IOException("Couldn't remove temp file");
            }
            String string2 = "/native/x86_64-darwin/" + string;
            InputStream inputStream = FileEventsApi.class.getResourceAsStream(string2);
            if (inputStream == null) {
                String string3 = "Native library " + string + " (" + string2 + ") can't be loaded.";
                throw new UnsatisfiedLinkError(string3);
            }
            final File file2 = new File(file.getAbsolutePath() + "/" + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(byArray)) >= 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                throw new UnsatisfiedLinkError("Error while extracting native library: " + exception);
            }
            finally {
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Files.delete(file2.toPath());
                    }
                    catch (IOException iOException) {
                        System.err.println("Error deleting temporary files: " + iOException);
                    }
                }
            });
            System.load(file2.getAbsolutePath());
        }
        catch (Exception exception) {
            FileEventsApi.exit("Couldn't load packaged library apple-file-events0");
        }
    }

    public static FileEventsApi apply(Consumer<FileEvent> consumer, Consumer<String> consumer2) throws InterruptedException {
        return new FileEventsApi(consumer, consumer2);
    }

    public static native void loop(long var0);

    public static native void close(long var0);

    public static native long init(Consumer<FileEvent> var0, Consumer<String> var1);

    public static native int createStream(String var0, double var1, int var3, long var4);

    public static native void stopLoop(long var0);

    public static native void stopStream(long var0, int var2);

    static {
        FileEventsApi.loadPackaged();
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

