/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.util.Arrays;
import java.util.logging.Logger;
import net.bluecow.spectro.WindowFunction;

public class VorbisWindowFunction
implements WindowFunction {
    private static final Logger logger = Logger.getLogger(VorbisWindowFunction.class.getName());
    private final double[] scalars;
    private static final double PI = Math.PI;

    public VorbisWindowFunction(int size) {
        this.scalars = new double[size];
        for (int i = 0; i < size; ++i) {
            double xx = Math.sin(Math.PI / (2.0 * (double)size) * (2.0 * (double)i));
            this.scalars[i] = Math.sin(1.5707963267948966 * (xx * xx));
        }
        logger.finest(String.format("VorbisWindowFunction scalars (size=%d): %s\n", this.scalars.length, Arrays.toString(this.scalars)));
    }

    public void applyWindow(double[] data) {
        if (data.length != this.scalars.length) {
            throw new IllegalArgumentException("Invalid array size (required: " + this.scalars.length + "; given: " + data.length + ")");
        }
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] * this.scalars[i];
        }
    }
}

