# Arabic (Arabian Peninsula)

## Introduction

The oral folk tradition of star names and asterisms in the Arabian Peninsula, mostly scattered in poetry and proverbs.

## Description

<p>
The Arabian Peninsula is a region covering the south western corner of Asia, bordered by Gulf of Aden and Arabian Sea on the south, Gulf of Oman and Persian Gulf on the East, The Red Sea on the west. The northern border is not well defined but according to ancient geographers, it is bordered by rivers, meaning The Euphrates river [#16] [#17]. This region is inhabited by Arabs and covers Jordan, Saudi Arabia, Kuwait, Bahrain, Qatar, United Arab Emirates, Oman, Yemen, and parts of Syria and Iraq.
<p><img width="300" src="illustrations/arabian_peninsula.jpg" /></p>
</p>

The Bedouins and farmers in the Arabian Peninsula relied heavily on stars for timing their nomadic trips, animal care, weather forecast and agricultural activities. We find frequent mention of stars in their proverbs and poetry. Fortunately, the oral poetry and proverbs have been documented and preserved in collections by different scholars. Surveying these collections along with oral traditions reveals the star knowledge of the people of this region.

The stars used for timing are the same as that of ancient Arabs, but the system is simplified by beginning the year cycle with the heliacal rising of al-Thurayyā, the Pleiades, in the beginning of summer, and then counting 13 days for each lunar station, except for al-Ǧabhah that has 14 days. This will have 27 lunar stations x 13 days + 14 days (al-Ǧabhah) = 365-day cycle. Other methods of timing were used like the monthly Pleiades-Moon conjunction or using other stars like the stars of the Big Dipper.

The sources show that star names and asterisms are few compared to that of ancient Arabs. Only the bright stars and prominent asterism were named and used. An important source of star knowledge that continued its influence up to the present is the poetry of al-Ḫalāwī, a poet who's time is not certain but estimated to be in the 17th century[#3]. Another important source is a poem by Moḥammad al-Qāḍī (~1809 -1886), where he described all the 28 lunar stations, citing them by the local names[#2].

#### Sources of Star Names and Asterisms

The source of this sky culture is a compilation of star names from oral traditions and the following books: [#2], [#3], [#5], [#6], [#8], [#11], [#12], [#13], [#14], [#15].

## Constellations

<table>
<tr><td>ID</td><td><b>Arabic</b></td><td><b>Transliteration</b></td><td><b>Translation</b></td><td><b>Comment</b></td><td><b>References</b></td></tr>
<tr><td colspan="6" style="text-align:center;"><b>Constellations</b></td></tr>
<tr><td><notr>CON 100</notr></td><td><notr>الحويجزين</notr></td><td><notr>al-Ḥuwaiǧzain</notr></td><td>The Two Guards</td><td>The two stars: β UMi and γ UMi. They are used for directions. The Two Guards comes from the legend that al-Jady (Polaris) killed the father of the seven sisters who are carrying the bier of their father (The stars of the Big Dipper) and circling al-Jady, vowing that they will not burry their father until they get revenge. al-Jady asked these two for protection, and the name is The Two Guards.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 100</notr></td><td><notr>الدخيلين</notr></td><td><notr>al-Diḫīlain</notr></td><td>The Two Refugees</td><td>The other name of the two stars: β UMi and γ Umi, The Two Refugees, comes from another version of the legend that they are the ones who committed the killing and they fled towards al-Jady for protection.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 100</notr></td><td><notr>آل أبا بزي</notr></td><td><notr>Āl Aba Bzay</notr></td><td>The Family Of Aba Bzay</td><td>The two stars: β UMi and γ UMi</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 200</notr></td><td><notr>النعايم</notr></td><td><notr>al-Naʿāyem</notr></td><td>Al-Nayem</td><td>Meaning is not known for certain. It could mean the camels. composed of the seven stars of the Big Dipper.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 200</notr></td><td><notr>السبَّع</notr></td><td><notr>al-Sibbaʿ</notr></td><td>The Seven</td><td>The seven stars of the Big Dipper.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 200</notr></td><td><notr>بنات نعش</notr></td><td><notr>Banāt Naʿš</notr></td><td>Daughters Of Na'sh</td><td>The seven stars of the Big Dipper. Seven sisters carrying the bier of their father who was killed by al-Ǧady (Polaris).</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 300</notr></td><td><notr>الشداد</notr></td><td><notr>al-Šdād</notr></td><td>The Saddle Of The Camel</td><td>The 5 bright stars of Cassiopeia. This name is used in the western areas along the red sea of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 400</notr></td><td><notr>المغزل</notr></td><td><notr>al-Miġzal</notr></td><td>The Wool Spindle</td><td>The Cross shaped stars of α Cyg (Deneb), ε Cyg (Gienah), γ Cyg (Sadr), δ Cyg, and β1+β2 Cyg (Albireo). The source is oral tradition from the town of Zulfi in central Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 2502</notr></td><td><notr>المقدم</notr></td><td><notr>al-Muqaddam</notr></td><td>The Front</td><td>The front mouth of the bucket (24th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2504</notr></td><td><notr>المؤخر</notr></td><td><notr>al-Muḫḫar</notr></td><td>The Rear</td><td>The rear mouth of the bucket (25th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2550</notr></td><td><notr>الرشا</notr></td><td><notr>al-Rša</notr></td><td>The Bucket Rope</td><td>The rope used to pull the bucket from the well (26th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2602</notr></td><td><notr>الشرطين</notr></td><td><notr>al-Šarṭain</notr></td><td>The Two Marks</td><td>The two marks, stars (α Ari and β Ari) (27th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2603</notr></td><td><notr>البطين</notr></td><td><notr>al-Bṭain</notr></td><td>The Little Abdomen</td><td>The little abdomen of al-Ḥamal (28th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2604</notr></td><td><notr>الثريا</notr></td><td><notr>al-Thrayyā</notr></td><td>Al-Thurayya</td><td>Al-Thurayya is a proper name of the Pleiades (first mansion of the Moon).</td><td><notr>3</notr></td></tr>
<tr><td><notr>CON 2801</notr></td><td><notr>الذراع</notr></td><td><notr>al-Dhraʿ</notr></td><td>The Arm</td><td>The two stars of Canis Minor, the arm of the lion (5th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 4501</notr></td><td><notr>الكليبين</notr></td><td><notr>al-Klaibain</notr></td><td>The Two Little Dogs</td><td>An asterism of the two stars: δ CMa and ε CMa. Their heliacal rising is used for timing (same time as the 6th mansion of the Moon). The name is common in central Arabia.</td><td><notr>2,3</notr></td></tr>
<tr><td><notr>CON 2803</notr></td><td><notr>النثرة</notr></td><td><notr>al-Nathrah</notr></td><td>The Nostrils</td><td>M 44 and two adjacent stars representing the nose tip of the Arab lion (6th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2804</notr></td><td><notr>الطرف</notr></td><td><notr>al-Ṭarf</notr></td><td>The Eyes</td><td>Eyes of the lion (7th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2805</notr></td><td><notr>الجبهة</notr></td><td><notr>al-Ǧabhah</notr></td><td>The Forehead</td><td>Forehead of the lion (8th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2806</notr></td><td><notr>الزبرة</notr></td><td><notr>al-Zubrah</notr></td><td>The Mane</td><td>Mane of the lion (9th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2808</notr></td><td><notr>العوا</notr></td><td><notr>al-ʿAwwā</notr></td><td>The Bend</td><td>an arc of 5 stars. The arabic al-ʿAwwā could mean also the Howlers, dogs barking at the lion (11th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2810</notr></td><td><notr>الغفر</notr></td><td><notr>al-Ġafr</notr></td><td>The Cover</td><td>Three star asterism (13th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2901</notr></td><td><notr>الزبانى</notr></td><td><notr>al-Zubānā</notr></td><td>Claws Of The Scorpion</td><td>The two bright stars of Libra (14th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2902</notr></td><td><notr>الإكليل</notr></td><td><notr>al-Iklīl</notr></td><td>The Diadem</td><td>The arc of the three stars on the forehead of Scorpius (15th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2906</notr></td><td><notr>الشولة</notr></td><td><notr>al-Šawlah</notr></td><td>Raised Tail Of The Scorpion</td><td>The sting of Scorpius (17th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 2999</notr></td><td><notr>العقرب</notr></td><td><notr>al-ʿAqrab</notr></td><td>The Scorpion</td><td>The scorpion image</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 3005</notr></td><td><notr>البلدة</notr></td><td><notr>al-Baldah</notr></td><td>The Empty Place</td><td>An area with no bright stars in Sagittarius (19th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 3099</notr></td><td><notr>النعايم</notr></td><td><notr>al-Naʿāyem</notr></td><td>The Ostriches</td><td>Four stars in the milky way representing four ostriches drinking at the river and another four away from the milky way representing four ostriches returning from the river. A ninth star between and above the two groups is included. All the stars are in the Sagittarius constellation (18th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 3199</notr></td><td><notr>سعد الذابح</notr></td><td><notr>Saʿd al-Dhabiḥ</notr></td><td>The Lucky Star Of The Slaughterer</td><td>Ancient Arab asterism representing a man slaughtering a sheep (20th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 3299</notr></td><td><notr>سعد بلع</notr></td><td><notr>Saʿd bulaʿ</notr></td><td>The Lucky Star Of The Swallower</td><td>Ancient Arab asterism representing a man swallowing a bite (21th mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 3399</notr></td><td><notr>سعد السعود</notr></td><td><notr>Saʿd al-suʿūd</notr></td><td>The Luckiest Of The Lucky Stars</td><td>Ancient Arab asterism three stars that rises in the morning in the spring (22nd mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 3499</notr></td><td><notr>سعد الأخبية</notr></td><td><notr>Saʿd al-aḫbiyah</notr></td><td>The Lucky Star Of The Tents</td><td>Ancient Arab asterism of a triangle of three stars and a fourth star is inside the triangle, a man inside a tent (23rd mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 4201</notr></td><td><notr>الهقعة</notr></td><td><notr>al-Haqʿah</notr></td><td>The Circular Mark</td><td>Ancient Arab asterism of a small triangle of stars (head of Orion) representing a mark on the side of the horse (third mansion of the Moon).</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 4206</notr></td><td><notr>الهنعة</notr></td><td><notr>al-Hanʿah</notr></td><td>Stoopness</td><td>Ancient Arab asterism (4th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>CON 4202</notr></td><td><notr>ظهر الجوزا</notr></td><td><notr>Ẓahr al-Ǧawzā</notr></td><td>Back Of Al-Jawza</td><td>The three stars at the belt of Orion. This name along with the star names of Northern Horn of al-Jawza and Southern Horn of al-Jawza comes from the western region of Saudi Arabia and used by the fishers of the red sea. The source is oral tradition from the seaport Umluj of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 4213</notr></td><td><notr>زوابن الجوزا</notr></td><td><notr>Zawābin al-Ǧawzā</notr></td><td>Claws Of Al-Jawza</td><td>Names of the stars: α, γ, β, and κ Ori, orally communicated from the Qasseem region of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 4213</notr></td><td><notr>الزبَّن</notr></td><td><notr>al-Zibban</notr></td><td>Claws Of Al-Jawza</td><td>Names of the stars: α, γ, β, and κ Ori, orally communicated from the Qasseem region of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 2650</notr></td><td><notr>مسجد الثريا</notr></td><td><notr>Masǧid al-Thrayyā</notr></td><td>Mosque Of Al-Thurayya</td><td>A triangle of stars that rise before al-Thurayya (The Pleiades). It is composed of the three stars: α Ari, α Tri, and β Tri. The source of this name is oral tradition in the region of Wadi al-Dawasir in southwestern Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>CON 4299</notr></td><td><notr>الجوزا</notr></td><td><notr>al-Ǧawā</notr></td><td>Al-Jawza</td><td>Al-Jawza is a proper name for a woman. this constellation is a woman shape for the Orion stars. It is the same as that of ancient Arabs. Some oral traditions will give the name to only the three stars of Orion belt.</td><td><notr>2,3</notr></td></tr>
<tr><td colspan="6" style="text-align:center;"><b>Planets</b></td></tr>
<tr><td>Venus</td><td><notr>نجمة الصبح</notr></td><td><notr>Naǧmat al-ṣibḥ</notr></td><td>Morning Star</td><td>A name for Venus when it sets after the Sun.</td><td><notr>1</notr></td></tr>
<tr><td>Venus</td><td><notr>نجمة االعشا</notr></td><td><notr>Naǧmat al-ʿŠā</notr></td><td>Evening Star</td><td>A name for Venus when it rises before the Sun.</td><td><notr>1</notr></td></tr>
<tr><td>Venus</td><td><notr>الجغمة، الجغامة</notr></td><td><notr>al-Ǧuġmah, al-Ǧuġġāmah</notr></td><td>The Sip, The Sipper</td><td>Bedouins will tell the kids when they ask for milk to wait until Venus (The sip, the sipper) sets. Another version is that they encourage the children to drink their milk before Venus (The sipper) drinks it.</td><td><notr>1</notr></td></tr>
<tr><td>Venus</td><td><notr>نجمة الهودان</notr></td><td><notr>Naǧmat al-Hawdān</notr></td><td>The Star Of Al-Hawdan</td><td>Al-Hawdan is a tribe. Every evening they agree that when they see Venus in the morning, they will start their nomadic trip looking for pasture for their camels, but in they morning they decide to stay. Another version is that they will take their camels to the pasture early when Venus rises preceding others, and they will take back their camels late in the evening when Venus sets.</td><td><notr>1</notr></td></tr>
<tr><td colspan="6" style="text-align:center;"><b>Stars</b></td></tr>
<tr><td><notr>HIP 11767</notr></td><td><notr>الجدي</notr></td><td><notr>al-Ǧady</notr></td><td>The Kid</td><td>Same as the ancient Arab name.</td><td><notr>3</notr></td></tr>
<tr><td><notr>HIP 72607</notr></td><td><notr>الحويجزين 1</notr></td><td><notr>al-Ḥuwaiǧzain 1</notr></td><td>The Two Guards 1</td><td>See CON100</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 75097</notr></td><td><notr>الحويجزين 2</notr></td><td><notr>al-Ḥuwaiǧzain 2</notr></td><td>The Two Guards 2</td><td>See CON100</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 72607</notr></td><td><notr>الدخيلين 1</notr></td><td><notr>al-Diḫīlain 1</notr></td><td>The Two Refugees 1</td><td>See CON100</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 75097</notr></td><td><notr>الدخيلين 2</notr></td><td><notr>al-Diḫīlain 2</notr></td><td>The Two Refugees 2</td><td>See CON100</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 72607</notr></td><td><notr>آل أبا بزي 1</notr></td><td><notr>Āl Aba Bzay 1</notr></td><td>The Family Of Aba Bzay 1</td><td>See CON100</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 75097</notr></td><td><notr>آل أبا بزي 2</notr></td><td><notr>Āl Aba Bzay 2</notr></td><td>The Family Of Aba Bzay 2</td><td>See CON100</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 54061</notr></td><td><notr>الخلج 1</notr></td><td><notr>al-Ḫilj 1</notr></td><td>Al-Khilj 1</td><td>The first two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 53910</notr></td><td><notr>الخلج 2</notr></td><td><notr>al-Ḫilj 2</notr></td><td>Al-Khilj 2</td><td>The first two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 54061</notr></td><td><notr>الخلج الاولات 1</notr></td><td><notr>al-Ḫilj al-awwalāt 1</notr></td><td>The first Khilj 1</td><td>The first two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 53910</notr></td><td><notr>الخلج الاولات 2</notr></td><td><notr>al-Ḫilj al-awwalāt 2</notr></td><td>The first Khilj 2</td><td>The first two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 58001</notr></td><td><notr>الخلج التوالي 1</notr></td><td><notr>al-Ḫilj al-Tuwalī 1</notr></td><td>The Latter Khilj 1</td><td>The second two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 59774</notr></td><td><notr>الخلج التوالي 2</notr></td><td><notr>al-Ḫilj al-Tuwalī 2</notr></td><td>The Latter Khilj 2</td><td>The second two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 58001</notr></td><td><notr>الربّع 1</notr></td><td><notr>al-Rubbaʿ 1</notr></td><td>The fourth ones 1</td><td>The second two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 59774</notr></td><td><notr>الربّع 2</notr></td><td><notr>al-Rubbaʿ 2</notr></td><td>The fourth ones 2</td><td>The second two stars of the Big Dipper to rise</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 62956</notr></td><td><notr>الخامس</notr></td><td><notr>al-Ḫamis</notr></td><td>The Fifth</td><td>The star ε UMa, fifth to rise of the seven stars of the Big Dipper.</td><td><notr>5</notr></td></tr>
<tr><td><notr>HIP 65378</notr></td><td><notr>السات</notr></td><td><notr>al-Satt</notr></td><td>The Sixth</td><td>The star ζ UMa, sixth to rise of the seven stars of the Big Dipper.</td><td><notr>5</notr></td></tr>
<tr><td><notr>HIP 67301</notr></td><td><notr>السويبع</notr></td><td><notr>al-Swaibiʿ</notr></td><td>The Seventh</td><td>The star η UMa, seventh to rise of the seven stars of the Big Dipper.</td><td><notr>7</notr></td></tr>
<tr><td><notr>HIP 69673</notr></td><td><notr>الرقيب</notr></td><td><notr>al-Reqīb</notr></td><td>The Watcher</td><td>The star α Boo. The source of this name is in the tradition of Ḥayel region.</td><td><notr>6</notr></td></tr>
<tr><td><notr>HIP 69673</notr></td><td><notr>الاحيمر</notr></td><td><notr>al-Iḥaimir</notr></td><td>The Reddish One</td><td>The star α Boo. The source of this name is in the traditions of seafarers and fishers of the west and east costs of the Arabian Peninsula.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 91262</notr></td><td><notr>النسر المكتف</notr></td><td><notr>al-Nasr al-Mkattaf</notr></td><td>The Closed Wings Eagle</td><td>The star α Lyr (Vega), named because the two stars: ζ Lyr and ε Lyr forms the closed wings. Source is Ḥayel region.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 24608</notr></td><td><notr>المباري</notr></td><td><notr>al-Mbarī</notr></td><td>The Parallel One</td><td>The star Capella, parallels al-Thurayya (The Pleiades)</td><td><notr>8</notr></td></tr>
<tr><td><notr>HIP 24608</notr></td><td><notr>الجنيب</notr></td><td><notr>al-Ǧinīb</notr></td><td>The Sided One</td><td>The star Capella, on the far side of al-Thurayya (The Pleiades)</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 97649</notr></td><td><notr>النسر الباسط</notr></td><td><notr>al-Nasr al-Basiṭ</notr></td><td>The Spread Wings Eagle</td><td>The star α Aql (Altair), named because the two stars: γ Aql and β Aql forms the spread wings. Source is Ḥayel region.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 97649</notr></td><td><notr>الكانون</notr></td><td><notr>al-Kanūn</notr></td><td>Al-Kanoon</td><td>Another name of The Spread wings Eagle mentioned in the poetry of al-Ḫalāwī.</td><td><notr>4</notr></td></tr>
<tr><td><notr>HIP 677</notr></td><td><notr>المؤخر 2</notr></td><td><notr>al-Mwaḫḫar 2</notr></td><td>The Rear Bucket Mouth 2</td><td>See CON2504</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 1067</notr></td><td><notr>المؤخر 1</notr></td><td><notr>al-Mwaḫḫar 1</notr></td><td>The Rear Bucket Mouth 1</td><td>See CON2504</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 113881</notr></td><td><notr>المقدم 2</notr></td><td><notr>al-Mqaddam 2</notr></td><td>The Front Bucket Mouth 2</td><td>See CON2502</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 113963</notr></td><td><notr>المقدم 1</notr></td><td><notr>al-Mqaddam 1</notr></td><td>The Front Bucket Mouth 1</td><td>See CON2502</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 21421</notr></td><td><notr>التويبع</notr></td><td><notr>al-Twaibiʿ</notr></td><td>The Follower</td><td>The star Aldebaran, (second mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 21421</notr></td><td><notr>التويلي</notr></td><td><notr>al-Twailī</notr></td><td>The Latter</td><td>The star Aldebaran, (second mansion of the Moon)</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 21421</notr></td><td><notr>المجيدح</notr></td><td><notr>al-Mǧaidiḥ</notr></td><td>Al-Mjaidih</td><td>The star Aldebaran, (second mansion of the Moon), Name is used in al-Ṭayef region, western Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 36046</notr></td><td><notr>الاظفار 1</notr></td><td><notr>al-Aẓfār 1</notr></td><td>The Claws 1</td><td>Stars between α CMi (Procyon) and α Gem. The source is oral tradition of Najran, southwest of Saudi Arabia.</td><td><notr>1, 9</notr></td></tr>
<tr><td><notr>HIP 36962</notr></td><td><notr>الاظفار 2</notr></td><td><notr>al-Aẓfār 2</notr></td><td>The Claws 2</td><td>Stars between α CMi (Procyon) and α Gem. The source is oral tradition of Najran, southwest of Saudi Arabia.</td><td><notr>1, 9</notr></td></tr>
<tr><td><notr>HIP 37740</notr></td><td><notr>الاظفار 3</notr></td><td><notr>al-Aẓfār 3</notr></td><td>The Claws 3</td><td>Stars between α CMi (Procyon) and α Gem. The source is oral tradition of Najran, southwest of Saudi Arabia.</td><td><notr>1, 9</notr></td></tr>
<tr><td><notr>HIP 35550</notr></td><td><notr>الاظفار 4</notr></td><td><notr>al-Aẓfār 4</notr></td><td>The Claws 4</td><td>Stars between α CMi (Procyon) and α Gem. The source is oral tradition of Najran, southwest of Saudi Arabia.</td><td><notr>1, 9</notr></td></tr>
<tr><td><notr>HIP 34088</notr></td><td><notr>الاظفار 5</notr></td><td><notr>al-Aẓfār 5</notr></td><td>The Claws 5</td><td>Stars between α CMi (Procyon) and α Gem. The source is oral tradition of Najran, southwest of Saudi Arabia.</td><td><notr>1, 9</notr></td></tr>
<tr><td><notr>HIP 35350</notr></td><td><notr>الاظفار 6</notr></td><td><notr>al-Aẓfār 6</notr></td><td>The Claws 6</td><td>Stars between α CMi (Procyon) and α Gem. The source is oral tradition of Najran, southwest of Saudi Arabia.</td><td><notr>1, 9</notr></td></tr>
<tr><td><notr>HIP 57632</notr></td><td><notr>الصرفة</notr></td><td><notr>al-Ṣarfah</notr></td><td>Star Of Weather Change</td><td>(10th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 65474</notr></td><td><notr>السماك الأعزل</notr></td><td><notr>al-Smak al-ʿazal</notr></td><td>The High Unarmed One</td><td>(12th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 80763</notr></td><td><notr>القلب</notr></td><td><notr>al-Qalb</notr></td><td>The Heart</td><td>(16th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 85927</notr></td><td><notr>الشولة</notr></td><td><notr>al-Šawlah</notr></td><td>Raised Tail Of The Scorpion</td><td>(17th mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 26366</notr></td><td><notr>الهقعة</notr></td><td><notr>al-Haqʿah</notr></td><td>The Circular Mark</td><td>(third mansion of the Moon)</td><td><notr>2</notr></td></tr>
<tr><td><notr>HIP 27989</notr></td><td><notr>قرن الجوزا الشمالي</notr></td><td><notr>Qarn al-Ǧawza al-Šimalī</notr></td><td>Northern Horn Of Al-Jawza</td><td>Name of the star: α Ori, from the western region of Saudi Arabia and used by the fishers of the red sea. The source is oral tradition from the seaport Umluj of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 27989</notr></td><td><notr>زابن الجوزا الشمالي</notr></td><td><notr>Zabin al-Ǧawza al-Šimalī</notr></td><td>Northern Claw Of Al-Jawza</td><td>Name of the star: α Ori, this specific name "Northern Claw of al-Jawza" appeared in [#10], pg. 292.</td><td><notr>5</notr></td></tr>
<tr><td><notr>HIP 27366</notr></td><td><notr>رجل الجوزا</notr></td><td><notr>Riǧl al-Ǧawza</notr></td><td>Leg Of Al-Jawza</td><td>Name of the star: κ Ori, from the western region of Saudi Arabia and used by the fishers of the red sea. The source is oral tradition from the seaport Umluj of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 24436</notr></td><td><notr>قرن الجوزا الجنوبي</notr></td><td><notr>Qarn al-Ǧawza al-Ǧunūbī</notr></td><td>Southern Horn Of Al-Jawza</td><td>Name of the star: β Ori, from the western region of Saudi Arabia and used by the fishers of the red sea. The source is oral tradition from the seaport Umluj of Saudi Arabia.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 24436</notr></td><td><notr>زابن الجوزا الجنوبي</notr></td><td><notr>Zabin al-Ǧawza al-Ǧunūbī</notr></td><td>Southern Claw Of Al-Jawza</td><td>Name of the star: β Ori, this name is infered from the name of "Northern Claw of al-Jawza" for α Ori.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 32349</notr></td><td><notr>المرزم</notr></td><td><notr>al-Mirzam</notr></td><td>Al-Mirzam</td><td>A common name of α CMa (Sirius) used to time the period of the 5th lunar mansion.</td><td><notr>2, 3</notr></td></tr>
<tr><td><notr>HIP 32349</notr></td><td><notr>الشعلى</notr></td><td><notr>al-Šiʿla</notr></td><td>Al-Shi'la</td><td>Another name of α CMa (Sirius) used in the northern parts of the Arabian Peninsula.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 30438</notr></td><td><notr>سهيل</notr></td><td><notr>Shail</notr></td><td>Suhayl</td><td>The star α Car (Canopus). The name is of ancient origin.</td><td><notr>2, 3</notr></td></tr>
<tr><td><notr>HIP 7588</notr></td><td><notr>محلف</notr></td><td><notr>Miḥlif</notr></td><td>The Oath Star</td><td>A name of α Eri. It is named as such because people would confuse it with Suhayl (Canopus), resulting in an argument with some one making an oath that it is or is not Suhayl.</td><td><notr>4</notr></td></tr>
<tr><td><notr>HIP 7588</notr></td><td><notr>أبا السهل</notr></td><td><notr>Aba al-sihil</notr></td><td>Aba Alsihil</td><td>Another name of α Eri.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 7588</notr></td><td><notr>المسهل</notr></td><td><notr>al-Mishil</notr></td><td>Al-Miss.hil</td><td>Another name of α Eri.</td><td><notr>1</notr></td></tr>
<tr><td><notr>HIP 7588</notr></td><td><notr>السهلي</notr></td><td><notr>al-Shali</notr> (S here is pronounced as in same, not as in share)</td><td>As-S.hali</td><td>Another name of α Eri.</td><td><notr>3</notr></td></tr>
<tr><td><notr>HIP 68702</notr></td><td><notr>النعايم 1</notr></td><td><notr>al-Naʿāyem 1</notr></td><td>al-Naayem 1</td><td>A name for the two bright stars: α and β Cen. This name is used by the tribes of al-Dawāsir and Yām in the southern regions of Saudi Arabia, and should not be confused with the same name for the stars of the Big Dipper used by the tribes of central and northern regions of Saudi Arabia, or the name of ancient Arabs for the 18th Lunar mansion.</td><td><notr>10</notr></td></tr>
<tr><td><notr>HIP 71683</notr></td><td><notr>النعايم 2</notr></td><td><notr>al-Naʿāyem 2</notr></td><td>al-Naayem 2</td><td>A name for the two bright stars: α and β Cen. This name is used by the tribes of al-Dawāsir and Yām in the southern regions of Saudi Arabia, and should not be confused with the same name for the stars of the Big Dipper used by the tribes of central and northern regions of Saudi Arabia, or the name of ancient Arabs for the 18th Lunar mansion.</td><td><notr>10</notr></td></tr>
</table>

## References

 - [#1]: Oral tradition
 - [#2]: Al-Ajaji, Khalid, Šarḥ Qaṣidat al-Qāḍī fi al-anwāʾ wal-nuǧūm, Explanation of al-Qāḍī poem of anwāʾ and stars, Riyadh,  Saudi Arabia, 2013.,خالد بن عبد الله العجاجي، شرح قصيدة القاضي في الأنواء والنجوم، الرياض، المملكة العربية السعودية، 1434 هـ.
 - [#3]: Al-Ajaji, Khalid, Šarḥ Maʾthūrāt al-Ḫalāwī al-falakiyah, Explanation of al-Ḫalāwī astronomy poems, Riyadh,  Saudi Arabia, 2018.,خالد بن عبد الله العجاجي، شرح مأثورات الخلاوي الفلكية، الرياض، المملكة العربية السعودية، 1439 هـ.
 - [#4]: Ibn Ḫamīs, ʿAbd Allah b. Muḥammad, Rāshid al-Ḫalāwī, Riyadh,  Saudi Arabia, 2002.,عبدالله بن محمد بن خميس ، راشد الخلاوي ، الرياض، المملكة العربية السعودية، 1423 هـ.
 - [#5]: Al-Blādī, ʿAtiq b. Ġayth, Al-adab al-šaʿbī fi al-ḥiǧāz, Folk literature in Ḥijaz, Dar Makkah, Makkah, Saudi Arabia, 1982, عاتق بن غيث البلادي (ت 1431 ه)، الأدب الشعبي في الحجاز، دار مكة، مكة المكرمة، ط 2، 1402 هـ.
 - [#6]: Al-Suwaydā, ʿAbd al-Raḥman, Al-Amthāl al-šaʿbiyah al-sāʾirah fi manṭiqat Ḥāʾil, The local common proverbs of the Ḥayel region, Riyadh,  Saudi Arabia, 2007., عبد الرحمن بن زيد السويداء، الأمثال الشعبية السائرة في منطقة حائل، الرياض، المملكة العربية السعودية، 1428 هـ.
 - [#7]: Al-Ḥatim, ʿAbd Allah Khalid, Diwān ʿAbd Allah bin Ḥmūd al-Sbayel, The poetry collection of the poet ʿAbd Allah b. Ḥumūd al-Sbayel, 1984, عبدالله الخالد الحاتم ، ديوان عبدالله بن حمود السبيِّل، 1404 هـ.
 - [#8]: Al-Suwaydā, ʿAbd al-Raḥman, Šuʿarāʾ al-ǧabal al-šaʿbiyūn, The Poets of the mountain, 5 volume Poetry collection, Riyadh,  Saudi Arabia, 2013.,عبد الرحمن بن زيد السويداء، شعراء الجبل الشعبيون، الرياض، المملكة العربية السعودية، 1434 هـ.
 - [#9]: Al-ʿAnsī, Yaḥyā, Al-Maʿalim al-ziraʿiyah fi al-Yaman, Agricultural signs in Yemen, Yemen, 2010, يحيى العنسي، المعالم الزراعية في اليمن، اليمن، 1431 هـ.
 - [#10]: Ibn Bišir, ʿUṯmān ibn ʿAbd Allah (died 1873), ʿInwān al-maǧd fi tarīḫ Naǧd, The title of glory on the history of Najd, (Arabic critical edition print by Dr. Muḥammad ibn Nāṣir al-Šiṯrī), Riyadh, Saudi Arabia, 2012., ابن بشر، عثمان بن عبد الله بن بشر، عنوان المجد في تاريخ نجد، تحقيق الدكتور محمد بن ناصر الشثري، الرياض، المملكة العربية السعودية، 1433 هـ.
 - [#11]: Al-ʿUbūdī, Moḥammad b. Nāṣir, Al-Amthāl al-ʿāmiyah fi Naǧd, The folk proverbs in Najd, 4 volumes, Dar Al-Thulūthiyah, Riyadh, Saudi Arabia, 2010. محمد بن ناصر العبودي، الأمثال العامية في نجد، دار الثلوثية، الرياض، المملكة العربية السعودية، 1431 هـ.
 - [#12]: Al-ʿUbūdī, Moḥammad b. Nāṣir, Muʿǧam al-Uṣūl al-faṣīḥah lil-alfāẓ al-dariǧah, Lexicon of the classical root of the common dialect words, 13 volumes, King AbdulAzeez Library, Riyadh,  Saudi Arabia, 2009. محمد بن ناصر العبودي، معجم الأصول الفصيحة للألفاظ الدارجة، مكتبة الملك عبد العزيز، الرياض، المملكة العربية السعودية، 1430 هـ.
 - [#13]: Al-Azhār al-nadiyah min ashʿār al-badiyah, A collection of Bedouins poetry by the name: The moist flowers of Bedouin Poetry, 18 volumes, Al Ma'arif library, Tayef, Saudi Arabia. الأزهار النادية من أشعار البادية، مكتبة المعارف، الطائف، المملكة العربية السعودية.
 - [#14]: Min ādābinā al-shaʿbiyah fi al-ǧazīrah al-ʿarabiyah, A collection of poetry by Mandeel al-Fuhaid, Our local literature of the Arab peninsula, 10 volumes, Riyadh, Saudi Arabia. منديل بن محمد الفهيد، من آدابنا الشعبية في الجزيرة العربية.
 - [#15]: Al-Suwaydā, ʿAbd al-Raḥman, Durar min al-shiʿr al-shaʿbī, The best of folk poetry, 3 volume Poetry collection, Riyadh,  Saudi Arabia, 1999. عبد الرحمن بن زيد السويداء، درر من الشعر الشعبي، الرياض، المملكة العربية السعودية، 1420 هـ.
 - [#16]: Al-Hamdânîʼs Geographie der Arabischen Halbinsel, David Heinrich Müller, Leiden : E. J. Brill, 1884, pg. 47.
 - [#17]: Le Bon, Gustave, La civilisation des Arabes, Paris, Librairie de Firmin-Didot, 1884, livre premier, pg. 1.

## Authors

Khalid al-Ajaji, turath.alfalak@gmail.com.

## License

CC BY-NC-ND 4.0
