package TDS::Admin::Editor;
# $Id: Editor.pm,v 1.39.8.1 2001/02/20 12:15:03 tom Exp $
################################################################

=head1 NAME

TDS::Admin::Editor - editing user data on web

=cut

################################################################

use strict;

use vars qw(@ISA @EXPORT
	    %HelpDocument);

use Exporter;

use JConv;
use ObjectTemplate;
use DateTime::Format;
use SimpleDB::Append;
use CGI::QueryString;
use CGI::Tools;

use TDS::AccessLog::DirInfo;
use TDS::IdentInfo;
use TDS::DirInfo;
use TDS::Admin::Skelton;
use TDS::Admin::Authorize;
use TDS::Admin::FTP;
use TDS::Admin::WriteServer;
use TDS::Admin::WriteServer::Selector;
use TDS::Admin::DirInfo;

@ISA = qw(TDS::Admin::WriteServer::Selector);
#@ISA = qw(ObjectTemplate);
#@ISA = qw(TDS::Admin::DirInfo);
@EXPORT = qw(attributes);

%HelpDocument = ('todo'=>'function.html#todo',
		 'schedule'=>'function.html#schedule',
		 'term'=>'function.html#replace_term',
		 'url'=>'function.html#replace_url',
		 'dictionary'=>'function.html#dictionary',
#		 'information'=>'function.html#information',

		 'robotlist'=>'files.html#robotlist',
		 'author_id'=>'files.html#author_id',
		 'tdf'=>'tdf.html',

		 'skelton'=>'customize.html#skelton',
		 'summary_skelton'=>'customize.html#summary_skelton',
		 'dictionary_skelton'=>'customize.html#summary_skelton',
		 'editor_skelton'=>'customize.html#editor_skelton',
		 'log_skelton'=>'customize.html#log_skelton'
#		 'id_map'=>''
		 );

attributes qw();

################################################################
sub initialize_dum($)
{
    my $self = shift;

    if ($self->type eq 'dat'){
	$self->ext("dat") unless $self->ext;
    } elsif ($self->type eq 'conf'){
	$self->ext("conf") unless $self->conf;
    }
    $self->SUPER::initialize;
}

sub ShowForm
{
    my $self = shift;

    my $auth = new TDS::Admin::Authorize;
    $auth->CheckAuthorized;
    
    my $skelton = new TDS::Admin::Skelton(filename=>"editor_skelton.html");
    $skelton->Read;
    
    # Macros
    $skelton->SetMacro("BODY", sub {
	return $self->AsBody;
    });
    $skelton->SetMacro("WRITE_METHOD", sub {
	return TDS::Admin::WriteServer::GetWriteMethod();
    });
    $skelton->SetMacro("ACTION_CGI", sub {
	my $uri = $ENV{'REQUEST_URI'};
	$uri =~ s/\?.*$//;
	return $uri;
    });
    $skelton->SetMacro("KIND", $self->kind);
    $skelton->SetMacro("TYPE", $self->type);
    $skelton->SetMacro("FILENAME", $self->GetFilename);
    $skelton->SetMacro("WRITE_FILENAME", $self->GetWriteFilename);
    $skelton->SetMacro("STYLE", $TDS::Style::Name || 'undef');
    $skelton->SetMacro("DATE_LOAD_FORM", $self->AsDateLoadForm);
    $skelton->SetMacro("HELP_DOCUMENT", "${TDS::TDSHomePage}doc/" . $HelpDocument{$self->kind});
    $skelton->SetMacro("HIDDEN_DATA", sub {
	my @data;
	if ($self->additional_path){
	    push(@data, {name=>'additional_path',
			 value=>$self->additional_path});
	}
	if ($self->ext){
	    push(@data, {name=>'ext', value=>$self->ext});
	}
	my $line;
	for (@data){
	    $line .= sprintf(qq(<input type="hidden" name="%s" value="%s">\n),
			     $_->{name}, $_->{value});
	}
	return $line;
    });

    print $skelton->AsHTML;
}
sub AsDateLoadForm { return undef;}
sub AsBody($)
{
    my $self = shift;
    open(F, $self->GetFilename) || return;
    my $rtn = join('', <F>);
    close F;
    *jconv = mkjconv('auto', $TDS::System::InternalJcode);
    jconv(\$rtn);
    $rtn =  Escape($rtn);
    return $rtn;
    
}

################################################################
sub Write($$)
{
    my ($self, $body) = @_;

    $self->SUPER::Write($body);
    $self->Logging;

    # show confirmation
    $self->ShowConfirm($body);
}
################################################################
sub Logging()
{
    my $self = shift;

    my $date_str = time2str("%Y/%m/%d %H:%M:%S %Z", time(), $TDS::System::TZ);
    
    my $logfile = GetLogDir() . "/editor.log";
    my $ap = new SimpleDB::Append($logfile);
    $ap->Append(sprintf("%s\t%s\t%s\t%s\t%s\n",
			$date_str,
			$self->kind,
			&TDS::Admin::WriteServer::GetWriteMethod(),
			$self->AdditionalLogComment));
}
sub AdditionalLogComment($) { undef }
    
sub ShowConfirm($$)
{
    my ($self, $body) = @_;

    print "<h1>", TDS::Admin::WriteServer::GetWriteMethod(), " done</h1>";
    printf("<p>file: %s</p><hr>", $self->GetFilename);
    $self->ShowContent($body);
    print qq(<hr><a href="./">[admin]</a><a href="../">[diary]</a>);
}
sub ShowContent($$)
{
    my ($self, $body) = @_;

    $body = Escape($body);
    $body =~ s/\r\n/\n/g;
    $body =~ s/\r/\n/g;

    print "<pre>$body</pre>";
}
################################################################
1;


