/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.sax;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.ParsedPatternFuture;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.Uri;
import com.thaiopensource.xml.sax.AbstractLexicalHandler;
import com.thaiopensource.xml.sax.XmlBaseHandler;
import com.thaiopensource.xml.util.Naming;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class SchemaParser<Pattern, NameClass, Location, ElementAnnotation, CommentListImpl extends CommentList<Location>, AnnotationsImpl extends Annotations<Location, ElementAnnotation, CommentListImpl>>
implements ParsedPatternFuture<Pattern> {
    private static final String relaxngURIPrefix = "http://relaxng.org/ns/structure/1.0".substring(0, "http://relaxng.org/ns/structure/1.0".lastIndexOf(47) + 1);
    static final String relaxng10URI = "http://relaxng.org/ns/structure/1.0";
    private static final Localizer localizer = new Localizer(SchemaParser.class);
    private String relaxngURI;
    private final XMLReader xr;
    private final ErrorHandler eh;
    private final SchemaBuilder<Pattern, NameClass, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> schemaBuilder;
    private Pattern startPattern;
    private Locator locator;
    private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
    private final ContextImpl context = new ContextImpl();
    private boolean hadError = false;
    private Map<String, State> patternMap;
    private Map<String, State> nameClassMap;
    private static final int PATTERN_CONTEXT = 0;
    private static final int ANY_NAME_CONTEXT = 1;
    private static final int NS_NAME_CONTEXT = 2;

    private void initPatternTable() {
        this.patternMap = new HashMap<String, State>();
        this.patternMap.put("zeroOrMore", new ZeroOrMoreState());
        this.patternMap.put("oneOrMore", new OneOrMoreState());
        this.patternMap.put("optional", new OptionalState());
        this.patternMap.put("list", new ListState());
        this.patternMap.put("choice", new ChoiceState());
        this.patternMap.put("interleave", new InterleaveState());
        this.patternMap.put("group", new GroupState());
        this.patternMap.put("mixed", new MixedState());
        this.patternMap.put("element", new ElementState());
        this.patternMap.put("attribute", new AttributeState());
        this.patternMap.put("empty", new EmptyState());
        this.patternMap.put("text", new TextState());
        this.patternMap.put("value", new ValueState());
        this.patternMap.put("data", new DataState());
        this.patternMap.put("notAllowed", new NotAllowedState());
        this.patternMap.put("grammar", new GrammarState());
        this.patternMap.put("ref", new RefState());
        this.patternMap.put("parentRef", new ParentRefState());
        this.patternMap.put("externalRef", new ExternalRefState());
    }

    private void initNameClassTable() {
        this.nameClassMap = new HashMap<String, State>();
        this.nameClassMap.put("name", new NameState());
        this.nameClassMap.put("anyName", new AnyNameState());
        this.nameClassMap.put("nsName", new NsNameState());
        this.nameClassMap.put("choice", new NameClassChoiceState());
    }

    @Override
    public Pattern getParsedPattern() throws IllegalSchemaException {
        if (this.hadError) {
            throw new IllegalSchemaException();
        }
        return this.startPattern;
    }

    private void error(String string) throws SAXException {
        this.error(string, this.locator);
    }

    private void error(String string, String string2) throws SAXException {
        this.error(string, string2, this.locator);
    }

    void error(String string, String string2, String string3) throws SAXException {
        this.error(string, string2, string3, this.locator);
    }

    private void error(String string, Locator locator) throws SAXException {
        this.error(new SAXParseException(localizer.message(string), locator));
    }

    private void error(String string, String string2, Locator locator) throws SAXException {
        this.error(new SAXParseException(localizer.message(string, string2), locator));
    }

    private void error(String string, String string2, String string3, Locator locator) throws SAXException {
        this.error(new SAXParseException(localizer.message(string, string2, string3), locator));
    }

    private void error(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        if (this.eh != null) {
            this.eh.error(sAXParseException);
        }
    }

    void warning(String string) throws SAXException {
        this.warning(string, this.locator);
    }

    private void warning(String string, String string2) throws SAXException {
        this.warning(string, string2, this.locator);
    }

    private void warning(String string, String string2, String string3) throws SAXException {
        this.warning(string, string2, string3, this.locator);
    }

    private void warning(String string, Locator locator) throws SAXException {
        this.warning(new SAXParseException(localizer.message(string), locator));
    }

    private void warning(String string, String string2, Locator locator) throws SAXException {
        this.warning(new SAXParseException(localizer.message(string, string2), locator));
    }

    private void warning(String string, String string2, String string3, Locator locator) throws SAXException {
        this.warning(new SAXParseException(localizer.message(string, string2, string3), locator));
    }

    private void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.eh != null) {
            this.eh.warning(sAXParseException);
        }
    }

    SchemaParser(XMLReader xMLReader, ErrorHandler errorHandler, SchemaBuilder<Pattern, NameClass, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> schemaBuilder, IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> includedGrammar, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope) throws SAXException {
        this.xr = xMLReader;
        this.eh = errorHandler;
        this.schemaBuilder = schemaBuilder;
        if (errorHandler != null) {
            xMLReader.setErrorHandler(errorHandler);
        }
        xMLReader.setDTDHandler(this.context);
        if (schemaBuilder.usesComments()) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", new LexicalHandlerImpl());
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                this.warning("no_comment_support", xMLReader.getClass().getName());
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                this.warning("no_comment_support", xMLReader.getClass().getName());
            }
        }
        this.initPatternTable();
        this.initNameClassTable();
        new RootState(includedGrammar, scope, SchemaBuilder.INHERIT_NS).set();
    }

    private Context getContext() {
        return this.context;
    }

    private NameClass expandName(String string, String string2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
        int n = string.indexOf(58);
        if (n == -1) {
            return this.schemaBuilder.makeName(string2, this.checkNCName(string), null, null, AnnotationsImpl2);
        }
        String string3 = this.checkNCName(string.substring(0, n));
        String string4 = this.checkNCName(string.substring(n + 1));
        PrefixMapping prefixMapping = this.context.prefixMapping;
        while (prefixMapping != null) {
            if (prefixMapping.prefix.equals(string3)) {
                return this.schemaBuilder.makeName(prefixMapping.uri, string4, string3, null, AnnotationsImpl2);
            }
            prefixMapping = prefixMapping.next;
        }
        this.error("undefined_prefix", string3);
        return this.schemaBuilder.makeName("", string4, null, null, AnnotationsImpl2);
    }

    private String findPrefix(String string, String string2) {
        String string3 = null;
        if (string == null || string.equals("")) {
            PrefixMapping prefixMapping = this.context.prefixMapping;
            while (prefixMapping != null) {
                if (prefixMapping.uri.equals(string2)) {
                    string3 = prefixMapping.prefix;
                    break;
                }
                prefixMapping = prefixMapping.next;
            }
        } else {
            int n = string.indexOf(58);
            if (n > 0) {
                string3 = string.substring(0, n);
            }
        }
        return string3;
    }

    private String checkNCName(String string) throws SAXException {
        if (!Naming.isNcname(string)) {
            this.error("invalid_ncname", string);
        }
        return string;
    }

    private Location makeLocation() {
        if (this.locator == null) {
            return null;
        }
        return this.schemaBuilder.makeLocation(this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
    }

    private void checkUriNoFragmentId(String string) throws SAXException {
        this.checkUri(string);
        if (Uri.hasFragmentId(string)) {
            this.error("href_fragment_id");
        }
    }

    private void checkUri(String string) throws SAXException {
        if (!Uri.isValid(string)) {
            this.error("invalid_uri", string);
        }
    }

    class ContextImpl
    extends AbstractContext {
        ContextImpl() {
        }

        @Override
        public String getBaseUri() {
            return SchemaParser.this.xmlBaseHandler.getBaseUri();
        }
    }

    class ZeroOrMoreState
    extends PatternContainerState {
        ZeroOrMoreState() {
        }

        @Override
        State create() {
            return new ZeroOrMoreState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeZeroOrMore(super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }
    }

    class OneOrMoreState
    extends PatternContainerState {
        OneOrMoreState() {
        }

        @Override
        State create() {
            return new OneOrMoreState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeOneOrMore(super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }
    }

    class OptionalState
    extends PatternContainerState {
        OptionalState() {
        }

        @Override
        State create() {
            return new OptionalState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeOptional(super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }
    }

    class ListState
    extends PatternContainerState {
        ListState() {
        }

        @Override
        State create() {
            return new ListState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeList(super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }
    }

    class ChoiceState
    extends PatternContainerState {
        ChoiceState() {
        }

        @Override
        State create() {
            return new ChoiceState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeChoice(list, Location2, AnnotationsImpl2);
        }
    }

    class InterleaveState
    extends PatternContainerState {
        InterleaveState() {
        }

        @Override
        State create() {
            return new InterleaveState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) {
            return SchemaParser.this.schemaBuilder.makeInterleave(list, Location2, AnnotationsImpl2);
        }
    }

    class GroupState
    extends PatternContainerState {
        GroupState() {
        }

        @Override
        State create() {
            return new GroupState();
        }
    }

    class MixedState
    extends PatternContainerState {
        MixedState() {
        }

        @Override
        State create() {
            return new MixedState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeMixed(super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }
    }

    class ElementState
    extends PatternContainerState
    implements NameClassRef<NameClass> {
        NameClass nameClass;
        boolean nameClassWasAttribute;
        String name;

        ElementState() {
        }

        @Override
        void setName(String string) {
            this.name = string;
        }

        @Override
        public void setNameClass(NameClass NameClass2) {
            this.nameClass = NameClass2;
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.name != null) {
                this.nameClass = SchemaParser.this.expandName(this.name, this.getNs(), null);
                this.nameClassWasAttribute = true;
            } else {
                new NameClassChildState(this, this).set();
            }
        }

        @Override
        State create() {
            return new ElementState();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeElement(this.nameClass, super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            if (this.nameClassWasAttribute || this.childPatterns.size() > 0 || this.nameClass == null) {
                super.endForeignChild(ElementAnnotation2);
            } else {
                this.nameClass = SchemaParser.this.schemaBuilder.annotateAfterNameClass(this.nameClass, ElementAnnotation2);
            }
        }
    }

    class AttributeState
    extends PatternContainerState
    implements NameClassRef<NameClass> {
        NameClass nameClass;
        boolean nameClassWasAttribute;
        String name;

        AttributeState() {
        }

        @Override
        State create() {
            return new AttributeState();
        }

        @Override
        void setName(String string) {
            this.name = string;
        }

        @Override
        public void setNameClass(NameClass NameClass2) {
            this.nameClass = NameClass2;
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.name != null) {
                String string = this.ns != null ? this.ns : "";
                this.nameClass = SchemaParser.this.expandName(this.name, string, null);
                this.nameClassWasAttribute = true;
            } else {
                new NameClassChildState(this, this).set();
            }
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            if (this.nameClassWasAttribute || this.childPatterns.size() > 0 || this.nameClass == null) {
                super.endForeignChild(ElementAnnotation2);
            } else {
                this.nameClass = SchemaParser.this.schemaBuilder.annotateAfterNameClass(this.nameClass, ElementAnnotation2);
            }
        }

        @Override
        void end() throws SAXException {
            if (this.childPatterns.size() == 0) {
                this.endPatternChild(SchemaParser.this.schemaBuilder.makeText(this.startLocation, null));
            }
            super.end();
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return SchemaParser.this.schemaBuilder.makeAttribute(this.nameClass, super.buildPattern(list, Location2, null), Location2, AnnotationsImpl2);
        }

        @Override
        State createChildState(String string) throws SAXException {
            State state = super.createChildState(string);
            if (state != null && this.childPatterns.size() != 0) {
                SchemaParser.this.error("attribute_multi_pattern");
            }
            return state;
        }
    }

    class EmptyState
    extends EmptyContentState {
        EmptyState() {
        }

        @Override
        State create() {
            return new EmptyState();
        }

        @Override
        Pattern makePattern() {
            return SchemaParser.this.schemaBuilder.makeEmpty(this.startLocation, this.annotations);
        }
    }

    class TextState
    extends EmptyContentState {
        TextState() {
        }

        @Override
        State create() {
            return new TextState();
        }

        @Override
        Pattern makePattern() {
            return SchemaParser.this.schemaBuilder.makeText(this.startLocation, this.annotations);
        }
    }

    class ValueState
    extends EmptyContentState {
        final StringBuffer buf;
        String type;

        ValueState() {
            this.buf = new StringBuffer();
        }

        @Override
        State create() {
            return new ValueState();
        }

        @Override
        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("type")) {
                this.type = SchemaParser.this.checkNCName(string2.trim());
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.buf.append(cArray, n, n2);
        }

        @Override
        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("value_contains_foreign_element");
        }

        @Override
        Pattern makePattern() throws SAXException {
            if (this.type == null) {
                return this.makePattern("", "token");
            }
            return this.makePattern(this.datatypeLibrary, this.type);
        }

        @Override
        void end() throws SAXException {
            this.mergeLeadingComments();
            super.end();
        }

        Pattern makePattern(String string, String string2) {
            return SchemaParser.this.schemaBuilder.makeValue(string, string2, this.buf.toString(), SchemaParser.this.getContext(), this.getNs(), this.startLocation, this.annotations);
        }
    }

    class DataState
    extends State {
        String type;
        Pattern except;
        DataPatternBuilder<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> dpb;

        DataState() {
            this.except = null;
            this.dpb = null;
        }

        @Override
        State create() {
            return new DataState();
        }

        @Override
        State createChildState(String string) throws SAXException {
            if (string.equals("param")) {
                if (this.except != null) {
                    SchemaParser.this.error("param_after_except");
                }
                return new ParamState(this.dpb);
            }
            if (string.equals("except")) {
                if (this.except != null) {
                    SchemaParser.this.error("multiple_except");
                }
                return new ChoiceState();
            }
            SchemaParser.this.error("expected_param_except", string);
            return null;
        }

        @Override
        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("type")) {
                this.type = SchemaParser.this.checkNCName(string2.trim());
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.type == null) {
                SchemaParser.this.error("missing_type_attribute");
            } else {
                this.dpb = SchemaParser.this.schemaBuilder.makeDataPatternBuilder(this.datatypeLibrary, this.type, this.startLocation);
            }
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            this.dpb.annotation(ElementAnnotation2);
        }

        @Override
        void end() throws SAXException {
            Object object = this.dpb != null ? (this.except != null ? this.dpb.makePattern(this.except, this.startLocation, this.annotations) : this.dpb.makePattern(this.startLocation, this.annotations)) : SchemaParser.this.schemaBuilder.makeErrorPattern();
            this.parent.endPatternChild(object);
        }

        @Override
        void endPatternChild(Pattern Pattern2) {
            this.except = Pattern2;
        }
    }

    class NotAllowedState
    extends EmptyContentState {
        NotAllowedState() {
        }

        @Override
        State create() {
            return new NotAllowedState();
        }

        @Override
        Pattern makePattern() {
            return SchemaParser.this.schemaBuilder.makeNotAllowed(this.startLocation, this.annotations);
        }
    }

    class GrammarState
    extends GrammarSectionState {
        Grammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammar;

        GrammarState() {
        }

        @Override
        void setParent(State state) {
            super.setParent(state);
            this.section = this.grammar = SchemaParser.this.schemaBuilder.makeGrammar(this.scope);
            this.scope = this.grammar;
        }

        @Override
        State create() {
            return new GrammarState();
        }

        @Override
        void end() throws SAXException {
            super.end();
            this.parent.endPatternChild(this.grammar.endGrammar(this.startLocation, this.annotations));
        }
    }

    class RefState
    extends EmptyContentState {
        String name;

        RefState() {
        }

        @Override
        State create() {
            return new RefState();
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.name == null) {
                SchemaParser.this.error("missing_name_attribute");
            }
        }

        @Override
        void setName(String string) throws SAXException {
            this.name = SchemaParser.this.checkNCName(string);
        }

        @Override
        Pattern makePattern() {
            if (this.name == null) {
                return SchemaParser.this.schemaBuilder.makeErrorPattern();
            }
            return this.scope.makeRef(this.name, this.startLocation, this.annotations);
        }
    }

    class ParentRefState
    extends RefState {
        ParentRefState() {
        }

        @Override
        State create() {
            return new ParentRefState();
        }

        @Override
        Pattern makePattern() {
            if (this.name == null) {
                return SchemaParser.this.schemaBuilder.makeErrorPattern();
            }
            return this.scope.makeParentRef(this.name, this.startLocation, this.annotations);
        }
    }

    class ExternalRefState
    extends EmptyContentState {
        String href;
        String base;
        Pattern includedPattern;

        ExternalRefState() {
        }

        @Override
        State create() {
            return new ExternalRefState();
        }

        @Override
        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("href")) {
                this.href = string2;
                SchemaParser.this.checkUriNoFragmentId(this.href);
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.href == null) {
                SchemaParser.this.error("missing_href_attribute");
            } else {
                this.base = SchemaParser.this.xmlBaseHandler.getBaseUri();
            }
        }

        @Override
        Pattern makePattern() {
            if (this.href != null) {
                try {
                    return SchemaParser.this.schemaBuilder.makeExternalRef(this.href, this.base, this.getNs(), this.scope, this.startLocation, this.annotations);
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    // empty catch block
                }
            }
            return SchemaParser.this.schemaBuilder.makeErrorPattern();
        }
    }

    class NameState
    extends NameClassBaseState {
        final StringBuffer buf;

        NameState() {
            this.buf = new StringBuffer();
        }

        @Override
        State createChildState(String string) throws SAXException {
            SchemaParser.this.error("expected_name", string);
            return null;
        }

        @Override
        State create() {
            return new NameState();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.buf.append(cArray, n, n2);
        }

        @Override
        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("name_contains_foreign_element");
        }

        @Override
        NameClass makeNameClass() throws SAXException {
            this.mergeLeadingComments();
            return SchemaParser.this.expandName(this.buf.toString().trim(), this.getNs(), this.annotations);
        }
    }

    class AnyNameState
    extends NameClassBaseState {
        NameClass except;

        AnyNameState() {
            this.except = null;
        }

        @Override
        State create() {
            return new AnyNameState();
        }

        @Override
        State createChildState(String string) throws SAXException {
            if (string.equals("except")) {
                if (this.except != null) {
                    SchemaParser.this.error("multiple_except");
                }
                return new NameClassChoiceState(this.getContext());
            }
            SchemaParser.this.error("expected_except", string);
            return null;
        }

        int getContext() {
            return 1;
        }

        @Override
        NameClass makeNameClass() {
            if (this.except == null) {
                return this.makeNameClassNoExcept();
            }
            return this.makeNameClassExcept(this.except);
        }

        NameClass makeNameClassNoExcept() {
            return SchemaParser.this.schemaBuilder.makeAnyName(this.startLocation, this.annotations);
        }

        NameClass makeNameClassExcept(NameClass NameClass2) {
            return SchemaParser.this.schemaBuilder.makeAnyName(NameClass2, this.startLocation, this.annotations);
        }

        @Override
        void endNameClassChild(NameClass NameClass2) {
            this.except = NameClass2;
        }
    }

    class NsNameState
    extends AnyNameState {
        NsNameState() {
        }

        @Override
        State create() {
            return new NsNameState();
        }

        @Override
        NameClass makeNameClassNoExcept() {
            return SchemaParser.this.schemaBuilder.makeNsName(this.getNs(), null, null);
        }

        @Override
        NameClass makeNameClassExcept(NameClass NameClass2) {
            return SchemaParser.this.schemaBuilder.makeNsName(this.getNs(), NameClass2, null, null);
        }

        @Override
        int getContext() {
            return 2;
        }
    }

    class NameClassChoiceState
    extends NameClassContainerState {
        private List<NameClass> nameClasses;
        private int context;

        NameClassChoiceState() {
            this.nameClasses = new ArrayList();
            this.context = 0;
        }

        NameClassChoiceState(int n) {
            this.nameClasses = new ArrayList();
            this.context = n;
        }

        @Override
        NameClassChoiceState toNameClassChoiceState() {
            return this;
        }

        @Override
        void setParent(State state) {
            super.setParent(state);
            NameClassChoiceState nameClassChoiceState = state.toNameClassChoiceState();
            if (nameClassChoiceState != null) {
                this.context = nameClassChoiceState.context;
            }
        }

        @Override
        State create() {
            return new NameClassChoiceState();
        }

        @Override
        State createChildState(String string) throws SAXException {
            if (string.equals("anyName")) {
                if (this.context >= 1) {
                    SchemaParser.this.error(this.context == 1 ? "any_name_except_contains_any_name" : "ns_name_except_contains_any_name");
                    return null;
                }
            } else if (string.equals("nsName") && this.context == 2) {
                SchemaParser.this.error("ns_name_except_contains_ns_name");
                return null;
            }
            return super.createChildState(string);
        }

        @Override
        void endNameClassChild(NameClass NameClass2) {
            this.nameClasses.add(NameClass2);
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            int n = this.nameClasses.size();
            if (n == 0) {
                super.endForeignChild(ElementAnnotation2);
            } else {
                this.nameClasses.set(n - 1, SchemaParser.this.schemaBuilder.annotateAfterNameClass(this.nameClasses.get(n - 1), ElementAnnotation2));
            }
        }

        @Override
        void end() throws SAXException {
            if (this.nameClasses.size() == 0) {
                SchemaParser.this.error("missing_name_class");
                this.parent.endNameClassChild(SchemaParser.this.schemaBuilder.makeErrorNameClass());
                return;
            }
            if (this.comments != null) {
                int n = this.nameClasses.size();
                this.nameClasses.set(n - 1, SchemaParser.this.schemaBuilder.commentAfterNameClass(this.nameClasses.get(n - 1), this.comments));
                this.comments = null;
            }
            this.parent.endNameClassChild(SchemaParser.this.schemaBuilder.makeNameClassChoice(this.nameClasses, this.startLocation, this.annotations));
        }
    }

    class LexicalHandlerImpl
    extends AbstractLexicalHandler {
        private boolean inDtd = false;

        LexicalHandlerImpl() {
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.inDtd = true;
        }

        @Override
        public void endDTD() throws SAXException {
            this.inDtd = false;
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            if (!this.inDtd) {
                ((CommentHandler)((Object)SchemaParser.this.xr.getContentHandler())).comment(new String(cArray, n, n2));
            }
        }
    }

    class RootState
    extends PatternContainerState {
        IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammar;

        RootState() {
        }

        RootState(IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> includedGrammar, Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope, String string) {
            this.grammar = includedGrammar;
            this.scope = scope;
            this.nsInherit = string;
            this.datatypeLibrary = "";
        }

        @Override
        RootState toRootState() {
            return this;
        }

        @Override
        State create() {
            return new RootState();
        }

        @Override
        State createChildState(String string) throws SAXException {
            if (this.grammar == null) {
                return super.createChildState(string);
            }
            if (string.equals("grammar")) {
                return new MergeGrammarState(this.grammar);
            }
            SchemaParser.this.error("expected_grammar", string);
            return null;
        }

        @Override
        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("root_bad_namespace_uri", SchemaParser.relaxng10URI);
        }

        @Override
        void endPatternChild(Pattern Pattern2) {
            SchemaParser.this.startPattern = Pattern2;
        }

        @Override
        boolean isRelaxNGElement(String string) throws SAXException {
            if (!string.startsWith(relaxngURIPrefix)) {
                return false;
            }
            if (!string.equals(SchemaParser.relaxng10URI)) {
                SchemaParser.this.warning("wrong_uri_version", SchemaParser.relaxng10URI.substring(relaxngURIPrefix.length()), string.substring(relaxngURIPrefix.length()));
            }
            SchemaParser.this.relaxngURI = string;
            return true;
        }
    }

    static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping next;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.uri = string2;
            this.next = prefixMapping;
        }
    }

    abstract class NameClassBaseState
    extends State {
        NameClassBaseState() {
        }

        abstract NameClass makeNameClass() throws SAXException;

        @Override
        void end() throws SAXException {
            this.parent.endNameClassChild(this.makeNameClass());
        }
    }

    class NameClassChildState
    extends NameClassContainerState {
        final State prevState;
        final NameClassRef<NameClass> nameClassRef;

        @Override
        State create() {
            return null;
        }

        NameClassChildState(State state, NameClassRef<NameClass> nameClassRef) {
            this.prevState = state;
            this.nameClassRef = nameClassRef;
            this.setParent(state.parent);
            this.ns = state.ns;
        }

        @Override
        void endNameClassChild(NameClass NameClass2) {
            this.nameClassRef.setNameClass(NameClass2);
            this.prevState.set();
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            this.prevState.endForeignChild(ElementAnnotation2);
        }

        @Override
        void end() throws SAXException {
            this.nameClassRef.setNameClass(SchemaParser.this.schemaBuilder.makeErrorNameClass());
            SchemaParser.this.error("missing_name_class");
            this.prevState.set();
            this.prevState.end();
        }
    }

    abstract class NameClassContainerState
    extends State {
        NameClassContainerState() {
        }

        @Override
        State createChildState(String string) throws SAXException {
            State state = (State)SchemaParser.this.nameClassMap.get(string);
            if (state == null) {
                SchemaParser.this.error("expected_name_class", string);
                return null;
            }
            return state.create();
        }
    }

    class StartState
    extends DefinitionState {
        StartState(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection) {
            super(grammarSection);
        }

        @Override
        State create() {
            return new StartState(null);
        }

        @Override
        void sendPatternToParent(Pattern Pattern2) {
            this.section.define("#start", this.combine, Pattern2, this.startLocation, this.annotations);
        }

        @Override
        State createChildState(String string) throws SAXException {
            State state = super.createChildState(string);
            if (state != null && this.childPatterns.size() != 0) {
                SchemaParser.this.error("start_multi_pattern");
            }
            return state;
        }
    }

    class DefineState
    extends DefinitionState {
        String name;

        DefineState(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection) {
            super(grammarSection);
        }

        @Override
        State create() {
            return new DefineState(null);
        }

        @Override
        void setName(String string) throws SAXException {
            this.name = SchemaParser.this.checkNCName(string);
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.name == null) {
                SchemaParser.this.error("missing_name_attribute");
            }
        }

        @Override
        void sendPatternToParent(Pattern Pattern2) {
            if (this.name != null) {
                this.section.define(this.name, this.combine, Pattern2, this.startLocation, this.annotations);
            }
        }
    }

    abstract class DefinitionState
    extends PatternContainerState {
        GrammarSection.Combine combine;
        final GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> section;

        DefinitionState(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection) {
            this.combine = null;
            this.section = grammarSection;
        }

        @Override
        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("combine")) {
                if ((string2 = string2.trim()).equals("choice")) {
                    this.combine = GrammarSection.COMBINE_CHOICE;
                } else if (string2.equals("interleave")) {
                    this.combine = GrammarSection.COMBINE_INTERLEAVE;
                } else {
                    SchemaParser.this.error("combine_attribute_bad_value", string2);
                }
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        @Override
        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            return super.buildPattern(list, Location2, null);
        }
    }

    class MergeGrammarState
    extends GrammarSectionState {
        final IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammar;

        MergeGrammarState(IncludedGrammar<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> includedGrammar) {
            super(includedGrammar);
            this.grammar = includedGrammar;
        }

        @Override
        void end() throws SAXException {
            super.end();
            this.parent.endPatternChild(this.grammar.endIncludedGrammar(this.startLocation, this.annotations));
        }
    }

    class IncludeState
    extends GrammarSectionState {
        String href;
        String base;
        final Include<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> include;

        IncludeState(Include<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> include) {
            super(include);
            this.include = include;
        }

        @Override
        void setOtherAttribute(String string, String string2) throws SAXException {
            if (string.equals("href")) {
                this.href = string2;
                SchemaParser.this.checkUriNoFragmentId(this.href);
            } else {
                super.setOtherAttribute(string, string2);
            }
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.href == null) {
                SchemaParser.this.error("missing_href_attribute");
            } else {
                this.base = SchemaParser.this.xmlBaseHandler.getBaseUri();
            }
        }

        @Override
        void end() throws SAXException {
            super.end();
            if (this.href != null) {
                try {
                    this.include.endInclude(this.href, this.base, this.getNs(), this.startLocation, this.annotations);
                }
                catch (IllegalSchemaException illegalSchemaException) {
                    // empty catch block
                }
            }
        }
    }

    class DivState
    extends GrammarSectionState {
        final Div<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> div;

        DivState(Div<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> div) {
            super(div);
            this.div = div;
        }

        @Override
        void end() throws SAXException {
            super.end();
            this.div.endDiv(this.startLocation, this.annotations);
        }
    }

    class GrammarSectionState
    extends State {
        GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> section;

        GrammarSectionState() {
        }

        GrammarSectionState(GrammarSection<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> grammarSection) {
            this.section = grammarSection;
        }

        @Override
        State create() {
            return new GrammarSectionState(null);
        }

        @Override
        State createChildState(String string) throws SAXException {
            Include include;
            if (string.equals("define")) {
                return new DefineState(this.section);
            }
            if (string.equals("start")) {
                return new StartState(this.section);
            }
            if (string.equals("include") && (include = this.section.makeInclude()) != null) {
                return new IncludeState(include);
            }
            if (string.equals("div")) {
                return new DivState(this.section.makeDiv());
            }
            SchemaParser.this.error("expected_define", string);
            return null;
        }

        @Override
        void end() throws SAXException {
            if (this.comments != null) {
                this.section.topLevelComment(this.comments);
                this.comments = null;
            }
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            this.section.topLevelAnnotation(ElementAnnotation2);
        }
    }

    abstract class SinglePatternContainerState
    extends PatternContainerState {
        SinglePatternContainerState() {
        }

        @Override
        State createChildState(String string) throws SAXException {
            if (this.childPatterns.size() == 0) {
                return super.createChildState(string);
            }
            SchemaParser.this.error("too_many_children");
            return null;
        }
    }

    class ParamState
    extends State {
        private final StringBuffer buf;
        private final DataPatternBuilder<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> dpb;
        private String name;

        ParamState(DataPatternBuilder<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> dataPatternBuilder) {
            this.buf = new StringBuffer();
            this.dpb = dataPatternBuilder;
        }

        @Override
        State create() {
            return new ParamState(null);
        }

        @Override
        void setName(String string) throws SAXException {
            this.name = SchemaParser.this.checkNCName(string);
        }

        @Override
        void endAttributes() throws SAXException {
            if (this.name == null) {
                SchemaParser.this.error("missing_name_attribute");
            }
        }

        @Override
        State createChildState(String string) throws SAXException {
            SchemaParser.this.error("expected_empty", string);
            return null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.buf.append(cArray, n, n2);
        }

        @Override
        void checkForeignElement() throws SAXException {
            SchemaParser.this.error("param_contains_foreign_element");
        }

        @Override
        void end() throws SAXException {
            if (this.name == null) {
                return;
            }
            if (this.dpb == null) {
                return;
            }
            this.mergeLeadingComments();
            this.dpb.addParam(this.name, this.buf.toString(), SchemaParser.this.getContext(), this.getNs(), this.startLocation, this.annotations);
        }
    }

    static interface NameClassRef<NC> {
        public void setNameClass(NC var1);
    }

    abstract class PatternContainerState
    extends State {
        List<Pattern> childPatterns;

        PatternContainerState() {
            this.childPatterns = new ArrayList();
        }

        @Override
        State createChildState(String string) throws SAXException {
            State state = (State)SchemaParser.this.patternMap.get(string);
            if (state == null) {
                SchemaParser.this.error("expected_pattern", string);
                return null;
            }
            return state.create();
        }

        Pattern buildPattern(List<Pattern> list, Location Location2, AnnotationsImpl AnnotationsImpl2) throws SAXException {
            if (list.size() == 1 && AnnotationsImpl2 == null) {
                return list.get(0);
            }
            return SchemaParser.this.schemaBuilder.makeGroup(list, Location2, AnnotationsImpl2);
        }

        @Override
        void endPatternChild(Pattern Pattern2) {
            this.childPatterns.add(Pattern2);
        }

        @Override
        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            int n = this.childPatterns.size();
            if (n == 0) {
                super.endForeignChild(ElementAnnotation2);
            } else {
                this.childPatterns.set(n - 1, SchemaParser.this.schemaBuilder.annotateAfterPattern(this.childPatterns.get(n - 1), ElementAnnotation2));
            }
        }

        @Override
        void end() throws SAXException {
            if (this.childPatterns.size() == 0) {
                SchemaParser.this.error("missing_children");
                this.endPatternChild(SchemaParser.this.schemaBuilder.makeErrorPattern());
            }
            if (this.comments != null) {
                int n = this.childPatterns.size();
                this.childPatterns.set(n - 1, SchemaParser.this.schemaBuilder.commentAfterPattern(this.childPatterns.get(n - 1), this.comments));
                this.comments = null;
            }
            this.sendPatternToParent(this.buildPattern(this.childPatterns, this.startLocation, this.annotations));
        }

        void sendPatternToParent(Pattern Pattern2) {
            this.parent.endPatternChild(Pattern2);
        }
    }

    abstract class EmptyContentState
    extends State {
        EmptyContentState() {
        }

        @Override
        State createChildState(String string) throws SAXException {
            SchemaParser.this.error("expected_empty", string);
            return null;
        }

        abstract Pattern makePattern() throws SAXException;

        @Override
        void end() throws SAXException {
            if (this.comments != null) {
                if (this.annotations == null) {
                    this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(null, SchemaParser.this.getContext());
                }
                this.annotations.addComment(this.comments);
                this.comments = null;
            }
            this.parent.endPatternChild(this.makePattern());
        }
    }

    class Skipper
    extends DefaultHandler
    implements CommentHandler {
        int level = 1;
        final State nextState;

        Skipper(State state) {
            this.nextState = state;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.level;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (--this.level == 0) {
                this.nextState.set();
            }
        }

        @Override
        public void comment(String string) {
        }
    }

    static class ForeignElementHandler
    extends Handler {
        final State nextState;
        ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl> builder;
        final Stack<ElementAnnotationBuilder<Location, ElementAnnotation, CommentListImpl>> builderStack;
        StringBuffer textBuf;
        Location textLoc;
        final /* synthetic */ SchemaParser this$0;

        ForeignElementHandler(State state, CommentListImpl CommentListImpl2) {
            this.this$0 = var1_1;
            this.builderStack = new Stack();
            this.nextState = state;
            this.comments = CommentListImpl2;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.flushText();
            if (this.builder != null) {
                this.builderStack.push(this.builder);
            }
            Object object = this.this$0.makeLocation();
            this.builder = this.this$0.schemaBuilder.makeElementAnnotationBuilder(string, string2, this.this$0.findPrefix(string3, string), object, this.getComments(), this.this$0.getContext());
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getURI(i);
                this.builder.addAttribute(string4, attributes.getLocalName(i), this.this$0.findPrefix(attributes.getQName(i), string4), attributes.getValue(i), object);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.flushText();
            if (this.comments != null) {
                this.builder.addComment(this.getComments());
            }
            Object ElementAnnotation2 = this.builder.makeElementAnnotation();
            if (this.builderStack.empty()) {
                this.nextState.endForeignChild(ElementAnnotation2);
                this.nextState.set();
            } else {
                this.builder = this.builderStack.pop();
                this.builder.addElement(ElementAnnotation2);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.textBuf == null) {
                this.textBuf = new StringBuffer();
            }
            this.textBuf.append(cArray, n, n2);
            if (this.textLoc == null) {
                this.textLoc = this.this$0.makeLocation();
            }
        }

        @Override
        public void comment(String string) {
            this.flushText();
            super.comment(string);
        }

        void flushText() {
            if (this.textBuf != null && this.textBuf.length() != 0) {
                this.builder.addText(this.textBuf.toString(), this.textLoc, this.getComments());
                this.textBuf.setLength(0);
            }
            this.textLoc = null;
        }
    }

    abstract class State
    extends Handler {
        State parent;
        String nsInherit;
        String ns;
        String datatypeLibrary;
        Scope<Pattern, Location, ElementAnnotation, CommentListImpl, AnnotationsImpl> scope;
        Location startLocation;
        AnnotationsImpl annotations;

        State() {
        }

        void set() {
            SchemaParser.this.xr.setContentHandler(this);
        }

        abstract State create();

        abstract State createChildState(String var1) throws SAXException;

        RootState toRootState() {
            return null;
        }

        NameClassChoiceState toNameClassChoiceState() {
            return null;
        }

        void setParent(State state) {
            this.parent = state;
            this.nsInherit = state.getNs();
            this.datatypeLibrary = state.datatypeLibrary;
            this.scope = state.scope;
            this.startLocation = SchemaParser.this.makeLocation();
            if (state.comments != null) {
                this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(state.comments, SchemaParser.this.getContext());
                state.comments = null;
            } else if (state.toRootState() != null) {
                this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(null, SchemaParser.this.getContext());
            }
        }

        String getNs() {
            return this.ns == null ? this.nsInherit : this.ns;
        }

        boolean isRelaxNGElement(String string) throws SAXException {
            return string.equals(SchemaParser.this.relaxngURI);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            SchemaParser.this.xmlBaseHandler.startElement();
            if (this.isRelaxNGElement(string)) {
                State state = this.createChildState(string2);
                if (state == null) {
                    SchemaParser.this.xr.setContentHandler(new Skipper(this));
                    return;
                }
                state.setParent(this);
                state.set();
                state.attributes(attributes);
            } else {
                this.checkForeignElement();
                ForeignElementHandler foreignElementHandler = new ForeignElementHandler(SchemaParser.this, this, this.getComments());
                foreignElementHandler.startElement(string, string2, string3, attributes);
                SchemaParser.this.xr.setContentHandler(foreignElementHandler);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            SchemaParser.this.xmlBaseHandler.endElement();
            this.parent.set();
            this.end();
        }

        void setName(String string) throws SAXException {
            SchemaParser.this.error("illegal_name_attribute");
        }

        void setOtherAttribute(String string, String string2) throws SAXException {
            SchemaParser.this.error("illegal_attribute_ignored", string);
        }

        void endAttributes() throws SAXException {
        }

        void checkForeignElement() throws SAXException {
        }

        void attributes(Attributes attributes) throws SAXException {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getURI(i);
                if (string.length() == 0) {
                    String string2 = attributes.getLocalName(i);
                    if (string2.equals("name")) {
                        this.setName(attributes.getValue(i).trim());
                        continue;
                    }
                    if (string2.equals("ns")) {
                        this.ns = attributes.getValue(i);
                        continue;
                    }
                    if (string2.equals("datatypeLibrary")) {
                        this.datatypeLibrary = attributes.getValue(i);
                        SchemaParser.this.checkUri(this.datatypeLibrary);
                        if (!this.datatypeLibrary.equals("") && !Uri.isAbsolute(this.datatypeLibrary)) {
                            SchemaParser.this.error("relative_datatype_library");
                        }
                        if (Uri.hasFragmentId(this.datatypeLibrary)) {
                            SchemaParser.this.error("fragment_identifier_datatype_library");
                        }
                        this.datatypeLibrary = Uri.escapeDisallowedChars(this.datatypeLibrary);
                        continue;
                    }
                    this.setOtherAttribute(string2, attributes.getValue(i));
                    continue;
                }
                if (string.equals(SchemaParser.this.relaxngURI)) {
                    SchemaParser.this.error("qualified_attribute", attributes.getLocalName(i));
                    continue;
                }
                if (string.equals("http://www.w3.org/XML/1998/namespace") && attributes.getLocalName(i).equals("base")) {
                    SchemaParser.this.xmlBaseHandler.xmlBaseAttribute(attributes.getValue(i));
                    continue;
                }
                if (this.annotations == null) {
                    this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(null, SchemaParser.this.getContext());
                }
                this.annotations.addAttribute(string, attributes.getLocalName(i), SchemaParser.this.findPrefix(attributes.getQName(i), string), attributes.getValue(i), this.startLocation);
            }
            this.endAttributes();
        }

        abstract void end() throws SAXException;

        void endPatternChild(Pattern Pattern2) {
        }

        void endNameClassChild(NameClass NameClass2) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
            if (this.comments != null && SchemaParser.this.startPattern != null) {
                SchemaParser.this.startPattern = SchemaParser.this.schemaBuilder.commentAfterPattern(SchemaParser.this.startPattern, this.comments);
                this.comments = null;
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            block3: for (int i = 0; i < n2; ++i) {
                switch (cArray[n + i]) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        SchemaParser.this.error("illegal_characters_ignored");
                    }
                }
            }
        }

        boolean isPatternNamespaceURI(String string) {
            return string.equals(SchemaParser.this.relaxngURI);
        }

        void endForeignChild(ElementAnnotation ElementAnnotation2) {
            if (this.annotations == null) {
                this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(null, SchemaParser.this.getContext());
            }
            this.annotations.addElement(ElementAnnotation2);
        }

        void mergeLeadingComments() {
            if (this.comments != null) {
                if (this.annotations == null) {
                    this.annotations = SchemaParser.this.schemaBuilder.makeAnnotations(this.comments, SchemaParser.this.getContext());
                } else {
                    this.annotations.addLeadingComment((CommentList)this.comments);
                }
                this.comments = null;
            }
        }
    }

    abstract class Handler
    implements ContentHandler,
    CommentHandler {
        CommentListImpl comments;

        Handler() {
        }

        CommentListImpl getComments() {
            Object CommentListImpl2 = this.comments;
            this.comments = null;
            return CommentListImpl2;
        }

        @Override
        public void comment(String string) {
            if (this.comments == null) {
                this.comments = SchemaParser.this.schemaBuilder.makeCommentList();
            }
            this.comments.addComment(string, (Object)SchemaParser.this.makeLocation());
        }

        @Override
        public void processingInstruction(String string, String string2) {
        }

        @Override
        public void skippedEntity(String string) {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
            ((SchemaParser)SchemaParser.this).context.prefixMapping = new PrefixMapping(string, string2, ((SchemaParser)SchemaParser.this).context.prefixMapping);
        }

        @Override
        public void endPrefixMapping(String string) {
            ((SchemaParser)SchemaParser.this).context.prefixMapping = ((SchemaParser)SchemaParser.this).context.prefixMapping.next;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            SchemaParser.this.locator = locator;
            SchemaParser.this.xmlBaseHandler.setLocator(locator);
        }
    }

    static interface CommentHandler {
        public void comment(String var1);
    }

    static class SavedContext
    extends AbstractContext {
        private final String baseUri;

        SavedContext(AbstractContext abstractContext) {
            super(abstractContext);
            this.baseUri = abstractContext.getBaseUri();
        }

        @Override
        public String getBaseUri() {
            return this.baseUri;
        }
    }

    static abstract class AbstractContext
    extends DtdContext
    implements Context {
        PrefixMapping prefixMapping;

        AbstractContext() {
            this.prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
        }

        AbstractContext(AbstractContext abstractContext) {
            super(abstractContext);
            this.prefixMapping = abstractContext.prefixMapping;
        }

        @Override
        public String resolveNamespacePrefix(String string) {
            PrefixMapping prefixMapping = this.prefixMapping;
            while (prefixMapping != null) {
                if (prefixMapping.prefix.equals(string)) {
                    return prefixMapping.uri;
                }
                prefixMapping = prefixMapping.next;
            }
            return null;
        }

        @Override
        public Set<String> prefixes() {
            HashSet<String> hashSet = new HashSet<String>();
            PrefixMapping prefixMapping = this.prefixMapping;
            while (prefixMapping != null) {
                hashSet.add(prefixMapping.prefix);
                prefixMapping = prefixMapping.next;
            }
            return hashSet;
        }

        @Override
        public Context copy() {
            return new SavedContext(this);
        }
    }
}

