/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_CORE_PTR_H
#define VATOMIC_CORE_PTR_H
/*******************************************************************************
 * @file core_ptr.h
 * @brief Atomic functions for vatomicptr_t variables.
 *
 * This file declares and documents the core atomic functions operating on
 * vatomicptr_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/core.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#ifndef VATOMIC_CORE_H
    #error "File included directly. Include <vsync/atomic/core.h> instead!"
#endif

/**
 * Initializes the atomic variable a with value v.
 *
 * The initialization is equivalent to an vatomicptr_write().
 *
 * @param a atomic variable
 * @param v initial value
 * @memord seq_cst
 */
static inline void vatomicptr_init(vatomicptr_t *a, void *v);

/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
static inline void *vatomicptr_read(const vatomicptr_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
static inline void *vatomicptr_read_acq(const vatomicptr_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
static inline void *vatomicptr_read_rlx(const vatomicptr_t *a);

/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
static inline void vatomicptr_write(vatomicptr_t *a, void *v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
static inline void vatomicptr_write_rel(vatomicptr_t *a, void *v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
static inline void vatomicptr_write_rlx(vatomicptr_t *a, void *v);

/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
static inline void *vatomicptr_xchg(vatomicptr_t *a, void *v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
static inline void *vatomicptr_xchg_acq(vatomicptr_t *a, void *v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
static inline void *vatomicptr_xchg_rel(vatomicptr_t *a, void *v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
static inline void *vatomicptr_xchg_rlx(vatomicptr_t *a, void *v);

/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline void *vatomicptr_cmpxchg(vatomicptr_t *a, void *e, void *v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline void *vatomicptr_cmpxchg_acq(vatomicptr_t *a, void *e, void *v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline void *vatomicptr_cmpxchg_rel(vatomicptr_t *a, void *e, void *v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline void *vatomicptr_cmpxchg_rlx(vatomicptr_t *a, void *e, void *v);

#endif
