/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.connectioncache.client;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.connectioncache.client.CacheableConnectorHandlerPool;
import com.sun.grizzly.connectioncache.spi.transport.ContactInfo;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableConnectorHandler
implements ConnectorHandler<SelectorHandler, CallbackHandler>,
CallbackHandler {
    private SocketAddress targetAddress;
    private Controller.Protocol protocol;
    private CacheableConnectorHandlerPool parentPool;
    private ConnectorHandler underlyingConnectorHandler;
    private CallbackHandler underlyingCallbackHandler;
    private ConnectExecutor connectExecutor;

    public CacheableConnectorHandler(CacheableConnectorHandlerPool parentPool) {
        this.parentPool = parentPool;
        this.connectExecutor = new ConnectExecutor();
    }

    void setProtocol(Controller.Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public Controller.Protocol protocol() {
        return this.protocol;
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, callbackHandler, selectorHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CallbackHandler callbackHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, callbackHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connectExecutor.setParameters(remoteAddress);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, localAddress, callbackHandler, selectorHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, localAddress, callbackHandler);
        this.doConnect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        this.connectExecutor.setParameters(remoteAddress, localAddress);
        this.doConnect(remoteAddress);
    }

    public void release(int expectedResponseCount) {
        this.parentPool.getOutboundConnectionCache().release(this.underlyingConnectorHandler, expectedResponseCount);
    }

    public void responseReceived() {
        this.parentPool.getOutboundConnectionCache().responseReceived(this.underlyingConnectorHandler);
    }

    private void doConnect(SocketAddress targetAddress) throws IOException {
        this.targetAddress = targetAddress;
        this.underlyingCallbackHandler = this.connectExecutor.callbackHandler;
        this.underlyingConnectorHandler = this.parentPool.getOutboundConnectionCache().get(new CacheableConnectorInfo(this.parentPool, this.connectExecutor, this.protocol, targetAddress), this.parentPool.getConnectionFinder());
        if (!this.connectExecutor.wasCalled()) {
            this.underlyingConnectorHandler.setCallbackHandler(this);
            this.notifyCallbackHandlerPseudoConnect();
        }
    }

    @Override
    public void close() throws IOException {
        this.parentPool.getOutboundConnectionCache().release(this.underlyingConnectorHandler, 0);
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        return this.underlyingConnectorHandler.read(byteBuffer, blocking);
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        return this.underlyingConnectorHandler.write(byteBuffer, blocking);
    }

    @Override
    public void finishConnect(SelectionKey key) {
        if (this.connectExecutor.wasCalled()) {
            try {
                this.underlyingConnectorHandler.finishConnect(key);
            }
            catch (IOException ex) {
                Controller.logger().severe(ex.getMessage());
            }
        }
    }

    @Override
    public void setController(Controller controller) {
        this.underlyingConnectorHandler.setController(controller);
    }

    @Override
    public Controller getController() {
        return this.underlyingConnectorHandler.getController();
    }

    public ConnectorHandler getUnderlyingConnectorHandler() {
        return this.underlyingConnectorHandler;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.underlyingConnectorHandler.getUnderlyingChannel();
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.underlyingConnectorHandler.getCallbackHandler();
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.underlyingConnectorHandler.setCallbackHandler(callbackHandler);
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.underlyingConnectorHandler.getSelectorHandler();
    }

    private void notifyCallbackHandlerPseudoConnect() throws ClosedChannelException {
        Selector protocolSelector = this.underlyingConnectorHandler.getSelectorHandler().getSelector();
        SelectionKey key = this.underlyingConnectorHandler.getUnderlyingChannel().keyFor(protocolSelector);
        if (key == null) {
            key = this.underlyingConnectorHandler.getUnderlyingChannel().register(protocolSelector, 8);
        }
        assert (key != null);
        key.attach((Object)CallbackHandlerSelectionKeyAttachment.create(this));
        Context context = this.parentPool.getController().pollContext(key);
        this.onConnect((IOEvent)new IOEvent.DefaultIOEvent<Context>(context));
    }

    public void onConnect(IOEvent ioEvent) {
        if (this.underlyingCallbackHandler == null) {
            this.underlyingCallbackHandler = new CallbackHandler<Context>(){

                @Override
                public void onConnect(IOEvent<Context> ioEvent) {
                    SelectionKey key = ioEvent.attachment().getSelectionKey();
                    CacheableConnectorHandler.this.finishConnect(key);
                    ioEvent.attachment().getSelectorHandler().register(key, 1);
                }

                @Override
                public void onRead(IOEvent<Context> ioEvent) {
                }

                @Override
                public void onWrite(IOEvent<Context> ioEvent) {
                }
            };
        }
        this.underlyingCallbackHandler.onConnect(ioEvent);
    }

    public void onRead(IOEvent ioEvent) {
        this.underlyingCallbackHandler.onRead(ioEvent);
    }

    public void onWrite(IOEvent ioEvent) {
        this.underlyingCallbackHandler.onWrite(ioEvent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheableConnectorInfo
    implements ContactInfo<ConnectorHandler> {
        private SelectorHandler selectorHandler;
        private CacheableConnectorHandlerPool parentPool;
        private ConnectExecutor connectExecutor;
        private Controller.Protocol protocol;
        private SocketAddress targetAddress;

        public CacheableConnectorInfo(CacheableConnectorHandlerPool parentPool, ConnectExecutor connectExecutor, Controller.Protocol protocol, SocketAddress targetAddress) {
            this.parentPool = parentPool;
            this.connectExecutor = connectExecutor;
            this.protocol = protocol;
            this.targetAddress = targetAddress;
        }

        @Override
        public ConnectorHandler createConnection() throws IOException {
            Object connectorHandler = this.parentPool.getProtocolConnectorHandlerPool().acquireConnectorHandler(this.protocol);
            this.connectExecutor.setConnectorHandler((ConnectorHandler)connectorHandler);
            this.connectExecutor.invokeProtocolConnect();
            this.selectorHandler = connectorHandler.getSelectorHandler();
            return connectorHandler;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append(" targetAddress: ");
            sb.append(this.targetAddress);
            sb.append(" protocol: ");
            sb.append((Object)this.protocol);
            sb.append(" hashCode: ");
            sb.append(super.hashCode());
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheableConnectorInfo other = (CacheableConnectorInfo)obj;
            if (this.selectorHandler != null && other.selectorHandler != null && this.selectorHandler != other.selectorHandler && !this.selectorHandler.equals(other.selectorHandler)) {
                return false;
            }
            if (this.protocol != other.protocol) {
                return false;
            }
            return this.targetAddress == other.targetAddress || this.targetAddress != null && this.targetAddress.equals(other.targetAddress);
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + (this.protocol != null ? this.protocol.hashCode() : 0);
            hash = 47 * hash + (this.targetAddress != null ? this.targetAddress.hashCode() : 0);
            return hash;
        }
    }

    private class ConnectExecutor {
        private int methodNumber;
        private SocketAddress remoteAddress;
        private SocketAddress localAddress;
        private SelectorHandler selectorHandler;
        private CallbackHandler callbackHandler;
        private boolean wasCalled;

        private ConnectExecutor() {
        }

        public void setConnectorHandler(ConnectorHandler connectorHandler) {
            CacheableConnectorHandler.this.underlyingConnectorHandler = connectorHandler;
        }

        public void setParameters(SocketAddress remoteAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) {
            this.setParameters(remoteAddress, null, callbackHandler, selectorHandler);
            this.methodNumber = 1;
        }

        public void setParameters(SocketAddress remoteAddress, CallbackHandler callbackHandler) {
            this.setParameters(remoteAddress, null, callbackHandler);
            this.methodNumber = 2;
        }

        public void setParameters(SocketAddress remoteAddress) {
            this.setParameters(remoteAddress, (SocketAddress)null);
            this.methodNumber = 3;
        }

        public void setParameters(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, SelectorHandler selectorHandler) {
            this.wasCalled = false;
            this.remoteAddress = remoteAddress;
            this.localAddress = localAddress;
            this.callbackHandler = callbackHandler;
            this.selectorHandler = selectorHandler;
            this.methodNumber = 4;
        }

        public void setParameters(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler) {
            this.setParameters(remoteAddress, localAddress, callbackHandler, null);
            this.methodNumber = 5;
        }

        public void setParameters(SocketAddress remoteAddress, SocketAddress localAddress) {
            this.setParameters(remoteAddress, localAddress, null);
            this.methodNumber = 6;
        }

        public boolean wasCalled() {
            return this.wasCalled;
        }

        public void invokeProtocolConnect() throws IOException {
            this.wasCalled = true;
            switch (this.methodNumber) {
                case 1: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, CacheableConnectorHandler.this, this.selectorHandler);
                    break;
                }
                case 2: 
                case 3: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, CacheableConnectorHandler.this);
                    break;
                }
                case 4: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, this.localAddress, CacheableConnectorHandler.this, this.selectorHandler);
                    break;
                }
                case 5: 
                case 6: {
                    CacheableConnectorHandler.this.underlyingConnectorHandler.connect(this.remoteAddress, this.localAddress, CacheableConnectorHandler.this);
                    break;
                }
                default: {
                    throw new IllegalStateException("Can not find appropriate connect method: " + this.methodNumber);
                }
            }
        }
    }
}

