/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.omegat.gui.dialogs.LicenseDialog;
import org.omegat.help.Help;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class AboutDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JScrollPane aboutpane;
    private JTextArea abouttext;
    private JPanel buttonPanel;
    private JButton copySupportInfoButton;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JLabel javaversion;
    private JButton licenseButton;
    private JLabel memoryusage;
    private JButton okButton;
    private JLabel versionLabel;
    private int returnStatus = 0;

    public AboutDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        StaticUIUtils.setCaretUpdateEnabled(this.abouttext, false);
        this.abouttext.setText(StringUtil.format(OStrings.getString("ABOUTDIALOG_CONTRIBUTORS"), AboutDialog.getContributors(), AboutDialog.getLibraries()));
        this.versionLabel.setText(this.getVersionString());
        Object[] args = new Object[]{StaticUtils.getMB(Runtime.getRuntime().totalMemory()), StaticUtils.getMB(Runtime.getRuntime().freeMemory()), StaticUtils.getMB(Runtime.getRuntime().maxMemory())};
        String memoryUsage = StringUtil.format(OStrings.getString("MEMORY_USAGE"), args);
        this.memoryusage.setText(memoryUsage);
        String javaVersion = StringUtil.format(OStrings.getString("JAVA_VERSION"), System.getProperty("java.version"), Platform.is64Bit() ? 64 : 32);
        this.javaversion.setText(javaVersion);
        this.invalidate();
        this.pack();
        StaticUIUtils.fitInScreen(this);
        this.setLocationRelativeTo(parent);
    }

    private static String getLibraries() {
        URI librariesUri = Help.getHelpFileURI("libraries.txt");
        String result = OStrings.getString("ABOUTDIALOG_LIBRARIES_UNAVAILABLE");
        if (librariesUri != null) {
            try {
                result = IOUtils.toString((URI)librariesUri, (Charset)StandardCharsets.UTF_8);
                result = StringUtil.wrap(result, 78).replaceAll("(?m)^", "  ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static String getContributors() {
        URI contributorsUri = Help.getHelpFileURI("contributors.txt");
        String result = OStrings.getString("ABOUTDIALOG_CONTRIBUTORS_UNAVAILABLE");
        if (contributorsUri != null) {
            try {
                result = IOUtils.toString((URI)contributorsUri, (Charset)StandardCharsets.UTF_8);
                result = StringUtil.wrap(result, 78).replaceAll("(?m)^", "  ");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private String getVersionString() {
        if (!StringUtil.isEmpty(OStrings.UPDATE) && !OStrings.UPDATE.equals("0")) {
            return StringUtil.format(OStrings.getString("ABOUTDIALOG_BRAND_VERSION_UPDATE_REVISION"), OStrings.getApplicationDisplayName(), OStrings.VERSION, OStrings.UPDATE, OStrings.REVISION);
        }
        return StringUtil.format(OStrings.getString("ABOUTDIALOG_BRAND_VERSION_REVISION"), OStrings.getApplicationDisplayName(), OStrings.VERSION, OStrings.REVISION);
    }

    private void copySupportInfo() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(StaticUtils.getSupportInfo()), null);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.versionLabel = new JLabel();
        this.aboutpane = new JScrollPane();
        this.abouttext = new JTextArea();
        this.buttonPanel = new JPanel();
        this.javaversion = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 4), new Dimension(0, 4), new Dimension(Short.MAX_VALUE, 4));
        this.memoryusage = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(0, 4), new Dimension(0, 4), new Dimension(Short.MAX_VALUE, 4));
        this.jLabel2 = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(0, 4), new Dimension(0, 4), new Dimension(Short.MAX_VALUE, 4));
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.copySupportInfoButton = new JButton();
        this.licenseButton = new JButton();
        this.okButton = new JButton();
        this.setTitle(OStrings.getString("ABOUTDIALOG_TITLE"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.versionLabel.setIcon(new ImageIcon(ResourcesUtil.APP_ICON_32X32));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)OStrings.getString("ABOUTDIALOG_BRAND_VERSION_REVISION"));
        this.versionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.versionLabel, "North");
        this.aboutpane.setHorizontalScrollBarPolicy(31);
        this.abouttext.setEditable(false);
        this.abouttext.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.abouttext.setFont(this.versionLabel.getFont());
        this.abouttext.setLineWrap(true);
        this.abouttext.setText(OStrings.getString("ABOUTDIALOG_CONTRIBUTORS"));
        this.abouttext.setWrapStyleWord(true);
        this.abouttext.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.abouttext.setCaretPosition(0);
        this.aboutpane.setViewportView(this.abouttext);
        this.getContentPane().add((Component)this.aboutpane, "Center");
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 3));
        Mnemonics.setLocalizedText((JLabel)this.javaversion, (String)OStrings.getString("JAVA_VERSION"));
        this.buttonPanel.add(this.javaversion);
        this.buttonPanel.add(this.filler1);
        Mnemonics.setLocalizedText((JLabel)this.memoryusage, (String)OStrings.getString("MEMORY_USAGE"));
        this.buttonPanel.add(this.memoryusage);
        this.buttonPanel.add(this.filler2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)OStrings.getString("ABOUTDIALOG_COPYRIGHT"));
        this.buttonPanel.add(this.jLabel2);
        this.buttonPanel.add(this.filler3);
        this.jPanel3.setAlignmentX(0.0f);
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel1.setAlignmentX(0.0f);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.copySupportInfoButton, (String)OStrings.getString("ABOUTDIALOG_COPY_SUPPORT_INFO_BUTTON"));
        this.copySupportInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.copySupportInfoButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.copySupportInfoButton);
        Mnemonics.setLocalizedText((AbstractButton)this.licenseButton, (String)OStrings.getString("ABOUTDIALOG_LICENSE_BUTTON"));
        this.licenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.licenseButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.licenseButton);
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.jPanel3.add((Component)this.jPanel1, "East");
        this.buttonPanel.add(this.jPanel3);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    private void licenseButtonActionPerformed(ActionEvent evt) {
        new LicenseDialog(this).setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void copySupportInfoButtonActionPerformed(ActionEvent evt) {
        this.copySupportInfo();
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

