/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarGripper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;

public class VLToolBarLayout
implements LayoutManager2 {
    private ArrayList components = new ArrayList();
    private boolean isHorizontal;
    private int gap;

    public VLToolBarLayout() {
        this(true, 0);
    }

    public VLToolBarLayout(boolean isHorizontal) {
        this(isHorizontal, 0);
    }

    public VLToolBarLayout(boolean isHorizontal, int gap) {
        this.isHorizontal = isHorizontal;
        this.gap = gap;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            this.components.add(comp);
        } else {
            Integer i = (Integer)constraints;
            this.components.add(i, comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.components.remove(comp);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int visible = 0;
            for (int i = 0; i < this.components.size(); ++i) {
                Component comp = (Component)this.components.get(i);
                Dimension d = comp.getPreferredSize();
                if (!comp.isVisible()) continue;
                ++visible;
                if (this.isHorizontal) {
                    dim.width += d.width;
                    dim.height = Math.max(dim.height, d.height);
                    continue;
                }
                dim.width = Math.max(dim.width, d.width);
                dim.height += d.height;
            }
            if (this.isHorizontal) {
                dim.width += (visible - 1) * this.gap;
            } else {
                dim.height += (visible - 1) * this.gap;
            }
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension toolbarDim = this.preferredLayoutSize(target);
            Insets insets = target.getInsets();
            if (this.isHorizontal) {
                int left = insets.left;
                if (target.getComponentOrientation().isLeftToRight()) {
                    for (int i = 0; i < this.components.size(); ++i) {
                        left = this.layoutHorizComponent((Component)this.components.get(i), toolbarDim, insets, left);
                    }
                } else {
                    Component firstComp = this.components.size() == 0 ? null : (Component)this.components.get(0);
                    int endWith = 0;
                    if (firstComp != null && firstComp instanceof ToolBarGripper) {
                        left = this.layoutHorizComponent(firstComp, toolbarDim, insets, left);
                        endWith = 1;
                    }
                    for (int i = this.components.size() - 1; i >= endWith; --i) {
                        left = this.layoutHorizComponent((Component)this.components.get(i), toolbarDim, insets, left);
                    }
                }
            } else {
                int centerX = insets.left + (toolbarDim.width - insets.left - insets.right) / 2;
                int top = insets.top;
                for (int i = 0; i < this.components.size(); ++i) {
                    Component comp = (Component)this.components.get(i);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getPreferredSize();
                    comp.setBounds(insets.left, top, toolbarDim.width - insets.left - insets.right, d.height);
                    top += d.height + this.gap;
                }
            }
        }
    }

    private int layoutHorizComponent(Component comp, Dimension toolbarDim, Insets insets, int left) {
        if (comp.isVisible()) {
            Dimension d = comp.getPreferredSize();
            comp.setBounds(left, insets.top, d.width, toolbarDim.height - insets.top - insets.bottom);
            left += d.width + this.gap;
        }
        return left;
    }
}

